/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class CallRoutingTestResult
implements Serializable {
    private static final long serialVersionUID = -478267528978233335L;
    private String incomingInvite;
    private String outgoingInvite;
    private List<String> flowInfoList = new ArrayList<String>();
    private final List<String> destInfoList = new ArrayList<String>();

    public void setIncomingInvite(String incomingInvite) {
        this.incomingInvite = this.sortHeaders(incomingInvite);
    }

    public String getIncomingInvite() {
        return this.incomingInvite;
    }

    public void setOutgoingInvite(String outgoingInvite) {
        this.outgoingInvite = this.sortHeaders(outgoingInvite);
    }

    public String getOutgoingInvite() {
        return this.outgoingInvite;
    }

    public List<String> getFlowInfoList() {
        return this.flowInfoList;
    }

    public List<String> getDestInfoList() {
        return this.destInfoList;
    }

    public void addDestInfo(String destInfo) {
        this.destInfoList.add(destInfo);
    }

    public void addRoutingInfo(String routingInfo) {
        this.flowInfoList.add(routingInfo);
    }

    private String sortHeaders(String originalInvite) {
        String line;
        int index;
        HashMap<String, ArrayList<String>> headers = new HashMap<String, ArrayList<String>>();
        String[] lines = originalInvite.split("\\r?\\n");
        StringBuilder sortedInvite = new StringBuilder();
        sortedInvite.append(lines[0]);
        sortedInvite.append("\n");
        for (index = 1; index < lines.length && !"".equals(line = lines[index]); ++index) {
            String headerName = line.split(":")[0];
            ArrayList<String> headersOfThisType = (ArrayList<String>)headers.get(headerName);
            if (headersOfThisType == null) {
                headersOfThisType = new ArrayList<String>();
                headers.put(headerName, headersOfThisType);
            }
            headersOfThisType.add(line);
        }
        ArrayList sortedKeys = new ArrayList(headers.keySet());
        Collections.sort(sortedKeys);
        for (String headerName : sortedKeys) {
            for (String header : (List)headers.get(headerName)) {
                sortedInvite.append(header);
                sortedInvite.append("\n");
            }
        }
        while (index < lines.length) {
            sortedInvite.append(lines[index]);
            sortedInvite.append("\n");
            ++index;
        }
        return sortedInvite.toString();
    }

    public String toString() {
        return "CallRoutingTestResult:\nflowInfoList: " + this.flowInfoList.toString() + " \n destInfoList: " + this.destInfoList;
    }
}

