/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.ReadWriteLockHandler;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.common.logging.client.Logger;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class LocationPatternTree {
    protected static final Logger log = AsmLogger.getLogger(LocationPatternTree.class);
    private static final String v4ValidChars = "0123456789.xX*";
    private static final String v6ValidChars = "0123456789abcdef:xX*";
    private static final Character X_CHAR = Character.valueOf('x');
    private static final Character CAP_X_CHAR = Character.valueOf('X');
    private static final Character STAR_CHAR = Character.valueOf('*');
    protected static final boolean USEGROUPS = true;
    private static final int IPV6_GROUP_MASK = 65536;
    private volatile Map<Object, LocationPatternTree> map = null;
    private volatile AtomicLong locationId = null;
    protected static final ReadWriteLockHandler lock = new ReadWriteLockHandler(LocationPatternTree.class.getSimpleName());

    public Long getLocationId() {
        if (this.locationId == null) {
            return null;
        }
        return this.locationId.get();
    }

    protected void setLocationId(Long routingorigination_id) {
        if (this.locationId == null) {
            this.locationId = new AtomicLong(routingorigination_id);
        } else {
            this.locationId.set(routingorigination_id);
        }
    }

    protected static int[] getGroupVal(String pattern, IPAddress.IPAddressFamily type, int depth) {
        int length = pattern.length();
        if (depth >= length) {
            return null;
        }
        int radix = type == IPAddress.IPAddressFamily.IPV6 ? 16 : 10;
        int groupVal = 0;
        int index = depth;
        while (index < length) {
            char c = pattern.charAt(index);
            if (c >= '0' && c <= '9') {
                groupVal = groupVal * radix + (c - 48);
                ++index;
                continue;
            }
            if (c >= 'a' && c <= 'f' && radix == 16) {
                groupVal = (groupVal << 4) + (c - 97 + 10);
                ++index;
                continue;
            }
            if (c == '.' && type == IPAddress.IPAddressFamily.IPV4) {
                ++index;
                break;
            }
            if (c == ':' && type == IPAddress.IPAddressFamily.IPV6) {
                ++index;
                break;
            }
            return null;
        }
        if (type == IPAddress.IPAddressFamily.IPV6) {
            groupVal |= 0x10000;
        }
        int[] retVal = new int[]{groupVal, index};
        return retVal;
    }

    public LocationPatternTree matchPattern(IPAddress address) {
        lock.acquireReadLock();
        try {
            LocationPatternTree locationPatternTree = this.matchPattern(address.toExpandedForm(false));
            return locationPatternTree;
        }
        finally {
            lock.releaseReadLock();
        }
    }

    public LocationPatternTree matchPattern(String address) {
        lock.acquireReadLock();
        try {
            LocationPatternTree locationPatternTree = this.matchPattern(0, address, IPAddress.getAddressFamily(address), true);
            return locationPatternTree;
        }
        finally {
            lock.releaseReadLock();
        }
    }

    protected LocationPatternTree matchPattern(int depth, String address, IPAddress.IPAddressFamily type, boolean beginGroup) {
        LocationPatternTree xMatch;
        LocationPatternTree exactMatch;
        char c;
        LocationPatternTree groupMatch;
        LocationPatternTree node;
        int[] groupData;
        int length = address.length();
        if (length == depth) {
            return this.locationId == null ? null : this;
        }
        if (this.map == null) {
            return null;
        }
        boolean group = false;
        int groupVal = 0;
        int index = depth;
        if (beginGroup && (groupData = LocationPatternTree.getGroupVal(address, type, depth)) != null) {
            group = true;
            groupVal = groupData[0];
            index = groupData[1];
        }
        if (group && (node = this.map.get(groupVal)) != null && (groupMatch = node.matchPattern(index, address, type, true)) != null) {
            return groupMatch;
        }
        String validChars = type == IPAddress.IPAddressFamily.IPV6 ? v6ValidChars : v4ValidChars;
        int cindex = validChars.indexOf(c = address.charAt(depth));
        if (cindex < 0) {
            log.error((Object)("matchPattern: bad char in address " + address + " cindex=" + cindex + " depth=" + depth));
            return null;
        }
        beginGroup = c == '.' || c == ':';
        LocationPatternTree subtree = this.map.get(Character.valueOf(c));
        if (subtree != null && (exactMatch = subtree.matchPattern(depth + 1, address, type, beginGroup)) != null) {
            return exactMatch;
        }
        subtree = this.map.get(X_CHAR);
        if (subtree != null && (xMatch = subtree.matchPattern(depth + 1, address, type, beginGroup)) != null) {
            return xMatch;
        }
        if (group && (subtree = this.map.get(CAP_X_CHAR)) != null && (xMatch = subtree.matchPattern(index, address, type, beginGroup)) != null) {
            return xMatch;
        }
        return this.map.get(STAR_CHAR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(String pattern, Long routingorigination_id) {
        lock.acquireWriteLock();
        try {
            boolean bl = this.insert(0, pattern, IPAddress.getAddressFamily(pattern), routingorigination_id, true);
            return bl;
        }
        finally {
            lock.releaseWriteLock();
        }
    }

    protected boolean insert(int depth, String pattern, IPAddress.IPAddressFamily type, Long routingorigination_id, boolean beginGroup) {
        Constable key;
        int[] groupData;
        int length = pattern.length();
        boolean group = false;
        int groupVal = 0;
        int index = depth;
        if (beginGroup && (groupData = LocationPatternTree.getGroupVal(pattern, type, depth)) != null) {
            group = true;
            groupVal = groupData[0];
            index = groupData[1];
        }
        int adjustedDepth = depth;
        if (group) {
            adjustedDepth = index - 1;
            key = new Integer(groupVal);
        } else {
            char c;
            String validChars = type == IPAddress.IPAddressFamily.IPV6 ? v6ValidChars : v4ValidChars;
            index = validChars.indexOf(c = pattern.charAt(depth));
            if (index < 0 || CAP_X_CHAR.equals(Character.valueOf(c)) && !beginGroup) {
                log.error((Object)("insert bad char in pattern " + pattern + " index=" + index + " depth=" + depth));
                return false;
            }
            key = new Character(c);
            if (CAP_X_CHAR.equals(Character.valueOf(c))) {
                if (adjustedDepth + 1 < length && pattern.charAt(++adjustedDepth) != ':') {
                    log.error((Object)("insert bad char following X in pattern " + pattern));
                    return false;
                }
            } else {
                boolean bl = beginGroup = c == '.' || c == ':';
            }
        }
        if (this.map == null) {
            this.map = new HashMap<Object, LocationPatternTree>(2);
        }
        LocationPatternTree node = this.map.get(key);
        if (length == adjustedDepth + 1) {
            if (node == null) {
                node = new LocationPatternTree();
                this.map.put(key, node);
            }
            node.setLocationId(routingorigination_id);
            return true;
        }
        if (node == null) {
            node = new LocationPatternTree();
            this.map.put(key, node);
        }
        boolean inserted = node.insert(adjustedDepth + 1, pattern, type, routingorigination_id, beginGroup);
        if (depth == 0 && !inserted) {
            this.delete(pattern);
        }
        return inserted;
    }

    public boolean delete(String pattern) {
        lock.acquireWriteLock();
        try {
            boolean bl = this.delete(0, pattern, IPAddress.getAddressFamily(pattern), true);
            return bl;
        }
        finally {
            lock.releaseWriteLock();
        }
    }

    protected boolean delete(int depth, String pattern, IPAddress.IPAddressFamily type, boolean beginGroup) {
        int[] groupData;
        int length = pattern.length();
        boolean group = false;
        int groupVal = 0;
        int index = depth;
        if (beginGroup && (groupData = LocationPatternTree.getGroupVal(pattern, type, depth)) != null) {
            group = true;
            groupVal = groupData[0];
            index = groupData[1];
        }
        if (length > depth) {
            Constable key;
            if (group) {
                depth = index - 1;
                key = groupVal;
            } else {
                char c;
                String validChars = type == IPAddress.IPAddressFamily.IPV6 ? v6ValidChars : v4ValidChars;
                index = validChars.indexOf(c = pattern.charAt(depth));
                if (index < 0) {
                    log.error((Object)("delete bad pattern " + pattern + " index=" + index + " depth=" + depth));
                }
                key = new Character(c);
                if (CAP_X_CHAR.equals(Character.valueOf(c))) {
                    if (depth + 1 < length && pattern.charAt(++depth) != ':') {
                        log.error((Object)("insert bad char following X in pattern " + pattern));
                        return false;
                    }
                } else {
                    boolean bl = beginGroup = c == '.' || c == ':';
                }
            }
            if (this.map == null) {
                log.error((Object)("delete null subnode pattern=" + pattern + " index=" + index + " depth=" + depth));
            } else {
                LocationPatternTree node = this.map.get(key);
                if (node == null) {
                    log.error((Object)("delete null subnode pattern=" + pattern + " index=" + index + " depth=" + depth));
                } else {
                    if (!node.delete(depth + 1, pattern, type, beginGroup)) {
                        return false;
                    }
                    this.map.remove(key);
                }
            }
        } else {
            this.locationId = null;
        }
        if (this.map != null && this.map.isEmpty()) {
            this.map = null;
        }
        return this.map == null && this.locationId == null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("ro=");
        buffer.append(this.locationId);
        if (this.map != null) {
            buffer.append(" [");
            boolean first = true;
            for (Object key : this.map.keySet()) {
                if (!first) {
                    buffer.append(", ");
                }
                first = false;
                if (key instanceof Character) {
                    buffer.append("'");
                    buffer.append(key);
                    buffer.append("'");
                    continue;
                }
                if (((Integer)key & 0x10000) != 0) {
                    buffer.append(Integer.toHexString((Integer)key & 0xFFFEFFFF));
                    continue;
                }
                buffer.append(key.toString());
            }
            buffer.append("]");
        }
        return buffer.toString();
    }

    public String print() {
        lock.acquireReadLock();
        try {
            String string = this.print("");
            return string;
        }
        finally {
            lock.releaseReadLock();
        }
    }

    protected String print(String pattern) {
        StringBuilder buffer = new StringBuilder(pattern);
        buffer.append(" ");
        buffer.append(this.toString());
        if (this.map != null) {
            for (Map.Entry<Object, LocationPatternTree> e : this.map.entrySet()) {
                Object key = e.getKey();
                LocationPatternTree subTree = e.getValue();
                boolean isLeaf = subTree.getLocationId() != null;
                buffer.append("\n");
                if (key instanceof Character) {
                    buffer.append(subTree.print(pattern + key.toString() + (!isLeaf && CAP_X_CHAR.equals(key) ? ":" : "")));
                    continue;
                }
                if (((Integer)key & 0x10000) != 0) {
                    buffer.append(subTree.print(pattern + Integer.toHexString((Integer)key & 0xFFFEFFFF) + (isLeaf ? "" : ":")));
                    continue;
                }
                buffer.append(subTree.print(pattern + ((Integer)key).toString() + (isLeaf ? "" : ".")));
            }
        }
        return buffer.toString();
    }
}

