/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmConstants;
import com.avaya.asm.datamgr.objectapi.FQDNOrIpAddr;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.IPAddressFamilyTransportKey;
import com.avaya.asm.datamgr.objectapi.ListenPort;
import com.avaya.asm.datamgr.objectapi.SipMonResponseHandling;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class SIPEntity
implements Serializable {
    private static final long serialVersionUID = -1905272531674140429L;
    final long id;
    final String type;
    IPAddrFamilyType ipAddrFamilyType;
    FQDNOrIpAddr fqdnoripaddr;
    FQDNOrIpAddr fqdnoripaddr2;
    FQDNOrIpAddr sip_fqdn;
    final String name;
    final boolean useRFC3263;
    Long adaptationId;
    Long outboundproxyId;
    final Long locationId;
    final int timerBFSecs;
    final Boolean doMonitoring;
    final int monitorProactiveSecs;
    final int monitorReactiveSecs;
    final int monitorRetries;
    final boolean cacCapable;
    final List<Long> bwSharingSmIds = new ArrayList<Long>();
    final Integer tcpFailoverPort;
    final Integer tlsFailoverPort;
    final Integer tcpFailoverPortIPv6;
    final Integer tlsFailoverPortIPv6;
    final String preferredHandleType;
    final CDRSetting cdrsetting;
    List<ListenPort> listenPorts;
    final boolean isSecurable;
    final boolean ipAddrTolerant;
    final int monitorOkResponses;
    final Long loadBalancerId;
    protected Map<Long, SipMonResponseHandling> sipMonResponseHandling;

    public SIPEntity(long id, String type, String ipAddrFamilyTypeStr, String fqdnoripaddr, String fqdnoripaddr2, String sip_fqdn, String name, boolean useRFC3263, Long adaptationId, Long outboundproxyId, Long locationId, int timerBFSecs, Boolean doMonitoring, int monitorProactiveSecs, int monitorReactiveSecs, int monitorRetries, int monitorOkResponses, CDRSetting cdrsetting, boolean cacCapable, Long bwSharingSm1Id, Long bwSharingSm2Id, Integer tcpFailoverPort, Integer tlsFailoverPort, Integer tcpFailoverPortIPv6, Integer tlsFailoverPortIPv6, String preferredHandleType, boolean supportsEndToEndSecureIndicator, boolean ipAddrTolerant, Long loadBalancerId) {
        this.id = id;
        this.type = SIPEntity.getSIPEntityTypeFromString(type);
        this.setAddresses(ipAddrFamilyTypeStr, fqdnoripaddr, fqdnoripaddr2);
        this.setSipFqdn(sip_fqdn);
        this.name = name;
        this.useRFC3263 = useRFC3263;
        this.adaptationId = adaptationId;
        this.outboundproxyId = outboundproxyId;
        this.locationId = locationId;
        this.timerBFSecs = timerBFSecs;
        this.doMonitoring = doMonitoring;
        this.monitorProactiveSecs = monitorProactiveSecs;
        this.monitorReactiveSecs = monitorReactiveSecs;
        this.monitorRetries = monitorRetries;
        this.monitorOkResponses = monitorOkResponses;
        this.cdrsetting = cdrsetting;
        this.cacCapable = cacCapable;
        if (bwSharingSm1Id != null) {
            this.bwSharingSmIds.add(bwSharingSm1Id);
        }
        if (bwSharingSm2Id != null) {
            this.bwSharingSmIds.add(bwSharingSm2Id);
        }
        this.tcpFailoverPort = tcpFailoverPort;
        this.tlsFailoverPort = tlsFailoverPort;
        this.tcpFailoverPortIPv6 = tcpFailoverPortIPv6;
        this.tlsFailoverPortIPv6 = tlsFailoverPortIPv6;
        this.preferredHandleType = SIPEntity.getCommProfileTypeFromString(preferredHandleType);
        this.listenPorts = null;
        this.sipMonResponseHandling = null;
        this.isSecurable = supportsEndToEndSecureIndicator;
        this.ipAddrTolerant = ipAddrTolerant;
        this.loadBalancerId = loadBalancerId;
    }

    public SIPEntity(long id, String type, String ipAddrFamilyTypeStr, String fqdnoripaddr, String fqdnoripaddr2, String sip_fqdn, String name, boolean useRFC3263, Long adaptationId, Long outboundproxyId, Long locationId, int timerBFSecs, Boolean doMonitoring, int monitorProactiveSecs, int monitorReactiveSecs, int monitorRetries, int monitorOkResponses, CDRSetting cdrsetting, boolean cacCapable, Long bwSharingSm1Id, Long bwSharingSm2Id, Integer tcpFailoverPort, Integer tlsFailoverPort, Integer tcpFailoverPortIPv6, Integer tlsFailoverPortIPv6, String preferredHandleType, boolean supportsEndToEndSecureIndicator, boolean ipAddrTolerant) {
        this(id, type, ipAddrFamilyTypeStr, fqdnoripaddr, fqdnoripaddr2, sip_fqdn, name, useRFC3263, adaptationId, outboundproxyId, locationId, timerBFSecs, doMonitoring, monitorProactiveSecs, monitorReactiveSecs, monitorRetries, monitorOkResponses, cdrsetting, cacCapable, bwSharingSm1Id, bwSharingSm2Id, tcpFailoverPort, tlsFailoverPort, tcpFailoverPortIPv6, tlsFailoverPortIPv6, preferredHandleType, supportsEndToEndSecureIndicator, ipAddrTolerant, null);
    }

    public SIPEntity(long id, String type, String ipAddrFamilyTypeStr, String fqdnoripaddr, String fqdnoripaddr2, String name, boolean useRFC3263, Long adaptationId, Long outboundproxyId, Long locationId, int timerBFSecs, Boolean doMonitoring, int monitorProactiveSecs, int monitorReactiveSecs, int monitorRetries, CDRSetting cdrsetting, boolean cacCapable, Long bwSharingSm1Id, Long bwSharingSm2Id, Integer tcpFailoverPort, Integer tlsFailoverPort, Integer tcpFailoverPortIPv6, Integer tlsFailoverPortIPv6, String preferredHandleType, boolean supportsEndToEndSecureIndicator, boolean ipAddrTolerant) {
        this(id, type, ipAddrFamilyTypeStr, fqdnoripaddr, fqdnoripaddr2, null, name, useRFC3263, adaptationId, outboundproxyId, locationId, timerBFSecs, doMonitoring, monitorProactiveSecs, monitorReactiveSecs, monitorRetries, 1, cdrsetting, cacCapable, bwSharingSm1Id, bwSharingSm2Id, tcpFailoverPort, tlsFailoverPort, tcpFailoverPortIPv6, tlsFailoverPortIPv6, preferredHandleType, supportsEndToEndSecureIndicator, ipAddrTolerant);
    }

    public SIPEntity(long id, String type, String ipAddrFamilyTypeStr, String fqdnoripaddr, String fqdnoripaddr2, String sipFqdn, String name, boolean useRFC3263, Long adaptationId, Long outboundproxyId, Long locationId, int timerBFSecs, Boolean doMonitoring, int monitorProactiveSecs, int monitorReactiveSecs, int monitorRetries, CDRSetting cdrsetting, boolean cacCapable, Long bwSharingSm1Id, Long bwSharingSm2Id, Integer tcpFailoverPort, Integer tlsFailoverPort, Integer tcpFailoverPortIPv6, Integer tlsFailoverPortIPv6, String preferredHandleType, boolean supportsEndToEndSecureIndicator, boolean ipAddrTolerant) {
        this(id, type, ipAddrFamilyTypeStr, fqdnoripaddr, fqdnoripaddr2, sipFqdn, name, useRFC3263, adaptationId, outboundproxyId, locationId, timerBFSecs, doMonitoring, monitorProactiveSecs, monitorReactiveSecs, monitorRetries, 1, cdrsetting, cacCapable, bwSharingSm1Id, bwSharingSm2Id, tcpFailoverPort, tlsFailoverPort, tcpFailoverPortIPv6, tlsFailoverPortIPv6, preferredHandleType, supportsEndToEndSecureIndicator, ipAddrTolerant);
    }

    public SIPEntity(long id, String type, String fqdnoripaddr, String name, boolean useRFC3263, Long adaptationId, Long outboundproxyId, Long locationId, int timerBFSecs, Boolean doMonitoring, int monitorProactiveSecs, int monitorReactiveSecs, int monitorRetries, CDRSetting cdrsetting, boolean cacCapable, Long bwSharingSm1Id, Long bwSharingSm2Id, Integer tcpFailoverPort, Integer tlsFailoverPort, Integer tcpFailoverPortIPv6, Integer tlsFailoverPortIPv6, String preferredHandleType, boolean supportsEndToEndSecureIndicator) {
        this(id, type, IPAddrFamilyType.IPv4.toString(), fqdnoripaddr, null, name, useRFC3263, adaptationId, outboundproxyId, locationId, timerBFSecs, doMonitoring, monitorProactiveSecs, monitorReactiveSecs, monitorRetries, cdrsetting, cacCapable, bwSharingSm1Id, bwSharingSm2Id, tcpFailoverPort, tlsFailoverPort, tcpFailoverPortIPv6, tlsFailoverPortIPv6, preferredHandleType, supportsEndToEndSecureIndicator, false);
    }

    public SIPEntity(long id, String type, String fqdnoripaddr, String name, boolean useRFC3263, Long adaptationId, Long outboundproxyId, Long locationId, int timerBFSecs, Boolean doMonitoring, int monitorProactiveSecs, int monitorReactiveSecs, int monitorRetries, boolean cacCapable, Long bwSharingSm1Id, Long bwSharingSm2Id, Integer tcpFailoverPort, Integer tlsFailoverPort, Integer tcpFailoverPortIPv6, Integer tlsFailoverPortIPv6, String preferredHandleType) {
        this(id, SIPEntity.getSIPEntityTypeFromString(type), fqdnoripaddr, name, useRFC3263, adaptationId, outboundproxyId, locationId, timerBFSecs, doMonitoring, monitorProactiveSecs, monitorReactiveSecs, monitorRetries, CDRSetting.none, cacCapable, bwSharingSm1Id, bwSharingSm2Id, tcpFailoverPort, tlsFailoverPort, tcpFailoverPortIPv6, tlsFailoverPortIPv6, SIPEntity.getCommProfileTypeFromString(preferredHandleType), false);
    }

    public SIPEntity(long id, String type, String fqdnoripaddr, String name, boolean useRFC3263, Long adaptationId, Long outboundproxyId, Long locationId, int timerBFSecs, Boolean doMonitoring, int monitorProactiveSecs, int monitorReactiveSecs, int monitorRetries, boolean cacCapable, Long bwSharingSm1Id, Long bwSharingSm2Id, String preferredHandleType) {
        this(id, SIPEntity.getSIPEntityTypeFromString(type), fqdnoripaddr, name, useRFC3263, adaptationId, outboundproxyId, locationId, timerBFSecs, doMonitoring, monitorProactiveSecs, monitorReactiveSecs, monitorRetries, CDRSetting.none, cacCapable, bwSharingSm1Id, bwSharingSm2Id, null, null, null, null, SIPEntity.getCommProfileTypeFromString(preferredHandleType), false);
    }

    public SIPEntity(SIPEntity oldEntity) {
        this.id = oldEntity.id;
        this.type = oldEntity.type;
        this.ipAddrFamilyType = oldEntity.ipAddrFamilyType;
        this.fqdnoripaddr = oldEntity.fqdnoripaddr;
        this.fqdnoripaddr2 = oldEntity.fqdnoripaddr2;
        this.sip_fqdn = oldEntity.sip_fqdn;
        this.name = oldEntity.name;
        this.useRFC3263 = oldEntity.useRFC3263;
        this.adaptationId = oldEntity.adaptationId;
        this.outboundproxyId = oldEntity.outboundproxyId;
        this.locationId = oldEntity.locationId;
        this.timerBFSecs = oldEntity.timerBFSecs;
        this.doMonitoring = oldEntity.doMonitoring;
        this.monitorProactiveSecs = oldEntity.monitorProactiveSecs;
        this.monitorReactiveSecs = oldEntity.monitorReactiveSecs;
        this.monitorRetries = oldEntity.monitorRetries;
        this.monitorOkResponses = oldEntity.monitorOkResponses;
        this.cdrsetting = oldEntity.cdrsetting;
        this.cacCapable = oldEntity.cacCapable;
        this.bwSharingSmIds.addAll(oldEntity.bwSharingSmIds);
        this.preferredHandleType = oldEntity.preferredHandleType;
        this.tcpFailoverPort = oldEntity.tcpFailoverPort;
        this.tlsFailoverPort = oldEntity.tlsFailoverPort;
        this.tcpFailoverPortIPv6 = oldEntity.tcpFailoverPortIPv6;
        this.tlsFailoverPortIPv6 = oldEntity.tlsFailoverPortIPv6;
        if (oldEntity.listenPorts == null) {
            this.listenPorts = null;
        } else {
            this.listenPorts = new CopyOnWriteArrayList<ListenPort>();
            this.listenPorts.addAll(oldEntity.listenPorts);
        }
        if (oldEntity.sipMonResponseHandling == null) {
            this.sipMonResponseHandling = null;
        } else {
            this.sipMonResponseHandling = new ConcurrentHashMap<Long, SipMonResponseHandling>();
            this.sipMonResponseHandling.putAll(oldEntity.sipMonResponseHandling);
        }
        this.isSecurable = oldEntity.isSecurable;
        this.ipAddrTolerant = oldEntity.ipAddrTolerant;
        this.loadBalancerId = oldEntity.loadBalancerId;
    }

    public SIPEntity(Long id, String fqdnoripaddr, String name, Boolean doMonitoring) {
        this(id, "ASM", fqdnoripaddr, name, false, 0L, 0L, 0L, 4, doMonitoring, 900, 120, 1, CDRSetting.none, false, null, null, null, null, null, null, "", false);
    }

    public SIPEntity(Long id, String fqdnoripaddr, String name, Long locationId, Boolean doMonitoring) {
        this(id, "ASM", fqdnoripaddr, name, false, 0L, 0L, locationId, 4, doMonitoring, 900, 120, 1, CDRSetting.none, false, null, null, null, null, null, null, "", false);
    }

    public SIPEntity(Long id, String fqdnoripaddr, String name, boolean cacCapable, Long bwSharingSm1Id, Long bwSharingSm2Id) {
        this(id, "CM", fqdnoripaddr, name, false, 0L, 0L, 0L, 4, false, 900, 120, 1, CDRSetting.none, cacCapable, bwSharingSm1Id, bwSharingSm2Id, null, null, null, null, "", false);
    }

    private static String getSIPEntityTypeFromString(String string) {
        if (string == null) {
            return null;
        }
        if ("ASM".equalsIgnoreCase(string)) {
            return "ASM";
        }
        if ("AMS".equalsIgnoreCase(string)) {
            return "AMS";
        }
        if ("CM".equalsIgnoreCase(string)) {
            return "CM";
        }
        if ("ELIN".equalsIgnoreCase(string)) {
            return "ELIN";
        }
        if ("Gateway".equalsIgnoreCase(string)) {
            return "Gateway";
        }
        if ("Modular Messaging".equalsIgnoreCase(string)) {
            return "Modular Messaging";
        }
        if ("MMCS".equalsIgnoreCase(string)) {
            return "MMCS";
        }
        if ("PS".equalsIgnoreCase(string)) {
            return "PS";
        }
        if ("CE".equalsIgnoreCase(string)) {
            return "CE";
        }
        if ("SIP Trunk".equalsIgnoreCase(string)) {
            return "SIP Trunk";
        }
        if ("Survivability Server".equalsIgnoreCase(string)) {
            return "Survivability Server";
        }
        if ("SVCPRO".equalsIgnoreCase(string)) {
            return "SVCPRO";
        }
        if ("VP".equalsIgnoreCase(string)) {
            return "VP";
        }
        if ("OTHER".equalsIgnoreCase(string)) {
            return "OTHER";
        }
        return string;
    }

    private static String getCommProfileTypeFromString(String string) {
        if (string == null) {
            return null;
        }
        if ("SIP".equals(string = string.toUpperCase())) {
            return "SIP";
        }
        if ("CM".equals(string)) {
            return "CM";
        }
        if ("PS".equals(string)) {
            return "PS";
        }
        if ("AUS".equals(string)) {
            return "AUS";
        }
        return string;
    }

    public long getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public boolean getIsASM() {
        return "ASM".equals(this.type);
    }

    public boolean getIsSipTrunk() {
        return "SIP Trunk".equals(this.type);
    }

    public boolean isServiceProvider() {
        return "SVCPRO".equals(this.type);
    }

    public boolean getIsCM() {
        return "CM".equals(this.type);
    }

    public boolean getIsELIN() {
        return "ELIN".equals(this.type);
    }

    public boolean getIsAMS() {
        return "AMS".equals(this.type);
    }

    public boolean getIsEDP() {
        return "CE".equals(this.type);
    }

    public boolean getIsSurvivabilityServer() {
        return "Survivability Server".equals(this.type);
    }

    public IPAddrFamilyType getIPAddrFamilyType() {
        return this.ipAddrFamilyType;
    }

    private void setAddresses(String ipAddrFamilyTypeStr, String fqdnoripaddr, String fqdnoripaddr2) {
        try {
            this.ipAddrFamilyType = IPAddrFamilyType.valueOf(ipAddrFamilyTypeStr);
        }
        catch (IllegalArgumentException e) {
            this.ipAddrFamilyType = IPAddrFamilyType.IPv4;
        }
        this.setFqdnoripaddr(fqdnoripaddr);
        if (this.ipAddrFamilyType == IPAddrFamilyType.IPv46) {
            this.setFqdnoripaddr2(fqdnoripaddr2);
        } else {
            this.setFqdnoripaddr2(null);
        }
    }

    public String getFqdnoripaddr() {
        return this.fqdnoripaddr.getFqdnoripaddr();
    }

    public FQDNOrIpAddr getFQDNOrIpAddr() {
        return this.fqdnoripaddr;
    }

    public String getFqdnoripaddr2() {
        return this.fqdnoripaddr2.getFqdnoripaddr();
    }

    public FQDNOrIpAddr getFQDNOrIpAddr2() {
        return this.fqdnoripaddr2;
    }

    public String getSIPFqdn() {
        return this.sip_fqdn.getFqdnoripaddr();
    }

    public FQDNOrIpAddr getSIPFQDN() {
        return this.sip_fqdn;
    }

    public List<FQDNOrIpAddr> getFQDNOrIPAddrs() {
        ArrayList<FQDNOrIpAddr> addresses = new ArrayList<FQDNOrIpAddr>();
        if (!this.fqdnoripaddr.isNull()) {
            addresses.add(this.fqdnoripaddr);
        }
        if (!this.fqdnoripaddr2.isNull()) {
            addresses.add(this.fqdnoripaddr2);
        }
        return addresses;
    }

    public String getFqdnoripaddr(IPAddress.IPAddressFamily ipAddrFamily) {
        FQDNOrIpAddr fqdnOrIpAddr = this.getFQDNOrIpAddr(ipAddrFamily);
        if (fqdnOrIpAddr != null) {
            return fqdnOrIpAddr.getFqdnoripaddr();
        }
        return null;
    }

    public FQDNOrIpAddr getFQDNOrIpAddr(IPAddress.IPAddressFamily requestedAddressFamily) {
        if (requestedAddressFamily == IPAddress.IPAddressFamily.IPV4) {
            switch (this.ipAddrFamilyType) {
                case IPv4: 
                case IPv46: {
                    return this.fqdnoripaddr;
                }
            }
            return null;
        }
        if (requestedAddressFamily == IPAddress.IPAddressFamily.IPV6) {
            switch (this.ipAddrFamilyType) {
                case IPv6: {
                    return this.fqdnoripaddr;
                }
                case IPv46: {
                    if (this.fqdnoripaddr2.isNull()) {
                        if (this.fqdnoripaddr.isIPAddress()) {
                            return null;
                        }
                        return this.fqdnoripaddr;
                    }
                    return this.fqdnoripaddr2;
                }
            }
            return null;
        }
        return null;
    }

    public String[] getFqdnoripaddrs() {
        String addr2 = this.getFqdnoripaddr2();
        String[] retVal = new String[addr2 == null ? 1 : 2];
        retVal[0] = this.getFqdnoripaddr();
        if (addr2 != null) {
            retVal[1] = addr2;
        }
        return retVal;
    }

    public boolean hasFQDN() {
        return this.fqdnoripaddr.isFQDN() || this.fqdnoripaddr2.isFQDN();
    }

    public boolean hasFQDN(IPAddress.IPAddressFamily ipAddrFamily) {
        FQDNOrIpAddr fqdnOrIPAddr = this.getFQDNOrIpAddr(ipAddrFamily);
        return fqdnOrIPAddr != null && fqdnOrIPAddr.isFQDN();
    }

    public boolean hasIpAddress(IPAddress.IPAddressFamily ipAddrFamily) {
        FQDNOrIpAddr fqdnOrIPAddr = this.getFQDNOrIpAddr(ipAddrFamily);
        return fqdnOrIPAddr != null ? fqdnOrIPAddr.isIPAddress() : false;
    }

    public void setFqdnoripaddr(String fqdnoripaddr) {
        this.fqdnoripaddr = new FQDNOrIpAddr(fqdnoripaddr);
    }

    public void setFqdnoripaddr2(String fqdnoripaddr2) {
        this.fqdnoripaddr2 = new FQDNOrIpAddr(fqdnoripaddr2);
    }

    public void setSipFqdn(String sipFqdn) {
        this.sip_fqdn = new FQDNOrIpAddr(sipFqdn);
    }

    public String getName() {
        return this.name;
    }

    public boolean getUseRFC3263() {
        return this.useRFC3263;
    }

    public Long getAdaptation_id() {
        return this.adaptationId;
    }

    public void setAdaptation_id(Long adaptationId) {
        this.adaptationId = adaptationId;
    }

    public Long getOutboundproxy_id() {
        return this.outboundproxyId;
    }

    public void setOutboundproxy_id(Long outboundproxyId) {
        this.outboundproxyId = outboundproxyId;
    }

    public int getTimer_bf_secs() {
        return this.timerBFSecs;
    }

    public Boolean getDo_monitoring() {
        return this.doMonitoring;
    }

    public int getMonitor_proactive_secs() {
        return this.monitorProactiveSecs;
    }

    public int getMonitor_reactive_secs() {
        return this.monitorReactiveSecs;
    }

    public int getMonitor_retries() {
        return this.monitorRetries;
    }

    public int getMonitor_okResponses() {
        return this.monitorOkResponses;
    }

    public Long getRoutingorigination_id() {
        return this.locationId;
    }

    public CDRSetting getCdrsetting() {
        return this.cdrsetting;
    }

    public boolean isSecurable() {
        return this.isSecurable;
    }

    public boolean isIPAddrTolerant() {
        return this.ipAddrTolerant;
    }

    public Long getLoadBalancerId() {
        return this.loadBalancerId;
    }

    public void update(SIPEntity oldEntity) {
        this.listenPorts = oldEntity.listenPorts == null ? null : new CopyOnWriteArrayList<ListenPort>(oldEntity.listenPorts);
        if (oldEntity.sipMonResponseHandling == null) {
            this.sipMonResponseHandling = null;
        } else {
            this.sipMonResponseHandling = new ConcurrentHashMap<Long, SipMonResponseHandling>(8, 0.9f, 1);
            this.sipMonResponseHandling.putAll(oldEntity.sipMonResponseHandling);
        }
    }

    public Map<Long, SipMonResponseHandling> getSipMonResponseHandling() {
        if (this.sipMonResponseHandling == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.sipMonResponseHandling);
    }

    public void addResponseHandling(SipMonResponseHandling responseHandling) {
        if (this.sipMonResponseHandling == null) {
            this.sipMonResponseHandling = new ConcurrentHashMap<Long, SipMonResponseHandling>(8, 0.9f, 1);
        }
        this.sipMonResponseHandling.put(responseHandling.getId(), responseHandling);
    }

    public void removeResponseHandling(Long id) {
        if (this.sipMonResponseHandling != null) {
            this.sipMonResponseHandling.remove(id);
            if (this.sipMonResponseHandling.isEmpty()) {
                this.sipMonResponseHandling = null;
            }
        }
    }

    public Boolean matchesSipMonResponseHandling(String toMatch) {
        if (this.sipMonResponseHandling == null) {
            return null;
        }
        Boolean up = null;
        int length = 0;
        for (SipMonResponseHandling handling : this.sipMonResponseHandling.values()) {
            String response = handling.getResponse();
            if (!toMatch.startsWith(response) || response.length() <= length) continue;
            up = handling.getUp();
            length = response.length();
        }
        return up;
    }

    public void addListenPort(ListenPort port) {
        if (this.listenPorts == null) {
            this.listenPorts = new CopyOnWriteArrayList<ListenPort>();
        }
        this.listenPorts.add(port);
    }

    public void removeListenPort(ListenPort port) {
        if (this.listenPorts != null) {
            this.listenPorts.remove(port);
            if (this.listenPorts.isEmpty()) {
                this.listenPorts = null;
            }
        }
    }

    public List<ListenPort> getListenPorts() {
        if (this.listenPorts == null) {
            return null;
        }
        return Collections.unmodifiableList(this.listenPorts);
    }

    public ListenPort getListenPort(Integer portNumber, String transportProtocol, IPAddress.IPAddressFamily ipAddressFamily, Boolean endpoint) {
        if (this.listenPorts != null) {
            for (ListenPort port : this.listenPorts) {
                if (!port.matches(portNumber, transportProtocol, ipAddressFamily, endpoint)) continue;
                return port;
            }
        }
        return null;
    }

    public boolean getCacCapable() {
        return this.cacCapable;
    }

    public boolean isBwSharer() {
        return !this.bwSharingSmIds.isEmpty();
    }

    public List<Long> getBwSharingSmIds() {
        return this.bwSharingSmIds;
    }

    public String getPreferredHandleType() {
        return this.preferredHandleType;
    }

    public Map<IPAddressFamilyTransportKey, Integer> getSmContactPorts() {
        IPAddressFamilyTransportKey ipAddressFamilyTransportKey;
        HashMap<IPAddressFamilyTransportKey, Integer> contactPorts = new HashMap<IPAddressFamilyTransportKey, Integer>();
        if (this.tcpFailoverPort != null) {
            ipAddressFamilyTransportKey = new IPAddressFamilyTransportKey(AsmConstants.TRANSPORT.TCP, IPAddress.IPAddressFamily.IPV4);
            contactPorts.put(ipAddressFamilyTransportKey, this.tcpFailoverPort);
        }
        if (this.tlsFailoverPort != null) {
            ipAddressFamilyTransportKey = new IPAddressFamilyTransportKey(AsmConstants.TRANSPORT.TLS, IPAddress.IPAddressFamily.IPV4);
            contactPorts.put(ipAddressFamilyTransportKey, this.tlsFailoverPort);
        }
        if (this.tcpFailoverPortIPv6 != null) {
            ipAddressFamilyTransportKey = new IPAddressFamilyTransportKey(AsmConstants.TRANSPORT.TCP, IPAddress.IPAddressFamily.IPV6);
            contactPorts.put(ipAddressFamilyTransportKey, this.tcpFailoverPortIPv6);
        }
        if (this.tlsFailoverPortIPv6 != null) {
            ipAddressFamilyTransportKey = new IPAddressFamilyTransportKey(AsmConstants.TRANSPORT.TLS, IPAddress.IPAddressFamily.IPV6);
            contactPorts.put(ipAddressFamilyTransportKey, this.tlsFailoverPortIPv6);
        }
        return contactPorts;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + new Long(this.id).hashCode();
        hash = hash * 31 + (this.fqdnoripaddr == null ? 0 : this.fqdnoripaddr.hashCode());
        hash = hash * 31 + (this.fqdnoripaddr2 == null ? 0 : this.fqdnoripaddr2.hashCode());
        hash = hash * 31 + (this.sip_fqdn == null ? 0 : this.sip_fqdn.hashCode());
        hash = hash * 31 + (this.adaptationId == null ? 0 : this.adaptationId.hashCode());
        hash = hash * 31 + (this.outboundproxyId == null ? 0 : this.outboundproxyId.hashCode());
        hash = hash * 31 + (this.locationId == null ? 0 : this.locationId.hashCode());
        hash = hash * 31 + (this.doMonitoring == null ? 0 : this.doMonitoring.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SIPEntity) {
            if (this == obj) {
                return true;
            }
            SIPEntity other = (SIPEntity)obj;
            return this.id == other.id && SIPEntity.equalsWithNull(this.type, other.type) && SIPEntity.equalsWithNull(this.fqdnoripaddr, other.fqdnoripaddr) && SIPEntity.equalsWithNull(this.fqdnoripaddr2, other.fqdnoripaddr2) && SIPEntity.equalsWithNull(this.sip_fqdn, other.sip_fqdn) && SIPEntity.equalsWithNull(this.adaptationId, other.adaptationId) && SIPEntity.equalsWithNull(this.outboundproxyId, other.outboundproxyId) && SIPEntity.equalsWithNull(this.locationId, other.locationId) && SIPEntity.equalsWithNull(this.doMonitoring, other.doMonitoring) && SIPEntity.equalsWithNull(this.doMonitoring, other.doMonitoring) && this.useRFC3263 == other.useRFC3263 && this.timerBFSecs == other.timerBFSecs && this.monitorProactiveSecs == other.monitorProactiveSecs && this.monitorReactiveSecs == other.monitorReactiveSecs && this.monitorRetries == other.monitorRetries && this.monitorOkResponses == other.monitorOkResponses && this.cacCapable == other.cacCapable && this.ipAddrTolerant == other.ipAddrTolerant && this.bwSharingSmIds.equals(other.bwSharingSmIds) && SIPEntity.equalsWithNull(this.preferredHandleType, other.preferredHandleType) && SIPEntity.equalsWithNull(this.tcpFailoverPort, other.tcpFailoverPort) && SIPEntity.equalsWithNull(this.tlsFailoverPort, other.tlsFailoverPort) && SIPEntity.equalsWithNull(this.tcpFailoverPortIPv6, other.tcpFailoverPortIPv6) && SIPEntity.equalsWithNull(this.tlsFailoverPortIPv6, other.tlsFailoverPortIPv6) && SIPEntity.equalsWithNull(this.loadBalancerId, other.loadBalancerId);
        }
        return false;
    }

    private static boolean equalsWithNull(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return false;
    }

    public String toString() {
        return "SipEntity[id=" + this.id + ", name=\"" + this.name + "\", type=" + this.type + ", addrType=" + (Object)((Object)this.ipAddrFamilyType) + ", addr=" + this.fqdnoripaddr + ", addr2=" + this.fqdnoripaddr2 + ", SIP FQDN=" + this.sip_fqdn + ", 3263=" + this.useRFC3263 + ", adapt=" + this.adaptationId + ", proxy=" + this.outboundproxyId + ", loc=" + this.locationId + ", mon=" + this.doMonitoring + "/" + this.monitorProactiveSecs + "/" + this.monitorReactiveSecs + ", cdr=" + (Object)((Object)this.cdrsetting) + ", cacCapable=" + this.cacCapable + ", bwSharingSmIds=" + this.bwSharingSmIds + ", preferredHandleType=" + this.preferredHandleType + ", tcpFailoverPort=" + this.tcpFailoverPort + ", tlsFailoverPort=" + this.tlsFailoverPort + ", tcpFailoverPortIPv6=" + this.tcpFailoverPortIPv6 + ", tlsFailoverPortIPv6=" + this.tlsFailoverPortIPv6 + ", listenPorts=" + this.listenPorts + ", isSecurable=" + this.isSecurable + ", ipAddrTolerant=" + this.ipAddrTolerant + ", loadBalancerId=" + this.loadBalancerId + "]";
    }

    public static class SIPEntityType {
        public static final String ASM = "ASM";
        public static final String AMS = "AMS";
        public static final String CM = "CM";
        public static final String ENDPOINT_CONCENTRATOR = "ENDPTCONC";
        public static final String ELIN = "ELIN";
        public static final String GATEWAY = "Gateway";
        public static final String Modular_Messaging = "Modular Messaging";
        public static final String MMCS = "MMCS";
        public static final String PS = "PS";
        public static final String EDP = "CE";
        public static final String SIP_Trunk = "SIP Trunk";
        public static final String Survivability_Server = "Survivability Server";
        public static final String SVCPRO = "SVCPRO";
        public static final String VP = "VP";
        public static final String OTHER = "OTHER";
    }

    public static enum IPAddrFamilyType {
        IPv4,
        IPv6,
        IPv46;

    }

    public static enum CDRSetting {
        ingress,
        egress,
        both,
        none;

    }
}

