/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;

public class WeakHashSet<E>
extends HashSet<E> {
    ReferenceQueue queue = new ReferenceQueue();

    @Override
    public Iterator iterator() {
        this.processQueue();
        final Iterator i = super.iterator();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            public Object next() {
                return WeakHashSet.this.getReferenceObject((WeakReference)i.next());
            }

            @Override
            public void remove() {
                i.remove();
            }
        };
    }

    @Override
    public boolean contains(Object o) {
        return super.contains(WeakElement.create(o));
    }

    @Override
    public boolean add(E o) {
        this.processQueue();
        return super.add(WeakElement.create(o, this.queue));
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = super.remove(WeakElement.create(o));
        this.processQueue();
        return ret;
    }

    private final Object getReferenceObject(WeakReference ref) {
        return ref == null ? null : ref.get();
    }

    private final void processQueue() {
        WeakElement wv = null;
        while ((wv = (WeakElement)this.queue.poll()) != null) {
            super.remove(wv);
        }
    }

    private static class WeakElement
    extends WeakReference {
        private int hash;

        private WeakElement(Object o) {
            super(o);
            this.hash = o.hashCode();
        }

        private WeakElement(Object o, ReferenceQueue q) {
            super(o, q);
            this.hash = o.hashCode();
        }

        private static WeakElement create(Object o) {
            return o == null ? null : new WeakElement(o);
        }

        private static WeakElement create(Object o, ReferenceQueue q) {
            return o == null ? null : new WeakElement(o, q);
        }

        public boolean equals(Object o) {
            Object u;
            if (this == o) {
                return true;
            }
            if (!(o instanceof WeakElement)) {
                return false;
            }
            Object t = this.get();
            if (t == (u = ((WeakElement)o).get())) {
                return true;
            }
            if (t == null || u == null) {
                return false;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

