/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi.ppm;

import com.avaya.asm.datamgr.helpers.StringArrayBytes;
import java.sql.Timestamp;
import java.util.Arrays;

public class CsContact {
    static final int stringIndexSize = StringIndex.values().length;
    private Long id;
    private boolean ispublic;
    private Long publicContactOwner;
    private Timestamp updateDateTime;
    private byte[] stringData;

    public CsContact(Long id, String displayName, String displayNameAscii, String preferredgivenname, String givenName, String givenNameAscii, String surName, String surnameAscii, String preferredLanguage, boolean ispublic, String notes, Long publicContactOwner, Timestamp updateDateTime) {
        this.id = id;
        String[] strArray = new String[stringIndexSize];
        strArray[StringIndex.DISPLAYNAME.ordinal()] = displayName;
        strArray[StringIndex.DISPLAYNAMEASCII.ordinal()] = displayNameAscii;
        strArray[StringIndex.PREFERREDGIVENNAME.ordinal()] = preferredgivenname;
        strArray[StringIndex.GIVENNAME.ordinal()] = givenName;
        strArray[StringIndex.GIVENNAMEASCII.ordinal()] = givenNameAscii;
        strArray[StringIndex.SURNAME.ordinal()] = surName;
        strArray[StringIndex.SURNAMEASCII.ordinal()] = surnameAscii;
        strArray[StringIndex.PREFERREDLANGUAGE.ordinal()] = preferredLanguage;
        strArray[StringIndex.NOTES.ordinal()] = notes;
        this.stringData = StringArrayBytes.encode(strArray);
        this.ispublic = ispublic;
        this.publicContactOwner = publicContactOwner;
        this.updateDateTime = updateDateTime;
    }

    public CsContact(CsContact csContact) {
        this.id = csContact.id;
        this.stringData = csContact.stringData;
        this.ispublic = csContact.ispublic;
        this.publicContactOwner = csContact.publicContactOwner;
        this.updateDateTime = csContact.updateDateTime;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDisplayName() {
        return StringArrayBytes.getString(this.stringData, StringIndex.DISPLAYNAME.ordinal());
    }

    public void setDisplayName(String displayName) {
        this.stringData = StringArrayBytes.setString(this.stringData, displayName, StringIndex.DISPLAYNAME.ordinal());
    }

    public String getDisplayNameAscii() {
        return StringArrayBytes.getString(this.stringData, StringIndex.DISPLAYNAMEASCII.ordinal());
    }

    public void setDisplayNameAscii(String displayNameAscii) {
        this.stringData = StringArrayBytes.setString(this.stringData, displayNameAscii, StringIndex.DISPLAYNAMEASCII.ordinal());
    }

    public String getPreferredGivenName() {
        return StringArrayBytes.getString(this.stringData, StringIndex.PREFERREDGIVENNAME.ordinal());
    }

    public void setPreferredGivenName(String preferredgivenname) {
        this.stringData = StringArrayBytes.setString(this.stringData, preferredgivenname, StringIndex.PREFERREDGIVENNAME.ordinal());
    }

    public String getPreferredLanguage() {
        return StringArrayBytes.getString(this.stringData, StringIndex.PREFERREDLANGUAGE.ordinal());
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.stringData = StringArrayBytes.setString(this.stringData, preferredLanguage, StringIndex.PREFERREDLANGUAGE.ordinal());
    }

    public String getGivenName() {
        return StringArrayBytes.getString(this.stringData, StringIndex.GIVENNAME.ordinal());
    }

    public void setGivenName(String givenName) {
        this.stringData = StringArrayBytes.setString(this.stringData, givenName, StringIndex.GIVENNAME.ordinal());
    }

    public String getGivenNameAscii() {
        return StringArrayBytes.getString(this.stringData, StringIndex.GIVENNAMEASCII.ordinal());
    }

    public void setGivenNameASCII(String givenNameAscii) {
        this.stringData = StringArrayBytes.setString(this.stringData, givenNameAscii, StringIndex.GIVENNAMEASCII.ordinal());
    }

    public String getSurName() {
        return StringArrayBytes.getString(this.stringData, StringIndex.SURNAME.ordinal());
    }

    public void setSurName(String surName) {
        this.stringData = StringArrayBytes.setString(this.stringData, surName, StringIndex.SURNAME.ordinal());
    }

    public String getSurnameAscii() {
        return StringArrayBytes.getString(this.stringData, StringIndex.SURNAMEASCII.ordinal());
    }

    public void setSurnameAscii(String surnameAscii) {
        this.stringData = StringArrayBytes.setString(this.stringData, surnameAscii, StringIndex.SURNAMEASCII.ordinal());
    }

    public String getNotes() {
        return StringArrayBytes.getString(this.stringData, StringIndex.NOTES.ordinal());
    }

    public void setNotes(String notes) {
        this.stringData = StringArrayBytes.setString(this.stringData, notes, StringIndex.NOTES.ordinal());
    }

    public boolean isIspublic() {
        return this.ispublic;
    }

    public void setIspublic(boolean ispublic) {
        this.ispublic = ispublic;
    }

    public Long getPublicContactOwner() {
        return this.publicContactOwner;
    }

    public void setPublicContactOwner(Long publicContactOwner) {
        this.publicContactOwner = publicContactOwner;
    }

    public void setUpdateDateTime(Timestamp updateDateTime) {
        this.updateDateTime = updateDateTime;
    }

    public Timestamp getUpdateDateTime() {
        return this.updateDateTime;
    }

    public String toString() {
        return "CsContact [id: " + this.id + ", displayname: " + this.getDisplayName() + ", displaynameAscii: " + this.getDisplayNameAscii() + ", preferredgivenname: " + this.getPreferredGivenName() + ", givenname: " + this.getGivenName() + ", givennameAscii: " + this.getGivenNameAscii() + ", surname: " + this.getSurName() + ", surnameAscii: " + this.getSurnameAscii() + ", ispublic: " + this.isIspublic() + ", preferredLanguage: " + this.getPreferredLanguage() + ", notes: " + this.getNotes() + ", publicContactOwner: " + this.getPublicContactOwner() + ", updateDateTime: " + this.getUpdateDateTime() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.ispublic ? 1231 : 1237);
        result = 31 * result + (this.publicContactOwner == null ? 0 : this.publicContactOwner.hashCode());
        result = 31 * result + Arrays.hashCode(this.stringData);
        result = 31 * result + (this.updateDateTime == null ? 0 : this.updateDateTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CsContact other = (CsContact)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.ispublic != other.ispublic) {
            return false;
        }
        if (this.publicContactOwner == null ? other.publicContactOwner != null : !this.publicContactOwner.equals(other.publicContactOwner)) {
            return false;
        }
        if (!Arrays.equals(this.stringData, other.stringData)) {
            return false;
        }
        return !(this.updateDateTime == null ? other.updateDateTime != null : !this.updateDateTime.equals(other.updateDateTime));
    }

    static enum StringIndex {
        DISPLAYNAME,
        DISPLAYNAMEASCII,
        PREFERREDGIVENNAME,
        GIVENNAME,
        GIVENNAMEASCII,
        SURNAME,
        SURNAMEASCII,
        PREFERREDLANGUAGE,
        NOTES;

    }
}

