/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.tools;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;

public final class MemoryCounter {
    private static final MemorySizes sizes = new MemorySizes();
    private final Map<Object, Object> visited = new IdentityHashMap<Object, Object>();
    private final Stack<Object> stack = new Stack();

    public void reset() {
        this.visited.clear();
        this.stack.clear();
    }

    public void addObjectToSkip(Object obj) {
        this.visited.put(obj, null);
    }

    public synchronized long estimate(Object obj) {
        assert (this.stack.isEmpty());
        long result = this._estimate(obj);
        while (!this.stack.isEmpty()) {
            result += this._estimate(this.stack.pop());
        }
        return result;
    }

    private boolean skipObject(Object obj) {
        if (obj instanceof String && obj == ((String)obj).intern()) {
            return true;
        }
        return obj == null || this.visited.containsKey(obj);
    }

    private long _estimate(Object obj) {
        Class<?> clazz;
        if (this.skipObject(obj)) {
            return 0L;
        }
        this.visited.put(obj, null);
        long result = 0L;
        if (clazz.isArray()) {
            return this._estimateArray(obj);
        }
        for (clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers())) continue;
                if (fields[i].getType().isPrimitive()) {
                    result += (long)sizes.getPrimitiveFieldSize(fields[i].getType());
                    continue;
                }
                if (fields[i].getType() == Logger.class || fields[i].getType() == AsmLogger.class) {
                    result += (long)sizes.getPointerSize();
                    continue;
                }
                result += (long)sizes.getPointerSize();
                fields[i].setAccessible(true);
                try {
                    Object toBeDone = fields[i].get(obj);
                    if (toBeDone == null) continue;
                    this.stack.add(toBeDone);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    assert (false);
                    continue;
                }
            }
        }
        return this.roundUpToNearestEightBytes(result += (long)sizes.getClassSize());
    }

    private long roundUpToNearestEightBytes(long result) {
        if (result % 8L != 0L) {
            result += 8L - result % 8L;
        }
        return result;
    }

    protected long _estimateArray(Object obj) {
        long result = 16L;
        int length = Array.getLength(obj);
        if (length != 0) {
            Class<?> arrayElementClazz = obj.getClass().getComponentType();
            if (arrayElementClazz.isPrimitive()) {
                result += (long)(length * sizes.getPrimitiveArrayElementSize(arrayElementClazz));
            } else {
                for (int i = 0; i < length; ++i) {
                    result += (long)sizes.getPointerSize() + this._estimate(Array.get(obj, i));
                }
            }
        }
        return result;
    }

    private static class MemorySizes {
        private final Map<Class<?>, Integer> primitiveSizes = new IdentityHashMap<Class<?>, Integer>(){
            {
                this.put(Boolean.TYPE, new Integer(1));
                this.put(Byte.TYPE, new Integer(1));
                this.put(Character.TYPE, new Integer(2));
                this.put(Short.TYPE, new Integer(2));
                this.put(Integer.TYPE, new Integer(4));
                this.put(Float.TYPE, new Integer(4));
                this.put(Double.TYPE, new Integer(8));
                this.put(Long.TYPE, new Integer(8));
            }
        };

        private MemorySizes() {
        }

        public int getPrimitiveFieldSize(Class<?> clazz) {
            return this.primitiveSizes.get(clazz);
        }

        public int getPrimitiveArrayElementSize(Class<?> clazz) {
            return this.getPrimitiveFieldSize(clazz);
        }

        public int getPointerSize() {
            return 4;
        }

        public int getClassSize() {
            return 8;
        }
    }
}

