/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.ppm.mega.common;

import com.avaya.asm.datamgr.helpers.EnvVarUtils;
import com.google.common.net.InetAddresses;
import java.util.concurrent.TimeUnit;

public class MegaPPMConstants {
    public static final long LOGIN_CACHE_EXPIRATION_MS = TimeUnit.MINUTES.toMillis(2L);
    public static final long DEFAULT_CACHE_SIZE = 20000L;
    public static final String MEGA_SERVER_IP = MegaPPMConstants.getServerIP("SIP_SERVER");
    public static final String MEGA_SERVER_FQDN = MegaPPMConstants.getServerFQDN("SIP_SERVER");
    public static final String HA_MEGA_SERVER_IP = MegaPPMConstants.getServerIP("SIP_SERVER2");
    public static final String HA_MEGA_SERVER_FQDN = MegaPPMConstants.getServerFQDN("SIP_SERVER2");
    public static final String TENANT_ID = System.getenv("AF_TENANT");
    public static final String DEFAULT_LISTENPORT = EnvVarUtils.getEnvString("SIP_PORT", "5222");
    public static final String DEFAULT_TRANSPORT = EnvVarUtils.getEnvString("SIP_TRANSPORT", "udp");
    public static final long DEFAULT_SIPENTITY_ID = 1L;
    public static final long HA_SIPENTITY_ID = 2L;
    public static final long DEFAULT_ASMINSTANCE_ID = 1L;
    public static final long HA_ASMINSTANCE_ID = 2L;
    public static final long DEFAULT_USER_COMMUNITY_ID = 1L;
    public static final long DEFAULT_LOCATION_ID = 1L;
    public static final long DEFAULT_CM_ID = 1L;
    public static final String CALL_APPR_BUTTON_TYPE = "call-appr";
    public static final String AGNT_LOGIN_BUTTON_TYPE = "agnt-login";
    public static final String AGNT_LOGOUT_BUTTON_TYPE = "agnt-logout";
    public static final String CALL_FWD_BUTTON_TYPE = "call-fwd";
    public static final String AUTODIAL_BUTTON_TYPE = "autodial";
    public static final String AUTO_IN_BUTTON_TYPE = "auto-in";
    public static final String AFTER_CALL_BUTTON_TYPE = "after-call";
    public static final String AUX_WORK_BUTTON_TYPE = "aux-work";
    public static final String SIP_SOBSRV_BUTTON_TYPE = "sip-sobsrv";
    public static final String VU_DISPLAY_BUTTON_TYPE = "vu-display";
    public static final String Q_CALLS_BUTTON_TYPE = "q-calls";
    public static final String SEND_CALLS_BUTTON_TYPE = "send-calls";
    public static final String ASSIST_BUTTON_TYPE = "assist";
    public static final String LOGOUT_OVR_BUTTON_TYPE = "logout-ovr";
    public static final String WORK_CODE_BUTTON_TYPE = "work-code";
    public static final String STROKE_CNT_BUTTON_TYPE = "stroke-cnt";
    public static final String UUI_INFO_BUTTON_TYPE = "uui-info";
    public static final String LABEL_NAME_PARM = "LabelName";
    public static final String DIALED_NUMBER_PARM = "DialedNumber";
    public static final String REASON_CODE_PARM = "ReasonCode";
    public static final String LISTEN_ONLY_PARM = "ListenOnly";
    public static final String COACH_ONLY_PARM = "CoachOnly";
    public static final String DISPLAY_FORMAT_PARM = "DisplayFormat";
    public static final String EMPLOYEE_GROUP_PARM = "EmployeeGroup";
    public static final String EXTENSION_GROUP_PARM = "Extension";
    public static final String DN_PARM = "DN";
    public static final String CODE_PARM = "Code";
    public static final int DEFAULT_LINE_RESERVATION_TIMER = 30;
    public static final String EXTPREFIX_DIALPLAN_CALLTYPE = "external-prefix";
    public static final String LOCAL_DIALPLAN_CALLTYPE = "local";
    public static final String EMERGENCY_DIALPLAN_CALLTYPE = "emergency";
    public static final String EXTPREFIX_GLOBAL_CONFIG_KEY = "external_prefix_dialing";
    public static final String GLOBAL_CONFIG_VALUE_KEY = "value";
    public static final String EXTPREFIX_REQUIRED = "REQUIRED";
    public static final String EXTPREFIX_OPTIONAL = "OPTIONAL";
    public static final Long REST_GET_LOG_THRESHOLD_MS = null;
    public static final Long REST_PUT_LOG_THRESHOLD_MS = null;
    public static final int CCS_CONNECTION_POOL_SIZE = 3;
    public static final Long REST_READ_CONNECTION_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
    public static final Long REST_IDLE_SOCKET_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(25L);

    private static String getServerFQDN(String sipServerEnvName) {
        return MegaPPMConstants.getServerEntry(sipServerEnvName, true);
    }

    private static String getServerIP(String sipServerEnvName) {
        return MegaPPMConstants.getServerEntry(sipServerEnvName, false);
    }

    private static String getServerEntry(String sipServerEnvName, boolean returnFQDN) {
        String sipServer = System.getenv(sipServerEnvName);
        if (sipServer == null || sipServer.isEmpty()) {
            return null;
        }
        String[] entries = sipServer.split("[\\s]+");
        String rc = null;
        for (String entry : entries) {
            if (InetAddresses.isInetAddress((String)entry)) {
                if (returnFQDN) continue;
                rc = entry;
                break;
            }
            if (!returnFQDN) continue;
            rc = entry;
            break;
        }
        return rc;
    }
}

