/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.trustmgmt;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.trustmgmt.RevocationInfo;
import com.avaya.asm.trustmgmt.RevocationInfoManager;
import com.avaya.common.logging.client.Logger;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509CRL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class TrustKeyManagerFactorySupplier {
    private static final String ALGO_PKIX = "PKIX";
    private static final String ALGO_X509 = "X.509";
    private static final String SYSTEM_PARAM_KEY_STORE = "javax.net.ssl.keyStore";
    private static final String SYSTEM_PARAM_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String SYSTEM_PARAM_KEY_STORE_PROVIDER = "javax.net.ssl.keyStoreProvider";
    private static final String SYSTEM_PARAM_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM = "ssl.KeyManagerFactory.algorithm";
    private static final String SYSTEM_PARAM_TRUST_STORE = "javax.net.ssl.trustStore";
    private static final String SYSTEM_PARAM_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    private static final String SYSTEM_PARAM_TRUST_STORE_PROVIDER = "javax.net.ssl.trustStoreProvider";
    private static final String SYSTEM_PARAM_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private static final String SYSTEM_PARAM_TRUST_MANAGER_FACTORY_ALGORITHM = "ssl.TrustManagerFactory.algorithm";
    protected static final String SYSTEM_PARAM_TLS_EPHEMERAL_DH_KEY_SIZE = "jdk.tls.ephemeralDHKeySize";
    protected static final String SYSTEM_PARAM_PREFER_IPV4_STACK = "java.net.preferIPv4Stack";
    protected static final String SYSTEM_PARAM_TRUST_KEY_MANAGER_FACTORY_SUPPLIER = "com.avaya.mgmt.trust.TrustKeyManagerFactorySupplier";
    protected static final String DEFAULT_TRUST_KEY_MANAGER_FACTORY_SUPPLIER = "com.avaya.asm.trustmgmt.TrustKeyManagerFactorySupplier";
    protected static final String SYSTEM_PARAM_JAVAX_NET_DEBUG = "javax.net.debug";
    protected static final String SYSTEM_PARAM_JAVA_SECURITY_DEBUG = "java.security.debug";
    private static final boolean useDefaultRevocationChecker = Boolean.getBoolean("com.avaya.asm.trustmgmt.useDefaultRevocationChecker");
    private static final boolean useCustomRevocationChecker = Boolean.getBoolean("com.avaya.asm.trustmgmt.useCustomRevocationChecker");
    private static final boolean disablePrefetchedCrls = Boolean.getBoolean("com.avaya.asm.trustmgmt.disablePrefetchedCrls");
    private static boolean dumpStackIsEnabled = false;
    private static Logger log = AsmLogger.getLogger(TrustKeyManagerFactorySupplier.class);
    private static final boolean sslSecurityDebugEnabled = Boolean.getBoolean("java.security.debug");

    public TrustKeyManagerFactorySupplier() {
        String functionName = "TrustKeyManagerFactorySupplier";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)"TrustKeyManagerFactorySupplier: instantiated.");
        }
    }

    public KeyManagerFactory getKeyMgrFactory(String keyStorePath, String keyStoreType, String keyStoreProvider, String keyStorePassword, String keyManagerFactoryAlgorithm) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, UnrecoverableKeyException {
        String functionName = "getKeyMgrFactory";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("getKeyMgrFactory: entered. keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyStoreProvider=" + keyStoreProvider + ", keyStorePassword=<hidden>, keyManagerFactoryAlgorithm=" + keyManagerFactoryAlgorithm));
        }
        KeyManagerFactory keyMgrFactory = null;
        try {
            KeyStore keyStore = this.getKeyStore(keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword);
            keyMgrFactory = this.getKeyMgrFactory(keyStore, keyStorePassword, keyManagerFactoryAlgorithm);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            log.error((Object)("getKeyMgrFactory: Error getting keyMgrFactory. keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyStoreProvider=" + keyStoreProvider + ", keyManagerFactoryAlgorithm=" + keyManagerFactoryAlgorithm + ", toString=" + this.toString()), (Throwable)e);
            throw e;
        }
        return keyMgrFactory;
    }

    public KeyManagerFactory getKeyMgrFactory(KeyStore keyStore, String keyStorePassword, String keyManagerFactoryAlgorithm) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String functionName = "getKeyMgrFactory";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("getKeyMgrFactory: entered. keyStore=" + keyStore + ", keyStorePassword=<hidden>, keyManagerFactoryAlgorithm=" + keyManagerFactoryAlgorithm));
        }
        if (dumpStackIsEnabled) {
            Thread.dumpStack();
        }
        if (keyStorePassword == null) {
            keyStorePassword = System.getProperty(SYSTEM_PARAM_KEY_STORE_PASSWORD, null);
        }
        if (keyManagerFactoryAlgorithm == null) {
            keyManagerFactoryAlgorithm = System.getProperty(SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM, KeyManagerFactory.getDefaultAlgorithm());
        }
        KeyManagerFactory keyMgrFactory = null;
        try {
            keyMgrFactory = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithm);
            keyMgrFactory.init(keyStore, keyStorePassword.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            log.error((Object)("getKeyMgrFactory: Error getting keyMgrFactory., keyStorePassword=<hidden>, keyManagerFactoryAlgorithm=" + keyManagerFactoryAlgorithm + ", toString=" + this.toString()), (Throwable)e);
            throw e;
        }
        if (isFinerEnabled) {
            log.finer((Object)("getKeyMgrFactory: leave., keyStorePassword=<hidden>, keyManagerFactoryAlgorithm=" + keyManagerFactoryAlgorithm));
        }
        return keyMgrFactory;
    }

    public KeyStore getKeyStore(String keyStorePath, String keyStoreType, String keyStoreProvider, String keyStorePassword) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        String functionName = "getKeyStore";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("getKeyStore: entered. keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyStoreProvider=" + keyStoreProvider + ", keyStorePassword=<hidden>"));
        }
        if (keyStorePath == null) {
            keyStorePath = System.getProperty(SYSTEM_PARAM_KEY_STORE, null);
        }
        if (keyStoreType == null) {
            keyStoreType = System.getProperty(SYSTEM_PARAM_KEY_STORE_TYPE, KeyStore.getDefaultType());
        }
        if (keyStoreProvider == null) {
            keyStoreProvider = System.getProperty(SYSTEM_PARAM_KEY_STORE_PROVIDER, null);
        }
        if (keyStorePassword == null) {
            keyStorePassword = System.getProperty(SYSTEM_PARAM_KEY_STORE_PASSWORD, null);
        }
        KeyStore keyStore = null;
        try (FileInputStream fileInputStream = new FileInputStream(keyStorePath);){
            keyStore = keyStoreProvider == null ? KeyStore.getInstance(keyStoreType) : KeyStore.getInstance(keyStoreType, keyStoreProvider);
            keyStore.load(fileInputStream, keyStorePassword.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            log.error((Object)("getKeyStore: Error getting KeyStore. keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyStoreProvider=" + keyStoreProvider + ", keyStorePassword=<hidden>, toString=" + this.toString()), (Throwable)e);
            throw e;
        }
        if (isFinerEnabled) {
            log.finer((Object)("getKeyStore: leave. keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyStoreProvider=" + keyStoreProvider + ", keyStorePassword=<hidden>"));
        }
        return keyStore;
    }

    private PKIXParameters getPKIXParametersFromTrustStore(KeyStore trustStore) throws InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        String functionName = "getPKIXParametersFromTrustStore";
        boolean isFinerEnabled = log.isFinerEnabled();
        RevocationInfo revocationInfo = RevocationInfoManager.getInstance().getRevocationInfo();
        if (sslSecurityDebugEnabled && isFinerEnabled) {
            log.finer((Object)("getPKIXParametersFromTrustStore entered. revocationInfo=" + revocationInfo));
        }
        PKIXBuilderParameters params = null;
        try {
            params = new PKIXBuilderParameters(trustStore, null);
            if (revocationInfo.isRevocationCheckingEnabled()) {
                boolean usePrefetchedCrls;
                if (disablePrefetchedCrls && isFinerEnabled) {
                    log.finer((Object)"getPKIXParametersFromTrustStore: Prefetched CRLS disabled");
                }
                boolean bl = usePrefetchedCrls = !disablePrefetchedCrls && revocationInfo.isCrlRevocationCheckingEnabled();
                if (useDefaultRevocationChecker) {
                    if (isFinerEnabled) {
                        log.finer((Object)"getPKIXParametersFromTrustStore: Default BC Certpath Checker enabled (limited functionality).");
                    }
                    if (usePrefetchedCrls) {
                        params.addCertStore(this.getPrefetchedCrls());
                    }
                    params.setRevocationEnabled(true);
                } else {
                    if (isFinerEnabled) {
                        log.finer((Object)("getPKIXParametersFromTrustStore: Avaya Revocation Checker enabled. usePrefetchedCrls=" + usePrefetchedCrls));
                    }
                    if (usePrefetchedCrls) {
                        params.addCertStore(this.getPrefetchedCrls());
                    }
                    params.addCertPathChecker(this.getAvayaRevocationChecker());
                    params.setRevocationEnabled(true);
                }
            } else {
                if (isFinerEnabled) {
                    log.finer((Object)"getPKIXParametersFromTrustStore: Revocation Checking is NOT enabled");
                }
                params.setRevocationEnabled(false);
            }
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException e) {
            log.error((Object)("getPKIXParametersFromTrustStore: Error getting PKIX Parameters from trustStore., params=" + params + ", revocationInfo=" + revocationInfo + ", toString=" + this.toString()), (Throwable)e);
            throw e;
        }
        if (sslSecurityDebugEnabled && isFinerEnabled) {
            log.finer((Object)("getPKIXParametersFromTrustStore: returning params=" + ((PKIXParameters)params).toString()));
        }
        return params;
    }

    private PKIXRevocationChecker getAvayaRevocationChecker() throws NoSuchAlgorithmException, NoSuchProviderException, UnsupportedOperationException {
        String functionName = "getAvayaRevocationChecker";
        boolean isFinerEnabled = log.isFinerEnabled();
        boolean isFinestEnabled = log.isFinestEnabled();
        String certPathValidatorAlgorithm = ALGO_PKIX;
        RevocationInfo revocationInfo = RevocationInfoManager.getInstance().getRevocationInfo();
        PKIXRevocationChecker revocationChecker = null;
        CertPathValidator cpv = null;
        try {
            cpv = CertPathValidator.getInstance(ALGO_PKIX);
            if (isFinestEnabled) {
                log.finest((Object)("getAvayaRevocationChecker: entered. revocationInfo=" + revocationInfo + ", CertPathValidator.getDefaultType()=" + CertPathValidator.getDefaultType() + ", certPathValidatorAlgorithm=" + ALGO_PKIX + ", cpv.getProvider()=" + cpv.getProvider() + ", cpv.getAlgorithm()=" + cpv.getAlgorithm()));
            }
            revocationChecker = (PKIXRevocationChecker)cpv.getRevocationChecker();
            if (isFinestEnabled) {
                log.finest((Object)("getAvayaRevocationChecker: revocationChecker=" + revocationChecker + ", getOptions=" + revocationChecker.getOptions()));
            }
            HashSet<PKIXRevocationChecker.Option> set = new HashSet<PKIXRevocationChecker.Option>();
            if (revocationInfo.isSoftFailAllowed()) {
                set.add(PKIXRevocationChecker.Option.SOFT_FAIL);
            }
            if (revocationInfo.checkEndEntityOnly()) {
                set.add(PKIXRevocationChecker.Option.ONLY_END_ENTITY);
            }
            if (!revocationInfo.isFallbackAllowed()) {
                set.add(PKIXRevocationChecker.Option.NO_FALLBACK);
            }
            if (!revocationInfo.isOcspPreferred()) {
                set.add(PKIXRevocationChecker.Option.PREFER_CRLS);
            }
            revocationChecker.setOptions(set);
            if (isFinerEnabled) {
                log.finer((Object)("getAvayaRevocationChecker: leave. Revocation Options set., revocationChecker=" + revocationChecker + ", getOptions=" + revocationChecker.getOptions()));
            }
        }
        catch (UnsupportedOperationException | NoSuchAlgorithmException e) {
            log.error((Object)("getAvayaRevocationChecker: leave. Error getting revocation checker. revocationInfo=" + revocationInfo + ", CertPathValidator.getDefaultType()=" + CertPathValidator.getDefaultType() + ", certPathValidatorAlgorithm=" + ALGO_PKIX + ", toString=" + this.toString() + ", exception=" + e), (Throwable)e);
            throw e;
        }
        return revocationChecker;
    }

    public TrustManagerFactory getTrustMgrFactory(String trustStorePath, String trustStoreType, String trustStoreProvider, String trustStorePassword, String trustManagerFactoryAlgorithm, boolean isRevocationAware) throws CertificateException, InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, UnrecoverableKeyException {
        String functionName = "getTrustMgrFactory";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("getTrustMgrFactory: entered. trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", trustStorePassword=<hidden>, trustManagerFactoryAlgorithm=" + trustManagerFactoryAlgorithm + ", isRevocationAware=" + isRevocationAware + ", toString=" + this.toString()));
        }
        TrustManagerFactory trustMgrFactory = null;
        try {
            KeyStore trustStore = this.getTrustStore(trustStorePath, trustStoreType, trustStoreProvider, trustStorePassword);
            trustMgrFactory = this.getTrustMgrFactory(trustStore, trustManagerFactoryAlgorithm, isRevocationAware);
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException e) {
            log.error((Object)("getTrustMgrFactory: Error getting TrustMgrFactory.: trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", trustStorePassword=<hidden>, trustManagerFactoryAlgorithm=" + trustManagerFactoryAlgorithm + ", toString=" + this.toString()), (Throwable)e);
            throw e;
        }
        return trustMgrFactory;
    }

    public TrustManagerFactory getTrustMgrFactory(KeyStore trustStore) throws InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        String functionName = "getTrustMgrFactory";
        boolean isFinerEnabled = log.isFinerEnabled();
        String trustManagerFactoryAlgorithm = ALGO_PKIX;
        boolean isRevocationAware = true;
        if (isFinerEnabled) {
            log.finer((Object)("getTrustMgrFactory: entered. trustStore=" + trustStore + ", set trustManagerFactoryAlgorithm=" + ALGO_PKIX + ", set isRevocationAware=" + true));
        }
        return this.getTrustMgrFactory(trustStore, ALGO_PKIX, true);
    }

    public TrustManagerFactory getTrustMgrFactory(KeyStore trustStore, String trustManagerFactoryAlgorithm, boolean isRevocationAware) throws InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        String functionName = "getTrustMgrFactory";
        boolean isFinerEnabled = log.isFinerEnabled();
        boolean isFinestEnabled = log.isFinestEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("getTrustMgrFactory: entered. trustStore=" + trustStore + ", trustManagerFactoryAlgorithm=" + trustManagerFactoryAlgorithm + ", isRevocationAware=" + isRevocationAware));
        }
        if (dumpStackIsEnabled) {
            Thread.dumpStack();
        }
        if (trustManagerFactoryAlgorithm == null) {
            trustManagerFactoryAlgorithm = System.getProperty(SYSTEM_PARAM_TRUST_MANAGER_FACTORY_ALGORITHM, TrustManagerFactory.getDefaultAlgorithm());
        }
        TrustManagerFactory trustMgrFactory = null;
        try {
            trustMgrFactory = TrustManagerFactory.getInstance(trustManagerFactoryAlgorithm);
            if (isRevocationAware) {
                PKIXParameters params = this.getPKIXParametersFromTrustStore(trustStore);
                CertPathTrustManagerParameters certPathParams = new CertPathTrustManagerParameters(params);
                trustMgrFactory.init(certPathParams);
            } else {
                trustMgrFactory.init(trustStore);
            }
            if (isFinerEnabled) {
                log.finer((Object)("getTrustMgrFactory: leave. Initialized trustMgrFactory, trustManagerFactory=" + trustMgrFactory + ", getAlgorithm()=" + trustMgrFactory.getAlgorithm() + ", getDefaultAlgorithm()=" + TrustManagerFactory.getDefaultAlgorithm() + ", getProvider()=" + trustMgrFactory.getProvider() + ", getTrustManagers()=" + trustMgrFactory.getTrustManagers()));
            }
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException e) {
            log.error((Object)("getTrustMgrFactory: leave. Error getting trustMgrFactory. trustManagerFactoryAlgorithm=" + trustManagerFactoryAlgorithm), (Throwable)e);
            throw e;
        }
        return trustMgrFactory;
    }

    public KeyStore getTrustStore(String trustStorePath, String trustStoreType, String trustStoreProvider, String trustStorePassword) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        String functionName = "getTrustStore";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("getTrustStore: entered. trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", trustStorePassword=<hidden>"));
        }
        if (trustStorePath == null) {
            trustStorePath = System.getProperty(SYSTEM_PARAM_TRUST_STORE, null);
        }
        if (trustStoreType == null) {
            trustStoreType = System.getProperty(SYSTEM_PARAM_TRUST_STORE_TYPE, KeyStore.getDefaultType());
        }
        if (trustStoreProvider == null) {
            trustStoreProvider = System.getProperty(SYSTEM_PARAM_TRUST_STORE_PROVIDER, null);
        }
        if (trustStorePassword == null) {
            trustStorePassword = System.getProperty(SYSTEM_PARAM_TRUST_STORE_PASSWORD, null);
        }
        KeyStore trustStore = null;
        try (FileInputStream fileInputStream = new FileInputStream(trustStorePath);){
            trustStore = trustStoreProvider == null ? KeyStore.getInstance(trustStoreType) : KeyStore.getInstance(trustStoreType, trustStoreProvider);
            trustStore.load(fileInputStream, trustStorePassword.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            log.error((Object)("getTrustStore: Error getting trustStore. trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", trustStorePassword=<hidden>, toString=" + this.toString()), (Throwable)e);
            throw e;
        }
        return trustStore;
    }

    public boolean isCertificateTrusted(List<Certificate> certificateChain, String trustStorePath, String trustStoreType, String trustStoreProvider, String trustStorePassword) throws CertificateException, CertPathValidatorException, InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        String functionName = "isCertificateTrusted";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("isCertificateTrusted entered. certificateChain=" + certificateChain + ", trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", CertPathValidator.getDefaultType()=" + CertPathValidator.getDefaultType()));
        }
        if (trustStorePath == null) {
            trustStorePath = System.getProperty(SYSTEM_PARAM_TRUST_STORE, null);
        }
        if (trustStoreType == null) {
            trustStoreType = System.getProperty(SYSTEM_PARAM_TRUST_STORE_TYPE, null);
        }
        if (trustStoreProvider == null) {
            trustStoreProvider = System.getProperty(SYSTEM_PARAM_TRUST_STORE_PROVIDER, null);
        }
        if (trustStorePassword == null) {
            trustStorePassword = System.getProperty(SYSTEM_PARAM_TRUST_STORE_PASSWORD, null);
        }
        try {
            KeyStore trustStore = this.getTrustStore(trustStorePath, trustStoreType, trustStoreProvider, trustStorePassword);
            PKIXParameters params = this.getPKIXParametersFromTrustStore(trustStore);
            String certificateFactoryAlgorithm = ALGO_X509;
            String certificateFactoryProvider = null;
            CertificateFactory cf = null;
            cf = certificateFactoryProvider == null ? CertificateFactory.getInstance(ALGO_X509) : CertificateFactory.getInstance(ALGO_X509, certificateFactoryProvider);
            String certPathValidatorAlgorithm = ALGO_PKIX;
            String certPathValidatorProvider = null;
            CertPathValidator cpv = null;
            cpv = certPathValidatorProvider == null ? CertPathValidator.getInstance(ALGO_PKIX) : CertPathValidator.getInstance(ALGO_PKIX, certPathValidatorProvider);
            CertPath certPath = cf.generateCertPath(certificateChain);
            cpv.validate(certPath, params);
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertPathValidatorException | CertificateException e) {
            log.error((Object)("isCertificateTrusted: Error validating certificate chain. certificateChain=" + certificateChain + ", trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", trustStorePassword=<hidden>, toString=" + this.toString()), (Throwable)e);
            throw e;
        }
        return true;
    }

    CertStore getPrefetchedCrls() throws InvalidAlgorithmParameterException, IOException, NoSuchAlgorithmException {
        String functionName = "getPrefetchedCrls";
        boolean isFinestEnabled = log.isFinestEnabled();
        RevocationInfo revocationInfo = RevocationInfoManager.getInstance().getRevocationInfo();
        CertStore crlStore = null;
        try {
            List<X509CRL> crlList = revocationInfo.getCrlList();
            CollectionCertStoreParameters crlParams = new CollectionCertStoreParameters(crlList);
            crlStore = CertStore.getInstance("Collection", crlParams);
            if (sslSecurityDebugEnabled && isFinestEnabled) {
                log.finest((Object)("getPrefetchedCrls: leave. prefetched crlList=" + crlList + ", crlList.size()=" + crlList.size()));
            }
        }
        catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            log.error((Object)("getPrefetchedCrls: leave. Error getting Prefetched CRLs., revocationInfo=" + revocationInfo + ", toString=" + this.toString()), (Throwable)e);
            throw e;
        }
        return crlStore;
    }

    public String getSystemParameterAsString(String systemParameter) {
        return systemParameter + "=" + System.getProperty(systemParameter);
    }

    public String getSecuritySystemParametersAsString() {
        return this.getSystemParameterAsString(SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_KEY_STORE) + ", " + SYSTEM_PARAM_KEY_STORE_PASSWORD + "=<hidden>, " + this.getSystemParameterAsString(SYSTEM_PARAM_KEY_STORE_PROVIDER) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_KEY_STORE_TYPE) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_TRUST_MANAGER_FACTORY_ALGORITHM) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_TRUST_STORE) + ", " + SYSTEM_PARAM_TRUST_STORE_PASSWORD + "=<hidden>, " + this.getSystemParameterAsString(SYSTEM_PARAM_TRUST_STORE_PROVIDER) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_TRUST_STORE_TYPE) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_TLS_EPHEMERAL_DH_KEY_SIZE) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_PREFER_IPV4_STACK) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_TRUST_KEY_MANAGER_FACTORY_SUPPLIER) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_JAVAX_NET_DEBUG) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_JAVA_SECURITY_DEBUG) + ", KeyManagerFactory.getDefaultAlgorithm()=" + KeyManagerFactory.getDefaultAlgorithm() + ", TrustManagerFactory.getDefaultAlgorithm()=" + TrustManagerFactory.getDefaultAlgorithm() + ", KeyStore.getDefaultType()=" + KeyStore.getDefaultType() + ", securityProviders=" + Arrays.toString(Security.getProviders());
    }

    public String toString() {
        Runtime rt = Runtime.getRuntime();
        return "[useDefaultRevocationChecker=" + useDefaultRevocationChecker + ", useCustomRevocationChecker=" + useCustomRevocationChecker + ", disablePrefetchedCrls=" + disablePrefetchedCrls + ", dumpStackIsEnabled=" + dumpStackIsEnabled + ", " + this.getSecuritySystemParametersAsString() + ", heapSize=" + rt.totalMemory() + ", heapMaxSize=" + rt.maxMemory() + ", heapFreeSize=" + rt.freeMemory() + "]";
    }
}

