/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.RtsHostDAO;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.Instance;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CassandraUtils;
import com.avaya.ustore.SMInfoUtils;
import com.avaya.ustore.UStoreCommonConstants;
import com.avaya.ustore.UstoreUtils;
import com.avaya.ustore.VersionHelper;
import com.avaya.ustore.objectapi.SMInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AADSInfoUtils {
    private static final Logger log = AsmLogger.getLogger(AADSInfoUtils.class);
    protected static RtsHostDAO rtsHostDAO;
    protected SMInfoUtils smInfoUtils = new SMInfoUtils();
    protected CassandraUtils cassandraUtils = new CassandraUtils();

    public AADSInfoUtils() {
        rtsHostDAO = new RtsHostDAO();
    }

    public VersionHelper getMinAADSVersion() {
        String fcn_name = "getMinAADSVersion";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        if (isFiner) {
            log.finer((Object)"getMinAADSVersion: enter");
        }
        if (!UstoreUtils.isUstoreContactOperationAllowed()) {
            if (isFiner) {
                log.finer((Object)"getMinAADSVersion: leave, Ustore operation not allowed.");
            }
            return null;
        }
        String currentAadsVersion = null;
        VersionHelper minVersion = null;
        ArrayList<SMInfo> smInfos = new ArrayList<SMInfo>();
        HashMap<Long, Instance> smInstances = new HashMap<Long, Instance>();
        List<String> hostAddresses = this.cassandraUtils.loadSMInfoAsmInst(smInfos, smInstances);
        if (hostAddresses == null || hostAddresses.isEmpty()) {
            return null;
        }
        for (Instance inst : smInstances.values()) {
            long instId = inst.getId();
            String instName = inst.getManagementAccessPointHostName();
            if (!hostAddresses.contains(instName)) {
                if (!isFinest) continue;
                log.finest((Object)("getMinAADSVersion: instance =" + instName + ", is not present into Hosts list "));
                continue;
            }
            if (inst instanceof AsmInstance) {
                AsmInstance asmInst = (AsmInstance)inst;
                if (asmInst.getAadsApplicationSystemId() == null) {
                    if (!isFinest) continue;
                    log.finest((Object)("getMinAADSVersion: instance =" + instName + " is not paired with an AADS"));
                    continue;
                }
                if (isFinest) {
                    log.finest((Object)("getMinAADSVersion: instance =" + instName + " is paired with AADS " + asmInst.getAadsApplicationSystemId()));
                }
            } else {
                if (!isFinest) continue;
                log.finest((Object)("getMinAADSVersion: instance =" + instName + " is not an AsmInstance, class=" + inst.getClass().getSimpleName()));
                continue;
            }
            SMInfo smInfo = this.cassandraUtils.getSMInfo(smInfos, instId);
            if (smInfo != null) {
                currentAadsVersion = smInfo.getAadsVersion();
            }
            if (currentAadsVersion != null && !currentAadsVersion.isEmpty()) {
                if (isFinest) {
                    log.finest((Object)"getMinAADSVersion: Current version of AADS is compatible when 3 or more SMs which are configured for a user (AURASOLTN-90).");
                }
                minVersion = new VersionHelper(UStoreCommonConstants.VALID_AADS_VERSION);
                continue;
            }
            minVersion = new VersionHelper(UStoreCommonConstants.MIN_VERSION);
            if (!isFinest) break;
            log.finest((Object)"getMinAADSVersion: Current version of AADS is NOT compatible when 3 or more SMs which are configured for a user (AURASOLTN-90).");
            break;
        }
        if (isFiner) {
            log.finer((Object)("getMinAADSVersion: leave, minVersion :" + minVersion));
        }
        return minVersion;
    }

    public int getNumberPairedAADS() {
        String fcn_name = "getNumberPairedAADS";
        boolean isFiner = log.isFinerEnabled();
        if (isFiner) {
            log.info((Object)(fcn_name + ": Enter"));
        }
        List<Object> aadsAddressList = new ArrayList();
        Long aadsApplicationSystemId = null;
        AsmInstanceDAO myAsmDAO = (AsmInstanceDAO)DMFactory.getInstance().getDataMgr(AsmInstanceDAO.class);
        AsmInstance myAsm = myAsmDAO.getMyAsmInstance();
        if (myAsm == null) {
            log.error((Object)(fcn_name + ": myAsm is NULL"));
            return 0;
        }
        aadsApplicationSystemId = myAsm.getAadsApplicationSystemId();
        if (aadsApplicationSystemId != null) {
            if (isFiner) {
                log.info((Object)(fcn_name + ": aadsApplicationSystemId: " + aadsApplicationSystemId));
            }
            aadsAddressList = rtsHostDAO.getAadsServerIpAddressList(aadsApplicationSystemId);
        }
        if (isFiner) {
            log.info((Object)(fcn_name + ": aadsAddressList: " + aadsAddressList));
        }
        return aadsAddressList.size();
    }
}

