/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.SMSMInfoDM;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.ustore.factory.UstoreDAOFactory;
import com.avaya.asm.datamgr.objectapi.Instance;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.objectapi.SMInfo;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.utils.UUIDs;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class CassandraUtils {
    protected static SMSMInfoDM smInfoDM = null;
    protected static DMFactory dmFactory = null;
    private static final Logger log = AsmLogger.getLogger(CassandraUtils.class);

    public CassandraUtils() {
        dmFactory = DMFactory.getInstance();
        smInfoDM = (SMSMInfoDM)dmFactory.getDataMgr(SMSMInfoDM.class);
    }

    public static UUID genTimeUUID() {
        return UUIDs.timeBased();
    }

    public List<String> loadSMInfoAsmInst(ArrayList<SMInfo> smInfos, Map<Long, Instance> smInstances) {
        boolean isFiner = log.isFinerEnabled();
        String fcn_name = "loadSMInfoAsmInst";
        if (isFiner) {
            log.finer((Object)("loadSMInfoAsmInst: enter with smInfos : " + smInfos + ", smInstances : " + smInstances));
        }
        Set hosts = new HashSet();
        try {
            SessionDAO sessionDAO = UstoreDAOFactory.createSessionDAO();
            Metadata metaData = sessionDAO.getClusterMetadata();
            hosts = metaData.getAllHosts();
            if (hosts == null || hosts.isEmpty()) {
                log.warn((Object)"loadSMInfoAsmInst: Hosts are not present. SM is not running..!! ");
                return null;
            }
        }
        catch (DMException e) {
            log.error((Object)"loadSMInfoAsmInst: getAllHosts threw DMException", (Throwable)e);
            return null;
        }
        ArrayList<String> hostAddresses = new ArrayList<String>();
        for (Host host : hosts) {
            hostAddresses.add(host.getAddress().getHostAddress());
        }
        try {
            smInfos.addAll(smInfoDM.getCachedSMInfos());
        }
        catch (DMException e) {
            log.error((Object)"loadSMInfoAsmInst: getAllSMInfo threw DMException", (Throwable)e);
            return null;
        }
        AsmInstanceDAO aiDao = (AsmInstanceDAO)dmFactory.getDataMgr(AsmInstanceDAO.class);
        smInstances.putAll(aiDao.getAllAsmInstances());
        if (isFiner) {
            log.finer((Object)("loadSMInfoAsmInst: leave with smInfos : " + smInfos + ", smInstances : " + smInstances + ", hostAddresses : " + hostAddresses));
        }
        return hostAddresses;
    }

    public SMInfo getSMInfo(List<SMInfo> smInfos, long instId) {
        for (SMInfo smInfo : smInfos) {
            if (smInfo.getAsmInstId() != instId) continue;
            return smInfo;
        }
        return null;
    }
}

