/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Set;

public class UStoreRepairRequestFile {
    private static final String repairRequestFileEnvVar = "CASSANDRA_REPAIRREQUEST_FILE";
    private static final String usage = "USAGE: UStoreRepairRequestFile add keyspace[:table]\n       UStoreRepairRequestFile clear\n       UStoreRepairRequest getenv\nWHERE:\n      add command adds a keyspace and optional table to the list to be repaired\n      clear clears all existing requests\n      prints the name of the environmental variable that stores the file path\n";
    private File repairRequestFile = null;
    private Path repairRequestPath = null;
    private Set<PosixFilePermission> repairRequestPerms = PosixFilePermissions.fromString("rw-r--r--");
    private final Logger log = AsmLogger.getLogger(this.getClass());

    public UStoreRepairRequestFile() {
        String fcn_name = "UStoreRepairRequestFile";
        this.repairRequestFile = this.createRepairRequestFileFromEnv();
        if (this.repairRequestFile == null) {
            this.log.error((Object)"UStoreRepairRequestFile: cannot determine path to repairRequestFile");
        } else {
            this.repairRequestPath = Paths.get(this.repairRequestFile.getAbsolutePath(), new String[0]);
        }
    }

    private File createRepairRequestFileFromEnv() {
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        String fcn_name = "createRepairRequestFileFromEnv";
        if (isFiner) {
            this.log.finer((Object)"createRepairRequestFileFromEnv: enter");
        }
        String filePath = System.getenv(repairRequestFileEnvVar);
        if (isFinest) {
            this.log.finest((Object)("createRepairRequestFileFromEnv: env variable CASSANDRA_REPAIRREQUEST_FILE is set to " + filePath));
        }
        if (filePath == null) {
            this.log.warn((Object)"createRepairRequestFileFromEnv: CASSANDRA_REPAIRREQUEST_FILE is not defined in the environment");
            return null;
        }
        File file = new File(filePath);
        if (isFiner) {
            this.log.finer((Object)("createRepairRequestFileFromEnv: leave, returning " + file));
        }
        return file;
    }

    private static void usage(PrintStream ps) {
        ps.println(usage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> readInContents() {
        String fcn_name = "readInContents";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"readInContents: enter");
        }
        if (this.repairRequestPath == null) {
            this.log.error((Object)"readInContents: repairRequestPath is null");
            if (isFiner) {
                this.log.finer((Object)"readInContents: returning null");
            }
            return null;
        }
        ArrayList<String> contents = new ArrayList<String>();
        BufferedReader bufReader = null;
        try {
            String line;
            bufReader = Files.newBufferedReader(this.repairRequestPath);
            while ((line = bufReader.readLine()) != null) {
                contents.add(line);
            }
        }
        catch (NoSuchFileException e) {
        }
        catch (IOException e) {
            this.log.error((Object)("readInContents: bufReader.readLine() failed: " + e));
            ArrayList<String> arrayList = null;
            return arrayList;
        }
        finally {
            if (bufReader != null) {
                try {
                    bufReader.close();
                }
                catch (IOException e) {
                    this.log.error((Object)("readInContents: bufReader.close() failed with " + e.getLocalizedMessage()));
                }
            }
        }
        if (isFiner) {
            this.log.finer((Object)("readInContents: leave, contents=" + contents));
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeOutContents(ArrayList<String> contents) {
        String fcn_name = "writeOutContents";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("writeOutContents: enter, contents=" + contents));
        }
        if (this.repairRequestPath == null) {
            this.log.error((Object)"writeOutContents: repairRequestPath is null");
            if (isFiner) {
                this.log.finer((Object)"writeOutContents: returning false");
            }
            return false;
        }
        BufferedWriter bufWriter = null;
        try {
            bufWriter = Files.newBufferedWriter(this.repairRequestPath, new OpenOption[0]);
        }
        catch (IOException e) {
            this.log.error((Object)("writeOutContents: newBufferedWriter() failed for file " + this.repairRequestFile + " with " + e.getLocalizedMessage()));
            return false;
        }
        try {
            try {
                Files.setPosixFilePermissions(this.repairRequestPath, this.repairRequestPerms);
            }
            catch (IOException | UnsupportedOperationException e) {
                this.log.error((Object)("writeOutContents: cannot set file permission for " + this.repairRequestPath), (Throwable)e);
            }
            try {
                for (String line : contents) {
                    bufWriter.write(line);
                    bufWriter.newLine();
                }
            }
            catch (IOException e) {
                this.log.error((Object)("writeOutContents: bufWriter.write() failed with " + e.getLocalizedMessage()));
            }
        }
        finally {
            if (bufWriter != null) {
                try {
                    bufWriter.close();
                }
                catch (IOException e) {
                    this.log.error((Object)("writeOutContents: bufWriter.close() failed with " + e.getLocalizedMessage()));
                }
            }
        }
        if (isFiner) {
            this.log.finer((Object)"writeOutContents: leave, returning true");
        }
        return true;
    }

    private boolean doAdd(String kscf) {
        ArrayList<String> contents;
        String fcn_name = "doAdd";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("doAdd: enter, kstb=" + kscf));
        }
        if ((contents = this.readInContents()) == null) {
            this.log.error((Object)"doAdd: readInContents returned null");
            if (isFiner) {
                this.log.finer((Object)"doAdd: returning false");
            }
            return false;
        }
        if (contents.contains(kscf)) {
            if (isFiner) {
                this.log.finer((Object)("doAdd: leave, returning true because contents already includes " + kscf));
            }
            return true;
        }
        contents.add(kscf);
        if (!this.writeOutContents(contents)) {
            this.log.error((Object)("doAdd: writeOutContents failed, kstb=" + kscf + ", contents=" + contents));
            if (isFiner) {
                this.log.finer((Object)"doAdd: returning false");
            }
            return false;
        }
        if (isFiner) {
            this.log.finer((Object)"doAdd: leave, returning true");
        }
        return true;
    }

    private ArrayList<String> doGet() {
        String fcn_name = "doGet";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"doGet: enter");
        }
        ArrayList<String> contents = this.readInContents();
        if (isFiner) {
            this.log.finer((Object)("doGet: return, contents=" + contents));
        }
        return contents;
    }

    private boolean doClear() {
        boolean rc = true;
        if (this.repairRequestFile.exists()) {
            rc = this.repairRequestFile.delete();
        }
        return rc;
    }

    public ArrayList<String> get() {
        return this.doGet();
    }

    public boolean clear() {
        return this.doClear();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            UStoreRepairRequestFile.usage(System.err);
            System.exit(1);
        }
        String cmd = args[0];
        String addArg = null;
        boolean clearOpt = false;
        boolean envOpt = false;
        boolean getOpt = false;
        switch (cmd) {
            case "add": {
                if (args.length != 2) {
                    System.err.println("add command requires a keyspace[:table] argument.");
                    UStoreRepairRequestFile.usage(System.err);
                    System.exit(1);
                }
                addArg = args[1];
                break;
            }
            case "clear": {
                if (args.length != 1) {
                    System.err.println("clear command does not take any arguments.");
                    UStoreRepairRequestFile.usage(System.err);
                    System.exit(1);
                }
                clearOpt = true;
                break;
            }
            case "env": {
                if (args.length != 1) {
                    System.err.println("env command does not take any arguments.");
                    UStoreRepairRequestFile.usage(System.err);
                    System.exit(1);
                }
                envOpt = true;
                break;
            }
            case "get": {
                if (args.length != 1) {
                    System.err.println("get command does not take any arguments.");
                    UStoreRepairRequestFile.usage(System.err);
                    System.exit(1);
                }
                getOpt = true;
            }
        }
        UStoreRepairRequestFile usRepReqFile = new UStoreRepairRequestFile();
        int exitRc = 0;
        if (addArg != null) {
            if (!usRepReqFile.doAdd(addArg)) {
                System.err.println("doAdd failed for " + addArg);
                exitRc = 1;
            }
        } else if (getOpt) {
            ArrayList<String> kstb = usRepReqFile.doGet();
            if (kstb == null) {
                System.err.println("doGet failed");
                exitRc = 1;
            } else {
                kstb.forEach(n -> System.out.println((String)n));
            }
        } else if (clearOpt) {
            if (!usRepReqFile.doClear()) {
                System.err.println("doClear failed");
                exitRc = 1;
            }
        } else if (envOpt) {
            System.out.println(repairRequestFileEnvVar);
        }
        System.exit(exitRc);
    }
}

