/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ssh;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.PluginUtilities;
import com.avaya.eclipse.plugin.PropertyWindowEditor;
import com.avaya.eclipse.plugin.operation.CEOperation;
import com.avaya.eclipse.plugin.util.CEPluginHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class MavenCommandline {
    private String runtimePath;
    private String tempPath = "/temp/elib/";
    private static StringBuffer tempLogBuffer = new StringBuffer();
    private static char lastChar;

    public MavenCommandline(String runtimePath, String tempPath) {
        boolean isCompleted;
        this.runtimePath = runtimePath;
        this.tempPath = tempPath;
        File f = new File(tempPath);
        if (!f.exists() && (isCompleted = f.mkdirs())) {
            Activator.log(1, "Created path " + tempPath);
        }
        if (!(f = new File(tempPath + "/logback-core.jar")).exists()) {
            this.copyJAR(this.getClass().getClassLoader().getResource("/lib/logback-core.jar"), tempPath + "/logback-core.jar");
        }
        if (!(f = new File(tempPath + "/logback-classic.jar")).exists()) {
            this.copyJAR(this.getClass().getClassLoader().getResource("/lib/logback-classic.jar"), tempPath + "/logback-classic.jar");
        }
        if (!(f = new File(tempPath + "/async-http-client.jar")).exists()) {
            this.copyJAR(this.getClass().getClassLoader().getResource("/lib/async-http-client.jar"), tempPath + "/async-http-client.jar");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyJAR(URL url, String path) {
        FileOutputStream fos = null;
        try (InputStream ins = url.openStream();){
            fos = new FileOutputStream(path);
            int read = -1;
            byte[] bytes = new byte[1024];
            while ((read = ins.read(bytes)) != -1) {
                fos.write(bytes, 0, read);
            }
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error copying jar", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    Activator.log(4, 0, "Error closing connection", e);
                }
            }
        }
    }

    private String getClassPath() {
        if (this.runtimePath.indexOf("file:/") != -1) {
            this.runtimePath = this.runtimePath.split("file:/")[1];
        }
        File[] f = this.loadJarsClassPath(this.runtimePath, null, null);
        f = this.checkAndAddInCP(f, "org.slf4j.api");
        f = this.checkAndAddInCP(f, "javax.inject");
        f = new File(PluginUtilities.getInstance().getProjectLocation() + "/plugins").exists() ? this.loadJarsClassPath(PluginUtilities.getInstance().getProjectLocation() + "/plugins", f, "com.avaya.") : this.loadJarsClassPath(PluginUtilities.getInstance().getProjectLocation() + "/dropins", f, "com.avaya.");
        f = this.loadJarsClassPath(this.tempPath, f, "");
        String app = "";
        StringBuffer sb = new StringBuffer();
        for (File fa : f) {
            sb.append(app).append(fa.getAbsolutePath());
            app = MavenCommandline.isWindows() ? ";" : ":";
        }
        return sb.toString();
    }

    public int mvn(String pathtoPomXmlFile, String action, PrintWriter pr, CEPluginHelper mvnHelper) {
        String javaCMD = System.getenv("JAVA_HOME");
        if (javaCMD == null || javaCMD.isEmpty()) {
            Activator.log(4, "JAVA HOME is not set");
            javaCMD = PropertyWindowEditor.getServerConfProperties().getProperty("JAVA_HOME");
        }
        javaCMD = javaCMD == null || javaCMD.isEmpty() ? "java" : javaCMD + "/bin/java";
        String command = "";
        command = MavenCommandline.isWindows() ? "\"" + javaCMD + "\" -classpath " + this.getClassPath() + " -Dmaven.multiModuleProjectDirectory=" + pathtoPomXmlFile + " com.avaya.ssh.MavenStartPoint " + action + " " + pathtoPomXmlFile : javaCMD + " -classpath " + this.getClassPath() + " -Dmaven.multiModuleProjectDirectory=" + pathtoPomXmlFile + " com.avaya.ssh.MavenStartPoint " + action + " " + pathtoPomXmlFile;
        Activator.log(1, "command : " + command);
        return this.invoke(command, pr, mvnHelper);
    }

    public int invoke(String action, PrintWriter pr, CEPluginHelper mvnHelper) {
        try {
            Process p = MavenCommandline.isWindows() ? (System.getenv("JAVA_HOME") != null ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", action}) : Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", action}, new String[]{"JAVA_HOME=" + PropertyWindowEditor.getServerConfProperties().getProperty("JAVA_HOME"), "M2_HOME=" + PropertyWindowEditor.getMavenHome()})) : Runtime.getRuntime().exec(action);
            if (mvnHelper != null) {
                mvnHelper.readVersion(p, pr);
            } else {
                MavenCommandline.startOutStreams(p, pr);
            }
            return p.waitFor();
        }
        catch (InterruptedException e) {
            Activator.log(4, 0, "Error ", e);
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error ", e);
            CEOperation.openDialog("Maven Operation Failure", e.getMessage());
        }
        return -1;
    }

    private File[] loadJarsClassPath(File[] existing, File[] list) {
        if (list == null || list.length == 0) {
            if (existing == null || existing.length == 0) {
                return list;
            }
            return existing;
        }
        if (existing == null || existing.length == 0) {
            return list;
        }
        File[] finalList = new File[existing.length + list.length];
        System.arraycopy(existing, 0, finalList, 0, existing.length);
        System.arraycopy(list, 0, finalList, existing.length, list.length);
        return finalList;
    }

    private File[] loadJarsClassPath(String location, File[] existing, final String startsWith) {
        File[] list = new File(location).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(startsWith == null ? "" : startsWith) && name.endsWith(".jar");
            }
        });
        return this.loadJarsClassPath(existing, list == null || list.length == 0 ? new File[]{} : list);
    }

    private static void startOutStreams(Process p, PrintWriter pr) {
        InputStream ins1 = p.getInputStream();
        InputStream ins2 = p.getErrorStream();
        MavenCommandline.startStreamReader(ins1, pr);
        MavenCommandline.startStreamReader(ins2, pr);
    }

    private static void startStreamReader(final InputStream ins, final PrintWriter pr) {
        new Thread(){

            @Override
            public void run() {
                int i = -1;
                try {
                    while ((i = ins.read()) != -1) {
                        MavenCommandline.logConsole((char)i, pr);
                    }
                }
                catch (IOException e) {
                    Activator.log(4, 0, "Error ", e);
                }
            }
        }.start();
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static boolean isWindows() {
        return MavenCommandline.getOsName().toLowerCase().contains("windows");
    }

    public static void logConsole(char c, PrintWriter writer) {
        if (c == '\r' && lastChar == '\n' || c == '\n' && lastChar == '\r') {
            lastChar = c;
            return;
        }
        lastChar = c;
        if (c == '\n' || c == '\r') {
            writer.println(tempLogBuffer.toString());
            tempLogBuffer = new StringBuffer();
        } else {
            tempLogBuffer.append(c);
        }
    }

    private File[] checkAndAddInCP(File[] f, String bundleName) {
        String jarPath = this.getPath(bundleName);
        if (jarPath != null) {
            return this.loadJarsClassPath(f, new File[]{new File(jarPath)});
        }
        return this.loadJarsClassPath(PluginUtilities.getInstance().getProjectLocation() + "/plugins", f, bundleName);
    }

    private String getPath(String bundleName) {
        Path path = new Path("/");
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle != null) {
            try {
                URL fileUrl = FileLocator.find((Bundle)bundle, (IPath)path, null);
                return new File(FileLocator.toFileURL((URL)fileUrl).toURI()).getAbsolutePath();
            }
            catch (IOException | URISyntaxException e) {
                Activator.log(4, 0, "Error ", e);
            }
        }
        return null;
    }
}

