/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AusAttribute;
import com.avaya.zephyr.platform.dao.AusServiceDAO;
import com.avaya.zephyr.platform.dm.AbstractDMListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AusAttributeDAO
extends DataAccessObject {
    private static final Logger LOG = AsmLogger.getLogger(AusAttributeDAO.class);
    protected static final String ATTRIBUTE_TABLE = "zr_attribute_value";
    protected static final String ATTRIBUTE_META_TABLE = "zr_attribute_metadata";
    protected static final String SERVICE = "zr_service";
    protected static final List<DMListener> LISTENERS = new CopyOnWriteArrayList<DMListener>();
    protected static final String getAllAttributes = "SELECT value_table.id,meta_table.attribute_name, value_table.value, value_table.template_id, value_table.service_id, meta_table.factory_default_value, meta_table.enterprise_override_value, meta_table.global, service_table.service_name FROM zr_attribute_value value_table JOIN zr_attribute_metadata meta_table on metadata_id=meta_table.id JOIN zr_service service_table on service_table.id=value_table.service_id";
    protected static final String getAllAttributesById = "SELECT value_table.id,meta_table.attribute_name, value_table.value, value_table.template_id, value_table.service_id, meta_table.factory_default_value, meta_table.enterprise_override_value, meta_table.global, service_table.service_name FROM zr_attribute_value value_table JOIN zr_attribute_metadata meta_table on metadata_id=meta_table.id JOIN zr_service service_table on service_table.id=value_table.service_id WHERE value_table.id = ?";
    protected static final String getAllAttributesByMetaAttrId = "SELECT value_table.id,meta_table.attribute_name, value_table.value, value_table.template_id, value_table.service_id, meta_table.factory_default_value, meta_table.enterprise_override_value, meta_table.global, service_table.service_name FROM zr_attribute_value value_table JOIN zr_attribute_metadata meta_table on metadata_id=meta_table.id JOIN zr_service service_table on service_table.id=value_table.service_id WHERE metadata_id = ?";
    private Map<Long, AusAttribute> attributeMap = new ConcurrentHashMap<Long, AusAttribute>();
    private Map<String, AusAttribute> globalAttributeMap;
    private Map<String, Map<String, AusAttribute>> tmplSvcAttrMap = new ConcurrentHashMap<String, Map<String, AusAttribute>>();

    public Map<Long, AusAttribute> getAttributeMap() {
        return this.attributeMap;
    }

    public Map<String, AusAttribute> getGlobalAttributeMap() {
        return this.globalAttributeMap;
    }

    public Map<String, Map<String, AusAttribute>> getTmplSvcAttrMap() {
        return this.tmplSvcAttrMap;
    }

    protected ResultSetMapper getAttributeMapper() {
        return new RSMgetAttributeMapper();
    }

    public AusAttributeDAO() {
        super(true);
        this.globalAttributeMap = new ConcurrentHashMap<String, AusAttribute>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map tmpAttributeMap;
        ConcurrentHashMap<String, Map<String, AusAttribute>> tmpTmplSvcAttrMap = new ConcurrentHashMap<String, Map<String, AusAttribute>>();
        ConcurrentHashMap<String, AusAttribute> tmpGlobalAttributeMap = new ConcurrentHashMap<String, AusAttribute>();
        try {
            Object[] params = new Object[]{};
            tmpAttributeMap = (Map)this.dataSource.executeQuery(getAllAttributes, params, (Object)this.getAttributeMapper());
            if (LOG.isFinerEnabled()) {
                LOG.finer((Object)("init: query returns all the attrubutes:" + tmpAttributeMap));
            }
            this.lock.acquireWriteLock();
            try {
                for (AusAttribute attr : tmpAttributeMap.values()) {
                    if (LOG.isFinerEnabled()) {
                        LOG.finer((Object)("init: Add attribute to the TmplSvc Map:" + attr));
                    }
                    this.addAttributeToTmplSvcMap(attr, tmpTmplSvcAttrMap);
                    this.addAttributeToGlobalMap(attr, tmpGlobalAttributeMap);
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            LOG.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent((GenericAlarmRecoveryIntf)this, (Exception)((Object)e));
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            this.attributeMap = tmpAttributeMap;
            this.tmplSvcAttrMap = tmpTmplSvcAttrMap;
            this.globalAttributeMap = tmpGlobalAttributeMap;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    private void addAttributeToTmplSvcMap(AusAttribute attr, Map<String, Map<String, AusAttribute>> curMap) {
        if (attr.getService_id() == null) {
            LOG.error((Object)("addAttributeToTmplSvcMap: attribute has no service id associated:" + attr));
            return;
        }
        if (attr.getTemplate_id() == null) {
            LOG.fine((Object)("addAttributeToTmplSvcMap: attribute has no template id associated:" + attr));
            return;
        }
        Map<String, AusAttribute> attributes = curMap.get(attr.getCombinedKey());
        if (attributes == null && (attributes = curMap.get(attr.getCombinedKey())) == null) {
            attributes = new ConcurrentHashMap<String, AusAttribute>();
            if (LOG.isFinerEnabled()) {
                LOG.finer((Object)("init: adding new map for key:" + attr.getCombinedKey()));
            }
            curMap.put(attr.getCombinedKey(), attributes);
        }
        attributes.put(attr.getName(), attr);
        if (LOG.isFinerEnabled()) {
            LOG.finer((Object)("adding attr to the attribute map:" + attr));
        }
    }

    private void removeAttributeFromTmplSvcMap(AusAttribute attribute) {
        if (attribute == null) {
            return;
        }
        Map<String, AusAttribute> attributes = this.tmplSvcAttrMap.get(attribute.getCombinedKey());
        if (attributes != null) {
            attributes.remove(attribute.getName());
        }
        if ((attributes = this.tmplSvcAttrMap.get(attribute.getCombinedKey())) != null && attributes.size() == 0 && (attributes = this.tmplSvcAttrMap.get(attribute.getCombinedKey())) != null && attributes.size() == 0) {
            this.tmplSvcAttrMap.remove(attribute.getCombinedKey());
        }
    }

    private void addAttributeToGlobalMap(AusAttribute attr, Map<String, AusAttribute> tmpGlobalAttributeMap) {
        if (attr.getService_id() == null) {
            LOG.error((Object)("Service ID is null:" + attr));
            return;
        }
        if (attr.getService_id().equals(this.getGlobalServiceID())) {
            tmpGlobalAttributeMap.put(attr.getName(), attr);
            if (LOG.isFineEnabled()) {
                LOG.fine((Object)("addAttributeToGlobalMap: AusAttribute" + attr));
            }
        }
    }

    private Long getGlobalServiceID() {
        AusServiceDAO ausServiceDAO = new AusServiceDAO();
        return ausServiceDAO.getGlobalServiceID();
    }

    private void removeAttributeFromGlobalMap(AusAttribute oldObject) {
        if (oldObject == null) {
            return;
        }
        AusAttribute temp = this.globalAttributeMap.remove(oldObject.getName());
        if (LOG.isFineEnabled()) {
            LOG.fine((Object)("removeAttributeFromGlobalMap: Removing AusAttribute" + temp));
        }
    }

    @SMConsole(description="Get all the AusAttributes based on the database.")
    public Map<Long, AusAttribute> getAllAusAttributes() {
        return Collections.unmodifiableMap(this.attributeMap);
    }

    @SMConsole(description="Get all AUS global attributes")
    public Map<String, AusAttribute> getAllAusGlobalAttributes() {
        return Collections.unmodifiableMap(this.globalAttributeMap);
    }

    @SMConsole(description="Get global attribute value")
    public AusAttribute getAusGlobalAttributeValue(String attrName) {
        if (LOG.isFineEnabled()) {
            LOG.fine((Object)("getAusGlobalAttributeValue: " + attrName + " " + this.globalAttributeMap.get(attrName)));
        }
        return this.globalAttributeMap.get(attrName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get all AusAttributes based on a template service ID.", parameterNames={"templateServiceID"})
    public Map<String, AusAttribute> getAllAusAttributesByTmplSvcID(Long templateID, Long serviceID) {
        this.lock.acquireReadLock();
        try {
            if (this.tmplSvcAttrMap.get("" + templateID + serviceID) == null) {
                Map<String, AusAttribute> map = null;
                return map;
            }
            Map<String, AusAttribute> map = Collections.unmodifiableMap(this.tmplSvcAttrMap.get("" + templateID + serviceID));
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AusAttribute getAusAttribute(Long templateID, Long serviceID, String attrKey) {
        AusAttribute attribute = null;
        this.lock.acquireReadLock();
        try {
            Map<String, AusAttribute> attrMap = this.getAllAusAttributesByTmplSvcID(templateID, serviceID);
            if (attrMap != null) {
                attribute = attrMap.get(attrKey);
            } else if (LOG.isFinerEnabled()) {
                LOG.fine((Object)("getAusAttribute: no attrMap found for: templateID:" + templateID + " serviceID: " + serviceID));
            }
            AusAttribute ausAttribute = attribute;
            return ausAttribute;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDAO(DAOTableEvent tableEvent) {
        block34: {
            DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
            Long id = tableEvent.getKey();
            AusAttribute oldObject = null;
            AusAttribute newObject = null;
            try {
                if (ATTRIBUTE_TABLE.equals(tableEvent.getTableName())) {
                    if (DAOReplicationEvent.OperationType.DELETE.equals((Object)operation)) {
                        this.lock.acquireWriteLock();
                        try {
                            AusAttribute attribute = this.attributeMap.remove(id);
                            this.removeAttributeFromTmplSvcMap(attribute);
                            this.removeAttributeFromGlobalMap(attribute);
                            oldObject = attribute;
                        }
                        finally {
                            this.lock.releaseWriteLock();
                        }
                    }
                    Map attrs = new HashMap();
                    Object[] params = new Object[]{id};
                    attrs = (Map)this.dataSource.executeQuery(getAllAttributesById, params, (Object)this.getAttributeMapper());
                    AusAttribute attribute = (AusAttribute)attrs.get(id);
                    if (attribute != null) {
                        this.lock.acquireWriteLock();
                        try {
                            oldObject = this.attributeMap.put(attribute.getId(), attribute);
                            if (LOG.isFinerEnabled()) {
                                LOG.finer((Object)("adding/updating attribute:" + attribute));
                            }
                            this.addAttributeToTmplSvcMap(attribute, this.tmplSvcAttrMap);
                            this.addAttributeToGlobalMap(attribute, this.globalAttributeMap);
                        }
                        finally {
                            this.lock.releaseWriteLock();
                        }
                    } else {
                        LOG.warn((Object)("updateDAO: Entry in the database not found: " + tableEvent));
                    }
                    if (oldObject != null) {
                        String oldId = oldObject.getCombinedKey();
                        String newId = attribute.getCombinedKey();
                        if (oldId != null && !oldId.equals(newId)) {
                            this.lock.acquireWriteLock();
                            try {
                                this.removeAttributeFromTmplSvcMap(oldObject);
                                this.removeAttributeFromGlobalMap(oldObject);
                            }
                            finally {
                                this.lock.releaseWriteLock();
                            }
                        }
                    }
                    newObject = attribute;
                    if (oldObject != null || newObject != null) {
                        AusAttribute ausAttr = oldObject != null ? oldObject : (AusAttribute)newObject;
                        this.updateListeners(oldObject, newObject, ausAttr.getService_name());
                    }
                    break block34;
                }
                if (ATTRIBUTE_META_TABLE.equals(tableEvent.getTableName())) {
                    if (!DAOReplicationEvent.OperationType.UPDATE.equals((Object)operation)) break block34;
                    Object[] params = new Object[]{id};
                    Map attributes = (Map)this.dataSource.executeQuery(getAllAttributesByMetaAttrId, params, (Object)this.getAttributeMapper());
                    for (AusAttribute attribute : attributes.values()) {
                        oldObject = this.attributeMap.put(attribute.getId(), attribute);
                        this.lock.acquireWriteLock();
                        try {
                            this.addAttributeToTmplSvcMap(attribute, this.tmplSvcAttrMap);
                            this.addAttributeToGlobalMap(attribute, this.globalAttributeMap);
                        }
                        finally {
                            this.lock.releaseWriteLock();
                        }
                        if (oldObject != null) {
                            String oldId = oldObject.getCombinedKey();
                            String newId = attribute.getCombinedKey();
                            if (oldId != null && !oldId.equals(newId)) {
                                this.lock.acquireWriteLock();
                                try {
                                    this.removeAttributeFromTmplSvcMap(oldObject);
                                    this.removeAttributeFromGlobalMap(oldObject);
                                }
                                finally {
                                    this.lock.releaseWriteLock();
                                }
                            }
                            if (!oldObject.getName().equals(attribute.getName())) {
                                this.lock.acquireWriteLock();
                                try {
                                    this.removeAttributeFromTmplSvcMap(oldObject);
                                    this.removeAttributeFromGlobalMap(oldObject);
                                }
                                finally {
                                    this.lock.releaseWriteLock();
                                }
                            }
                        }
                        newObject = attribute;
                        AusAttribute ausAttr = oldObject != null ? oldObject : newObject;
                        if (oldObject != null && ((Object)oldObject).equals(newObject)) continue;
                        this.updateListeners(oldObject, newObject, ausAttr.getService_name());
                    }
                    break block34;
                }
                LOG.warn((Object)("Unknown table for this class: " + tableEvent));
            }
            catch (DMException e) {
                LOG.error((Object)"Error encountered.", (Throwable)e);
                this.reinit();
                return;
            }
        }
    }

    public void registerListener(DMListener listener) {
        LISTENERS.add(listener);
    }

    public void removeListener(DMListener listener) {
        LISTENERS.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateListeners(Object oldObj, Object newObj, String serviceName) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        for (DMListener listener : LISTENERS) {
            try {
                if (!(listener instanceof AbstractDMListener)) continue;
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                if (!((AbstractDMListener)listener).getServiceName().equals(serviceName)) continue;
                listener.objectChanged(oldObj, newObj);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOG.error((Object)"Exception is: ", (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                LOG.error((Object)("NoClassDefFoundError on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOG.error((Object)"Error is: ", (Throwable)e);
                LOG.error((Object)("Unregistering the listener " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.removeListener(listener);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateListeners(Object oldObj, Object newObj) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        for (DMListener listener : LISTENERS) {
            try {
                if (!(listener instanceof AbstractDMListener)) continue;
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                listener.objectChanged(oldObj, newObj);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOG.error((Object)"Exception is: ", (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                LOG.error((Object)("NoClassDefFoundError on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOG.error((Object)"Error is: ", (Throwable)e);
                LOG.error((Object)("Unregistering the listener " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.removeListener(listener);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    public List<String> getDependentTables() {
        return Arrays.asList(ATTRIBUTE_TABLE, ATTRIBUTE_META_TABLE);
    }

    protected Object getMainCollection() {
        return this.attributeMap;
    }

    public static class RSMgetAttributeMapper
    implements ResultSetMapper {
        public Map<Long, AusAttribute> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, AusAttribute> tmpMap = new ConcurrentHashMap<Long, AusAttribute>();
            while (results.next()) {
                Long id = (Long)results.getObject("id");
                tmpMap.put(id, new AusAttribute(id, results.getString("attribute_name"), results.getString("value"), (Long)results.getObject("template_id"), (Long)results.getObject("service_id"), results.getString("factory_default_value"), results.getString("enterprise_override_value"), results.getBoolean("global"), results.getString("service_name")));
            }
            return tmpMap;
        }
    }
}

