/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.DigitMapRouter;
import com.avaya.zephyr.platform.dal.api.objectapi.DigitMapRow;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AusDigitMapRouterDAO
extends DataAccessObject {
    protected static final Logger log = Logger.getLogger(AusDigitMapRouterDAO.class);
    private Map<Long, DigitMapRow> digitMapTable = new ConcurrentHashMap<Long, DigitMapRow>();
    private DigitMapRouter digitMapRouter = new DigitMapRouter();
    private static final String queryDMR = "SELECT id, min_digits, max_digits, digit_pattern, description, template_id FROM zr_implicit_pattern";
    private static final String queryDMRRow = "SELECT id, min_digits, max_digits, digit_pattern, description, template_id FROM zr_implicit_pattern WHERE id = ?";
    protected static final ResultSetMapper digitMapRowsMapper = new ResultSetMapper(){

        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, DigitMapRow> digRowMap = new ConcurrentHashMap<Long, DigitMapRow>();
            while (rs.next()) {
                long id = rs.getLong("id");
                digRowMap.put(id, new DigitMapRow(id, rs.getShort("min_digits"), rs.getShort("max_digits"), rs.getString("digit_pattern"), rs.getString("description"), rs.getLong("template_id")));
            }
            return digRowMap;
        }
    };

    protected void insertRowIntoDmrMap(DigitMapRouter dmrTMP, DigitMapRow row) throws DMException {
        if (log.isFinerEnabled()) {
            log.finer((Object)"insertRowIntoDmrMap ENTER");
        }
        if (row == null) {
            return;
        }
        try {
            for (DigitMapRow subrow : row.getSubrows()) {
                dmrTMP.insert(subrow.getDigits(), subrow.getMin(), subrow.getMax(), row);
            }
        }
        catch (IllegalArgumentException | UnsupportedOperationException e1) {
            throw new DMException((Throwable)e1);
        }
        if (log.isFinerEnabled()) {
            log.finer((Object)("insertRowIntoDmrMap EXIT, Inserted " + row + " into DigitMapRouter"));
        }
    }

    private void deleteRowFromDmrMap(DigitMapRow row) throws DMException {
        block6: {
            if (log.isFinerEnabled()) {
                log.finer((Object)"deleteRowFromDmrMap ENTER");
            }
            if (row == null) {
                return;
            }
            try {
                for (DigitMapRow subrow : row.getSubrows()) {
                    this.digitMapRouter.delete(subrow.getDigits(), subrow.getMin(), subrow.getMax(), row);
                }
            }
            catch (UnsupportedOperationException e) {
                if ("pattern/min/max not found".equals(e.getMessage())) break block6;
                throw new DMException((Throwable)e);
            }
        }
        if (log.isFinerEnabled()) {
            log.finer((Object)("deleteRowFromDmrMap EXIT, Removed " + row + " from DigitMapRouter"));
        }
    }

    public Object getMainCollection() {
        return null;
    }

    public synchronized void init() {
        if (log.isFinerEnabled()) {
            log.finer((Object)("Initializing " + AusDigitMapRouterDAO.class.getSimpleName()));
        }
        Map digitMapTableTMP = new ConcurrentHashMap();
        DigitMapRouter digitMapRouterTMP = new DigitMapRouter();
        try {
            Object[] params = new Object[]{};
            digitMapTableTMP = (Map)this.dataSource.executeQuery(queryDMR, params, (Object)digitMapRowsMapper);
            for (Map.Entry entry : digitMapTableTMP.entrySet()) {
                DigitMapRow row = (DigitMapRow)entry.getValue();
                try {
                    this.insertRowIntoDmrMap(digitMapRouterTMP, row);
                }
                catch (DMException e1) {
                    this.setStatus(DataMgr.Status.FAIL);
                    log.error((Object)("Error on initializing for key=" + entry.getKey() + ", and value=" + entry.getValue()), (Throwable)e1);
                    throw e1;
                }
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e2) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e2);
        }
        this.digitMapRouter = digitMapRouterTMP;
        this.digitMapTable = digitMapTableTMP;
    }

    public synchronized void updateDAO(DAOTableEvent event) {
        block8: {
            DAOReplicationEvent.OperationType operation = event.getOperation();
            String tableName = event.getTableName();
            if (!this.getDependentTables().contains(tableName) || operation == null) {
                return;
            }
            Long id = event.getKey();
            try {
                DigitMapRow remRow = this.digitMapTable.remove(id);
                if (remRow != null) {
                    this.deleteRowFromDmrMap(remRow);
                } else if (operation != DAOReplicationEvent.OperationType.INSERT) {
                    log.warn((Object)("Tried to remove a DigitMapRow for a " + operation + " that didn't exist; we are probably out of sync."));
                }
                if (operation == DAOReplicationEvent.OperationType.UPDATE || operation == DAOReplicationEvent.OperationType.INSERT) {
                    Object[] params = new Object[]{id};
                    Map rows = (Map)this.dataSource.executeQuery(queryDMRRow, params, (Object)digitMapRowsMapper);
                    DigitMapRow row = (DigitMapRow)rows.get(id);
                    if (row == null) {
                        throw new DMException("updateDAO query returned null");
                    }
                    this.digitMapTable.put(id, row);
                    this.insertRowIntoDmrMap(this.digitMapRouter, row);
                }
            }
            catch (DMException e) {
                log.error((Object)("Error updating " + AusDigitMapRouterDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
                this.reinit();
                if (this.okay()) break block8;
                log.finer((Object)"Update NOT successful.");
                return;
            }
        }
    }

    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("zr_implicit_pattern");
        return list;
    }

    public static void setLogLevelForJUnit() {
    }

    @SMConsole(description="Get the template id for matching implicit pattern")
    public DigitMapRow findTemplateForMatchedPattern(String digits) {
        return this.digitMapRouter.findBestMatch(digits);
    }
}

