/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AusClusterService;
import com.avaya.zephyr.platform.dal.api.objectapi.AusInstance;
import com.avaya.zephyr.platform.dal.api.objectapi.AusService;
import com.avaya.zephyr.platform.dal.api.objectapi.AusTemplateService;
import com.avaya.zephyr.platform.dal.api.objectapi.ClusterDefaultAttribute;
import com.avaya.zephyr.platform.dal.api.objectapi.DefaultAttribute;
import com.avaya.zephyr.platform.dal.api.objectapi.NamedService;
import com.avaya.zephyr.platform.dal.api.objectapi.ServiceRoutingRule;
import com.avaya.zephyr.platform.dao.AusInstanceDAO;
import com.avaya.zephyr.platform.dm.AbstractDMListener;
import com.avaya.zephyr.platform.dm.AusPlatformServiceDM;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AusServiceDAO
extends DataAccessObject {
    private static final String GLOBAL = "Global";
    private static long globalServiceID = 1L;
    private static final String STARTAPPONINSTALL = "StartOnInstall";
    private static final Logger LOG = AsmLogger.getLogger(AusServiceDAO.class);
    protected static final String TEMPLATE_SERVICE = "zr_join_template_service";
    protected static final String SERVICE_VERSION = "zr_service_version";
    protected static final String SERVICE = "zr_service";
    protected static final String NAMED_SERVICE = "zr_named_service";
    protected static final String DEFAULT_SERVICE_ATTRIBUTE = "zr_join_service_metadata";
    protected static final String ATTRIBUTE_META_TABLE = "zr_attribute_metadata";
    protected static final String ATTR_VALIDATION_RULE = "zr_validation_rule";
    protected static final String CLUSTER_SERVICE_MAP_TABLE = "zr_map_sversion_cluster";
    protected static final String CLUSTER_DEFAULT_ATTR_TABLE = "zr_map_sattribute_cluster";
    protected static final String APPLICATION_NAME = "application_name";
    protected static final String BUNDLE_VERSION = "zr_bundle_version";
    protected static final String BUNDLE_SERVICEVERSION_MAP_TABLE = "zr_map_bundle_sversion";
    protected static final String BUNDLE_VERVISE_DEPENDENCY = "zr_bundle_service_dependency";
    protected static final String SERVICE_ROUTING_RULE_TABLE = "zr_service_version_routing_rule";
    protected static final String LATEST = "Latest";
    protected static final String DEFAULT = "Default";
    protected static final String ENCRYPTED_TYPE = "ENCRYPTED_STRING";
    protected static final String CLUSTER_OVERIDDEN_VAL = "cluster_override_value";
    protected static final String SERVICE_NAME = "service_name";
    protected static final List<DMListener> ATTRIBUTE_LISTENERS = new CopyOnWriteArrayList<DMListener>();
    protected static final List<DMListener> SERVICE_LISTENERS = new CopyOnWriteArrayList<DMListener>();
    protected static final String getAllDefaultsAttributes = "SELECT join_table.service_id, attribute_table.attribute_name, attribute_table.factory_default_value, attribute_table.enterprise_override_value, attribute_table.id FROM zr_attribute_metadata attribute_table JOIN zr_join_service_metadata join_table  ON attribute_table.id = join_table.attribute_metadata_id";
    protected static final String getAllDefaultAttributesByValidationType = "SELECT join_table.service_id, attribute_table.attribute_name, attribute_table.factory_default_value, attribute_table.enterprise_override_value, attribute_table.id FROM zr_attribute_metadata attribute_table JOIN zr_join_service_metadata join_table  ON attribute_table.id = join_table.attribute_metadata_id JOIN zr_validation_rule rule_table ON attribute_table.validation_rule_id = rule_table.id WHERE rule_table.validation_type= ?";
    protected static final String getAllDefaultAttributesByAttributeID = "SELECT join_table.service_id, attribute_table.attribute_name, attribute_table.factory_default_value, attribute_table.enterprise_override_value, attribute_table.id FROM zr_attribute_metadata attribute_table JOIN zr_join_service_metadata join_table  ON attribute_table.id = join_table.attribute_metadata_id where attribute_table.id = ?";
    protected static final String getAllClusterDefaultAttributes = "SELECT map_cluster.id, join_table.service_id, attribute_table.attribute_name, map_cluster.cluster_id, map_cluster.cluster_override_value FROM zr_attribute_metadata attribute_table JOIN zr_join_service_metadata join_table ON attribute_table.id = join_table.attribute_metadata_id JOIN zr_map_sattribute_cluster map_cluster ON attribute_table.id = map_cluster.sattribute_id";
    protected static final String getAllClusterDefaultAttributesByMapTableID = "SELECT map_cluster.id, join_table.service_id, attribute_table.attribute_name, map_cluster.cluster_id, map_cluster.cluster_override_value FROM zr_attribute_metadata attribute_table JOIN zr_join_service_metadata join_table ON attribute_table.id = join_table.attribute_metadata_id JOIN zr_map_sattribute_cluster map_cluster ON attribute_table.id = map_cluster.sattribute_id where map_cluster.id = ?";
    private static final String getAllServices = "SELECT service_version.id, service.id as zr_service_id, service.service_name, service.service_type, service.latest_version, service.recommended_version, version_type, version_string, application_name, orig_order, term_order, service_version.trust_status, orig_group, term_group, fs_component, up_component, to_state, service.deployment_type FROM zr_service_version service_version JOIN zr_service service ON service_id = service.id";
    protected static final String getAllServicesById = "SELECT service_version.id, service.id as zr_service_id, service.service_name, service.service_type, service.latest_version, service.recommended_version, version_type, version_string, application_name, orig_order, term_order, service_version.trust_status, orig_group, term_group, fs_component, up_component, to_state, service.deployment_type FROM zr_service_version service_version JOIN zr_service service ON service_id = service.id WHERE service_version.id = ?";
    protected static final String getAllServiceVersionsForService = "SELECT service_version.id, service.id as zr_service_id, service.service_name, service.service_type, service.latest_version, service.recommended_version, version_type, version_string, application_name, orig_order, term_order, service_version.trust_status, orig_group, term_group, fs_component, up_component, to_state, service.deployment_type FROM zr_service_version service_version JOIN zr_service service ON service_id = service.id WHERE service_id = ?";
    protected static final String getAllTemplateService = "SELECT id, template_id, service_version_id, enabled, orig_order, term_order FROM zr_join_template_service";
    protected static final String getAllNamedServicesOrderRankAsc = "SELECT id, version, handle_pattern, rank, service_version_id, feature_tag, template_id FROM zr_named_service ORDER BY rank ASC";
    protected static final String getAllTemplateServiceById = "SELECT id, template_id, service_version_id, enabled, orig_order, term_order FROM zr_join_template_service WHERE id = ?";
    protected static final String getAllServiceVersionsForServiceName = "SELECT service_version.id, service.id as zr_service_id, service.service_name, service.service_type, service.latest_version, service.recommended_version, version_type, version_string, application_name, orig_order, term_order, service_version.trust_status, orig_group, term_group, fs_component, up_component, to_state, service.deployment_type FROM zr_service_version service_version JOIN zr_service service ON service_id = service.id WHERE service.service_name = ?";
    protected static final String getAllClusterService = "SELECT map_sversion.id, cluster_id, sversion_id, sversion_table.service_id,  application_name, map_sversion.is_latest, map_sversion.is_preferred FROM zr_map_sversion_cluster map_sversion JOIN zr_service_version sversion_table ON sversion_id=sversion_table.id";
    protected static final String getClusterServiceByMapTableId = "SELECT map_sversion.id, cluster_id, sversion_id, sversion_table.service_id,  application_name, map_sversion.is_latest, map_sversion.is_preferred FROM zr_map_sversion_cluster map_sversion JOIN zr_service_version sversion_table ON sversion_id=sversion_table.id WHERE map_sversion.id = ?";
    protected static final String getServiceRoutingRulesForService = "SELECT routing_rule.id as service_routing_rule_id, routing_rule.description, routing_rule.event_package, routing_rule.imgateway, routing_rule.wildcard_comparison, routing_rule.skip_sequencing, routing_rule.service_version_id, sversion_table.version_string as service_version, service_table.service_name as service_name FROM zr_service_version_routing_rule routing_rule JOIN zr_service_version sversion_table ON routing_rule.service_version_id = sversion_table.id JOIN zr_service service_table ON sversion_table.service_id = service_table.id";
    protected static final String getServiceRoutingRulesForServiceById = "SELECT routing_rule.id as service_routing_rule_id, routing_rule.description, routing_rule.event_package, routing_rule.imgateway, routing_rule.wildcard_comparison, routing_rule.skip_sequencing, routing_rule.service_version_id, sversion_table.version_string as service_version, service_table.service_name as service_name FROM zr_service_version_routing_rule routing_rule JOIN zr_service_version sversion_table ON routing_rule.service_version_id = sversion_table.id JOIN zr_service service_table ON sversion_table.service_id = service_table.id WHERE routing_rule.service_version_id = ?";
    protected static final String getDependencybyServiceVersionIdAndClusterId = "SELECT sv.application_name FROM zr_service_version AS sv, zr_bundle_version AS bv , zr_map_bundle_sversion AS mbv, zr_bundle_service_dependency AS bsd WHERE bv.bundle_id=mbv.bundle_id AND mbv.id=bsd.bundle_sversion_id AND sv.id=bsd.sversion_id AND bv.cluster_id=? AND mbv.sversion_id=?";
    protected static final String getClusterOverriddenAttrVal = "SELECT * from zr_map_sattribute_cluster WHERE (cluster_id IN (SELECT id FROM zr_cluster WHERE name=?) AND sattribute_id IN (SELECT id FROM zr_attribute_metadata WHERE attribute_name=? AND id IN (SELECT attribute_metadata_id FROM zr_join_service_metadata WHERE service_id IN (SELECT id FROM zr_service WHERE service_name=?))))";
    protected static final String getServiceNameForPU = "SELECT DISTINCT service_name, sv.version_string as service_version, pu.log_space as pu_log_space FROM zr_service_pu pu, zr_service_version sv, zr_service s WHERE pu.service_version_id = sv.id AND sv.service_id = s.id AND pu.pu_name = ? ";
    private Map<Long, AusService> serviceMap = new ConcurrentHashMap<Long, AusService>();
    private Map<Long, Map<Long, AusService>> serviceIdToServiceMap = new ConcurrentHashMap<Long, Map<Long, AusService>>();
    private Map<Long, AusTemplateService> templateServiceMap = new ConcurrentHashMap<Long, AusTemplateService>();
    private final Map<Long, AusClusterService> clusterServiceMap;
    private Map<Long, Map<Long, AusTemplateService>> templateToServiceMap = new ConcurrentHashMap<Long, Map<Long, AusTemplateService>>();
    private Map<Long, Map<String, AusClusterService>> clusterIdToServiceMap;
    private Map<String, Long> applicationToIdMap = new ConcurrentHashMap<String, Long>();
    private Map<Long, Map<String, DefaultAttribute>> defaultAttributeMap;
    private Map<Long, Map<String, DefaultAttribute>> defaultEncryptedAttributeMap;
    private Map<Long, Map<Long, Map<String, ClusterDefaultAttribute>>> servcIdToClusterIdToClusterDefaultAttrMap;
    private final Map<Long, Map<Long, Map<String, ClusterDefaultAttribute>>> servcIdTolusterIdToClusterDefaultEncryptedAttrMap;
    private Map<Long, Map<Long, ClusterDefaultAttribute>> clusterDefaultAttrMap;
    private final Map<Long, Map<Long, ClusterDefaultAttribute>> tempClusterDefaultAttrMap;
    private final Map<Long, ClusterDefaultAttribute> clusterDefaultEncyptedAttrMap;
    private final Map<Long, ClusterDefaultAttribute> tempClusterDefaultEncryptedAttrMap;
    private Map<String, Map<String, List<ServiceRoutingRule>>> serviceNameToRoutingRuleMap;
    private List<NamedService> orderedNamedServices = new ArrayList<NamedService>();

    public long getGlobalServiceID() {
        return globalServiceID;
    }

    public Map<Long, Map<Long, AusTemplateService>> getTemplateToServiceMap() {
        return this.templateToServiceMap;
    }

    public Map<Long, Map<String, AusClusterService>> getClusterIdToServiceMap() {
        return this.clusterIdToServiceMap;
    }

    public Map<String, Long> getApplicationToIdMap() {
        return this.applicationToIdMap;
    }

    public Map<Long, Map<String, DefaultAttribute>> getDefaultAttributeMap() {
        return this.defaultAttributeMap;
    }

    public Map<Long, Map<String, DefaultAttribute>> getDefaultEncryptedAttributeMap() {
        return this.defaultEncryptedAttributeMap;
    }

    public Map<Long, Map<Long, Map<String, ClusterDefaultAttribute>>> getServcIdToClusterIdToClusterDefaultAttrMap() {
        return this.servcIdToClusterIdToClusterDefaultAttrMap;
    }

    public Map<Long, Map<Long, Map<String, ClusterDefaultAttribute>>> getServcIdTolusterIdToClusterDefaultEncryptedAttrMap() {
        return this.servcIdTolusterIdToClusterDefaultEncryptedAttrMap;
    }

    public Map<Long, Map<Long, ClusterDefaultAttribute>> getClusterDefaultAttrMap() {
        return this.clusterDefaultAttrMap;
    }

    protected void setClusterDefaultAttrMap(Map<Long, Map<Long, ClusterDefaultAttribute>> clusterDefaultAttrMap) {
        this.clusterDefaultAttrMap = clusterDefaultAttrMap;
    }

    public Map<Long, AusService> getServiceMap() {
        return this.serviceMap;
    }

    public Map<Long, Map<Long, AusService>> getServiceIdToServiceMap() {
        return this.serviceIdToServiceMap;
    }

    public Map<Long, AusTemplateService> getTemplateServiceMap() {
        return this.templateServiceMap;
    }

    public Map<Long, AusClusterService> getClusterServiceMap() {
        return this.clusterServiceMap;
    }

    public Map<Long, Map<Long, ClusterDefaultAttribute>> getTempClusterDefaultAttrMap() {
        return this.tempClusterDefaultAttrMap;
    }

    public Map<Long, ClusterDefaultAttribute> getClusterDefaultEncyptedAttrMap() {
        return this.clusterDefaultEncyptedAttrMap;
    }

    public Map<Long, ClusterDefaultAttribute> getTempClusterDefaultEncryptedAttrMap() {
        return this.tempClusterDefaultEncryptedAttrMap;
    }

    public Map<String, Map<String, List<ServiceRoutingRule>>> getServiceNameToRoutingRuleMap() {
        return this.serviceNameToRoutingRuleMap;
    }

    public List<NamedService> getOrderedNamedServices() {
        return this.orderedNamedServices;
    }

    public AusServiceDAO() {
        super(true);
        this.defaultAttributeMap = new ConcurrentHashMap<Long, Map<String, DefaultAttribute>>();
        this.defaultEncryptedAttributeMap = new ConcurrentHashMap<Long, Map<String, DefaultAttribute>>();
        this.servcIdToClusterIdToClusterDefaultAttrMap = new ConcurrentHashMap<Long, Map<Long, Map<String, ClusterDefaultAttribute>>>();
        this.servcIdTolusterIdToClusterDefaultEncryptedAttrMap = new ConcurrentHashMap<Long, Map<Long, Map<String, ClusterDefaultAttribute>>>();
        this.clusterDefaultAttrMap = new ConcurrentHashMap<Long, Map<Long, ClusterDefaultAttribute>>();
        this.tempClusterDefaultAttrMap = new ConcurrentHashMap<Long, Map<Long, ClusterDefaultAttribute>>();
        this.clusterDefaultEncyptedAttrMap = new ConcurrentHashMap<Long, ClusterDefaultAttribute>();
        this.tempClusterDefaultEncryptedAttrMap = new ConcurrentHashMap<Long, ClusterDefaultAttribute>();
        this.clusterServiceMap = new ConcurrentHashMap<Long, AusClusterService>();
        this.clusterIdToServiceMap = new ConcurrentHashMap<Long, Map<String, AusClusterService>>();
        this.serviceNameToRoutingRuleMap = new ConcurrentHashMap<String, Map<String, List<ServiceRoutingRule>>>();
    }

    protected ResultSetMapper getServiceDependency() {
        return new RSMgetServiceDependency();
    }

    protected ResultSetMapper getServiceMapper() {
        return new RSMgetServiceMapper();
    }

    protected ResultSetMapper getTemplateServiceMapper() {
        return new RSMgetTemplateServiceMapper();
    }

    protected ResultSetMapper getClusterIdToServiceMapper() {
        return new RSMgetClusterIdToServiceMapper();
    }

    protected ResultSetMapper getNamedServiceMapper() {
        return new RSMgetNameServiceMapper();
    }

    protected ResultSetMapper getDefaultAttributeMapper() {
        return new ResultSetMapper(){

            public List<DefaultAttribute> mapResults(ResultSet results) throws SQLException, DMException {
                ArrayList<DefaultAttribute> list = new ArrayList<DefaultAttribute>();
                while (results.next()) {
                    Long id = (Long)results.getObject("service_id");
                    Long attributeId = (Long)results.getObject("id");
                    list.add(new DefaultAttribute(id, results.getString("attribute_name"), results.getString("factory_default_value"), results.getString("enterprise_override_value"), attributeId));
                }
                return list;
            }
        };
    }

    protected ResultSetMapper getClusterDefaultAttributeMapper() {
        return new ResultSetMapper(){

            public Map<Long, Map<Long, Map<String, ClusterDefaultAttribute>>> mapResults(ResultSet results) throws SQLException, DMException {
                ConcurrentHashMap<Long, Map<Long, Map<String, ClusterDefaultAttribute>>> serviceIdToClusterIdAttrMap = new ConcurrentHashMap<Long, Map<Long, Map<String, ClusterDefaultAttribute>>>();
                ClusterDefaultAttribute clustDefAttr = null;
                while (results.next()) {
                    Long serviceId = (Long)results.getObject("service_id");
                    if (serviceId == 1L) continue;
                    Long id = results.getLong("id");
                    Long clusterId = results.getLong("cluster_id");
                    String attrName = results.getString("attribute_name");
                    clustDefAttr = new ClusterDefaultAttribute(id, serviceId, clusterId, attrName, results.getString(AusServiceDAO.CLUSTER_OVERIDDEN_VAL));
                    if (serviceIdToClusterIdAttrMap.get(serviceId) == null) {
                        serviceIdToClusterIdAttrMap.put(serviceId, new ConcurrentHashMap());
                    }
                    if (((Map)serviceIdToClusterIdAttrMap.get(serviceId)).get(clusterId) == null) {
                        ((Map)serviceIdToClusterIdAttrMap.get(serviceId)).put(clusterId, new ConcurrentHashMap());
                    }
                    ((Map)((Map)serviceIdToClusterIdAttrMap.get(serviceId)).get(clusterId)).put(attrName, clustDefAttr);
                    if (AusServiceDAO.this.tempClusterDefaultAttrMap.get(id) == null) {
                        AusServiceDAO.this.tempClusterDefaultAttrMap.put(id, new ConcurrentHashMap());
                    }
                    if (((Map)AusServiceDAO.this.tempClusterDefaultAttrMap.get(id)).get(serviceId) != null) continue;
                    ((Map)AusServiceDAO.this.tempClusterDefaultAttrMap.get(id)).put(serviceId, clustDefAttr);
                }
                return serviceIdToClusterIdAttrMap;
            }
        };
    }

    protected ResultSetMapper getServiceRoutingRuleMapper() {
        return new RSMgetServiceRoutingRuleMapper();
    }

    protected ResultSetMapper getServiceRoutingRuleMapperById() {
        return new RSMgetServiceRoutineRuleMapperById();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map tmpTmplSvcMap;
        Map tmpMap;
        ConcurrentHashMap<Long, Map<Long, AusService>> tmpServiceIdToServiceMap = new ConcurrentHashMap<Long, Map<Long, AusService>>();
        ConcurrentHashMap<Long, Map<Long, AusTemplateService>> tmpTemplateToServiceMap = new ConcurrentHashMap<Long, Map<Long, AusTemplateService>>();
        Map tmpClusterIdToServiceMap = null;
        ConcurrentHashMap<String, Long> tmpApplicationToIdMap = new ConcurrentHashMap<String, Long>();
        List tmpOrderedNamedService = null;
        ConcurrentHashMap<Long, Map<String, DefaultAttribute>> tempDefaultAttrMap = new ConcurrentHashMap<Long, Map<String, DefaultAttribute>>();
        ConcurrentHashMap<Long, Map<String, DefaultAttribute>> tempDefaultEncryptedAttrMap = new ConcurrentHashMap<Long, Map<String, DefaultAttribute>>();
        Map tempSvcIdToClusterDefaultAttrMap = null;
        ConcurrentHashMap<String, Map<String, List<ServiceRoutingRule>>> tmpServiceNameToRoutingRuleMap = new ConcurrentHashMap<String, Map<String, List<ServiceRoutingRule>>>();
        try {
            Object[] params = new Object[]{};
            tmpMap = (Map)this.dataSource.executeQuery(getAllServices, params, (Object)this.getServiceMapper());
            tmpTmplSvcMap = (Map)this.dataSource.executeQuery(getAllTemplateService, params, (Object)this.getTemplateServiceMapper());
            tmpClusterIdToServiceMap = (Map)this.dataSource.executeQuery(getAllClusterService, params, (Object)this.getClusterIdToServiceMapper());
            tmpOrderedNamedService = (List)this.dataSource.executeQuery(getAllNamedServicesOrderRankAsc, params, (Object)this.getNamedServiceMapper());
            List tmpDefaultAttrList = (List)this.dataSource.executeQuery(getAllDefaultsAttributes, params, (Object)this.getDefaultAttributeMapper());
            List tmpDefaultEncryptedAttrList = (List)this.dataSource.executeQuery(getAllDefaultAttributesByValidationType, new Object[]{ENCRYPTED_TYPE}, (Object)this.getDefaultAttributeMapper());
            List tmpSrvRoutingList = (List)this.dataSource.executeQuery(getServiceRoutingRulesForService, params, (Object)this.getServiceRoutingRuleMapper());
            tempSvcIdToClusterDefaultAttrMap = (Map)this.dataSource.executeQuery(getAllClusterDefaultAttributes, params, (Object)this.getClusterDefaultAttributeMapper());
            this.loadServiceListByTemplate(tmpTmplSvcMap, tmpTemplateToServiceMap);
            this.loadAccessingMapForApplicationNameToServiceID(tmpMap, tmpApplicationToIdMap, tmpServiceIdToServiceMap);
            this.loadDefaultAttributeMap(tmpDefaultAttrList, tempDefaultAttrMap);
            this.loadServiceRoutingRuleMap(tmpSrvRoutingList, tmpServiceNameToRoutingRuleMap);
            this.loadDefaultEncryptedAttribute(tmpDefaultEncryptedAttrList, tempDefaultEncryptedAttrMap);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            LOG.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent((GenericAlarmRecoveryIntf)this, (Exception)((Object)e));
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            this.serviceMap = tmpMap;
            this.serviceIdToServiceMap = tmpServiceIdToServiceMap;
            this.templateServiceMap = tmpTmplSvcMap;
            this.templateToServiceMap = tmpTemplateToServiceMap;
            this.clusterIdToServiceMap = tmpClusterIdToServiceMap;
            this.applicationToIdMap = tmpApplicationToIdMap;
            this.orderedNamedServices = tmpOrderedNamedService;
            this.defaultAttributeMap = tempDefaultAttrMap;
            this.defaultEncryptedAttributeMap = tempDefaultEncryptedAttrMap;
            this.servcIdToClusterIdToClusterDefaultAttrMap = tempSvcIdToClusterDefaultAttrMap;
            this.clusterDefaultAttrMap = this.tempClusterDefaultAttrMap;
            this.serviceNameToRoutingRuleMap = tmpServiceNameToRoutingRuleMap;
            this.setGlobalServiceID();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void loadDefaultEncryptedAttribute(List<DefaultAttribute> tmpDefaultEncryptedAttrList, Map<Long, Map<String, DefaultAttribute>> tempDefaultEncryptedAttrMap) {
        for (DefaultAttribute attribute : tmpDefaultEncryptedAttrList) {
            if (tempDefaultEncryptedAttrMap.get(attribute.getService_id()) == null) {
                tempDefaultEncryptedAttrMap.put(attribute.getService_id(), new ConcurrentHashMap());
            }
            tempDefaultEncryptedAttrMap.get(attribute.getService_id()).put(attribute.getAttributeName(), attribute);
        }
    }

    public void loadServiceRoutingRuleMap(List<ServiceRoutingRule> tmpSrvRoutingList, Map<String, Map<String, List<ServiceRoutingRule>>> tmpServiceNameToRoutingRuleMap) {
        for (ServiceRoutingRule serviceRoutingRule : tmpSrvRoutingList) {
            if (tmpServiceNameToRoutingRuleMap.get(serviceRoutingRule.getServiceName()) == null) {
                tmpServiceNameToRoutingRuleMap.put(serviceRoutingRule.getServiceName(), new ConcurrentHashMap());
            }
            if (tmpServiceNameToRoutingRuleMap.get(serviceRoutingRule.getServiceName()).get(serviceRoutingRule.getServiceVersion()) == null) {
                tmpServiceNameToRoutingRuleMap.get(serviceRoutingRule.getServiceName()).put(serviceRoutingRule.getServiceVersion(), new ArrayList());
            }
            tmpServiceNameToRoutingRuleMap.get(serviceRoutingRule.getServiceName()).get(serviceRoutingRule.getServiceVersion()).add(serviceRoutingRule);
        }
    }

    public void loadServiceListByTemplate(Map<Long, AusTemplateService> tmpTmplSvcMap, Map<Long, Map<Long, AusTemplateService>> tmpTemplateToServiceMap) {
        for (AusTemplateService ts : tmpTmplSvcMap.values()) {
            if (tmpTemplateToServiceMap.get(ts.getTemplateId()) == null) {
                tmpTemplateToServiceMap.put(ts.getTemplateId(), new ConcurrentHashMap());
            }
            tmpTemplateToServiceMap.get(ts.getTemplateId()).put(ts.getServiceId(), ts);
        }
    }

    public void loadDefaultAttributeMap(List<DefaultAttribute> tmpDefaultAttrList, Map<Long, Map<String, DefaultAttribute>> tempDefaultAttrMap) {
        for (DefaultAttribute attribute : tmpDefaultAttrList) {
            if (tempDefaultAttrMap.get(attribute.getService_id()) == null) {
                tempDefaultAttrMap.put(attribute.getService_id(), new ConcurrentHashMap());
            }
            tempDefaultAttrMap.get(attribute.getService_id()).put(attribute.getAttributeName(), attribute);
        }
    }

    public void loadAccessingMapForApplicationNameToServiceID(Map<Long, AusService> tmpMap, Map<String, Long> tmpApplicationToIdMap, Map<Long, Map<Long, AusService>> tmpServiceIdToServiceMap) {
        for (AusService svc : tmpMap.values()) {
            tmpApplicationToIdMap.put(svc.getApplicationName(), svc.getId());
            if (LATEST.equals(svc.getVersionType()) || DEFAULT.equals(svc.getVersionType())) continue;
            Map<Long, AusService> tmpServiceMap = tmpServiceIdToServiceMap.get(svc.getService_id());
            if (tmpServiceMap == null) {
                tmpServiceMap = new ConcurrentHashMap<Long, AusService>();
                tmpServiceIdToServiceMap.put(svc.getService_id(), tmpServiceMap);
            }
            tmpServiceMap.put(svc.getId(), svc);
        }
    }

    private void setGlobalServiceID() {
        for (AusService service : this.serviceMap.values()) {
            if (!GLOBAL.equalsIgnoreCase(service.getName()) || !GLOBAL.equals(service.getServiceType())) continue;
            if (LOG.isFinerEnabled()) {
                LOG.finer((Object)("global service is" + service));
            }
            globalServiceID = service.getService_id();
        }
    }

    @SMConsole(description="Get all Aus Services")
    public Map<Long, AusService> getAllAusServicesMap() {
        return this.serviceMap;
    }

    @SMConsole(description="Get all Aus Templates to Service mappings")
    public Map<Long, Map<Long, AusTemplateService>> getAllAusTemplateToServicesMap() {
        return this.templateToServiceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get all enabled Aus Services for a given templateID", parameterNames={"templateId"})
    public List<AusService> getAllServices(long templateId) {
        ArrayList<AusService> services = null;
        try {
            this.lock.acquireReadLock();
            services = new ArrayList<AusService>();
            Map<Long, AusTemplateService> tmplMap = this.templateToServiceMap.get(templateId);
            if (tmplMap != null) {
                for (AusTemplateService tmpSrvc : tmplMap.values()) {
                    AusService serviceToAdd;
                    AusService service = this.serviceMap.get(tmpSrvc.getServiceId());
                    if (service == null || !tmpSrvc.getEnabled().booleanValue() || (serviceToAdd = this.findServiceToAdd(templateId, service)) == null) continue;
                    serviceToAdd = new AusService(serviceToAdd.getId(), serviceToAdd.getName(), serviceToAdd.getServiceType(), serviceToAdd.getVersion(), serviceToAdd.getVersionType(), serviceToAdd.getLatestVersion(), serviceToAdd.getDefaultVersion(), serviceToAdd.getApplicationName(), tmpSrvc.getOrigOrder(), tmpSrvc.getTermOrder(), serviceToAdd.getOrigGroup(), serviceToAdd.getTermGroup(), serviceToAdd.getUpComponent(), serviceToAdd.getFsComponent(), serviceToAdd.getService_id(), serviceToAdd.getToState(), serviceToAdd.getDeploymentType(), serviceToAdd.getTrustStatus());
                    services.add(serviceToAdd);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("getAllService(" + templateId + ") failed " + e), (Throwable)e);
        }
        finally {
            this.lock.releaseReadLock();
        }
        return services;
    }

    private AusService findServiceToAdd(long templateId, AusService service) {
        AusService serviceToAdd = null;
        if (LATEST.equals(service.getVersionType())) {
            AusService latestService = this.findLatestService(templateId, service);
            if (latestService != null) {
                serviceToAdd = latestService;
            }
        } else if (DEFAULT.equals(service.getVersionType())) {
            AusService defaultService = this.findDefaultService(templateId, service);
            if (defaultService != null) {
                if (LOG.isFineEnabled()) {
                    LOG.fine((Object)("adding preferred service:" + defaultService));
                }
                serviceToAdd = defaultService;
            }
        } else if (this.isServiceVersionInstalledInCluster(service.getId())) {
            if (LOG.isFineEnabled()) {
                LOG.fine((Object)("adding service:" + service));
            }
            serviceToAdd = service;
        }
        return serviceToAdd;
    }

    private AusService findDefaultService(long templateId, AusService service) {
        AusService defaultService = this.getPreferredClusterService(service.getService_id());
        if (defaultService == null) {
            if (LOG.isFineEnabled()) {
                LOG.fine((Object)("getAllServices: can't find default version of " + service.getName() + " for templateId=" + templateId + ". Attempt to get latest version"));
            }
            if ((defaultService = this.getLatestClusterService(service.getService_id())) == null && LOG.isFineEnabled()) {
                LOG.fine((Object)("getAllServices: can't find latest version of " + service.getName() + " for templateId=" + templateId));
            }
        }
        return defaultService;
    }

    private AusService findLatestService(long templateId, AusService service) {
        AusService latestService = this.getLatestClusterService(service.getService_id());
        if (latestService == null) {
            if (LOG.isFineEnabled()) {
                LOG.fine((Object)("getAllServices: can't find latest version of " + service.getName() + " for templateId=" + templateId));
            }
        } else if (LOG.isFineEnabled()) {
            LOG.fine((Object)("adding latest service:" + latestService));
        }
        return latestService;
    }

    @SMConsole(description="Get the AUS Service based on a service id.", parameterNames={"serviceId"})
    public AusService getService(Long id) {
        return this.serviceMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get the TemplateService for the provided templateId and serviceId.", parameterNames={"templateId", "serviceId"})
    public AusTemplateService getTemplateServiceByIds(long templateId, long serviceId) {
        try {
            this.lock.acquireReadLock();
            AusTemplateService ausTemplateService = this.templateToServiceMap.get(templateId).get(serviceId);
            return ausTemplateService;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all Named Aus Services")
    public List<NamedService> getAllNamedServices() {
        try {
            this.lock.acquireReadLock();
            List<NamedService> list = this.orderedNamedServices;
            return list;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get the installed service by the name of it and its version. If version is null, take the one with the highest version.", parameterNames={"applicationName"})
    public AusService getServiceByApplicationName(String applicationName) {
        AusService rtnService = null;
        this.lock.acquireReadLock();
        try {
            Long sversionId = this.applicationToIdMap.get(applicationName);
            if (sversionId != null) {
                rtnService = this.serviceMap.get(sversionId);
                Long serviceId = rtnService.getService_id();
                if (LATEST.equals(rtnService.getVersionType())) {
                    rtnService = this.getLatestClusterService(serviceId);
                    if (rtnService == null) {
                        LOG.fine((Object)("Latest version for application : " + applicationName + "is not installed"));
                    }
                } else if (DEFAULT.equals(rtnService.getVersionType())) {
                    rtnService = this.getPreferredClusterService(serviceId);
                    if (rtnService == null) {
                        LOG.fine((Object)("Preferred version for application : " + applicationName + "is not installed, trying latest."));
                        rtnService = this.getLatestClusterService(serviceId);
                        if (rtnService == null) {
                            LOG.fine((Object)("Latest version for application : " + applicationName + "is not installed"));
                        }
                    }
                } else if (!this.isServiceVersionInstalledInCluster(rtnService.getId()) && (rtnService = null) == null) {
                    LOG.fine((Object)("Application : " + applicationName + "is not installed"));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("getServiceByApplicationName(" + applicationName + ") failed " + e), (Throwable)e);
        }
        finally {
            this.lock.releaseReadLock();
        }
        return rtnService;
    }

    @SMConsole(description="Given a service name, find all service versions which have this name.", parameterNames={"serviceName"})
    public List<AusService> getAllServicesByServiceName(String serviceName) {
        Object[] params = new Object[]{serviceName};
        ArrayList<AusService> rtnList = new ArrayList<AusService>();
        try {
            rtnList.addAll(((Map)this.dataSource.executeQuery(getAllServiceVersionsForServiceName, params, (Object)this.getServiceMapper())).values());
        }
        catch (DMException e) {
            LOG.error((Object)("Unable to find service versions for given service name=" + serviceName));
        }
        return rtnList;
    }

    @SMConsole(description="Given a service name, find all service versions which have this name.", parameterNames={"serviceName"})
    public List<AusService> getServicesByServiceName(String serviceName) {
        ArrayList<AusService> list = new ArrayList<AusService>();
        try {
            if (serviceName == null) {
                LOG.fine((Object)"getServicesByServiceName: serviceName is null");
                throw new NullPointerException("serviceName is null");
            }
            for (AusService service : this.serviceMap.values()) {
                if (!serviceName.equalsIgnoreCase(service.getName())) continue;
                if (LOG.isFinerEnabled()) {
                    LOG.finer((Object)("aus service " + serviceName + ": " + service));
                }
                list.add(service);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception: ", (Throwable)e);
        }
        return list;
    }

    @SMConsole(description="Given a service name, find service ID which has this name.", parameterNames={"serviceName"})
    public Long getServiceIDByServiceName(String serviceName) {
        if (serviceName == null) {
            LOG.fine((Object)"getServicesByServiceName: serviceName is null");
            return null;
        }
        for (AusService service : this.serviceMap.values()) {
            if (!serviceName.equalsIgnoreCase(service.getName())) continue;
            return service.getService_id();
        }
        if (LOG.isFineEnabled()) {
            LOG.fine((Object)("getServiceIDByServiceName: Service ID not found for service:" + serviceName));
        }
        return null;
    }

    public String getClusterOverrideValueOfAttribute(String clusterName, String serviceName, String attributeName) {
        String attributeValue = null;
        Object[] params = new Object[]{clusterName, attributeName, serviceName};
        try {
            attributeValue = (String)this.dataSource.executeQuery(getClusterOverriddenAttrVal, params, (Object)this.getRSMgetClusterOverriddenValue());
        }
        catch (DMException e) {
            LOG.error((Object)("Unable to fetch cluster overridden value for service-" + serviceName + " cluster-" + clusterName + " attribute-" + attributeName));
        }
        return attributeValue;
    }

    public List<Map<String, String>> getServiceNameForPU(String puName) {
        List puServicesInfoList = null;
        Object[] params = new Object[]{puName};
        try {
            puServicesInfoList = (List)this.dataSource.executeQuery(getServiceNameForPU, params, (Object)this.getRSMgetServiceNameForPU());
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to fetch service name for PU " + puName));
        }
        return puServicesInfoList;
    }

    private Long getServiceVersionIDByServiceNameAndVersion(String serviceName, String serviceVersion) {
        if (serviceName == null) {
            LOG.fine((Object)"getServiceVersionIDByServiceNameAndVersion: serviceName is null");
            return null;
        }
        if (serviceVersion == null) {
            LOG.fine((Object)"getServiceVersionIDByServiceNameAndVersion: serviceVersion is null");
            return null;
        }
        for (AusService service : this.serviceMap.values()) {
            if (!serviceName.equalsIgnoreCase(service.getName()) || !serviceVersion.equalsIgnoreCase(service.getVersion())) continue;
            return service.getId();
        }
        if (LOG.isFineEnabled()) {
            LOG.fine((Object)("getServiceVersionIDByServiceNameAndVersion: Service version ID not found for service:" + serviceName + " version: " + serviceVersion));
        }
        return null;
    }

    @SMConsole(description="Get the default attributes based on a service id in the zr_service table.", parameterNames={"serviceId"})
    public Map<String, DefaultAttribute> getDefaultAttributesById(Long id) {
        try {
            this.lock.acquireReadLock();
            Map<String, DefaultAttribute> map = this.defaultAttributeMap.get(id);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get the cluster default value for a service id in the zr_service table and attribute name.", parameterNames={"serviceId", "attributeName"})
    public ClusterDefaultAttribute getClusterDefaultAttribute(Long id, String attrName) {
        Long clusterId = null;
        clusterId = this.getAusInstanceDAO().getMyClusterId();
        if (clusterId == null) {
            return null;
        }
        try {
            this.lock.acquireReadLock();
            if (this.servcIdToClusterIdToClusterDefaultAttrMap != null && this.servcIdToClusterIdToClusterDefaultAttrMap.get(id) != null && this.servcIdToClusterIdToClusterDefaultAttrMap.get(id).get(clusterId) != null) {
                ClusterDefaultAttribute clusterDefaultAttribute = this.servcIdToClusterIdToClusterDefaultAttrMap.get(id).get(clusterId).get(attrName);
                return clusterDefaultAttribute;
            }
            ClusterDefaultAttribute clusterDefaultAttribute = null;
            return clusterDefaultAttribute;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get the Cluster default value based on service id in the zr_service table and attribute name.", parameterNames={"serviceId", "attributeName"})
    public ClusterDefaultAttribute getClusterDefaultEncryptedAttribute(Long id, String attrName) {
        Long clusterId = null;
        clusterId = this.getAusInstanceDAO().getMyClusterId();
        if (clusterId == null) {
            return null;
        }
        try {
            this.lock.acquireReadLock();
            if (this.servcIdToClusterIdToClusterDefaultAttrMap != null && this.servcIdToClusterIdToClusterDefaultAttrMap.get(id) != null && this.servcIdToClusterIdToClusterDefaultAttrMap.get(id).get(clusterId) != null) {
                ClusterDefaultAttribute clusterDefaultAttribute = this.servcIdToClusterIdToClusterDefaultAttrMap.get(id).get(clusterId).get(attrName);
                return clusterDefaultAttribute;
            }
            ClusterDefaultAttribute clusterDefaultAttribute = null;
            return clusterDefaultAttribute;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get a default value based a service id in the zr_service table and attribute name.", parameterNames={"serviceId", "attributeName"})
    public DefaultAttribute getDefaultAttribute(Long id, String attrName) throws NoAttributeFoundException {
        try {
            this.lock.acquireReadLock();
            if (this.defaultAttributeMap.get(id) != null) {
                DefaultAttribute defaultAttribute = this.defaultAttributeMap.get(id).get(attrName);
                return defaultAttribute;
            }
            throw new NoAttributeFoundException(((Object)((Object)this)).getClass() + ":Attribute name:" + attrName + " for service:" + id + " does not exist");
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get a default encrypted value based a service id in the zr_service table and attribute name.", parameterNames={"serviceId", "attributeName"})
    public DefaultAttribute getDefaultEncryptedAttribute(Long id, String attrName) throws NoAttributeFoundException {
        try {
            this.lock.acquireReadLock();
            if (this.defaultEncryptedAttributeMap.get(id) != null) {
                DefaultAttribute defaultAttribute = this.defaultEncryptedAttributeMap.get(id).get(attrName);
                return defaultAttribute;
            }
            LOG.error((Object)("Attribute name:" + attrName + " for service:" + id + " does not exist"));
            throw new NoAttributeFoundException(((Object)((Object)this)).getClass() + ":Attribute name:" + attrName + " for service:" + id + " does not exist");
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDependencyByApplicationName(String applicationName) {
        Long clusterId = null;
        clusterId = this.getAusInstanceDAO().getMyClusterId();
        if (clusterId != null) {
            try {
                this.lock.acquireReadLock();
                Long sversionId = this.applicationToIdMap.get(applicationName);
                if (sversionId != null) {
                    Object[] params = new Object[]{clusterId, sversionId};
                    List list = (List)this.dataSource.executeQuery(getDependencybyServiceVersionIdAndClusterId, params, (Object)this.getServiceDependency());
                    return list;
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error encountered.", (Throwable)e);
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get encrypted Y/N value based a service id in the zr_service table and attribute name.", parameterNames={"serviceId", "attributeName"})
    public boolean isEncryptedAttribute(Long id, String attrName) {
        try {
            this.lock.acquireReadLock();
            if (this.defaultEncryptedAttributeMap.get(id) != null) {
                boolean bl = this.defaultEncryptedAttributeMap.get(id).containsKey(attrName);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get a service ID of the zr_service table from the service id in the zr_service_version table", parameterNames={"serviceId"})
    public Long getServiceIdFromServiceVersionId(Long id) throws Exception {
        try {
            this.lock.acquireReadLock();
            if (this.serviceMap.get(id) != null) {
                Long l = this.serviceMap.get(id).getService_id();
                return l;
            }
            throw new Exception("No AusService is found for service ID:" + id);
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    protected ResultSetMapper getDefaultAttributeMapperByAttributeID() {
        return new ResultSetMapper(){

            public DefaultAttribute mapResults(ResultSet results) throws SQLException, DMException {
                DefaultAttribute defaultAttribute = null;
                while (results.next()) {
                    Long id = (Long)results.getObject("service_id");
                    Long attributeId = (Long)results.getObject("id");
                    defaultAttribute = new DefaultAttribute(id, results.getString("attribute_name"), results.getString("factory_default_value"), results.getString("enterprise_override_value"), attributeId);
                }
                return defaultAttribute;
            }
        };
    }

    protected DefaultAttribute getAttributeMetaTable(Long id) {
        DefaultAttribute newObject = null;
        try {
            Object[] params = new Object[]{id};
            newObject = (DefaultAttribute)this.dataSource.executeQuery(getAllDefaultAttributesByAttributeID, params, (Object)this.getDefaultAttributeMapperByAttributeID());
        }
        catch (Exception e) {
            LOG.error((Object)("Error while fetching service attribute of id=" + id + " from DataBase : " + e.getMessage()));
        }
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleClusterServiceTableUpdates(Long id, DAOReplicationEvent.OperationType operation) {
        block14: {
            try {
                if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) || operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
                    AusClusterService newInstance = (AusClusterService)this.dataSource.executeQuery(getClusterServiceByMapTableId, new Object[]{id}, (Object)this.getClusterServiceByMapTableId());
                    if (newInstance == null) break block14;
                    try {
                        this.lock.acquireWriteLock();
                        if (this.clusterIdToServiceMap.get(newInstance.getClusterId()) == null) {
                            this.clusterIdToServiceMap.put(newInstance.getClusterId(), new ConcurrentHashMap());
                        }
                        this.clusterIdToServiceMap.get(newInstance.getClusterId()).put(newInstance.getServiceName(), newInstance);
                        break block14;
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                AusClusterService clusterService = null;
                Long clusterId = null;
                String svcName = null;
                try {
                    this.lock.acquireWriteLock();
                    block8: for (Map.Entry<Long, Map<String, AusClusterService>> instances : this.clusterIdToServiceMap.entrySet()) {
                        for (Map.Entry<String, AusClusterService> entry : instances.getValue().entrySet()) {
                            clusterService = entry.getValue();
                            if (!id.equals(clusterService.getId())) continue;
                            clusterId = clusterService.getClusterId();
                            svcName = clusterService.getServiceName();
                            continue block8;
                        }
                    }
                    if (clusterId != null) {
                        this.clusterIdToServiceMap.get(clusterId).remove(svcName);
                        if (this.clusterIdToServiceMap.get(clusterId).isEmpty()) {
                            this.clusterIdToServiceMap.remove(clusterId);
                        }
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error while updating cache for change in table zr_map_sversion_cluster For id=" + id + "Exception:" + e.getMessage()));
                this.reinit();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleServiceRoutingRuleTableUpdates(Long id, DAOReplicationEvent.OperationType operation) {
        block18: {
            try {
                List newInstanceList;
                if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT) && (newInstanceList = (List)this.dataSource.executeQuery(getServiceRoutingRulesForServiceById, new Object[]{id}, (Object)this.getServiceRoutingRuleMapperById())) != null) {
                    try {
                        this.lock.acquireWriteLock();
                        for (ServiceRoutingRule newInstance : newInstanceList) {
                            if (this.serviceNameToRoutingRuleMap.get(newInstance.getServiceName()) == null) {
                                this.serviceNameToRoutingRuleMap.put(newInstance.getServiceName(), new ConcurrentHashMap());
                            }
                            if (this.serviceNameToRoutingRuleMap.get(newInstance.getServiceName()).get(newInstance.getServiceVersion()) == null) {
                                this.serviceNameToRoutingRuleMap.get(newInstance.getServiceName()).put(newInstance.getServiceVersion(), new ArrayList());
                            }
                            this.serviceNameToRoutingRuleMap.get(newInstance.getServiceName()).get(newInstance.getServiceVersion()).add(newInstance);
                        }
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                if (!operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) break block18;
                try {
                    this.lock.acquireWriteLock();
                    ArrayList<ServiceRoutingRule> delList = new ArrayList<ServiceRoutingRule>();
                    Iterator<Map.Entry<String, Map<String, List<ServiceRoutingRule>>>> instances = this.serviceNameToRoutingRuleMap.entrySet().iterator();
                    while (instances.hasNext()) {
                        Iterator<Map.Entry<String, List<ServiceRoutingRule>>> entry = instances.next().getValue().entrySet().iterator();
                        while (entry.hasNext()) {
                            for (ServiceRoutingRule routingRule : entry.next().getValue()) {
                                if (!id.equals(routingRule.getServiceVersionId())) continue;
                                delList.add(routingRule);
                            }
                        }
                    }
                    for (ServiceRoutingRule delRoutingRule : delList) {
                        this.serviceNameToRoutingRuleMap.get(delRoutingRule.getServiceName()).get(delRoutingRule.getServiceVersion()).remove(delRoutingRule);
                        if (this.serviceNameToRoutingRuleMap.get(delRoutingRule.getServiceName()).get(delRoutingRule.getServiceVersion()).isEmpty()) {
                            this.serviceNameToRoutingRuleMap.get(delRoutingRule.getServiceName()).remove(delRoutingRule.getServiceVersion());
                        }
                        if (!this.serviceNameToRoutingRuleMap.get(delRoutingRule.getServiceName()).isEmpty()) continue;
                        this.serviceNameToRoutingRuleMap.remove(delRoutingRule.getServiceName());
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error while updating cache for change in table zr_service_version_routing_rule For id=" + id + "Exception:" + e.getMessage()));
                this.reinit();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAttributeMetaTableUpdates(Long id) {
        DefaultAttribute newAttObj;
        DefaultAttribute oldAttObj;
        block9: {
            oldAttObj = null;
            newAttObj = null;
            try {
                newAttObj = this.getAttributeMetaTable(id);
                if (newAttObj == null) break block9;
                oldAttObj = this.defaultAttributeMap.get(newAttObj.getService_id()).get(newAttObj.getAttributeName());
                try {
                    this.lock.acquireWriteLock();
                    if (this.defaultAttributeMap.get(newAttObj.getService_id()) != null) {
                        this.defaultAttributeMap.get(newAttObj.getService_id()).put(newAttObj.getAttributeName(), newAttObj);
                    }
                    if (this.defaultEncryptedAttributeMap.get(newAttObj.getService_id()) != null && this.defaultEncryptedAttributeMap.get(newAttObj.getService_id()).get(newAttObj.getAttributeName()) != null) {
                        this.defaultEncryptedAttributeMap.get(newAttObj.getService_id()).put(newAttObj.getAttributeName(), newAttObj);
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error while updating cache for change in table zr_attribute_metadata For id=" + id));
                this.reinit();
                return;
            }
        }
        if (!(oldAttObj == null && newAttObj == null || oldAttObj != null && newAttObj != null && oldAttObj.equals(newAttObj))) {
            LOG.fine((Object)"Notifying Listeners for change in service attribute...");
            Long serviceId = newAttObj != null ? newAttObj.getService_id() : oldAttObj.getService_id();
            Map<Long, AusService> versionIdToServiceMap = this.serviceIdToServiceMap.get(serviceId);
            if (versionIdToServiceMap != null) {
                Map.Entry<Long, AusService> ausEntry = versionIdToServiceMap.entrySet().iterator().next();
                this.updateAttributeListeners(oldAttObj, newAttObj, ausEntry.getValue().getName());
            }
        }
    }

    protected ResultSetMapper getClusterServiceByMapTableId() {
        return new RSMgetClusterServiceByMapTableId();
    }

    protected ResultSetMapper getClusterDefaultAttributeMapperByMapTableID() {
        return new RSMgetClusterDefaultAttributeMapperByTableID();
    }

    protected ResultSetMapper getRSMgetClusterOverriddenValue() {
        return new RSMgetClusterOverriddenValue();
    }

    protected ResultSetMapper getRSMgetServiceNameForPU() {
        return new RSMgetServiceNameForPU();
    }

    protected List<ClusterDefaultAttribute> getAttributeClusterMapTable(Long id) {
        List newObjList = null;
        try {
            Object[] params = new Object[]{id};
            newObjList = (List)this.dataSource.executeQuery(getAllClusterDefaultAttributesByMapTableID, params, (Object)this.getClusterDefaultAttributeMapperByMapTableID());
        }
        catch (Exception e) {
            LOG.error((Object)("Error while fetching service attribute of id=" + id + " from DataBase : " + e.getMessage()));
        }
        return newObjList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleClusterDefaultAttrUpdate(Long id, DAOReplicationEvent.OperationType operation) {
        block22: {
            AusInstance ausInstance = this.getAusInstanceDAO().getMyAusInstance();
            List<ClusterDefaultAttribute> newAttObjList = null;
            try {
                if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) || operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
                    newAttObjList = this.getAttributeClusterMapTable(id);
                    if (newAttObjList == null) break block22;
                    try {
                        this.lock.acquireWriteLock();
                        for (ClusterDefaultAttribute newAttObject : newAttObjList) {
                            ClusterDefaultAttribute oldAttObject = null;
                            Long newServiceId = newAttObject.getService_id();
                            Long newClusterId = newAttObject.getClusterId();
                            if (this.servcIdToClusterIdToClusterDefaultAttrMap.get(newServiceId) != null && this.servcIdToClusterIdToClusterDefaultAttrMap.get(newServiceId).get(newClusterId) != null) {
                                oldAttObject = this.servcIdToClusterIdToClusterDefaultAttrMap.get(newAttObject.getService_id()).get(newAttObject.getClusterId()).get(newAttObject.getAttributeName());
                            }
                            if (this.clusterDefaultAttrMap.get(id) == null) {
                                this.clusterDefaultAttrMap.put(id, new ConcurrentHashMap());
                            }
                            if (this.clusterDefaultAttrMap.get(id).get(newServiceId) == null) {
                                this.clusterDefaultAttrMap.get(id).put(newServiceId, newAttObject);
                            }
                            if (this.servcIdToClusterIdToClusterDefaultAttrMap.get(newServiceId) == null) {
                                this.servcIdToClusterIdToClusterDefaultAttrMap.put(newServiceId, new ConcurrentHashMap());
                            }
                            if (this.servcIdToClusterIdToClusterDefaultAttrMap.get(newServiceId).get(newClusterId) == null) {
                                this.servcIdToClusterIdToClusterDefaultAttrMap.get(newServiceId).put(newClusterId, new ConcurrentHashMap());
                            }
                            this.servcIdToClusterIdToClusterDefaultAttrMap.get(newServiceId).get(newClusterId).put(newAttObject.getAttributeName(), newAttObject);
                            Map<Long, AusService> versionIdToServiceMap = this.serviceIdToServiceMap.get(newServiceId);
                            if (versionIdToServiceMap == null) continue;
                            Map.Entry<Long, AusService> ausEntry = versionIdToServiceMap.entrySet().iterator().next();
                            if (!ausInstance.getCluster_id().equals(newClusterId)) continue;
                            this.updateAttributeListeners(oldAttObject, newAttObject, ausEntry.getValue().getName());
                        }
                        break block22;
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                try {
                    Map<Long, ClusterDefaultAttribute> list = this.clusterDefaultAttrMap.get(id);
                    try {
                        this.lock.acquireWriteLock();
                        for (Map.Entry<Long, ClusterDefaultAttribute> entry : list.entrySet()) {
                            Map<Long, AusService> versionIdToServiceMap;
                            ClusterDefaultAttribute oldObj = entry.getValue();
                            Long oldServiceId = oldObj.getService_id();
                            Long oldClusterId = oldObj.getClusterId();
                            if (this.clusterDefaultAttrMap.get(id) != null && this.clusterDefaultAttrMap.get(id).get(oldServiceId) != null) {
                                this.clusterDefaultAttrMap.get(id).remove(oldServiceId);
                            }
                            if (this.clusterDefaultAttrMap.get(id).isEmpty()) {
                                this.clusterDefaultAttrMap.remove(id);
                            }
                            this.servcIdToClusterIdToClusterDefaultAttrMap.get(oldServiceId).get(oldClusterId).remove(oldObj.getAttributeName());
                            if (this.servcIdToClusterIdToClusterDefaultAttrMap.get(oldServiceId).get(oldClusterId).isEmpty()) {
                                this.servcIdToClusterIdToClusterDefaultAttrMap.get(oldServiceId).remove(oldClusterId);
                            }
                            if (this.servcIdToClusterIdToClusterDefaultAttrMap.get(oldServiceId).isEmpty()) {
                                this.servcIdToClusterIdToClusterDefaultAttrMap.remove(oldServiceId);
                            }
                            if ((versionIdToServiceMap = this.serviceIdToServiceMap.get(oldServiceId)) == null) continue;
                            Map.Entry<Long, AusService> ausEntry = versionIdToServiceMap.entrySet().iterator().next();
                            if (!ausInstance.getCluster_id().equals(oldClusterId)) continue;
                            this.updateAttributeListeners(oldObj, null, ausEntry.getValue().getName());
                        }
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Error while updating cache for change in table zr_map_sattribute_cluster For id=" + id));
                    this.reinit();
                    return;
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error while updating cache for change in table zr_attribute_metadata For id=" + id));
                this.reinit();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDAO(DAOTableEvent tableEvent) {
        ArrayList<AusService> newObjectList;
        ArrayList<AusTemplateService> oldObjectList;
        Serializable newObject;
        Serializable oldObject;
        block52: {
            String tableName = tableEvent.getTableName();
            DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
            Long id = tableEvent.getKey();
            if (LOG.isFineEnabled()) {
                LOG.fine((Object)("updateDAO: table = " + tableName + " operation = " + operation + " event = " + tableEvent));
            }
            oldObject = null;
            newObject = null;
            oldObjectList = null;
            newObjectList = null;
            try {
                if (SERVICE.equals(tableName) || SERVICE_VERSION.equals(tableName)) {
                    if (SERVICE_VERSION.equals(tableName)) {
                        this.handleServiceRoutingRuleTableUpdates(id, operation);
                    }
                    Map<Long, AusService> affectedServices = new HashMap();
                    Object[] params = new Object[]{id};
                    if (SERVICE.equals(tableName)) {
                        affectedServices = (Map)this.dataSource.executeQuery(getAllServiceVersionsForService, params, (Object)this.getServiceMapper());
                    } else if (DAOReplicationEvent.OperationType.DELETE != operation) {
                        affectedServices = (Map)this.dataSource.executeQuery(getAllServicesById, params, (Object)this.getServiceMapper());
                    } else {
                        AusService tmpSvc = this.serviceMap.get(id);
                        if (tmpSvc != null) {
                            affectedServices.put(id, tmpSvc);
                        }
                    }
                    this.lock.acquireWriteLock();
                    try {
                        for (AusService svc : affectedServices.values()) {
                            switch (operation) {
                                case DELETE: {
                                    oldObject = this.serviceMap.remove(svc.getId());
                                    if (oldObject == null) break;
                                    this.applicationToIdMap.remove(((AusService)oldObject).getApplicationName());
                                    Map<Long, AusService> tmpServiceMap = this.serviceIdToServiceMap.get(svc.getService_id());
                                    if (tmpServiceMap == null) break;
                                    tmpServiceMap.remove(svc.getId());
                                    if (!tmpServiceMap.isEmpty()) break;
                                    this.serviceIdToServiceMap.remove(svc.getService_id());
                                    break;
                                }
                                case UPDATE: 
                                case INSERT: {
                                    Map<Long, AusService> tmpServiceMap;
                                    newObject = svc;
                                    oldObject = this.serviceMap.put(svc.getId(), (AusService)newObject);
                                    if (oldObject != null) {
                                        this.applicationToIdMap.remove(((AusService)oldObject).getApplicationName());
                                    }
                                    if (!LATEST.equals(svc.getVersionType()) && !DEFAULT.equals(svc.getVersionType())) {
                                        tmpServiceMap = this.serviceIdToServiceMap.get(svc.getService_id());
                                        if (tmpServiceMap != null) {
                                            tmpServiceMap.remove(svc.getId());
                                        } else {
                                            tmpServiceMap = new ConcurrentHashMap<Long, AusService>();
                                            this.serviceIdToServiceMap.put(svc.getService_id(), tmpServiceMap);
                                        }
                                        tmpServiceMap.put(svc.getId(), svc);
                                    }
                                    this.applicationToIdMap.put(svc.getApplicationName(), svc.getId());
                                    break;
                                }
                                default: {
                                    if (!LOG.isFineEnabled()) break;
                                    LOG.fine((Object)("Unknown event: " + tableEvent));
                                }
                            }
                            if (oldObject == null && newObject == null) continue;
                            if (oldObjectList == null) {
                                oldObjectList = new ArrayList<AusTemplateService>();
                            }
                            oldObjectList.add((AusTemplateService)oldObject);
                            if (newObjectList == null) {
                                newObjectList = new ArrayList<AusService>();
                            }
                            newObjectList.add((AusService)newObject);
                        }
                        break block52;
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                if (TEMPLATE_SERVICE.equals(tableName)) {
                    try {
                        Map<Long, AusTemplateService> tmplSvc;
                        this.lock.acquireWriteLock();
                        AusTemplateService delObject = this.templateServiceMap.remove(id);
                        if (delObject != null && (tmplSvc = this.templateToServiceMap.get(delObject.getTemplateId())) != null) {
                            tmplSvc.remove(delObject.getServiceId());
                        }
                        if (DAOReplicationEvent.OperationType.DELETE != operation) {
                            Object[] params = new Object[]{id};
                            Map tmpTmplSvcMap = (Map)this.dataSource.executeQuery(getAllTemplateServiceById, params, (Object)this.getTemplateServiceMapper());
                            AusTemplateService ts = (AusTemplateService)tmpTmplSvcMap.get(id);
                            if (ts != null) {
                                this.templateServiceMap.put(id, ts);
                                if (this.templateToServiceMap.get(ts.getTemplateId()) == null) {
                                    this.templateToServiceMap.put(ts.getTemplateId(), new ConcurrentHashMap());
                                }
                                this.templateToServiceMap.get(ts.getTemplateId()).put(ts.getServiceId(), ts);
                                newObject = ts;
                            } else if (LOG.isFineEnabled()) {
                                LOG.fine((Object)("updateDAO: Expected to find an entry for " + tableEvent + " but was null"));
                            }
                        }
                        oldObject = delObject;
                        break block52;
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                if (CLUSTER_SERVICE_MAP_TABLE.equals(tableName)) {
                    this.handleClusterServiceTableUpdates(id, operation);
                    break block52;
                }
                if (NAMED_SERVICE.equals(tableName)) {
                    try {
                        List tmpOrderedNamedService;
                        this.lock.acquireWriteLock();
                        Object[] params = new Object[]{};
                        this.orderedNamedServices = tmpOrderedNamedService = (List)this.dataSource.executeQuery(getAllNamedServicesOrderRankAsc, params, (Object)this.getNamedServiceMapper());
                        break block52;
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                if (ATTRIBUTE_META_TABLE.equals(tableName) && operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
                    this.handleAttributeMetaTableUpdates(id);
                    break block52;
                }
                if (DEFAULT_SERVICE_ATTRIBUTE.equals(tableName) || ATTRIBUTE_META_TABLE.equals(tableName) || ATTR_VALIDATION_RULE.endsWith(tableName)) {
                    try {
                        this.lock.acquireWriteLock();
                        if (ATTRIBUTE_META_TABLE.equals(tableName)) {
                            this.handleAttributeMetaTableInsertAndDelete(id, operation);
                        }
                        List tmpDefaultEncryptedAttrList = (List)this.dataSource.executeQuery(getAllDefaultAttributesByValidationType, new Object[]{ENCRYPTED_TYPE}, (Object)this.getDefaultAttributeMapper());
                        this.defaultEncryptedAttributeMap.clear();
                        for (DefaultAttribute attribute : tmpDefaultEncryptedAttrList) {
                            if (this.defaultEncryptedAttributeMap.get(attribute.getService_id()) == null) {
                                this.defaultEncryptedAttributeMap.put(attribute.getService_id(), new ConcurrentHashMap());
                            }
                            this.defaultEncryptedAttributeMap.get(attribute.getService_id()).put(attribute.getAttributeName(), attribute);
                        }
                        break block52;
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                if (tableName.equals(CLUSTER_DEFAULT_ATTR_TABLE)) {
                    this.handleClusterDefaultAttrUpdate(id, operation);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error encountered.", (Throwable)e);
                this.reinit();
            }
        }
        if (oldObjectList != null && newObject != null) {
            this.updateListeners(oldObjectList, newObjectList);
        } else if (oldObject != null || newObject != null) {
            this.updateListeners(oldObject, newObject);
        }
        if (LOG.isFineEnabled()) {
            LOG.fine((Object)("updateDAO: Successful for " + tableEvent));
        }
    }

    protected void handleAttributeMetaTableInsertAndDelete(Long id, DAOReplicationEvent.OperationType operation) {
        if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            DefaultAttribute newAttObj = this.getAttributeMetaTable(id);
            if (this.defaultAttributeMap.get(newAttObj.getService_id()) == null) {
                this.defaultAttributeMap.put(newAttObj.getService_id(), new ConcurrentHashMap());
            }
            this.defaultAttributeMap.get(newAttObj.getService_id()).put(newAttObj.getAttributeName(), newAttObj);
            Map<Long, AusService> versionIdToServiceMap = this.serviceIdToServiceMap.get(newAttObj.getService_id());
            if (versionIdToServiceMap != null) {
                Map.Entry<Long, AusService> ausEntry = versionIdToServiceMap.entrySet().iterator().next();
                this.updateAttributeListeners(null, newAttObj, ausEntry.getValue().getName());
            }
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            DefaultAttribute delAttObj = null;
            String delAttributeName = null;
            Long delServiceId = null;
            boolean attributeFound = false;
            for (Map.Entry<Long, Map<String, DefaultAttribute>> instances : this.defaultAttributeMap.entrySet()) {
                for (Map.Entry<String, DefaultAttribute> entry : instances.getValue().entrySet()) {
                    if (entry.getValue().getAttributeId() == null || !entry.getValue().getAttributeId().equals(id)) continue;
                    delAttObj = entry.getValue();
                    delAttributeName = entry.getValue().getAttributeName();
                    delServiceId = entry.getValue().getService_id();
                    attributeFound = true;
                    break;
                }
                if (!attributeFound) continue;
                break;
            }
            if (delServiceId != null) {
                Map<Long, AusService> versionIdToServiceMap;
                this.defaultAttributeMap.get(delServiceId).remove(delAttributeName);
                if (this.defaultAttributeMap.get(delServiceId).isEmpty()) {
                    this.defaultAttributeMap.remove(delServiceId);
                }
                if ((versionIdToServiceMap = this.serviceIdToServiceMap.get(delServiceId)) != null) {
                    Map.Entry<Long, AusService> ausEntry = versionIdToServiceMap.entrySet().iterator().next();
                    this.updateAttributeListeners(delAttObj, null, ausEntry.getValue().getName());
                }
            }
        }
    }

    public void registerListener(DMListener listener) {
        ATTRIBUTE_LISTENERS.add(listener);
    }

    public void removeListener(DMListener listener) {
        ATTRIBUTE_LISTENERS.remove(listener);
    }

    public void registerServiceListener(DMListener listener) {
        SERVICE_LISTENERS.add(listener);
    }

    public void removeServiceListener(DMListener listener) {
        SERVICE_LISTENERS.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAttributeListeners(Object oldObj, Object newObj, String serviceName) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        for (DMListener listener : ATTRIBUTE_LISTENERS) {
            try {
                if (!(listener instanceof AbstractDMListener)) continue;
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                if (serviceName.equals(GLOBAL)) {
                    listener.objectChanged(oldObj, newObj);
                    continue;
                }
                if (!((AbstractDMListener)listener).getServiceName().equals(serviceName)) continue;
                listener.objectChanged(oldObj, newObj);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOG.error((Object)"Exception is: ", (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                LOG.error((Object)("NoClassDefFoundError on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOG.error((Object)"Error is: ", (Throwable)e);
                LOG.error((Object)("Unregistering the listener " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.removeListener(listener);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    protected void updateListeners(Object oldObj, Object newObj) {
        for (DMListener listener : SERVICE_LISTENERS) {
            try {
                listener.objectChanged(oldObj, newObj);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOG.error((Object)"Exception is: ", (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                LOG.error((Object)("updateListeners NoClassDefFoundError on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOG.error((Object)"updateListeners Error is: ", (Throwable)e);
                LOG.error((Object)("updateListeners Unregistering the listener " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.removeServiceListener(listener);
            }
        }
    }

    protected void updateListeners(List<Object> oldList, List<Object> newList) {
        if (oldList == null || newList == null || oldList.size() != newList.size()) {
            return;
        }
        int size = oldList.size();
        for (DMListener listener : SERVICE_LISTENERS) {
            try {
                for (int i = 0; i < size; ++i) {
                    listener.objectChanged(oldList.get(i), newList.get(i));
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Exception on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOG.error((Object)"Exception is: ", (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                LOG.error((Object)("updateListeners NoClassDefFoundError on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOG.error((Object)"updateListeners Error is: ", (Throwable)e);
                LOG.error((Object)("updateListeners Unregistering the listener " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.removeServiceListener(listener);
            }
        }
    }

    public List<String> getDependentTables() {
        return Arrays.asList(SERVICE, SERVICE_VERSION, TEMPLATE_SERVICE, NAMED_SERVICE, DEFAULT_SERVICE_ATTRIBUTE, ATTRIBUTE_META_TABLE, ATTR_VALIDATION_RULE, CLUSTER_DEFAULT_ATTR_TABLE, CLUSTER_SERVICE_MAP_TABLE);
    }

    protected Object getMainCollection() {
        return this.serviceMap;
    }

    public List<String> getGlobalAttributeList() {
        return this.getServiceAttributeList(this.getGlobalServiceID());
    }

    public List<String> getServiceAttributeList(Long serviceID) {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, DefaultAttribute> map = this.defaultAttributeMap.get(serviceID);
        if (map == null) {
            LOG.error((Object)("No map found for service: " + serviceID + ". Map is null"));
            return list;
        }
        list.addAll(map.keySet());
        return list;
    }

    public Map<Long, AusService> getServicesFromServiceId(Long serviceId) {
        if (serviceId != null) {
            return this.serviceIdToServiceMap.get(serviceId);
        }
        LOG.fine((Object)"getServicesFromServiceId: ServiceId is null");
        return null;
    }

    protected AusInstanceDAO getAusInstanceDAO() {
        return (AusInstanceDAO)DMFactory.getInstance().getDataMgr(AusInstanceDAO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get All services in the cluster")
    public ArrayList<String> getAllClusterServices() {
        AusInstanceDAO ausInstDao = this.getAusInstanceDAO();
        Long clusterId = ausInstDao.getMyClusterId();
        ArrayList<String> serviceNames = new ArrayList<String>();
        if (clusterId != null && this.clusterIdToServiceMap.get(clusterId) != null) {
            try {
                this.lock.acquireReadLock();
                serviceNames.addAll(this.clusterIdToServiceMap.get(clusterId).keySet());
                ArrayList<String> arrayList = serviceNames;
                return arrayList;
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClusterServiceByServiceName(String serviceName) {
        AusInstanceDAO ausInstDao = this.getAusInstanceDAO();
        Long clusterId = ausInstDao.getMyClusterId();
        try {
            Map<String, AusClusterService> nameToServiceMap;
            this.lock.acquireWriteLock();
            if (clusterId != null && (nameToServiceMap = this.clusterIdToServiceMap.get(clusterId)) != null) {
                nameToServiceMap.remove(serviceName);
                if (nameToServiceMap.isEmpty()) {
                    this.clusterIdToServiceMap.remove(clusterId);
                }
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public boolean isServiceVersionInstalledInCluster(Long sversionId) {
        AusInstanceDAO ausInstDao = this.getAusInstanceDAO();
        Long clusterId = ausInstDao.getMyClusterId();
        if (clusterId != null && this.clusterIdToServiceMap.get(clusterId) != null) {
            for (AusClusterService service : this.clusterIdToServiceMap.get(clusterId).values()) {
                if (!service.getSversionId().equals(sversionId)) continue;
                return true;
            }
        }
        return false;
    }

    @SMConsole
    public AusService getLatestClusterService(Long serviceId) {
        AusInstanceDAO ausInstDao = this.getAusInstanceDAO();
        Long clusterId = ausInstDao.getMyClusterId();
        if (clusterId != null && this.clusterIdToServiceMap.get(clusterId) != null) {
            for (AusClusterService service : this.clusterIdToServiceMap.get(clusterId).values()) {
                if (!service.getServiceId().equals(serviceId) || !service.isLatest()) continue;
                return this.serviceMap.get(service.getSversionId());
            }
        }
        return null;
    }

    @SMConsole
    public AusService getPreferredClusterService(Long serviceId) {
        AusInstanceDAO ausInstDao = this.getAusInstanceDAO();
        Long clusterId = ausInstDao.getMyClusterId();
        if (clusterId != null && this.clusterIdToServiceMap.get(clusterId) != null) {
            for (AusClusterService service : this.clusterIdToServiceMap.get(clusterId).values()) {
                if (!service.getServiceId().equals(serviceId) || !service.isPreferred()) continue;
                return this.serviceMap.get(service.getSversionId());
            }
        }
        return null;
    }

    @SMConsole
    public AusService getLatestClusterServiceByName(String serviceName) {
        AusInstanceDAO ausInstDao;
        Long clusterId;
        Long serviceId = this.getServiceIDByServiceName(serviceName);
        if (serviceId != null && (clusterId = (ausInstDao = this.getAusInstanceDAO()).getMyClusterId()) != null && this.clusterIdToServiceMap.get(clusterId) != null) {
            for (AusClusterService service : this.clusterIdToServiceMap.get(clusterId).values()) {
                if (!service.getServiceId().equals(serviceId) || !service.isLatest()) continue;
                return this.serviceMap.get(service.getSversionId());
            }
        }
        return null;
    }

    @SMConsole
    public AusService getPreferredClusterServiceByName(String serviceName) {
        AusInstanceDAO ausInstDao;
        Long clusterId;
        Long serviceId = this.getServiceIDByServiceName(serviceName);
        if (serviceId != null && (clusterId = (ausInstDao = this.getAusInstanceDAO()).getMyClusterId()) != null && this.clusterIdToServiceMap.get(clusterId) != null) {
            for (AusClusterService service : this.clusterIdToServiceMap.get(clusterId).values()) {
                if (!service.getServiceId().equals(serviceId) || !service.isPreferred()) continue;
                return this.serviceMap.get(service.getSversionId());
            }
        }
        return null;
    }

    @SMConsole
    public AusService getDefaultClusterServiceByName(String serviceName) {
        AusService ausService = this.getPreferredClusterServiceByName(serviceName);
        if (ausService == null) {
            ausService = this.getLatestClusterServiceByName(serviceName);
        }
        return ausService;
    }

    public String getServiceAttribute(String serviceName, String attrName) {
        AusPlatformServiceDM dm = (AusPlatformServiceDM)DMFactory.getInstance().getDataMgr(AusPlatformServiceDM.class);
        String attrValue = null;
        try {
            attrValue = dm.getServiceAttribute(serviceName, attrName);
        }
        catch (NoAttributeFoundException e) {
            if (attrName != null && attrName.equalsIgnoreCase(STARTAPPONINSTALL)) {
                LOG.warn((Object)("Attribute not found for the given service. " + e.getMessage()));
            }
            LOG.error((Object)("Attribute not found for the given service. " + e.getMessage()));
        }
        return attrValue;
    }

    @SMConsole(description="Get Encrypted service attribue value")
    public String getEncryptedServiceAttribute(String serviceName, String attrName) {
        AusPlatformServiceDM dm = (AusPlatformServiceDM)DMFactory.getInstance().getDataMgr(AusPlatformServiceDM.class);
        String attrValue = null;
        try {
            attrValue = dm.getEncryptedServiceAttribute(serviceName, attrName);
        }
        catch (NoAttributeFoundException e) {
            LOG.error((Object)("Attribute not found for the given service." + e.getMessage()));
        }
        return attrValue;
    }

    @SMConsole(description="Get Service version to routing rule map")
    public Map<String, List<ServiceRoutingRule>> getESCAndIMRoutingRulesByServiceName(String serviceName) {
        HashMap<String, List<ServiceRoutingRule>> tmpMap = new HashMap<String, List<ServiceRoutingRule>>();
        if (this.serviceNameToRoutingRuleMap.get(serviceName) == null) {
            return tmpMap;
        }
        return Collections.unmodifiableMap(this.serviceNameToRoutingRuleMap.get(serviceName));
    }

    @SMConsole(description="Returns true if the given service is preferred")
    public boolean isPreferred(String serviceName, String serviceVersion) {
        AusInstanceDAO ausInstDao;
        Long clusterId;
        Long serviceVersionId = this.getServiceVersionIDByServiceNameAndVersion(serviceName, serviceVersion);
        if (serviceVersionId != null && (clusterId = (ausInstDao = this.getAusInstanceDAO()).getMyClusterId()) != null && this.clusterIdToServiceMap.get(clusterId) != null) {
            for (AusClusterService service : this.clusterIdToServiceMap.get(clusterId).values()) {
                if (!service.getSversionId().equals(serviceVersionId)) continue;
                if (!service.isPreferred()) break;
                return true;
            }
        }
        return false;
    }

    protected String getAllServicesQuery() {
        return getAllServices;
    }

    public static class RSMgetServiceNameForPU
    implements ResultSetMapper {
        public List<Map<String, String>> mapResults(ResultSet results) throws SQLException, DMException {
            ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
            while (results.next()) {
                HashMap<String, String> puInfoMap = new HashMap<String, String>();
                puInfoMap.put(AusServiceDAO.SERVICE_NAME, results.getString(AusServiceDAO.SERVICE_NAME));
                puInfoMap.put("service_version", results.getString("service_version"));
                puInfoMap.put("pu_log_space", results.getString("pu_log_space"));
                resultList.add(puInfoMap);
            }
            return resultList;
        }
    }

    public static class RSMgetClusterOverriddenValue
    implements ResultSetMapper {
        public String mapResults(ResultSet results) throws SQLException, DMException {
            ArrayList<String> resultList = new ArrayList<String>();
            while (results.next()) {
                resultList.add(results.getString(AusServiceDAO.CLUSTER_OVERIDDEN_VAL));
            }
            if (resultList.isEmpty()) {
                return null;
            }
            return (String)resultList.get(0);
        }
    }

    public static class RSMgetServiceDependency
    implements ResultSetMapper {
        public List<String> mapResults(ResultSet results) throws SQLException, DMException {
            ArrayList<String> resultList = new ArrayList<String>();
            while (results.next()) {
                resultList.add(results.getString(AusServiceDAO.APPLICATION_NAME));
            }
            return resultList;
        }
    }

    public static class RSMgetClusterServiceByMapTableId
    implements ResultSetMapper {
        public AusClusterService mapResults(ResultSet results) throws SQLException, DMException {
            AusClusterService clusterService = null;
            while (results.next()) {
                clusterService = new AusClusterService(results.getLong("id"), results.getLong("cluster_id"), results.getLong("sversion_id"), results.getLong("service_id"), results.getString(AusServiceDAO.APPLICATION_NAME), results.getBoolean("is_latest"), results.getBoolean("is_preferred"));
            }
            return clusterService;
        }
    }

    public static class RSMgetClusterDefaultAttributeMapperByTableID
    implements ResultSetMapper {
        public final List<ClusterDefaultAttribute> mapResults(ResultSet results) throws SQLException, DMException {
            ArrayList<ClusterDefaultAttribute> tmpList = new ArrayList<ClusterDefaultAttribute>();
            while (results.next()) {
                Long serviceId = (Long)results.getObject("service_id");
                if (serviceId == 1L) continue;
                tmpList.add(new ClusterDefaultAttribute(results.getLong("id"), serviceId, results.getLong("cluster_id"), results.getString("attribute_name"), results.getString(AusServiceDAO.CLUSTER_OVERIDDEN_VAL)));
            }
            return tmpList;
        }
    }

    public static class RSMgetClusterIdToServiceMapper
    implements ResultSetMapper {
        public final Map<Long, Map<String, AusClusterService>> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, Map<String, AusClusterService>> tmpMap = new ConcurrentHashMap<Long, Map<String, AusClusterService>>();
            while (results.next()) {
                Long clusterId = (Long)results.getObject("cluster_id");
                String svcName = (String)results.getObject(AusServiceDAO.APPLICATION_NAME);
                AusClusterService clusterService = new AusClusterService(results.getLong("id"), clusterId, results.getLong("sversion_id"), results.getLong("service_id"), svcName, results.getBoolean("is_latest"), results.getBoolean("is_preferred"));
                if (tmpMap.get(clusterId) == null) {
                    tmpMap.put(clusterId, new ConcurrentHashMap());
                }
                ((Map)tmpMap.get(clusterId)).put(svcName, clusterService);
            }
            return tmpMap;
        }
    }

    public static class RSMgetServiceRoutineRuleMapperById
    implements ResultSetMapper {
        public final List<ServiceRoutingRule> mapResults(ResultSet results) throws SQLException, DMException {
            ArrayList<ServiceRoutingRule> list = new ArrayList<ServiceRoutingRule>();
            while (results.next()) {
                list.add(new ServiceRoutingRule(results.getLong("service_routing_rule_id"), results.getString(AusServiceDAO.SERVICE_NAME), results.getString("description"), results.getString("event_package"), results.getBoolean("imgateway"), results.getBoolean("wildcard_comparison"), results.getBoolean("skip_sequencing"), results.getString("service_version"), results.getLong("service_version_id")));
            }
            return list;
        }
    }

    public static class RSMgetNameServiceMapper
    implements ResultSetMapper {
        public final List<NamedService> mapResults(ResultSet results) throws SQLException, DMException {
            ArrayList<NamedService> tmpList = new ArrayList<NamedService>();
            while (results.next()) {
                tmpList.add(new NamedService((Long)results.getObject("id"), (Integer)results.getObject("version"), results.getString("handle_pattern"), (Integer)results.getObject("rank"), (Long)results.getObject("service_version_id"), results.getString("feature_tag"), (Long)results.getObject("template_id")));
            }
            return tmpList;
        }
    }

    public static class RSMgetServiceRoutingRuleMapper
    implements ResultSetMapper {
        public final List<ServiceRoutingRule> mapResults(ResultSet results) throws SQLException, DMException {
            ArrayList<ServiceRoutingRule> list = new ArrayList<ServiceRoutingRule>();
            while (results.next()) {
                Long id = (Long)results.getObject("service_routing_rule_id");
                list.add(new ServiceRoutingRule(id, results.getString(AusServiceDAO.SERVICE_NAME), results.getString("description"), results.getString("event_package"), results.getBoolean("imgateway"), results.getBoolean("wildcard_comparison"), results.getBoolean("skip_sequencing"), results.getString("service_version"), results.getLong("service_version_id")));
            }
            return list;
        }
    }

    private static class RSMgetTemplateServiceMapper
    implements ResultSetMapper {
        private RSMgetTemplateServiceMapper() {
        }

        public final Map<Long, AusTemplateService> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, AusTemplateService> tmpMap = new ConcurrentHashMap<Long, AusTemplateService>();
            while (results.next()) {
                Long id = (Long)results.getObject("id");
                tmpMap.put(id, new AusTemplateService(id, (Long)results.getObject("template_id"), (Long)results.getObject("service_version_id"), results.getBoolean("enabled"), (Integer)results.getObject("orig_order"), (Integer)results.getObject("term_order")));
            }
            return tmpMap;
        }
    }

    private static class RSMgetServiceMapper
    implements ResultSetMapper {
        private RSMgetServiceMapper() {
        }

        public Map<Long, AusService> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, AusService> tmpMap = new ConcurrentHashMap<Long, AusService>();
            while (results.next()) {
                Long id = (Long)results.getObject("id");
                tmpMap.put(id, new AusService(id, results.getString(AusServiceDAO.SERVICE_NAME), results.getString("service_type"), results.getString("version_string"), results.getString("version_type"), results.getString("latest_version"), results.getString("recommended_version"), results.getString(AusServiceDAO.APPLICATION_NAME), (Integer)results.getObject("orig_order"), (Integer)results.getObject("term_order"), (Integer)results.getObject("orig_group"), (Integer)results.getObject("term_group"), results.getBoolean("up_component"), results.getBoolean("fs_component"), (Long)results.getObject("zr_service_id"), results.getString("to_state"), results.getString("deployment_type"), results.getBoolean("trust_status")));
            }
            return tmpMap;
        }
    }
}

