/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AuthorizationCertDetails;
import com.avaya.zephyr.platform.dao.AusInstanceDAO;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPublicKey;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.DatatypeConverter;

public class AuthorizationCertDetailsDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(AuthorizationCertDetailsDAO.class);
    private static final String ZR_AUTHORIZATION_CERTS = "zr_authorization_certs";
    private static final String GET_AUTHORIZATION_CERTS_DETAILS = "SELECT ID as ID, AUTH_SERVICE_IDENTIFIER AS AUTHSERVICEIDENTIFIER, FSINSTANCE_ID AS FSINSTANCEID, CERTS AS CERTS FROM ZR_AUTHORIZATION_CERTS";
    private static final String GET_AUTHORIZATION_CERTS_DETAILS_BY_ID = "SELECT ID as ID, AUTH_SERVICE_IDENTIFIER AS AUTHSERVICEIDENTIFIER, FSINSTANCE_ID AS FSINSTANCEID, CERTS AS CERTS FROM ZR_AUTHORIZATION_CERTS WHERE ID=?";
    private Map<Long, AuthorizationCertDetails> idToAuthorizationCertDetailsMap = new ConcurrentHashMap<Long, AuthorizationCertDetails>();
    private Map<Long, Long> nodeIdToIdMap = new ConcurrentHashMap<Long, Long>();
    private Map<String, Long> authServiceAppIdtoIdMap = new ConcurrentHashMap<String, Long>();
    protected static final List<DMListener> LISTENERS = new CopyOnWriteArrayList<DMListener>();

    protected AusInstanceDAO getAusInstanceDAO() {
        return (AusInstanceDAO)DMFactory.getInstance().getDataMgr(AusInstanceDAO.class);
    }

    protected final ResultSetMapper getAuthorizationCertDetailsMapper() {
        return new ResultSetMapper(){

            public Map<Long, AuthorizationCertDetails> mapResults(ResultSet results) throws SQLException, DMException {
                ConcurrentHashMap<Long, AuthorizationCertDetails> idToAuthorizationCertDetailsMapTmp = new ConcurrentHashMap<Long, AuthorizationCertDetails>();
                while (results.next()) {
                    AuthorizationCertDetails authorizationCertDetails = new AuthorizationCertDetails(results.getLong("ID"), results.getString("AUTHSERVICEIDENTIFIER"), results.getString("CERTS"), results.getLong("FSINSTANCEID"), AuthorizationCertDetailsDAO.this.buildRSAPublicKey(results.getString("CERTS")));
                    idToAuthorizationCertDetailsMapTmp.put(results.getLong("ID"), authorizationCertDetails);
                }
                return idToAuthorizationCertDetailsMapTmp;
            }
        };
    }

    protected final ResultSetMapper getAuthorizationCertDetailsMapperById() {
        return new ResultSetMapper(){

            public AuthorizationCertDetails mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    String publicKeyString = results.getString("CERTS");
                    RSAPublicKey rsaPublickKey = AuthorizationCertDetailsDAO.this.buildRSAPublicKey(publicKeyString);
                    AuthorizationCertDetails authorizationCertDetails = new AuthorizationCertDetails(results.getLong("ID"), results.getString("AUTHSERVICEIDENTIFIER"), results.getString("CERTS"), results.getLong("FSINSTANCEID"), rsaPublickKey);
                    return authorizationCertDetails;
                }
                return null;
            }
        };
    }

    private RSAPublicKey buildRSAPublicKey(String publicKeyStr) {
        byte[] publicKeyByteArray = DatatypeConverter.parseBase64Binary((String)publicKeyStr);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(publicKeyByteArray);
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            Certificate cert = certFactory.generateCertificate(inputStream);
            return (RSAPublicKey)cert.getPublicKey();
        }
        catch (CertificateException e) {
            this.log.error((Object)("AuthorizationCertDetailsDAO buildRSAPublicKey : CertificateException for cert: " + publicKeyStr), (Throwable)e);
            return null;
        }
    }

    public void init() {
        Map idToAuthorizationCertDetailsMapTmp;
        try {
            Object[] params = new Object[]{};
            idToAuthorizationCertDetailsMapTmp = (Map)this.dataSource.executeQuery(GET_AUTHORIZATION_CERTS_DETAILS, params, (Object)this.getAuthorizationCertDetailsMapper());
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("AuthorizationCertDetailsDAO init(): Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            if (idToAuthorizationCertDetailsMapTmp != null && !idToAuthorizationCertDetailsMapTmp.isEmpty()) {
                this.idToAuthorizationCertDetailsMap = idToAuthorizationCertDetailsMapTmp;
                this.populateDependantMaps();
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    private void populateDependantMaps() {
        if (this.idToAuthorizationCertDetailsMap != null && this.idToAuthorizationCertDetailsMap.keySet() != null) {
            Iterator<Long> iterator = this.idToAuthorizationCertDetailsMap.keySet().iterator();
            while (iterator.hasNext()) {
                AuthorizationCertDetails authCertDetails = this.idToAuthorizationCertDetailsMap.get(iterator.next());
                this.nodeIdToIdMap.put(authCertDetails.getNodeId(), authCertDetails.getId());
                this.authServiceAppIdtoIdMap.put(authCertDetails.getAuthServiceIdentifier(), authCertDetails.getId());
            }
        }
    }

    public List<String> getDependentTables() {
        return Arrays.asList(ZR_AUTHORIZATION_CERTS);
    }

    protected Object getMainCollection() {
        return this.idToAuthorizationCertDetailsMap;
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("AuthorizationCertDetailsDAO updateDAO(): " + tableEvent));
        }
        String tableName = tableEvent.getTableName();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        if (operation != null && tableName.equalsIgnoreCase(ZR_AUTHORIZATION_CERTS)) {
            this.updateAuthorizationCertDetails(operation, id);
        }
    }

    private void updateAuthorizationCertDetails(DAOReplicationEvent.OperationType operation, Long id) {
        if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            this.handleAuthorizationCertsDelete(id);
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
            this.handleAuthorizationCertsUpdate(id);
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            this.handleAuthorizationCertsInsert(id);
        }
    }

    private void handleAuthorizationCertsInsert(Long id) {
        AuthorizationCertDetails newObject;
        block5: {
            newObject = null;
            try {
                newObject = (AuthorizationCertDetails)this.dataSource.executeQuery(GET_AUTHORIZATION_CERTS_DETAILS_BY_ID, new Object[]{id}, (Object)this.getAuthorizationCertDetailsMapperById());
                if (newObject == null) break block5;
                this.lock.acquireWriteLock();
                try {
                    this.idToAuthorizationCertDetailsMap.put(id, newObject);
                    this.nodeIdToIdMap.put(newObject.getNodeId(), id);
                    this.authServiceAppIdtoIdMap.put(newObject.getAuthServiceIdentifier(), id);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("AuthorizationCertDetailsDAO handleAuthorizationCertsInsert():Error while updating Cache for table zr_authorization_certs " + e.getMessage()));
            }
        }
        this.updateListeners(null, newObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAuthorizationCertsUpdate(Long id) {
        AuthorizationCertDetails oldObject;
        AuthorizationCertDetails newObject;
        block5: {
            newObject = null;
            oldObject = null;
            try {
                newObject = (AuthorizationCertDetails)this.dataSource.executeQuery(GET_AUTHORIZATION_CERTS_DETAILS_BY_ID, new Object[]{id}, (Object)this.getAuthorizationCertDetailsMapperById());
                oldObject = this.idToAuthorizationCertDetailsMap.get(id);
                if (newObject == null || oldObject == null) break block5;
                this.lock.acquireWriteLock();
                try {
                    this.idToAuthorizationCertDetailsMap.remove(id);
                    this.idToAuthorizationCertDetailsMap.put(id, newObject);
                    this.nodeIdToIdMap.remove(oldObject.getNodeId());
                    this.authServiceAppIdtoIdMap.remove(oldObject.getAuthServiceIdentifier());
                    this.nodeIdToIdMap.put(newObject.getNodeId(), id);
                    this.authServiceAppIdtoIdMap.put(newObject.getAuthServiceIdentifier(), id);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("AuthorizationCertDetailsDAO handleAuthorizationCertsUpdate(): Error while updating Cache for table zr_authorization_certs " + e.getMessage()));
            }
        }
        this.updateListeners(oldObject, newObject);
    }

    private void handleAuthorizationCertsDelete(Long id) {
        AuthorizationCertDetails oldObject = null;
        try {
            this.lock.acquireWriteLock();
            oldObject = this.idToAuthorizationCertDetailsMap.get(id);
            if (oldObject != null) {
                this.idToAuthorizationCertDetailsMap.remove(id);
                this.nodeIdToIdMap.remove(oldObject.getNodeId());
                this.authServiceAppIdtoIdMap.remove(oldObject.getAuthServiceIdentifier());
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.updateListeners(oldObject, null);
    }

    @SMConsole(description="Get authorization service app ID of the current node")
    public String getAuthServiceAppId() {
        AuthorizationCertDetails authCertDetails;
        Long instanceId = this.getAusInstanceDAO().getMyInstanceId();
        Long entryId = this.nodeIdToIdMap.get(instanceId);
        if (entryId != null && (authCertDetails = this.idToAuthorizationCertDetailsMap.get(entryId)) != null) {
            return authCertDetails.getAuthServiceIdentifier();
        }
        return null;
    }

    @SMConsole(description="Get RSA Public key for the input authorization service app ID")
    public RSAPublicKey getRSAPublicKey(String authServiceAppId) {
        AuthorizationCertDetails authCertDetails;
        Long entryId = this.authServiceAppIdtoIdMap.get(authServiceAppId);
        if (entryId != null && (authCertDetails = this.idToAuthorizationCertDetailsMap.get(entryId)) != null) {
            return authCertDetails.getRsaPublickKey();
        }
        return null;
    }

    @SMConsole(description="Get RSA public key for the current node")
    public RSAPublicKey getRSAPublicKey() {
        AuthorizationCertDetails authCertDetails;
        Long instanceId = this.getAusInstanceDAO().getMyInstanceId();
        Long entryId = this.nodeIdToIdMap.get(instanceId);
        if (entryId != null && (authCertDetails = this.idToAuthorizationCertDetailsMap.get(entryId)) != null) {
            return authCertDetails.getRsaPublickKey();
        }
        return null;
    }

    @SMConsole(description="Get certificate for the current node")
    public String getCertificate() {
        AuthorizationCertDetails authCertDetails;
        Long instanceId = this.getAusInstanceDAO().getMyInstanceId();
        Long entryId = this.nodeIdToIdMap.get(instanceId);
        if (entryId != null && (authCertDetails = this.idToAuthorizationCertDetailsMap.get(entryId)) != null) {
            return authCertDetails.getCerts();
        }
        return null;
    }

    public void registerListener(DMListener listener) {
        LISTENERS.add(listener);
    }

    public void removeListener(DMListener listener) {
        LISTENERS.remove(listener);
    }

    protected void updateListeners(Object oldObj, Object newObj) {
        for (DMListener listener : LISTENERS) {
            try {
                listener.objectChanged(oldObj, newObj);
            }
            catch (Exception e) {
                this.log.error((Object)("Exception on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()), (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                this.log.error((Object)("NoClassDefFoundError on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.log.error((Object)"Error is: ", (Throwable)e);
                this.log.error((Object)("Unregistering the listener " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.removeListener(listener);
            }
        }
    }
}

