/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.encrypt.EncryptDecrypt;
import com.avaya.zephyr.platform.dal.api.objectapi.AuthorizationClient;
import com.avaya.zephyr.platform.dal.api.objectapi.AuthorizationPki;
import com.avaya.zephyr.platform.dal.api.objectapi.AuthorizationServer;
import com.avaya.zephyr.platform.dao.AusInstanceDAO;
import com.avaya.zephyr.platform.dao.AusServiceDAO;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class AuthorizationServiceDAO
extends DataAccessObject {
    protected static final String AUTHORIZATION_KEY = "zr_authorization_key";
    protected static final String AUTHORIZATION_CLIENT = "zr_authorization_client";
    protected static final String AUTHORIZATION_SERVICE = "zr_authorization_service";
    protected static final String AUTHORIZATION_RESOURCE = "zr_authorization_resource";
    protected static final String SERVICE_VERSION = "zr_service_version";
    protected static final String SERVICE = "zr_service";
    protected static final String CLIENT_APP_ATTRIBUTE_NAME = "com.avaya.authorization.client";
    protected static final String AUTHZ_SERVER_ATTRIBUTE_NAME = "com.avaya.authorization.server";
    protected static final List<DMListener> LISTENERS = new CopyOnWriteArrayList<DMListener>();
    protected static final String GET_CLIENT_APPS = "select client_table.id, client_table.client_app_name, client_table.client_app_id, pki_table.public_key,pki_table.fingerprint, client_table.redirection_uri, pki_table.cert_expiry from zr_authorization_client client_table JOIN zr_authorization_key pki_table ON client_table.key_id = pki_table.id";
    protected static final String GET_CLIENT_APPS_BY_ID = "select client_table.id, client_table.client_app_name, client_table.client_app_id, pki_table.public_key,pki_table.fingerprint, client_table.redirection_uri, pki_table.cert_expiry from zr_authorization_client client_table JOIN zr_authorization_key pki_table ON client_table.key_id = pki_table.id where client_table.id = ?";
    protected static final String GET_AUTHZ_APPS = "select server_table.id, server_table.service_name, server_table.service_app_id, pki_table.public_key,pki_table.fingerprint from zr_authorization_service server_table JOIN zr_authorization_key pki_table ON server_table.key_id = pki_table.id";
    protected static final String GET_AUTHZ_APPS_BY_ID = "select server_table.id, server_table.service_name, server_table.service_app_id, pki_table.public_key,pki_table.fingerprint from zr_authorization_service server_table JOIN zr_authorization_key pki_table ON server_table.key_id = pki_table.id where server_table.id = ?";
    protected static final String GET_ALL_PKI = "select pki_table.id,pki_table.public_key,pki_table.private_key,pki_table.fingerprint,pki_table.cert_expiry,pki_table.auth_service_identifier,server_table.id as server_table_id,server_table.service_name,server_table.sversion_id as server_sversion_id,server_table.cluster_id as server_cluster_id,server_table.service_app_id,client_table.id as client_table_id,client_table.client_app_name,client_table.sversion_id as client_sversion_id,client_table.cluster_id as client_cluster_id,client_table.client_app_id from zr_authorization_key pki_table LEFT JOIN zr_authorization_service server_table ON pki_table.id=server_table.key_id LEFT JOIN zr_authorization_client client_table ON pki_table.id=client_table.key_id";
    protected static final String GET_ALL_PKI_BY_ID = "select pki_table.id,pki_table.public_key,pki_table.private_key,pki_table.fingerprint,pki_table.cert_expiry,pki_table.auth_service_identifier,server_table.id as server_table_id,server_table.service_name,server_table.sversion_id as server_sversion_id,server_table.cluster_id as server_cluster_id,server_table.service_app_id,client_table.id as client_table_id,client_table.client_app_name,client_table.sversion_id as client_sversion_id,client_table.cluster_id as client_cluster_id,client_table.client_app_id from zr_authorization_key pki_table LEFT JOIN zr_authorization_service server_table ON pki_table.id=server_table.key_id LEFT JOIN zr_authorization_client client_table ON pki_table.id=client_table.key_id where pki_table.id = ?";
    protected static final String GET_RESOURCE_APPS = "select resource.resource_name,resource.cluster_id,service.service_name from zr_authorization_resource resource join zr_service_version sversion on resource.sversion_id = sversion.id join zr_service service on sversion.service_id=service.id where sversion.version_string = 'Default'";
    private static DMFactory factory;
    private Map<Long, AuthorizationClient> authorizationClientMap;
    private Map<Long, AuthorizationServer> authorizationServerMap;
    private Map<Long, AuthorizationPki> pkiIdToApplicationMap;
    private final Map<Long, Map<String, String>> clusterIdToAppMap;
    private final Map<String, String> appIdToPrivateKeyMap;
    private final Map<String, String> appIdToPublicKeyMap;
    private final Map<String, RSAPrivateKey> appIdToRSAPrivateKeyMap;
    private final Map<String, RSAPublicKey> appIdToRSAPublicKeyMap;
    private Map<Long, Map<String, String>> serviceNameToResourceNameMap;
    private final Map<String, Long> idToAuthorizationCertExpiryMap;
    private final Logger logger = AsmLogger.getLogger(AuthorizationServiceDAO.class);

    private static DMFactory getFactory() {
        if (factory == null) {
            factory = DMFactory.getInstance();
        }
        return factory;
    }

    public AuthorizationServiceDAO() {
        this.authorizationClientMap = new ConcurrentHashMap<Long, AuthorizationClient>();
        this.authorizationServerMap = new ConcurrentHashMap<Long, AuthorizationServer>();
        this.pkiIdToApplicationMap = new ConcurrentHashMap<Long, AuthorizationPki>();
        this.clusterIdToAppMap = new ConcurrentHashMap<Long, Map<String, String>>();
        this.appIdToPrivateKeyMap = new ConcurrentHashMap<String, String>();
        this.appIdToPublicKeyMap = new ConcurrentHashMap<String, String>();
        this.appIdToRSAPrivateKeyMap = new ConcurrentHashMap<String, RSAPrivateKey>();
        this.appIdToRSAPublicKeyMap = new ConcurrentHashMap<String, RSAPublicKey>();
        this.serviceNameToResourceNameMap = new ConcurrentHashMap<Long, Map<String, String>>();
        this.idToAuthorizationCertExpiryMap = new ConcurrentHashMap<String, Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map tempServiceNameToResourceNameMap;
        Map tempAuthorizationServerMap;
        Map tempAuthorizationClientMap;
        Map tempPkiIdToAppMap;
        this.logger.info((Object)"AuthorizationServiceDAO::init ENTER");
        Object[] params = new Object[]{};
        try {
            tempPkiIdToAppMap = (Map)this.dataSource.executeQuery(GET_ALL_PKI, params, (Object)this.getPkiMapper());
            tempAuthorizationClientMap = (Map)this.dataSource.executeQuery(GET_CLIENT_APPS, params, (Object)this.getClientAppMapper());
            tempAuthorizationServerMap = (Map)this.dataSource.executeQuery(GET_AUTHZ_APPS, params, (Object)this.getAuthzAppMapper());
            tempServiceNameToResourceNameMap = (Map)this.dataSource.executeQuery(GET_RESOURCE_APPS, params, (Object)this.getResourceMapper());
        }
        catch (DMException e) {
            this.logger.error((Object)"Error while initializing AuthorizationServiceDAO, ", (Throwable)e);
            this.setStatus(DataMgr.Status.FAIL);
            return;
        }
        try {
            this.lock.acquireWriteLock();
            this.pkiIdToApplicationMap = tempPkiIdToAppMap;
            this.authorizationClientMap = tempAuthorizationClientMap;
            this.authorizationServerMap = tempAuthorizationServerMap;
            this.serviceNameToResourceNameMap = tempServiceNameToResourceNameMap;
            this.populateAppIdAndKeyMaps();
            this.populateDependantMaps();
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.logger.info((Object)"AuthorizationServiceDAO::init EXIT");
    }

    private void populateAppIdAndKeyMaps() {
        for (Map.Entry<Long, AuthorizationPki> entry : this.pkiIdToApplicationMap.entrySet()) {
            AuthorizationPki authorizationPki = entry.getValue();
            RSAPublicKey rsaPublicKey = this.buildRSAPublicKey(authorizationPki.getPublicKey());
            if (rsaPublicKey == null) {
                this.logger.warn((Object)("Couldn't build RSAPublicKey for = " + authorizationPki.getAppId()));
                continue;
            }
            if (authorizationPki.getClusterId() == null || authorizationPki.getClusterId().longValue() == NumberUtils.LONG_ZERO.longValue()) {
                if (!StringUtils.isEmpty((CharSequence)authorizationPki.getAuthServiceIdentifier())) {
                    this.appIdToPublicKeyMap.put(authorizationPki.getAuthServiceIdentifier(), authorizationPki.getPublicKey());
                    this.appIdToRSAPublicKeyMap.put(authorizationPki.getAuthServiceIdentifier(), rsaPublicKey);
                    continue;
                }
                if (authorizationPki.getAppId() == null) continue;
                this.appIdToPublicKeyMap.put(authorizationPki.getAppId(), authorizationPki.getPublicKey());
                this.appIdToRSAPublicKeyMap.put(authorizationPki.getAppId(), rsaPublicKey);
                continue;
            }
            RSAPrivateKey rsaPrivateKey = this.buildRSAPrivateKey(authorizationPki.getPrivateKey(), authorizationPki.getAppName());
            if (rsaPrivateKey == null) {
                this.logger.info((Object)("Couldn't build RSAPrivateKey for = " + authorizationPki.getAppName()));
                continue;
            }
            if (this.clusterIdToAppMap.get(authorizationPki.getClusterId()) == null) {
                this.clusterIdToAppMap.put(authorizationPki.getClusterId(), new ConcurrentHashMap());
            }
            this.clusterIdToAppMap.get(authorizationPki.getClusterId()).put(authorizationPki.getAppName(), authorizationPki.getAppId());
            if (!StringUtils.isEmpty((CharSequence)authorizationPki.getAuthServiceIdentifier())) {
                this.appIdToPrivateKeyMap.put(authorizationPki.getAuthServiceIdentifier(), authorizationPki.getPrivateKey());
                this.appIdToRSAPrivateKeyMap.put(authorizationPki.getAuthServiceIdentifier(), rsaPrivateKey);
                this.appIdToPublicKeyMap.put(authorizationPki.getAuthServiceIdentifier(), authorizationPki.getPublicKey());
                this.appIdToRSAPublicKeyMap.put(authorizationPki.getAuthServiceIdentifier(), rsaPublicKey);
                continue;
            }
            this.appIdToPrivateKeyMap.put(authorizationPki.getAppId(), authorizationPki.getPrivateKey());
            this.appIdToRSAPrivateKeyMap.put(authorizationPki.getAppId(), rsaPrivateKey);
            this.appIdToPublicKeyMap.put(authorizationPki.getAppId(), authorizationPki.getPublicKey());
            this.appIdToRSAPublicKeyMap.put(authorizationPki.getAppId(), rsaPublicKey);
        }
    }

    private RSAPublicKey buildRSAPublicKey(String publicKeyStr) {
        try {
            byte[] secretByteArray = DatatypeConverter.parseBase64Binary((String)publicKeyStr);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(secretByteArray);
            try {
                return (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(keySpec);
            }
            catch (InvalidKeySpecException e) {
                this.logger.error((Object)"AuthorizationServiceDAO getRSAPublicKey : InvalidKeySpecException ", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error((Object)"AuthorizationServiceDAO getRSAPublicKey : RSA algorithm is not found ", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"AuthorizationServiceDAO getRSAPublicKey : Couldn't build RSAPublicKey ", (Throwable)e);
        }
        return null;
    }

    private RSAPrivateKey buildRSAPrivateKey(String privateKeyStr, String appName) {
        try {
            String secret = EncryptDecrypt.decrypt((String)privateKeyStr, (String)appName);
            byte[] secretByteArray = DatatypeConverter.parseBase64Binary((String)secret);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(secretByteArray);
            try {
                return (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(keySpec);
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error((Object)"RSA algorithm not found ", (Throwable)e);
            }
            catch (InvalidKeySpecException e) {
                this.logger.error((Object)"Invalid key specification ", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"AuthorizationServiceDAO buildRSAPrivateKey : Couldn't build RSAPrivateKey ", (Throwable)e);
        }
        return null;
    }

    protected ResultSetMapper getPkiMapper() {
        return new PkiResultSetMapper();
    }

    protected ResultSetMapper getResourceMapper() {
        return new ResultSetMapper(){

            public Map<Long, Map<String, String>> mapResults(ResultSet results) throws SQLException, DMException {
                ConcurrentHashMap<Long, Map<String, String>> resourceMap = new ConcurrentHashMap<Long, Map<String, String>>();
                while (results.next()) {
                    Long clusterId = results.getLong("cluster_id");
                    if (resourceMap.get(clusterId) == null) {
                        resourceMap.put(clusterId, new ConcurrentHashMap());
                    }
                    ((Map)resourceMap.get(clusterId)).put(results.getString("service_name"), results.getString("resource_name"));
                }
                return resourceMap;
            }
        };
    }

    protected ResultSetMapper getClientAppMapper() {
        return new ResultSetMapper(){

            public Map<Long, AuthorizationClient> mapResults(ResultSet results) throws SQLException, DMException {
                HashMap<Long, AuthorizationClient> map = new HashMap<Long, AuthorizationClient>();
                while (results.next()) {
                    map.put(results.getLong("id"), new AuthorizationClient(results.getLong("id"), results.getString("client_app_name"), results.getString("client_app_id"), results.getString("public_key"), results.getString("fingerprint"), results.getString("redirection_uri"), results.getString("cert_expiry")));
                }
                return map;
            }
        };
    }

    protected ResultSetMapper getAuthzAppMapper() {
        return new ResultSetMapper(){

            public Map<Long, AuthorizationServer> mapResults(ResultSet results) throws SQLException, DMException {
                HashMap<Long, AuthorizationServer> map = new HashMap<Long, AuthorizationServer>();
                while (results.next()) {
                    map.put(results.getLong("id"), new AuthorizationServer(results.getString("service_name"), results.getString("service_app_id"), results.getString("public_key"), results.getString("fingerprint")));
                }
                return map;
            }
        };
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        String tableName = tableEvent.getTableName();
        if (this.logger.isFinestEnabled()) {
            this.logger.finest((Object)("updateDAO: table = " + tableName + " operation = " + tableEvent.getOperation() + " event = " + tableEvent));
        }
        if (AUTHORIZATION_KEY.equals(tableName)) {
            this.handleUpdateForPkiTable(tableEvent);
        }
        if (AUTHORIZATION_CLIENT.equals(tableName)) {
            this.handleUpdateForClientTable(tableEvent);
        }
        if (AUTHORIZATION_SERVICE.equals(tableName)) {
            this.handleUpdateForAuthzTable(tableEvent);
        }
        if (AUTHORIZATION_RESOURCE.equals(tableName)) {
            this.handleUpdateForResourceTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUpdateForResourceTable() {
        Map tempServiceNameToResourceNameMap;
        Object[] params = new Object[]{};
        try {
            tempServiceNameToResourceNameMap = (Map)this.dataSource.executeQuery(GET_RESOURCE_APPS, params, (Object)this.getResourceMapper());
        }
        catch (DMException e) {
            this.logger.error((Object)"Error while updating resource map ", (Throwable)e);
            return;
        }
        try {
            this.lock.acquireWriteLock();
            this.serviceNameToResourceNameMap = tempServiceNameToResourceNameMap;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUpdateForAuthzTable(DAOTableEvent tableEvent) {
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        try {
            this.lock.acquireWriteLock();
            if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) || operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
                AuthorizationServer oldObject = this.authorizationServerMap.get(id);
                AuthorizationServer newObject = this.getAuthorizationServerByID(id);
                this.authorizationServerMap.put(id, newObject);
                this.updateListeners(oldObject, newObject);
            } else {
                AuthorizationServer oldObject = this.authorizationServerMap.remove(id);
                this.updateListeners(oldObject, null);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.reinitKeyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUpdateForClientTable(DAOTableEvent tableEvent) {
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        try {
            this.lock.acquireWriteLock();
            if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) || operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
                AuthorizationClient oldObject = this.authorizationClientMap.get(id);
                AuthorizationClient newObject = this.getAuthorizationClientByID(id);
                this.authorizationClientMap.put(id, newObject);
                if (newObject != null && oldObject != null && !oldObject.getClientAppId().equals(newObject.getClientAppId())) {
                    this.idToAuthorizationCertExpiryMap.remove(oldObject.getClientAppId());
                    this.idToAuthorizationCertExpiryMap.put(newObject.getClientAppId(), newObject.getId());
                } else if (newObject != null) {
                    this.idToAuthorizationCertExpiryMap.put(newObject.getClientAppId(), newObject.getId());
                }
                this.updateListeners(oldObject, newObject);
            } else {
                AuthorizationClient oldObject = this.authorizationClientMap.remove(id);
                if (oldObject != null) {
                    this.idToAuthorizationCertExpiryMap.remove(oldObject.getClientAppId());
                }
                this.updateListeners(oldObject, null);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.reinitKeyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUpdateForPkiTable(DAOTableEvent tableEvent) {
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        try {
            this.lock.acquireWriteLock();
            if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
                this.actOnPkiTableUpdateOrInsert(id);
            }
            if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
                AuthorizationPki authorizationPki = this.actOnPkiTableUpdateOrInsert(id);
                if (authorizationPki == null) {
                    return;
                }
                if (authorizationPki.getServerId() != null && authorizationPki.getServerId().longValue() != NumberUtils.LONG_ZERO.longValue()) {
                    AuthorizationServer oldServerObject = this.authorizationServerMap.get(authorizationPki.getServerId());
                    AuthorizationServer newServerObject = new AuthorizationServer(authorizationPki.getAppName(), authorizationPki.getAppId(), authorizationPki.getPublicKey(), authorizationPki.getFingerprint());
                    this.authorizationServerMap.put(authorizationPki.getServerId(), newServerObject);
                    this.updateListeners(oldServerObject, newServerObject);
                } else {
                    AuthorizationClient oldClientObject = this.authorizationClientMap.get(authorizationPki.getClientId());
                    AuthorizationClient newClientObject = new AuthorizationClient(authorizationPki.getClientId(), authorizationPki.getAppName(), authorizationPki.getAppId(), authorizationPki.getPublicKey(), authorizationPki.getFingerprint(), oldClientObject.getRedirectURI(), authorizationPki.getCertExpiry());
                    this.authorizationClientMap.put(authorizationPki.getClientId(), newClientObject);
                    this.updateListeners(oldClientObject, newClientObject);
                }
            }
            if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
                this.handleAuthorizationKeyDeleteEvent(id);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    private void handleAuthorizationKeyDeleteEvent(Long id) {
        Map<String, String> appNameToAppIdMap;
        AuthorizationPki authorizationPki = this.pkiIdToApplicationMap.remove(id);
        if (authorizationPki.getClusterId() != null && authorizationPki.getClusterId().longValue() != NumberUtils.LONG_ZERO.longValue() && (appNameToAppIdMap = this.clusterIdToAppMap.get(authorizationPki.getClusterId())) != null) {
            appNameToAppIdMap.remove(authorizationPki.getAppName());
            if (this.clusterIdToAppMap.get(authorizationPki.getClusterId()).isEmpty()) {
                this.clusterIdToAppMap.remove(authorizationPki.getClusterId());
            }
        }
        this.appIdToPrivateKeyMap.remove(authorizationPki.getAppId());
        this.appIdToRSAPrivateKeyMap.remove(authorizationPki.getAppId());
        this.appIdToPublicKeyMap.remove(authorizationPki.getAppId());
        this.appIdToRSAPublicKeyMap.remove(authorizationPki.getAppId());
    }

    private AuthorizationPki actOnPkiTableUpdateOrInsert(Long id) {
        AuthorizationPki authorizationPki = this.getAuthorizationPkiByID(id);
        if (authorizationPki == null) {
            return null;
        }
        this.pkiIdToApplicationMap.put(id, authorizationPki);
        RSAPublicKey rsaPublicKey = this.buildRSAPublicKey(authorizationPki.getPublicKey());
        if (rsaPublicKey == null) {
            this.logger.warn((Object)("Couldn't build RSAPublicKey for = " + authorizationPki.getAppId()));
            return null;
        }
        if (authorizationPki.getClusterId() == null || authorizationPki.getClusterId().longValue() == NumberUtils.LONG_ZERO.longValue()) {
            if (!StringUtils.isEmpty((CharSequence)authorizationPki.getAuthServiceIdentifier())) {
                this.appIdToPublicKeyMap.put(authorizationPki.getAuthServiceIdentifier(), authorizationPki.getPublicKey());
                this.appIdToRSAPublicKeyMap.put(authorizationPki.getAuthServiceIdentifier(), rsaPublicKey);
            } else if (authorizationPki.getAppId() != null) {
                this.appIdToPublicKeyMap.put(authorizationPki.getAppId(), authorizationPki.getPublicKey());
                this.appIdToRSAPublicKeyMap.put(authorizationPki.getAppId(), rsaPublicKey);
            }
            return authorizationPki;
        }
        RSAPrivateKey rsaPrivateKey = this.buildRSAPrivateKey(authorizationPki.getPrivateKey(), authorizationPki.getAppName());
        if (rsaPrivateKey == null) {
            this.logger.info((Object)("Couldn't build RSAPrivateKey for = " + authorizationPki.getAppName()));
            return null;
        }
        if (this.clusterIdToAppMap.get(authorizationPki.getClusterId()) == null) {
            this.clusterIdToAppMap.put(authorizationPki.getClusterId(), new ConcurrentHashMap());
        }
        this.clusterIdToAppMap.get(authorizationPki.getClusterId()).put(authorizationPki.getAppName(), authorizationPki.getAppId());
        if (!StringUtils.isEmpty((CharSequence)authorizationPki.getAuthServiceIdentifier())) {
            this.appIdToPrivateKeyMap.put(authorizationPki.getAuthServiceIdentifier(), authorizationPki.getPrivateKey());
            this.appIdToRSAPrivateKeyMap.put(authorizationPki.getAuthServiceIdentifier(), rsaPrivateKey);
            this.appIdToPublicKeyMap.put(authorizationPki.getAuthServiceIdentifier(), authorizationPki.getPublicKey());
            this.appIdToRSAPublicKeyMap.put(authorizationPki.getAuthServiceIdentifier(), rsaPublicKey);
        } else {
            this.appIdToPrivateKeyMap.put(authorizationPki.getAppId(), authorizationPki.getPrivateKey());
            this.appIdToRSAPrivateKeyMap.put(authorizationPki.getAppId(), rsaPrivateKey);
            this.appIdToPublicKeyMap.put(authorizationPki.getAppId(), authorizationPki.getPublicKey());
            this.appIdToRSAPublicKeyMap.put(authorizationPki.getAppId(), rsaPublicKey);
        }
        return authorizationPki;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinitKeyMap() {
        Map tempPkiIdToAppMap;
        Object[] params = new Object[]{};
        try {
            tempPkiIdToAppMap = (Map)this.dataSource.executeQuery(GET_ALL_PKI, params, (Object)this.getPkiMapper());
        }
        catch (DMException e) {
            this.logger.error((Object)"Error while re-initializing key map ", (Throwable)e);
            return;
        }
        try {
            this.lock.acquireWriteLock();
            this.pkiIdToApplicationMap = tempPkiIdToAppMap;
            this.populateAppIdAndKeyMaps();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    protected AuthorizationServer getAuthorizationServerByID(Long id) {
        try {
            Object[] params = new Object[]{id};
            Map tempClientAppMap = (Map)this.dataSource.executeQuery(GET_AUTHZ_APPS_BY_ID, params, (Object)this.getAuthzAppMapper());
            if (!tempClientAppMap.isEmpty()) {
                return (AuthorizationServer)tempClientAppMap.entrySet().iterator().next().getValue();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error while fetching AuthorizationClient of id=" + id + " from DataBase : "), (Throwable)e);
        }
        return null;
    }

    protected AuthorizationClient getAuthorizationClientByID(Long id) {
        try {
            Object[] params = new Object[]{id};
            Map tempClientAppMap = (Map)this.dataSource.executeQuery(GET_CLIENT_APPS_BY_ID, params, (Object)this.getClientAppMapper());
            if (!tempClientAppMap.isEmpty()) {
                return (AuthorizationClient)tempClientAppMap.entrySet().iterator().next().getValue();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error while fetching AuthorizationClient of id=" + id + " from DataBase : "), (Throwable)e);
        }
        return null;
    }

    protected AuthorizationPki getAuthorizationPkiByID(Long id) {
        try {
            Object[] params = new Object[]{id};
            Map tempPkiIdToAppMap = (Map)this.dataSource.executeQuery(GET_ALL_PKI_BY_ID, params, (Object)this.getPkiMapper());
            if (!tempPkiIdToAppMap.isEmpty()) {
                return (AuthorizationPki)tempPkiIdToAppMap.entrySet().iterator().next().getValue();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error while fetching AuthorizationPki of id=" + id + " from DataBase : "), (Throwable)e);
        }
        return null;
    }

    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(AUTHORIZATION_KEY);
        list.add(AUTHORIZATION_CLIENT);
        list.add(AUTHORIZATION_SERVICE);
        list.add(AUTHORIZATION_RESOURCE);
        return list;
    }

    protected Object getMainCollection() {
        return this.pkiIdToApplicationMap;
    }

    public void registerListener(DMListener listener) {
        LISTENERS.add(listener);
    }

    public void removeListener(DMListener listener) {
        LISTENERS.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateListeners(Object oldObj, Object newObj) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        for (DMListener listener : LISTENERS) {
            try {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                listener.objectChanged(oldObj, newObj);
            }
            catch (Exception e) {
                this.logger.error((Object)("Exception on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()), (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                this.logger.error((Object)("NoClassDefFoundError on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.logger.error((Object)"Error is: ", (Throwable)e);
                this.logger.error((Object)("Unregistering the listener " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.removeListener(listener);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    protected AusInstanceDAO getAusInstaceDAO() {
        return (AusInstanceDAO)AuthorizationServiceDAO.getFactory().getDataMgr(AusInstanceDAO.class);
    }

    protected AusServiceDAO getAusServiceDAO() {
        return (AusServiceDAO)AuthorizationServiceDAO.getFactory().getDataMgr(AusServiceDAO.class);
    }

    private void populateDependantMaps() {
        if (this.authorizationClientMap != null && this.authorizationClientMap.keySet() != null) {
            Iterator<Long> iterator = this.authorizationClientMap.keySet().iterator();
            while (iterator.hasNext()) {
                AuthorizationClient authClient = this.authorizationClientMap.get(iterator.next());
                this.idToAuthorizationCertExpiryMap.put(authClient.getClientAppId(), authClient.getId());
            }
        }
    }

    @SMConsole(description="get redirect url")
    public String getRedirectUrl(String applicationId) {
        Long id = this.idToAuthorizationCertExpiryMap.get(applicationId);
        AuthorizationClient client = this.authorizationClientMap.get(id);
        if (null == client || StringUtils.isEmpty((CharSequence)client.getRedirectURI())) {
            return null;
        }
        return client.getRedirectURI();
    }

    @SMConsole(description="Is Cert Expired")
    public Boolean isCertificateExpired(String applicationId) {
        this.logger.finest((Object)("isCertificateExpired  =" + this.idToAuthorizationCertExpiryMap));
        Long id = this.idToAuthorizationCertExpiryMap.get(applicationId);
        String certDate = null;
        AuthorizationClient certMap = this.authorizationClientMap.get(id);
        this.logger.info((Object)("isCertificateExpired AuthorizationClient =" + certMap));
        if (null != certMap) {
            certDate = certMap.getCertExpiry();
        }
        if (StringUtils.isEmpty(certDate)) {
            return false;
        }
        String[] startEndDate = StringUtils.split((String)certDate, (String)",");
        try {
            Date startDate = new SimpleDateFormat("MM/dd/yyyy").parse(startEndDate[0]);
            Date endDate = new SimpleDateFormat("MM/dd/yyyy").parse(startEndDate[1]);
            Date currentDate = Calendar.getInstance().getTime();
            this.logger.finest((Object)("start date = " + startDate + "end date " + endDate + " current date " + currentDate));
            if (currentDate.compareTo(startDate) > 0 && currentDate.compareTo(endDate) < 0) {
                return false;
            }
        }
        catch (ParseException e) {
            this.logger.error((Object)("Exception isCertificateExpired validating expiry date " + e.getMessage()));
            return false;
        }
        return true;
    }

    @SMConsole(description="Get Server Application Id")
    public String getServerApplicationId(String serviceName) {
        Long clusterId = this.getAusInstaceDAO().getMyClusterId();
        String appName = this.getAusServiceDAO().getServiceAttribute(serviceName, AUTHZ_SERVER_ATTRIBUTE_NAME);
        Map<String, String> appNameToAppIdMap = this.clusterIdToAppMap.get(clusterId);
        if (appName != null && appNameToAppIdMap != null) {
            return appNameToAppIdMap.get(appName);
        }
        return null;
    }

    @SMConsole(description="Get Client Application Id")
    public String getClientApplicationId(String serviceName) {
        Long clusterId = this.getAusInstaceDAO().getMyClusterId();
        String appName = this.getAusServiceDAO().getServiceAttribute(serviceName, CLIENT_APP_ATTRIBUTE_NAME);
        Map<String, String> appNameToAppIdMap = this.clusterIdToAppMap.get(clusterId);
        if (appName != null && appNameToAppIdMap != null) {
            return appNameToAppIdMap.get(appName);
        }
        return null;
    }

    @SMConsole(description="Get Server Private key")
    public String getServerPrivateKey(String serviceName) {
        String encryptedKey;
        String appId;
        Long clusterId = this.getAusInstaceDAO().getMyClusterId();
        String serverAppName = this.getAusServiceDAO().getServiceAttribute(serviceName, AUTHZ_SERVER_ATTRIBUTE_NAME);
        Map<String, String> appNameToAppIdMap = this.clusterIdToAppMap.get(clusterId);
        if (serverAppName != null && appNameToAppIdMap != null && (appId = appNameToAppIdMap.get(serverAppName)) != null && (encryptedKey = this.appIdToPrivateKeyMap.get(appId)) != null) {
            return EncryptDecrypt.decrypt((String)encryptedKey, (String)serverAppName);
        }
        return null;
    }

    @SMConsole(description="Get Server Private key")
    public RSAPrivateKey getServerRSAPrivateKey(String serviceName) {
        String appId;
        Long clusterId = this.getAusInstaceDAO().getMyClusterId();
        String serverAppName = this.getAusServiceDAO().getServiceAttribute(serviceName, AUTHZ_SERVER_ATTRIBUTE_NAME);
        Map<String, String> appNameToAppIdMap = this.clusterIdToAppMap.get(clusterId);
        if (serverAppName != null && appNameToAppIdMap != null && (appId = appNameToAppIdMap.get(serverAppName)) != null) {
            return this.appIdToRSAPrivateKeyMap.get(appId);
        }
        return null;
    }

    @SMConsole(description="Get Client Private key")
    public String getClientPrivateKey(String serviceName) {
        Long clusterId = this.getAusInstaceDAO().getMyClusterId();
        String clientAppName = this.getAusServiceDAO().getServiceAttribute(serviceName, CLIENT_APP_ATTRIBUTE_NAME);
        Map<String, String> appNameToAppIdMap = this.clusterIdToAppMap.get(clusterId);
        if (clientAppName != null && appNameToAppIdMap != null) {
            return EncryptDecrypt.decrypt((String)this.appIdToPrivateKeyMap.get(appNameToAppIdMap.get(clientAppName)), (String)clientAppName);
        }
        return null;
    }

    @SMConsole(description="Get Client Private key")
    public RSAPrivateKey getClientRSAPrivateKey(String serviceName) {
        Long clusterId = this.getAusInstaceDAO().getMyClusterId();
        String clientAppName = this.getAusServiceDAO().getServiceAttribute(serviceName, CLIENT_APP_ATTRIBUTE_NAME);
        Map<String, String> appNameToAppIdMap = this.clusterIdToAppMap.get(clusterId);
        if (clientAppName != null && appNameToAppIdMap != null) {
            return this.appIdToRSAPrivateKeyMap.get(appNameToAppIdMap.get(clientAppName));
        }
        return null;
    }

    @SMConsole(description="Get Public Key")
    public String getPublicKey(String applicationId) {
        if (applicationId == null) {
            return null;
        }
        return this.appIdToPublicKeyMap.get(applicationId);
    }

    @SMConsole(description="Get RSA Public Key")
    public RSAPublicKey getRSAPublicKey(String applicationId) {
        if (applicationId == null) {
            return null;
        }
        return this.appIdToRSAPublicKeyMap.get(applicationId);
    }

    @SMConsole(description="Get Resource short name")
    public String getResourceShortName(String serviceName) {
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            return null;
        }
        Long clusterId = this.getAusInstaceDAO().getMyClusterId();
        Map<String, String> servNameResourceNameMap = this.serviceNameToResourceNameMap.get(clusterId);
        if (servNameResourceNameMap != null) {
            return servNameResourceNameMap.get(serviceName);
        }
        return null;
    }

    protected void populateAuthorizationClientMap() {
        this.authorizationClientMap = new ConcurrentHashMap<Long, AuthorizationClient>();
        this.authorizationClientMap.put(3L, new AuthorizationClient(1L, "clientAppName", "clientAppId", "publicKey", "fingerprint", "redirectURI", "certexpirt"));
    }

    private static class PkiResultSetMapper
    implements ResultSetMapper {
        private PkiResultSetMapper() {
        }

        public Map<Long, AuthorizationPki> mapResults(ResultSet results) throws SQLException, DMException {
            HashMap<Long, AuthorizationPki> map = new HashMap<Long, AuthorizationPki>();
            while (results.next()) {
                String appName = null;
                Long sversionId = null;
                Long clusterId = null;
                String appId = null;
                Long serverId = results.getLong("server_table_id");
                Long clientId = results.getLong("client_table_id");
                String authServiceIdentifier = results.getString("auth_service_identifier");
                String certExpiry = results.getString("cert_expiry");
                if (serverId.longValue() != NumberUtils.LONG_ZERO.longValue()) {
                    appName = results.getString("service_name");
                    sversionId = results.getLong("server_sversion_id");
                    clusterId = results.getLong("server_cluster_id");
                    appId = results.getString("service_app_id");
                }
                if (clientId.longValue() != NumberUtils.LONG_ZERO.longValue()) {
                    appName = results.getString("client_app_name");
                    sversionId = results.getLong("client_sversion_id");
                    clusterId = results.getLong("client_cluster_id");
                    appId = results.getString("client_app_id");
                }
                map.put(results.getLong("id"), new AuthorizationPki(results.getString("public_key"), results.getString("private_key"), results.getString("fingerprint"), appName, sversionId, clusterId, appId, serverId, clientId, authServiceIdentifier, certExpiry));
            }
            return map;
        }
    }
}

