/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.LdapConfig;
import com.avaya.zephyr.platform.dao.AuthorizationDetailsDAO;
import com.avaya.zephyr.platform.dm.ZephyrDM;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class LdapConfigDAO
extends DataAccessObject {
    private final Map<String, LdapConfig> ldapConfigMap = new ConcurrentHashMap<String, LdapConfig>();
    protected static final String UPM_DATASOURCE = "UPM_DATASOURCE";
    private static final Logger LOG = Logger.getLogger(LdapConfigDAO.class);
    private static final String INIT_QUERY = "SELECT upm_datasource.id, upm_datasource.datasourcename, upm_datasource.ldapschemaattribute, u1.value as address, u2.value as allowDeletions, u3.value as base, u4.value as filter, u5.value as port, u6.value as principal, u7.value as ssl, u8.value as password FROM upm_datasource INNER JOIN upm_connectionparameter AS u1 ON upm_datasource.id = u1.umdatasourceid INNER JOIN upm_connectionparameter AS u2 ON upm_datasource.id = u2.umdatasourceid INNER JOIN upm_connectionparameter AS u3 ON upm_datasource.id = u3.umdatasourceid INNER JOIN upm_connectionparameter AS u4 ON upm_datasource.id = u4.umdatasourceid INNER JOIN upm_connectionparameter AS u5 ON upm_datasource.id = u5.umdatasourceid INNER JOIN upm_connectionparameter AS u6 ON upm_datasource.id = u6.umdatasourceid INNER JOIN upm_connectionparameter AS u7 ON upm_datasource.id = u7.umdatasourceid INNER JOIN upm_connectionparameter AS u8 ON upm_datasource.id = u8.umdatasourceid WHERE (u1.name='address') AND (u2.name='allowDeletions') AND (u3.name='base' ) AND (u4.name='filter' ) AND (u5.name='port' ) AND (u6.name='principal' ) AND (u7.name='ssl' ) AND (u8.name='password' ) ;";
    protected static final List<DMListener> LISTENERS = new CopyOnWriteArrayList<DMListener>();

    public final void init() {
        LOG.info((Object)"init ENTER");
        Object[] params = new Object[]{};
        try {
            List tmpLdapConfigList = (List)this.dataSource.executeQuery(INIT_QUERY, params, (Object)this.getLdapConfigMapper());
            this.ldapConfigMap.clear();
            if (tmpLdapConfigList != null) {
                for (LdapConfig ldapConfig : tmpLdapConfigList) {
                    this.ldapConfigMap.put(ldapConfig.getDatasourceName(), ldapConfig);
                }
            }
            if (LOG.isFinestEnabled()) {
                LOG.finest((Object)("ldap config list : " + this.ldapConfigMap));
            }
            this.setStatus(DataMgr.Status.OKAY);
            LOG.fine((Object)"Set status to okay");
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            LOG.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent((GenericAlarmRecoveryIntf)this, (Exception)((Object)e));
        }
        LOG.info((Object)"init EXIT");
    }

    public final List<String> getDependentTables() {
        return Arrays.asList("upm_datasource", "upm_connectionparameter");
    }

    protected final Object getMainCollection() {
        return this.ldapConfigMap;
    }

    public final void updateDAO(DAOTableEvent tableEvent) {
        String tableName = tableEvent.getTableName();
        if (tableName.equalsIgnoreCase(UPM_DATASOURCE)) {
            if (LOG.isFineEnabled()) {
                LOG.fine((Object)("LdapConfigDAO updateDAO(): " + tableEvent));
            }
            this.init();
            this.updateListeners(null, new Object());
        }
    }

    protected final LdapConfigMapper getLdapConfigMapper() {
        return new LdapConfigMapper();
    }

    @SMConsole(description="Get the list and details of Ldap directories configured")
    public final List<LdapConfig> getLdapConfigList() {
        if (!DataMgr.Status.OKAY.equals((Object)this.getStatus())) {
            this.init();
        }
        ArrayList<LdapConfig> ldapConfigs = new ArrayList<LdapConfig>();
        ldapConfigs.addAll(this.ldapConfigMap.values());
        return ldapConfigs;
    }

    @SMConsole(description="Get the details of Ldap directory of user by loginName")
    public final LdapConfig getLdapConfigForUser(String loginName) {
        if (!DataMgr.Status.OKAY.equals((Object)this.getStatus())) {
            this.init();
        }
        try {
            ZephyrDM zephyrDM = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);
            AuthorizationDetailsDAO authorizationDetailsDAO = zephyrDM.getAuthorizationDetailsDAO();
            String dataSource = authorizationDetailsDAO.getDataSourceForUser(loginName);
            if (dataSource != null) {
                return this.ldapConfigMap.get(dataSource);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error in getting ldap details of user", (Throwable)e);
        }
        return null;
    }

    public void registerListener(DMListener listener) {
        LISTENERS.add(listener);
    }

    public void removeListener(DMListener listener) {
        LISTENERS.remove(listener);
    }

    protected void updateListeners(Object oldObj, Object newObj) {
        for (DMListener listener : LISTENERS) {
            try {
                listener.objectChanged(oldObj, newObj);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()), (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                LOG.error((Object)("NoClassDefFoundError on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOG.error((Object)"Error is: ", (Throwable)e);
                LOG.error((Object)("Unregistering the listener " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.removeListener(listener);
            }
        }
    }

    static class LdapConfigMapper
    implements ResultSetMapper {
        LdapConfigMapper() {
        }

        public List<LdapConfig> mapResults(ResultSet results) throws SQLException, DMException {
            ArrayList<LdapConfig> tmpList = new ArrayList<LdapConfig>();
            while (results.next()) {
                tmpList.add(new LdapConfig(results.getString("datasourcename"), results.getString("ldapschemaattribute"), results.getString("address"), results.getBoolean("allowDeletions"), results.getString("base"), results.getString("filter"), results.getInt("port"), results.getString("principal"), results.getBoolean("ssl"), results.getString("password")));
            }
            return tmpList;
        }
    }
}

