/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.Extension;
import com.avaya.zephyr.platform.dal.api.objectapi.Location;
import com.avaya.zephyr.platform.dal.api.objectapi.Network;
import com.avaya.zephyr.platform.dal.api.objectapi.NetworkRegion;
import com.avaya.zephyr.platform.dal.api.objectapi.SysparamFeature;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class NetworkDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(NetworkDAO.class);
    public static final String NETWORK_MAP_TABLE = "ipt_ip_network_map";
    public static final String SYSPARAM_FEATURES_TABLE = "ipt_sysparam_features";
    public static final String NETWORK_REGION_TABLE = "ipt_ip_network_region";
    public static final String LOCATIONS_TABLE = "ipt_locations";
    public static final String EXTENSION_TABLE = "ipt_extension";
    public static final String GET_NETWORK_MAPS = "select id, fromipaddress, toipaddress, cm_id, emeglocext_id, networkregion_id from ipt_ip_network_map";
    public static final String GET_NETWORK_MAP_BY_ID = "select id, fromipaddress, toipaddress, cm_id, emeglocext_id, networkregion_id from ipt_ip_network_map where id = ?";
    public static final String GET_LOCATIONS = "select id, display_name, station_location, cm_id from ipt_locations";
    public static final String GET_LOCATION_BY_ID = "select id, display_name, station_location, cm_id from ipt_locations where id = ?";
    public static final String GET_NETWORK_REGIONS = "select id, cm_id, location_id from ipt_ip_network_region";
    public static final String GET_NETWORK_REGION_BY_ID = "select id, cm_id, location_id from ipt_ip_network_region where id = ?";
    public static final String GET_SYSPARAM_FEATURES = "select id, cm_id, ucidnetworknodeid from ipt_sysparam_features";
    public static final String GET_SYSPARAM_FEATURE_BY_ID = "select id, cm_id, ucidnetworknodeid from ipt_sysparam_features where id = ?";
    public static final String GET_EXTENSIONS = "select id, cm_id, extension from ipt_extension";
    public static final String GET_EXTENSION_BY_ID = "select id, cm_id, extension from ipt_extension where id = ?";
    private Map<Long, Network> networkMap = new ConcurrentHashMap<Long, Network>();
    private Map<Long, Location> locationMap = new ConcurrentHashMap<Long, Location>();
    private Map<Long, NetworkRegion> networkRegionMap = new ConcurrentHashMap<Long, NetworkRegion>();
    private Map<Long, SysparamFeature> featuresMap = new ConcurrentHashMap<Long, SysparamFeature>();
    private Map<Long, Extension> extensionMap = new ConcurrentHashMap<Long, Extension>();
    protected static final List<DMListener> LISTENERS = new CopyOnWriteArrayList<DMListener>();

    public final Map<Long, Network> getNetworkMap() {
        return this.networkMap;
    }

    public final Map<Long, Location> getLocationMap() {
        return this.locationMap;
    }

    public final Map<Long, NetworkRegion> getNetworkRegionMap() {
        return this.networkRegionMap;
    }

    public final Map<Long, SysparamFeature> getFeaturesMap() {
        return this.featuresMap;
    }

    public final Map<Long, Extension> getExtensionMap() {
        return this.extensionMap;
    }

    protected ResultSetMapper getNetworkMapMapper() {
        return new ResultSetMapper(){

            public Map<Long, Network> mapResults(ResultSet results) throws SQLException, DMException {
                HashMap<Long, Network> map = new HashMap<Long, Network>();
                while (results.next()) {
                    map.put(results.getLong("id"), new Network(results.getLong("id"), results.getString("fromipaddress"), results.getString("toipaddress"), results.getLong("cm_id"), results.getLong("emeglocext_id"), results.getLong("networkregion_id")));
                }
                if (!map.isEmpty()) {
                    return map;
                }
                return null;
            }
        };
    }

    protected ResultSetMapper getLocationMapMapper() {
        return new ResultSetMapper(){

            public Map<Long, Location> mapResults(ResultSet results) throws SQLException, DMException {
                HashMap<Long, Location> map = new HashMap<Long, Location>();
                while (results.next()) {
                    map.put(results.getLong("id"), new Location(results.getLong("id"), results.getString("display_name"), results.getString("station_location"), results.getLong("cm_id")));
                }
                if (!map.isEmpty()) {
                    return map;
                }
                return null;
            }
        };
    }

    protected ResultSetMapper getNetworkRegionMapMapper() {
        return new ResultSetMapper(){

            public Map<Long, NetworkRegion> mapResults(ResultSet results) throws SQLException, DMException {
                HashMap<Long, NetworkRegion> map = new HashMap<Long, NetworkRegion>();
                while (results.next()) {
                    map.put(results.getLong("id"), new NetworkRegion(results.getLong("id"), results.getLong("cm_id"), results.getLong("location_id")));
                }
                if (!map.isEmpty()) {
                    return map;
                }
                return null;
            }
        };
    }

    protected ResultSetMapper getSysparamFeatureMapMapper() {
        return new ResultSetMapper(){

            public Map<Long, SysparamFeature> mapResults(ResultSet results) throws SQLException, DMException {
                HashMap<Long, SysparamFeature> map = new HashMap<Long, SysparamFeature>();
                while (results.next()) {
                    map.put(results.getLong("id"), new SysparamFeature(results.getLong("id"), results.getLong("cm_id"), results.getLong("ucidnetworknodeid")));
                }
                if (!map.isEmpty()) {
                    return map;
                }
                return null;
            }
        };
    }

    protected ResultSetMapper getExtensionMapMapper() {
        return new ResultSetMapper(){

            public Map<Long, Extension> mapResults(ResultSet results) throws SQLException, DMException {
                HashMap<Long, Extension> map = new HashMap<Long, Extension>();
                while (results.next()) {
                    map.put(results.getLong("id"), new Extension(results.getLong("id"), results.getLong("cm_id"), results.getString("extension")));
                }
                if (!map.isEmpty()) {
                    return map;
                }
                return null;
            }
        };
    }

    protected ResultSetMapper getNetworkMapMapperByID() {
        return new ResultSetMapper(){

            public Network mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    Network nMap = new Network(results.getLong("id"), results.getString("fromipaddress"), results.getString("toipaddress"), results.getLong("cm_id"), results.getLong("emeglocext_id"), results.getLong("networkregion_id"));
                    return nMap;
                }
                return null;
            }
        };
    }

    protected ResultSetMapper getLocationMapMapperByID() {
        return new ResultSetMapper(){

            public Location mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    Location nMap = new Location(results.getLong("id"), results.getString("display_name"), results.getString("station_location"), results.getLong("cm_id"));
                    return nMap;
                }
                return null;
            }
        };
    }

    protected ResultSetMapper getNetworkRegionMapMapperByID() {
        return new ResultSetMapper(){

            public NetworkRegion mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    NetworkRegion nMap = new NetworkRegion(results.getLong("id"), results.getLong("cm_id"), results.getLong("location_id"));
                    return nMap;
                }
                return null;
            }
        };
    }

    protected ResultSetMapper getSysparamFeatureMapMapperByID() {
        return new ResultSetMapper(){

            public SysparamFeature mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    SysparamFeature nMap = new SysparamFeature(results.getLong("id"), results.getLong("cm_id"), results.getLong("ucidnetworknodeid"));
                    return nMap;
                }
                return null;
            }
        };
    }

    protected ResultSetMapper getExtensionMapperByID() {
        return new ResultSetMapper(){

            public Extension mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    Extension nMap = new Extension(results.getLong("id"), results.getLong("cm_id"), results.getString("extension"));
                    return nMap;
                }
                return null;
            }
        };
    }

    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(NETWORK_MAP_TABLE);
        list.add(SYSPARAM_FEATURES_TABLE);
        list.add(NETWORK_REGION_TABLE);
        list.add(LOCATIONS_TABLE);
        list.add(EXTENSION_TABLE);
        return list;
    }

    protected Object getMainCollection() {
        return this.networkMap;
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        if (tableEvent.getTableName().equalsIgnoreCase(NETWORK_MAP_TABLE)) {
            this.handleUpdateForNetworkMapTable(tableEvent);
        }
        if (tableEvent.getTableName().equalsIgnoreCase(NETWORK_REGION_TABLE)) {
            this.handleUpdateForNetworkRegionMapTable(tableEvent);
        }
        if (tableEvent.getTableName().equalsIgnoreCase(LOCATIONS_TABLE)) {
            this.handleUpdateForLocationMapTable(tableEvent);
        }
        if (tableEvent.getTableName().equalsIgnoreCase(SYSPARAM_FEATURES_TABLE)) {
            this.handleUpdateForSysparamFeatureMapTable(tableEvent);
        }
        if (tableEvent.getTableName().equalsIgnoreCase(EXTENSION_TABLE)) {
            this.handleUpdateForExtensionMapTable(tableEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUpdateForExtensionMapTable(DAOTableEvent tableEvent) {
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        Extension oldObj = null;
        Extension newObj = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) || operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            oldObj = this.extensionMap.get(id);
            newObj = this.getExtensionByID(id);
            try {
                this.lock.acquireWriteLock();
                this.extensionMap.put(id, newObj);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        try {
            this.lock.acquireWriteLock();
            oldObj = this.extensionMap.remove(id);
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.updateListeners(oldObj, newObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUpdateForSysparamFeatureMapTable(DAOTableEvent tableEvent) {
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        SysparamFeature oldObj = null;
        SysparamFeature newObj = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) || operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            oldObj = this.featuresMap.get(id);
            newObj = this.getSysparamFeatureMapByID(id);
            try {
                this.lock.acquireWriteLock();
                this.featuresMap.put(id, newObj);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        try {
            this.lock.acquireWriteLock();
            oldObj = this.featuresMap.remove(id);
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.updateListeners(oldObj, newObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUpdateForNetworkRegionMapTable(DAOTableEvent tableEvent) {
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        NetworkRegion oldObj = null;
        NetworkRegion newObj = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) || operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            oldObj = this.networkRegionMap.get(id);
            newObj = this.getNetworkRegionMapByID(id);
            try {
                this.lock.acquireWriteLock();
                this.networkRegionMap.put(id, newObj);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        try {
            this.lock.acquireWriteLock();
            oldObj = this.networkRegionMap.remove(id);
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.updateListeners(oldObj, newObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUpdateForLocationMapTable(DAOTableEvent tableEvent) {
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        Location oldObj = null;
        Location newObj = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) || operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            oldObj = this.locationMap.get(id);
            newObj = this.getLocationMapByID(id);
            try {
                this.lock.acquireWriteLock();
                this.locationMap.put(id, newObj);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        try {
            this.lock.acquireWriteLock();
            oldObj = this.locationMap.remove(id);
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.updateListeners(oldObj, newObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUpdateForNetworkMapTable(DAOTableEvent tableEvent) {
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        Network oldObj = null;
        Network newObj = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) || operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            oldObj = this.networkMap.get(id);
            newObj = this.getNetworkMapByID(id);
            try {
                this.lock.acquireWriteLock();
                this.networkMap.put(id, newObj);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        try {
            this.lock.acquireWriteLock();
            oldObj = this.networkMap.remove(id);
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.updateListeners(oldObj, newObj);
    }

    protected Network getNetworkMapByID(Long id) {
        Network newObject = null;
        try {
            Object[] params = new Object[]{id};
            newObject = (Network)this.dataSource.executeQuery(GET_NETWORK_MAP_BY_ID, params, (Object)this.getNetworkMapMapperByID());
        }
        catch (Exception e) {
            this.log.error((Object)("Error while fetching NetworkMap of id=" + id + " from DataBase : "), (Throwable)e);
        }
        return newObject;
    }

    protected Location getLocationMapByID(Long id) {
        Location newObject = null;
        try {
            Object[] params = new Object[]{id};
            newObject = (Location)this.dataSource.executeQuery(GET_LOCATION_BY_ID, params, (Object)this.getLocationMapMapperByID());
        }
        catch (Exception e) {
            this.log.error((Object)("Error while fetching NetworkMap of id=" + id + " from DataBase : "), (Throwable)e);
        }
        return newObject;
    }

    protected NetworkRegion getNetworkRegionMapByID(Long id) {
        NetworkRegion newObject = null;
        try {
            Object[] params = new Object[]{id};
            newObject = (NetworkRegion)this.dataSource.executeQuery(GET_NETWORK_REGION_BY_ID, params, (Object)this.getNetworkRegionMapMapperByID());
        }
        catch (Exception e) {
            this.log.error((Object)("Error while fetching NetworkMap of id=" + id + " from DataBase : "), (Throwable)e);
        }
        return newObject;
    }

    protected SysparamFeature getSysparamFeatureMapByID(Long id) {
        SysparamFeature newObject = null;
        try {
            Object[] params = new Object[]{id};
            newObject = (SysparamFeature)this.dataSource.executeQuery(GET_SYSPARAM_FEATURE_BY_ID, params, (Object)this.getSysparamFeatureMapMapperByID());
        }
        catch (Exception e) {
            this.log.error((Object)("Error while fetching NetworkMap of id=" + id + " from DataBase : "), (Throwable)e);
        }
        return newObject;
    }

    protected Extension getExtensionByID(Long id) {
        Extension newObject = null;
        try {
            Object[] params = new Object[]{id};
            newObject = (Extension)this.dataSource.executeQuery(GET_EXTENSION_BY_ID, params, (Object)this.getExtensionMapperByID());
        }
        catch (Exception e) {
            this.log.error((Object)("Error while fetching NetworkMap of id=" + id + " from DataBase : "), (Throwable)e);
        }
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.log.fine((Object)"Initializing NetworkDAO...");
        Map tmpNetworkMap = null;
        Map tmpLocationMap = null;
        Map tmpNetworkRegionMap = null;
        Map tmpFeaturesMap = null;
        Map tmpExtensionMap = null;
        try {
            tmpNetworkMap = (Map)this.dataSource.executeQuery(GET_NETWORK_MAPS, new Object[0], (Object)this.getNetworkMapMapper());
            tmpLocationMap = (Map)this.dataSource.executeQuery(GET_LOCATIONS, new Object[0], (Object)this.getLocationMapMapper());
            tmpNetworkRegionMap = (Map)this.dataSource.executeQuery(GET_NETWORK_REGIONS, new Object[0], (Object)this.getNetworkRegionMapMapper());
            tmpFeaturesMap = (Map)this.dataSource.executeQuery(GET_SYSPARAM_FEATURES, new Object[0], (Object)this.getSysparamFeatureMapMapper());
            tmpExtensionMap = (Map)this.dataSource.executeQuery(GET_EXTENSIONS, new Object[0], (Object)this.getExtensionMapMapper());
        }
        catch (DMException e) {
            this.log.error((Object)"Error while initializing NetworkDAO, ", (Throwable)e);
            this.setStatus(DataMgr.Status.FAIL);
            return;
        }
        try {
            this.lock.acquireWriteLock();
            if (tmpNetworkMap != null) {
                this.networkMap = tmpNetworkMap;
            }
            if (tmpLocationMap != null) {
                this.locationMap = tmpLocationMap;
            }
            if (tmpNetworkRegionMap != null) {
                this.networkRegionMap = tmpNetworkRegionMap;
            }
            if (tmpFeaturesMap != null) {
                this.featuresMap = tmpFeaturesMap;
            }
            if (tmpExtensionMap != null) {
                this.extensionMap = tmpExtensionMap;
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.setStatus(DataMgr.Status.OKAY);
    }

    @SMConsole
    public Map<Long, Network> getAllNetworkMapData() {
        return this.networkMap;
    }

    protected void updateListeners(Object oldObj, Object newObj) {
        for (DMListener listener : LISTENERS) {
            try {
                listener.objectChanged(oldObj, newObj);
            }
            catch (Exception e) {
                this.log.error((Object)("Exception on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()), (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                this.log.error((Object)("updateListeners: NoClassDefFoundError on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.log.error((Object)"Error is: ", (Throwable)e);
                this.log.error((Object)("updateListeners: Unregistering the listener " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.removeListener(listener);
            }
        }
    }

    protected void updateListeners(List<Object> oldList, List<Object> newList) {
        if (oldList == null || newList == null || oldList.size() != newList.size()) {
            return;
        }
        int size = oldList.size();
        for (DMListener listener : LISTENERS) {
            try {
                for (int i = 0; i < size; ++i) {
                    listener.objectChanged(oldList.get(i), newList.get(i));
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Exception on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()), (Throwable)e);
            }
        }
    }

    public void registerListener(DMListener listener) {
        LISTENERS.add(listener);
    }

    public void removeListener(DMListener listener) {
        LISTENERS.remove(listener);
    }

    public Network getNetworkMapWithFromIp(String fromIp, String toIp, Long cmId) {
        if (!this.networkMap.isEmpty()) {
            for (Map.Entry<Long, Network> entry : this.networkMap.entrySet()) {
                if (!entry.getValue().getFromIpAddress().equals(fromIp) || !entry.getValue().getToIpAddress().equalsIgnoreCase(toIp) || !entry.getValue().getCmId().equals(cmId)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public List<Network> getNetworkMapWithFromIp(String fromIp) {
        ArrayList<Network> nwlist = new ArrayList<Network>();
        if (!this.networkMap.isEmpty()) {
            for (Map.Entry<Long, Network> entry : this.networkMap.entrySet()) {
                if (!entry.getValue().getFromIpAddress().equalsIgnoreCase(fromIp)) continue;
                nwlist.add(entry.getValue());
            }
        }
        return nwlist;
    }

    public List<Network> getNetworkMapWithToIp(String toIp) {
        ArrayList<Network> nwlist = new ArrayList<Network>();
        if (!this.networkMap.isEmpty()) {
            for (Map.Entry<Long, Network> entry : this.networkMap.entrySet()) {
                if (!entry.getValue().getToIpAddress().equalsIgnoreCase(toIp)) continue;
                nwlist.add(entry.getValue());
            }
        }
        return nwlist;
    }

    public Long getUcidNetworkNodeId(long cmId) {
        if (!this.featuresMap.isEmpty()) {
            for (Map.Entry<Long, SysparamFeature> entry : this.featuresMap.entrySet()) {
                if (entry.getValue().getCmId() != cmId) continue;
                return entry.getValue().getUcidnetworknodeId();
            }
        }
        return null;
    }

    public String getLocation(long networkregionId) {
        Location lmap;
        NetworkRegion obj = this.networkRegionMap.get(networkregionId);
        if (obj != null && (lmap = this.locationMap.get(obj.getLocationId())) != null) {
            return lmap.getStationLocation();
        }
        return null;
    }

    public String getExtension(Long emeglocextId) {
        if (this.extensionMap.containsKey(emeglocextId)) {
            return this.extensionMap.get(emeglocextId).getExtension();
        }
        return null;
    }
}

