/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.SIPEntityDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.SIPEntity;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.ReliableEventingBroker;
import com.avaya.zephyr.platform.dal.api.objectapi.ReliableEventingCluster;
import com.avaya.zephyr.platform.dal.api.objectapi.ReliableEventingGroup;
import com.avaya.zephyr.platform.dao.AusInstanceDAO;
import com.avaya.zephyr.platform.dm.ZephyrDM;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReliableEventingDAO
extends DataAccessObject
implements DMListener {
    private final Logger log = AsmLogger.getLogger(ReliableEventingDAO.class);
    protected static final String ZR_REVENT_GROUP = "zr_revent_group";
    protected static final String ZR_REVENT_GROUP_CLUSTERS = "zr_map_revent_group_cluster";
    protected static final String ZR_REVENT_GROUP_BROKERS = "zr_map_revent_group_fsinstance";
    protected static final String GET_REVENT_GROUPS = "select id, name, description, reliability_type, is_enabled from zr_revent_group";
    protected static final String GET_REVENT_GROUP = "select id, name, description, reliability_type, is_enabled from zr_revent_group where id = ?";
    protected static final String GET_REVENT_GROUP_CLUSTER = "select id, revent_group_id, cluster_id from zr_map_revent_group_cluster where id = ?";
    protected static final String GET_REVENT_GROUP_CLUSTERS = "select id, revent_group_id, cluster_id from zr_map_revent_group_cluster";
    protected static final String GET_REVENT_GROUP_BROKERS = "select id, zookeeper_num, revent_group_id, port, fsinstance_id from zr_map_revent_group_fsinstance";
    protected static final String GET_REVENT_GROUP_BROKER = "select id, zookeeper_num, revent_group_id, port, fsinstance_id from zr_map_revent_group_fsinstance where id = ?";
    protected static final String UNKNOWN = "unknown";
    private Map<Long, ReliableEventingGroup> reventGroups = new HashMap<Long, ReliableEventingGroup>();
    private ReliableEventingGroup myGroup;
    private List<ReliableEventingBroker> myBrokers;
    private List<ReliableEventingGroup> myGroups;
    private Integer myZookeeperId;
    private ZephyrDM zephyrDm;

    public ReliableEventingDAO() {
        super(true);
    }

    public List<String> getDependentTables() {
        return Arrays.asList(ZR_REVENT_GROUP, ZR_REVENT_GROUP_CLUSTERS, ZR_REVENT_GROUP_BROKERS);
    }

    protected Object getMainCollection() {
        return null;
    }

    public final void objectChanged(Object oldObject, Object newObject) {
        this.log.finest((Object)"Got objectChanged");
        if (oldObject instanceof SIPEntity) {
            this.handleSipEntityUpdate((SIPEntity)oldObject, (SIPEntity)newObject);
        }
    }

    private void handleSipEntityUpdate(SIPEntity oldSipEntity, SIPEntity newSipEntity) {
        ReliableEventingBroker tmpReb = null;
        this.log.finest((Object)"enter handleSipEntityUpdate");
        for (ReliableEventingGroup reg : this.reventGroups.values()) {
            for (ReliableEventingBroker reb : reg.getBrokers()) {
                Long rebSipId = this.zephyrDm.getAusInstanceDAO().getAusInstance(reb.getAusInstanceId()).getSipEntityId();
                if (!rebSipId.equals(oldSipEntity.getId()) && !rebSipId.equals(newSipEntity.getId())) continue;
                tmpReb = new ReliableEventingBroker(reb.getId(), reb.getZookeeperNo(), reb.getAusInstanceId(), reb.getTransportPort(), reb.getReventGroupId());
                tmpReb.setTransportIp(newSipEntity.getFqdnoripaddr());
                this.log.finest((Object)"updating transportIP");
                this.updateListeners(reb, tmpReb);
                this.log.finest((Object)"updated transporIP, updating broker");
                this.lock.acquireWriteLock();
                reb.setTransportIp(newSipEntity.getFqdnoripaddr());
                this.lock.releaseWriteLock();
                this.log.finest((Object)"updated transporIP, updating broker");
            }
        }
        this.log.finest((Object)"exit handleSipEntityUpdate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateListeners(Object oldObj, Object newObj) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        for (DMListener listener : this.getListeners()) {
            try {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                listener.objectChanged(oldObj, newObj);
            }
            catch (Exception e) {
                this.log.error((Object)("Exception on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.log.error((Object)"Exception is: ", (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        String tableName = tableEvent.getTableName();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        if (operation != null) {
            if (tableName.equalsIgnoreCase(ZR_REVENT_GROUP)) {
                this.updateReventGroup(operation, id);
            }
            if (tableName.equalsIgnoreCase(ZR_REVENT_GROUP_CLUSTERS)) {
                this.updateReventClusters(operation, id);
            }
            if (tableName.equalsIgnoreCase(ZR_REVENT_GROUP_BROKERS)) {
                this.updateReventBrokers(operation, id);
            }
        }
    }

    private void updateReventBrokers(DAOReplicationEvent.OperationType operation, Long id) {
        this.log.finest((Object)"enter updateReventBrokers");
        ReliableEventingBroker oldObject = null;
        ReliableEventingBroker newObject = null;
        ReliableEventingGroup oldGroup = null;
        ReliableEventingGroup newGroup = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE) && (oldObject = this.deleteEventingBroker(id)) != null) {
            oldGroup = newGroup = this.reventGroups.get(oldObject.getReventGroupId());
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) || operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            try {
                newObject = this.getEventingBroker(id);
                newGroup = this.updateBrokerGroup(newObject, operation);
            }
            catch (DMException e) {
                this.log.error((Object)"Error while updating Cache for table zr_revent_group ", (Throwable)e);
            }
        }
        if (oldObject != null || newObject != null) {
            this.updateListeners(oldObject, newObject);
            if (oldGroup != null || newGroup != null) {
                this.updateListeners(oldGroup, newGroup);
            }
        }
        this.log.finest((Object)"exit updateReventBrokers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReliableEventingBroker deleteEventingBroker(Long id) {
        this.log.finest((Object)"enter deleteEventingBroker");
        ReliableEventingBroker oldObject = null;
        try {
            this.lock.acquireWriteLock();
            for (ReliableEventingGroup reg : this.reventGroups.values()) {
                for (ReliableEventingBroker reb : reg.getBrokers()) {
                    if (!reb.getId().equals(id)) continue;
                    oldObject = reb;
                    break;
                }
                if (oldObject == null) continue;
                reg.getBrokers().remove(oldObject);
                break;
            }
            this.setMyBrokers(null);
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.log.finest((Object)"exit deleteEventingBroker");
        return oldObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReliableEventingGroup updateBrokerGroup(ReliableEventingBroker newBroker, DAOReplicationEvent.OperationType operation) {
        this.log.finest((Object)"enter updateBrokerGroup");
        ReliableEventingGroup reg = null;
        if (newBroker == null) {
            return reg;
        }
        this.lock.acquireWriteLock();
        try {
            reg = this.reventGroups.get(newBroker.getReventGroupId());
            if (reg == null) {
                reg = new ReliableEventingGroup(newBroker.getReventGroupId(), UNKNOWN, UNKNOWN, UNKNOWN, false);
                this.reventGroups.put(newBroker.getReventGroupId(), reg);
            }
            if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
                this.reventGroups.get(newBroker.getReventGroupId()).getBrokers().add(newBroker);
            }
            if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
                for (ReliableEventingBroker reb : reg.getBrokers()) {
                    if (!reb.getId().equals(newBroker.getId())) continue;
                    reb.setAusInstanceId(newBroker.getAusInstanceId());
                    reb.setReventGroupId(newBroker.getReventGroupId());
                    reb.setZookeeperNo(newBroker.getZookeeperNo());
                }
            }
            this.setMyBrokers(null);
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.log.finest((Object)"exit updateBrokerGroup");
        return reg;
    }

    private ReliableEventingBroker getEventingBroker(Long id) throws DMException {
        return (ReliableEventingBroker)this.dataSource.executeQuery(GET_REVENT_GROUP_BROKER, new Object[]{id}, (Object)new ResultSetMapper(){
            private ReliableEventingBroker reb = null;

            public ReliableEventingBroker mapResults(ResultSet results) throws SQLException, DMException {
                while (results.next()) {
                    this.reb = new ReliableEventingBroker(results.getLong("id"), results.getInt("zookeeper_num"), results.getLong("fsinstance_id"), results.getInt("port"), results.getLong("revent_group_id"));
                    ReliableEventingDAO.this.updateBrokerTransport(this.reb);
                }
                return this.reb;
            }
        });
    }

    private void updateBrokerTransport(ReliableEventingBroker reb) {
        Long sipEntityId = this.zephyrDm.getAusInstanceDAO().getAusInstance(reb.getAusInstanceId()).getSipEntityId();
        reb.setTransportIp(this.zephyrDm.getAllSipEntities().get(sipEntityId).getFqdnoripaddr());
    }

    private void updateReventClusters(DAOReplicationEvent.OperationType operation, Long id) {
        this.log.finest((Object)"enter updateReventClusters");
        ReliableEventingCluster oldObject = null;
        ReliableEventingCluster newObject = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            oldObject = this.deleteEventingCluster(id);
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) || operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            try {
                newObject = this.getEventingCluster(id);
                this.updateClusterGroup(newObject, operation);
            }
            catch (DMException e) {
                this.log.error((Object)"Error while updating Cache for table zr_revent_group ", (Throwable)e);
            }
        }
        if (oldObject != null || newObject != null) {
            this.updateListeners(oldObject, newObject);
        }
        this.log.finest((Object)"exit updateReventClusters");
    }

    private ReliableEventingCluster getEventingCluster(Long id) throws DMException {
        return (ReliableEventingCluster)this.dataSource.executeQuery(GET_REVENT_GROUP_CLUSTER, new Object[]{id}, (Object)new ResultSetMapper(){
            private ReliableEventingCluster rec = null;

            public ReliableEventingCluster mapResults(ResultSet results) throws SQLException, DMException {
                while (results.next()) {
                    this.rec = new ReliableEventingCluster(results.getLong("id"), results.getLong("cluster_id"), results.getLong("revent_group_id"));
                }
                return this.rec;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReliableEventingCluster deleteEventingCluster(Long id) {
        this.log.finest((Object)"enter deleteEventingCluster");
        ReliableEventingCluster oldObject = null;
        try {
            this.lock.acquireWriteLock();
            for (ReliableEventingGroup reg : this.reventGroups.values()) {
                for (ReliableEventingCluster rec : reg.getParticipatingClusters()) {
                    if (!rec.getId().equals(id)) continue;
                    oldObject = rec;
                    break;
                }
                if (oldObject == null) continue;
                reg.getParticipatingClusters().remove(oldObject);
                break;
            }
            this.setMyBrokers(null);
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.log.finest((Object)"exit deleteEventingCluster");
        return oldObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClusterGroup(ReliableEventingCluster newObject, DAOReplicationEvent.OperationType operation) {
        this.log.finest((Object)"enter updateClusterGroup");
        this.lock.acquireWriteLock();
        try {
            ReliableEventingGroup reg = this.reventGroups.get(newObject.getReventGroupId());
            if (reg == null) {
                reg = new ReliableEventingGroup(newObject.getReventGroupId(), UNKNOWN, UNKNOWN, UNKNOWN, false);
                this.reventGroups.put(newObject.getReventGroupId(), reg);
            }
            if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
                this.reventGroups.get(newObject.getReventGroupId()).getParticipatingClusters().add(newObject);
            } else if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
                for (ReliableEventingCluster rec : reg.getParticipatingClusters()) {
                    if (!rec.getId().equals(newObject.getId())) continue;
                    rec.setClusterId(newObject.getClusterId());
                    rec.setReventGroupId(newObject.getReventGroupId());
                }
            }
            this.setMyBrokers(null);
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.log.finest((Object)"exit updateClusterGroup");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteReventGroup(Long id) {
        ReliableEventingGroup oldObject = null;
        Object newObject = null;
        this.log.finest((Object)"enter deleteReventGroup");
        try {
            this.lock.acquireWriteLock();
            oldObject = this.reventGroups.remove(id);
            this.setMyGroup(null);
        }
        finally {
            this.lock.releaseWriteLock();
        }
        if (oldObject != null || newObject != null) {
            this.updateListeners(oldObject, newObject);
        }
        this.log.finest((Object)"exit deleteReventGroup");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertReventGroup(Long id) {
        this.log.finest((Object)"enter insertReventGroup");
        Object oldObject = null;
        ReliableEventingGroup newObject = null;
        try {
            newObject = this.getReliableEventGroup(id);
            this.lock.acquireWriteLock();
            try {
                this.reventGroups.put(id, newObject);
                this.setMyGroup(null);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        catch (DMException e) {
            this.log.error((Object)"Error while updating Cache for table zr_revent_group ", (Throwable)e);
        }
        if (oldObject != null || newObject != null) {
            this.updateListeners(oldObject, newObject);
        }
        this.log.finest((Object)"exit insertReventGroup");
    }

    private void updateReventGroup(Long id) {
        ReliableEventingGroup oldObject = null;
        ReliableEventingGroup newObject = null;
        this.log.finest((Object)"enter updateReventGroup");
        try {
            newObject = this.getReliableEventGroup(id);
            oldObject = this.reventGroups.get(id);
            if (oldObject != null || newObject != null) {
                this.updateListeners(oldObject, newObject);
            }
            if (oldObject != null) {
                newObject.setBrokers(oldObject.getBrokers());
                newObject.setParticipatingClusters(oldObject.getParticipatingClusters());
            }
            this.lock.acquireWriteLock();
            this.reventGroups.put(id, newObject);
            this.setMyGroup(null);
            this.lock.releaseWriteLock();
        }
        catch (DMException e) {
            this.log.error((Object)"Error while updating Cache for table zr_revent_group ", (Throwable)e);
        }
        this.log.finest((Object)"exit updateReventGroup");
    }

    private void updateReventGroup(DAOReplicationEvent.OperationType operation, Long id) {
        if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            this.deleteReventGroup(id);
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            this.insertReventGroup(id);
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
            this.updateReventGroup(id);
        }
    }

    private ReliableEventingGroup getReliableEventGroup(Long id) throws DMException {
        return (ReliableEventingGroup)this.dataSource.executeQuery(GET_REVENT_GROUP, new Object[]{id}, (Object)new ResultSetMapper(){
            private ReliableEventingGroup tmpReventGroup = null;

            public ReliableEventingGroup mapResults(ResultSet results) throws SQLException, DMException {
                while (results.next()) {
                    this.tmpReventGroup = new ReliableEventingGroup(results.getLong("id"), results.getString("name"), results.getString("description"), results.getString("reliability_type"), results.getBoolean("is_enabled"));
                }
                return this.tmpReventGroup;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        HashMap tmpReventGroups;
        Object[] params = new Object[]{};
        this.zephyrDm = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);
        DMFactory.getInstance().getDataMgr(SIPEntityDAO.class).registerListener((DMListener)this);
        try {
            tmpReventGroups = (HashMap)this.dataSource.executeQuery(GET_REVENT_GROUPS, params, (Object)new ResultSetMapper(){

                public Map<Long, ReliableEventingGroup> mapResults(ResultSet results) throws SQLException, DMException {
                    ConcurrentHashMap<Long, ReliableEventingGroup> tmpReventGroups = new ConcurrentHashMap<Long, ReliableEventingGroup>();
                    while (results.next()) {
                        tmpReventGroups.put(results.getLong("id"), new ReliableEventingGroup(results.getLong("id"), results.getString("name"), results.getString("description"), results.getString("reliability_type"), results.getBoolean("is_enabled")));
                    }
                    if (!tmpReventGroups.isEmpty()) {
                        return tmpReventGroups;
                    }
                    return null;
                }
            });
            Map tmpReventBrokers = (Map)this.dataSource.executeQuery(GET_REVENT_GROUP_BROKERS, params, (Object)new ResultSetMapper(){

                public Object mapResults(ResultSet results) throws SQLException, DMException {
                    ConcurrentHashMap tmpReventBrokers = new ConcurrentHashMap();
                    while (results.next()) {
                        Long regId = results.getLong("revent_group_id");
                        ReliableEventingBroker reb = new ReliableEventingBroker(results.getLong("id"), results.getInt("zookeeper_num"), results.getLong("fsinstance_id"), results.getInt("port"), regId);
                        ReliableEventingDAO.this.updateBrokerTransport(reb);
                        if (tmpReventBrokers.get(regId) == null) {
                            tmpReventBrokers.put(regId, new ArrayList());
                        }
                        ((List)tmpReventBrokers.get(regId)).add(reb);
                    }
                    if (!tmpReventBrokers.isEmpty()) {
                        return tmpReventBrokers;
                    }
                    return null;
                }
            });
            Map tmpReventClusters = (Map)this.dataSource.executeQuery(GET_REVENT_GROUP_CLUSTERS, params, (Object)new EventingClustersMapper());
            this.updategroups(tmpReventGroups, tmpReventBrokers, tmpReventClusters);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            if (tmpReventGroups == null) {
                tmpReventGroups = new HashMap();
            }
            this.reventGroups = tmpReventGroups;
            this.setMyGroup(null);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    private void updategroups(Map<Long, ReliableEventingGroup> tmpReventGroups, Map<Long, List<ReliableEventingBroker>> tmpReventBrokers, Map<Long, List<ReliableEventingCluster>> tmpReventClusters) {
        if (tmpReventGroups != null) {
            for (ReliableEventingGroup reg : tmpReventGroups.values()) {
                if (this.log.isFinestEnabled()) {
                    this.log.finest((Object)("updating Brokers  for " + reg.getId()));
                }
                reg.setBrokers(null);
                if (tmpReventBrokers != null) {
                    this.updateGroupBrokers(reg, tmpReventBrokers);
                }
                if (this.log.isFinestEnabled()) {
                    this.log.finest((Object)("updating Clusters  for " + reg.getId()));
                }
                reg.setParticipatingClusters(null);
                if (tmpReventClusters == null) continue;
                this.updateGroupClusters(reg, tmpReventClusters);
            }
        }
    }

    private void updateGroupBrokers(ReliableEventingGroup reg, Map<Long, List<ReliableEventingBroker>> tmpReventBrokers) {
        this.log.finest((Object)"enter updateGroupBrokers");
        List<ReliableEventingBroker> brkL = tmpReventBrokers.get(reg.getId());
        if (brkL != null) {
            if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("adding Brokers " + brkL + " for " + reg.getId()));
            }
            reg.getBrokers().addAll(brkL);
        }
        this.log.finest((Object)"exit updateGroupBrokers");
    }

    private void updateGroupClusters(ReliableEventingGroup reg, Map<Long, List<ReliableEventingCluster>> tmpReventClusters) {
        this.log.finest((Object)"enter updateGroupClusters");
        List<ReliableEventingCluster> clsL = tmpReventClusters.get(reg.getId());
        if (clsL != null) {
            if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("adding Clusters " + clsL + " for " + reg.getId()));
            }
            reg.getParticipatingClusters().addAll(clsL);
        }
        this.log.finest((Object)"exit updateGroupClusters");
    }

    public Collection<ReliableEventingGroup> getEventingGroups() {
        if (this.getStatus() != DataMgr.Status.OKAY) {
            this.init();
        }
        return this.reventGroups.values();
    }

    public ReliableEventingGroup getMyGroup() {
        if (this.myGroup == null) {
            AusInstanceDAO ausIDao = (AusInstanceDAO)this.getDMFactoryInstance().getDataMgr(AusInstanceDAO.class);
            for (ReliableEventingGroup reg : this.reventGroups.values()) {
                for (ReliableEventingBroker reb : reg.getBrokers()) {
                    if (!reb.getAusInstanceId().equals(ausIDao.getMyInstanceId())) continue;
                    this.lock.acquireWriteLock();
                    this.myGroup = reg;
                    this.lock.releaseWriteLock();
                    return this.myGroup;
                }
            }
        }
        return this.myGroup;
    }

    public List<ReliableEventingBroker> getMyBrokers() {
        if (this.myBrokers == null) {
            ArrayList<ReliableEventingBroker> tmpBrkl = new ArrayList<ReliableEventingBroker>();
            AusInstanceDAO ausIDao = (AusInstanceDAO)this.getDMFactoryInstance().getDataMgr(AusInstanceDAO.class);
            for (ReliableEventingGroup reg : this.reventGroups.values()) {
                for (ReliableEventingCluster rec : reg.getParticipatingClusters()) {
                    if (!rec.getClusterId().equals(ausIDao.getMyClusterId())) continue;
                    tmpBrkl.addAll(reg.getBrokers());
                }
            }
            this.lock.acquireWriteLock();
            this.myBrokers = tmpBrkl;
            this.lock.releaseWriteLock();
        }
        return this.myBrokers;
    }

    public List<ReliableEventingGroup> getMyGroups() {
        if (this.myGroups == null) {
            this.log.finest((Object)"myGroups null ");
            ArrayList<ReliableEventingGroup> tmpGrpl = new ArrayList<ReliableEventingGroup>();
            AusInstanceDAO ausIDao = (AusInstanceDAO)this.getDMFactoryInstance().getDataMgr(AusInstanceDAO.class);
            for (ReliableEventingGroup reg : this.reventGroups.values()) {
                for (ReliableEventingCluster rec : reg.getParticipatingClusters()) {
                    if (!rec.getClusterId().equals(ausIDao.getMyClusterId())) continue;
                    this.log.finest((Object)("adding " + reg.getName() + " to myGroups"));
                    tmpGrpl.add(reg);
                }
            }
            this.log.finest((Object)("myGroups tmpGrpl " + tmpGrpl.size()));
            this.lock.acquireWriteLock();
            this.myGroups = tmpGrpl;
            this.lock.releaseWriteLock();
        }
        return this.myGroups;
    }

    public Integer getMyZookeeperId() {
        if (this.myZookeeperId == null && this.getMyGroup() != null && this.getMyGroup().isHa()) {
            AusInstanceDAO ausIDao = (AusInstanceDAO)this.getDMFactoryInstance().getDataMgr(AusInstanceDAO.class);
            List<ReliableEventingBroker> myBrokers = this.getMyBrokers();
            if (myBrokers != null) {
                for (ReliableEventingBroker broker : myBrokers) {
                    if (!broker.getAusInstanceId().equals(ausIDao.getMyInstanceId())) continue;
                    this.myZookeeperId = broker.getZookeeperNo();
                    break;
                }
            }
        }
        return this.myZookeeperId;
    }

    private void setMyGroup(ReliableEventingGroup myGroup) {
        this.log.finest((Object)"enter setMyGroup");
        this.myGroup = myGroup;
        this.setMyBrokers(null);
        this.log.finest((Object)"exit setMyGroup");
    }

    private void setMyBrokers(List<ReliableEventingBroker> myBrokers) {
        this.log.finest((Object)"enter setMyBrokers");
        this.myBrokers = myBrokers;
        this.setMyZookeeperId(null);
        this.setMyGroups(null);
        this.log.finest((Object)"exit setMyBrokers");
    }

    private void setMyZookeeperId(Integer myZookeeperId) {
        this.myZookeeperId = myZookeeperId;
    }

    protected void setReventGroups(Map<Long, ReliableEventingGroup> reventGroups) {
        this.log.finest((Object)"enter setReventGroups");
        this.reventGroups = reventGroups;
        this.setMyGroup(null);
        this.log.finest((Object)"exit setReventGroups");
    }

    private void setMyGroups(List<ReliableEventingGroup> myGroups) {
        this.log.finest((Object)"enter setMyGroups");
        this.myGroups = myGroups;
        this.log.finest((Object)"exit setMyGroups");
    }

    private static class EventingClustersMapper
    implements ResultSetMapper {
        private EventingClustersMapper() {
        }

        public Object mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap tmpReventClusters = new ConcurrentHashMap();
            while (results.next()) {
                Long regId = results.getLong("revent_group_id");
                ReliableEventingCluster rec = new ReliableEventingCluster(results.getLong("id"), results.getLong("cluster_id"), regId);
                if (tmpReventClusters.get(regId) == null) {
                    tmpReventClusters.put(regId, new ArrayList());
                }
                ((List)tmpReventClusters.get(regId)).add(rec);
            }
            if (!tmpReventClusters.isEmpty()) {
                return tmpReventClusters;
            }
            return null;
        }
    }
}

