/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.ServicePlatformDependencyData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServicePlatformDependencyDAO
extends DataAccessObject {
    protected static final Logger logger = Logger.getLogger(ServicePlatformDependencyDAO.class);
    protected static final String PLATFORM_DEPENDENCY_TABLE = "zr_service_platform_dependency";
    protected static final String SERVICE_VERSION_TABLE = "zr_service_version";
    protected static final String ID = "id";
    protected static final String SERVICE_VERSION = "service_version_id";
    protected static final String DEPENDENCY_NAME = "dependency_name";
    protected static final String RUN_TIME_ACTION = "run_time_action";
    protected static final String START_TIME_ACTION = "startup_time_action";
    protected static final String INSTALL_TIME_ACTION = "install_time_action";
    protected static final String APPLICATION_NAME = "application_name";
    protected static final String ARCHIVE_NAME = "archive_name";
    protected static final String GET_SRV_PLATFORM_DEPENDENCY_DATA = " SELECT dep.id, dep.service_version_id, dep.dependency_name, dep.run_time_action, dep.startup_time_action, dep.install_time_action, v.application_name, v.archive_name FROM zr_service_platform_dependency dep, zr_service_version v where dep.service_version_id=v.id";
    protected static final String GET_SRV_PLATFORM_DEPENDENCY_DATA_BY_ID = " SELECT dep.id, dep.service_version_id, dep.dependency_name, dep.run_time_action, dep.startup_time_action, dep.install_time_action, v.application_name, v.archive_name FROM zr_service_platform_dependency dep, zr_service_version v where dep.service_version_id=v.id  AND dep.id= ?";
    private Map<Long, ServicePlatformDependencyData> idToSrvPlatDepDataMap = new ConcurrentHashMap<Long, ServicePlatformDependencyData>();

    public List<String> getDependentTables() {
        return Arrays.asList(PLATFORM_DEPENDENCY_TABLE);
    }

    public Map<Long, ServicePlatformDependencyData> getIdToSrvPlatDepDataMap() {
        return this.idToSrvPlatDepDataMap;
    }

    protected Object getMainCollection() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDAO(DAOTableEvent tableEvent) {
        Long id = tableEvent.getKey();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        ServicePlatformDependencyData newData = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            try {
                newData = (ServicePlatformDependencyData)this.dataSource.executeQuery(GET_SRV_PLATFORM_DEPENDENCY_DATA_BY_ID, new Object[]{id}, (Object)this.getServiceDependencyDataMapperById());
                try {
                    this.lock.acquireWriteLock();
                    this.idToSrvPlatDepDataMap.put(id, newData);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                logger.error((Object)("updateDAO :Exception while inserting new entry to DAO for change in table zr_service_platform_dependency For id=" + id + " Exception:" + e.getMessage()));
                this.reinit();
            }
        } else if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
            try {
                newData = (ServicePlatformDependencyData)this.dataSource.executeQuery(GET_SRV_PLATFORM_DEPENDENCY_DATA_BY_ID, new Object[]{id}, (Object)this.getServiceDependencyDataMapperById());
                try {
                    this.lock.acquireWriteLock();
                    this.idToSrvPlatDepDataMap.put(id, newData);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                logger.error((Object)("updateDAO :Exception while updating DAO for change in table zr_service_platform_dependency For id=" + id + " Exception:" + e.getMessage()));
                this.reinit();
            }
        } else if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            this.idToSrvPlatDepDataMap.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map tempIdToSrvPlatDepDataMap;
        ServiceDependencyDataMapper serviceDependencyDataMapper = new ServiceDependencyDataMapper();
        try {
            tempIdToSrvPlatDepDataMap = (Map)this.dataSource.executeQuery(GET_SRV_PLATFORM_DEPENDENCY_DATA, new Object[0], (Object)serviceDependencyDataMapper);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            logger.error((Object)("init(): Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.lock.acquireWriteLock();
        try {
            this.idToSrvPlatDepDataMap = tempIdToSrvPlatDepDataMap;
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.setStatus(DataMgr.Status.OKAY);
    }

    protected final ResultSetMapper getServiceDependencyDataMapperById() {
        return new ResultSetMapper(){

            public ServicePlatformDependencyData mapResults(ResultSet resultSet) throws SQLException, DMException {
                ServicePlatformDependencyData result = null;
                while (resultSet.next()) {
                    result = new ServicePlatformDependencyData(resultSet.getLong(ServicePlatformDependencyDAO.ID), resultSet.getLong(ServicePlatformDependencyDAO.SERVICE_VERSION), resultSet.getString(ServicePlatformDependencyDAO.DEPENDENCY_NAME), resultSet.getString(ServicePlatformDependencyDAO.RUN_TIME_ACTION), resultSet.getString(ServicePlatformDependencyDAO.START_TIME_ACTION), resultSet.getString(ServicePlatformDependencyDAO.INSTALL_TIME_ACTION), resultSet.getString(ServicePlatformDependencyDAO.APPLICATION_NAME), resultSet.getString(ServicePlatformDependencyDAO.ARCHIVE_NAME));
                }
                return result;
            }
        };
    }

    @SMConsole(description="Returns the list of services with run time action as STOP for the given component.")
    public Map<String, String> getAppsToStopByComponent(String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException("component name cannot be null");
        }
        HashMap<String, String> appNames = new HashMap<String, String>();
        if (!this.idToSrvPlatDepDataMap.isEmpty()) {
            for (ServicePlatformDependencyData data : this.idToSrvPlatDepDataMap.values()) {
                if (!componentName.equalsIgnoreCase(data.getDependencyName()) || !"STOP".equalsIgnoreCase(data.getRunTimeAction())) continue;
                appNames.put(data.getApplicationName(), data.getArchiveName());
            }
        }
        return appNames;
    }

    @SMConsole(description="Returns the list of dependencies for the given application name")
    public List<String> getComponentsByApplicationName(String appName) {
        if (appName == null) {
            throw new IllegalArgumentException("Application Name cannot be null");
        }
        ArrayList<String> dependencies = new ArrayList<String>();
        if (!this.idToSrvPlatDepDataMap.isEmpty()) {
            for (ServicePlatformDependencyData data : this.idToSrvPlatDepDataMap.values()) {
                if (!appName.equals(data.getApplicationName())) continue;
                dependencies.add(data.getDependencyName());
            }
        }
        return dependencies;
    }

    @SMConsole(description="Returns the list of dependencies for the given application with start time action as DONT_START")
    public List<String> getComponentsWithStartTimeAction(String appName) {
        if (appName == null) {
            throw new IllegalArgumentException("Application Name cannot be null");
        }
        ArrayList<String> dependencies = new ArrayList<String>();
        if (!this.idToSrvPlatDepDataMap.isEmpty()) {
            for (ServicePlatformDependencyData data : this.idToSrvPlatDepDataMap.values()) {
                if (!appName.equals(data.getApplicationName()) || !"DONT_START".equalsIgnoreCase(data.getStartTimeAction())) continue;
                dependencies.add(data.getDependencyName());
            }
        }
        return dependencies;
    }

    @SMConsole(description="Returns archive name for the given application name")
    public String getArchiveName(String applicationName) {
        if (applicationName == null) {
            throw new IllegalArgumentException("Application Name cannot be null");
        }
        String archiveName = null;
        if (!this.idToSrvPlatDepDataMap.isEmpty()) {
            for (ServicePlatformDependencyData data : this.idToSrvPlatDepDataMap.values()) {
                if (!applicationName.equals(data.getApplicationName())) continue;
                archiveName = data.getArchiveName();
            }
        }
        return archiveName;
    }

    static class ServiceDependencyDataMapper
    implements ResultSetMapper {
        ServiceDependencyDataMapper() {
        }

        public Map<Long, ServicePlatformDependencyData> mapResults(ResultSet resultSet) throws SQLException, DMException {
            ConcurrentHashMap<Long, ServicePlatformDependencyData> map = new ConcurrentHashMap<Long, ServicePlatformDependencyData>();
            while (resultSet.next()) {
                Long id = resultSet.getLong(ServicePlatformDependencyDAO.ID);
                map.put(id, new ServicePlatformDependencyData(id, resultSet.getLong(ServicePlatformDependencyDAO.SERVICE_VERSION), resultSet.getString(ServicePlatformDependencyDAO.DEPENDENCY_NAME), resultSet.getString(ServicePlatformDependencyDAO.RUN_TIME_ACTION), resultSet.getString(ServicePlatformDependencyDAO.START_TIME_ACTION), resultSet.getString(ServicePlatformDependencyDAO.INSTALL_TIME_ACTION), resultSet.getString(ServicePlatformDependencyDAO.APPLICATION_NAME), resultSet.getString(ServicePlatformDependencyDAO.ARCHIVE_NAME)));
            }
            return map;
        }
    }
}

