/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.TMConfData;
import java.lang.invoke.LambdaMetafactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class TMConfDataDAO
extends DataAccessObject {
    private final Logger logger = Logger.getLogger(TMConfDataDAO.class);
    protected static final String TMCONFDATA_TABLE = "tmconfdata";
    protected static final String GET_ALLTMCONFDATA_QUERY = "select * from tmconfdata";
    protected static final String GET_ALLTMCONFDATA_QUERY_BY_ID = "select * from tmconfdata where id = ?";
    protected static final String MIN_TLS_VERSION_KEY = "TLS_VERSION";
    private Map<String, TMConfData> tmConfDataMap;

    public TMConfDataDAO() {
        super(true);
    }

    public void init() {
        Map tmConfDataMapTmp;
        this.logger.finer((Object)"init ENTER");
        try {
            tmConfDataMapTmp = (Map)this.dataSource.executeQuery(GET_ALLTMCONFDATA_QUERY, new Object[0], (Object)this.getResultSetMapper());
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.logger.error((Object)"init Error initializing TMConfDataDAO", (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            this.tmConfDataMap = tmConfDataMapTmp;
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.logger.finer((Object)"init EXIT");
    }

    protected ResultSetMapper getResultSetMapper() {
        return new ResultSetMapper(){

            public Object mapResults(ResultSet results) throws SQLException, DMException {
                ConcurrentHashMap<String, TMConfData> tmConfResultsMap = new ConcurrentHashMap<String, TMConfData>();
                while (results.next()) {
                    String tmConfDatakey = results.getString("key");
                    tmConfResultsMap.put(tmConfDatakey, new TMConfData(results.getLong("id"), tmConfDatakey, results.getString("keytype"), results.getString("value")));
                }
                return tmConfResultsMap;
            }
        };
    }

    public List<String> getDependentTables() {
        return Arrays.asList(TMCONFDATA_TABLE);
    }

    protected Object getMainCollection() {
        return new HashMap<String, TMConfData>(this.tmConfDataMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void updateDAO(DAOTableEvent tableEvent) {
        if (this.logger.isFinerEnabled()) {
            this.logger.finer((Object)("updateDAO(" + tableEvent + ") ENTER"));
        }
        tableName = tableEvent.getTableName();
        id = tableEvent.getKey();
        operationType = tableEvent.getOperation();
        oldObject = null;
        newObject = null;
        if ("tmconfdata".equalsIgnoreCase(tableName)) {
            try {
                this.lock.acquireWriteLock();
                switch (2.$SwitchMap$com$avaya$asm$datamgr$dao$replication$DAOReplicationEvent$OperationType[operationType.ordinal()]) {
                    case 1: {
                        deletedTmConfDataOptional = this.tmConfDataMap.values().stream().filter((Predicate<TMConfData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$updateDAO$0(long com.avaya.zephyr.platform.dal.api.objectapi.TMConfData ), (Lcom/avaya/zephyr/platform/dal/api/objectapi/TMConfData;)Z)((long)id)).findFirst();
                        if (deletedTmConfDataOptional.isPresent()) {
                            deletedTmConfData = deletedTmConfDataOptional.get();
                            oldObject = this.tmConfDataMap.remove(deletedTmConfData.getTmConfigurationName());
                            ** break;
lbl18:
                            // 1 sources

                        } else {
                            this.logger.error((Object)("updateDAO - deleted record with id" + id + " not found"));
                            ** break;
                        }
lbl21:
                        // 1 sources

                        break;
                    }
                    case 2: 
                    case 3: {
                        newConfigData = this.getTMConfig(id);
                        if (newConfigData == null) ** break;
                        newObject = newConfigData;
                        oldObject = this.tmConfDataMap.put(newConfigData.getTmConfigurationName(), newConfigData);
                        break;
                    }
                    ** default:
lbl29:
                    // 1 sources

                    break;
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
            if (oldObject != null || newObject != null) {
                this.updateListeners(oldObject, newObject);
            }
        }
    }

    @SMConsole(parameterNames={"configId"}, description="Get the TM Configuration object for the given ID")
    public TMConfData getTMConfig(long configId) {
        TMConfData tmConfData = null;
        Map tmConfDataMapTmp = null;
        try {
            tmConfDataMapTmp = (Map)this.dataSource.executeQuery(GET_ALLTMCONFDATA_QUERY_BY_ID, new Object[]{configId}, (Object)this.getResultSetMapper());
        }
        catch (DMException e) {
            this.logger.error((Object)"getTMConfig Error", (Throwable)e);
        }
        if (MapUtils.isNotEmpty(tmConfDataMapTmp)) {
            tmConfData = (TMConfData)tmConfDataMapTmp.values().toArray()[0];
        }
        return tmConfData;
    }

    @SMConsole(description="Get the Global Minimum TLS Version")
    public String getGlobalMinimumTLSVersion() {
        String minGlobalTLSVersion;
        TMConfData tmConfData = this.tmConfDataMap.get(MIN_TLS_VERSION_KEY);
        if (tmConfData != null && StringUtils.isNotBlank((CharSequence)(minGlobalTLSVersion = tmConfData.getTmConfigurationValue()))) {
            return minGlobalTLSVersion;
        }
        throw new IllegalArgumentException("GLOBAL Minimum TLS Version not found");
    }

    private static /* synthetic */ boolean lambda$updateDAO$0(long id, TMConfData tmConfData) {
        return tmConfData.getTmConfigurationId() == id;
    }
}

