/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dm;

import com.avaya.asm.datamgr.DMListener;
import com.avaya.common.logging.client.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public abstract class AbstractDMListener
implements DMListener {
    private static final Logger LOG = Logger.getLogger(AbstractDMListener.class);
    private String configFile = "/service.properties";
    private String serviceName;
    private String serviceVersion;

    public AbstractDMListener() {
        this.readConfig();
    }

    private void readConfig() {
        Properties properties = new Properties();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        InputStream configIn = contextClassLoader.getResourceAsStream(this.configFile);
        if (configIn == null) {
            LOG.error((Object)("Config file does not exist: " + this.configFile));
            return;
        }
        try {
            properties.load(configIn);
            this.serviceName = properties.getProperty("serviceName");
            this.serviceVersion = properties.getProperty("serviceVersion");
            configIn.close();
        }
        catch (IOException e) {
            LOG.error((Object)("Caught Exception: " + e));
        }
    }

    public abstract void objectChanged(Object var1, Object var2);

    public final String getServiceName() {
        return this.serviceName;
    }

    public final String getServiceVersion() {
        return this.serviceVersion;
    }
}

