/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.helper;

import com.avaya.common.logging.helper.EventCode;
import com.avaya.common.logging.helper.ParameterCoder;
import com.avaya.common.logging.helper.PluginResource;
import com.avaya.common.logging.helper.ResourceBundleLoader;
import com.avaya.common.logging.helper.ResourceKey;
import java.io.FileInputStream;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.logging.log4j.status.StatusLogger;

public class EventMsg {
    protected EventCode mEventCode = null;
    protected Object[] mArgumentList = null;

    public EventMsg(EventCode aCode) {
        if (aCode == null) {
            throw new NullPointerException();
        }
        this.mEventCode = aCode;
    }

    public EventMsg(EventCode aCode, Object ... aArgument) {
        if (aCode == null) {
            throw new NullPointerException();
        }
        this.mEventCode = aCode;
        this.mArgumentList = aArgument;
        for (int i = 0; i < this.mArgumentList.length; ++i) {
            if (this.mArgumentList[i] instanceof ResourceKey || this.mArgumentList[i] instanceof Date || this.mArgumentList[i] instanceof Number || this.mArgumentList[i] instanceof String) continue;
            this.mArgumentList[i] = this.mArgumentList[i] != null ? this.mArgumentList[i].toString() : "";
        }
    }

    private String getResourceKeyValue(String key) {
        StringBuilder resourceKeyValue;
        block6: {
            StringBuilder baseName = new StringBuilder(this.mEventCode.mNameSpace).append(".").append("EventCodes");
            resourceKeyValue = new StringBuilder("");
            ResourceBundle rBundle = null;
            try {
                FileInputStream resourceBundleInputStream;
                block5: {
                    resourceBundleInputStream = null;
                    try {
                        ResourceBundleLoader rbloader = new ResourceBundleLoader();
                        rBundle = rbloader.load(baseName.toString());
                    }
                    catch (MissingResourceException e) {
                        PluginResource pluginResource = new PluginResource();
                        resourceBundleInputStream = pluginResource.getPropertiesFile(Locale.getDefault().toString(), this.mEventCode.mNameSpace.toString());
                        if (resourceBundleInputStream == null) break block5;
                        rBundle = new PropertyResourceBundle(resourceBundleInputStream);
                    }
                }
                resourceKeyValue = new StringBuilder(rBundle.getString(key));
                if (resourceBundleInputStream != null) {
                    resourceBundleInputStream.close();
                }
            }
            catch (Exception e) {
                StatusLogger.getLogger().error("No object can be found for the resource key= " + key);
                if (key == null) break block6;
                resourceKeyValue = new StringBuilder(key);
            }
        }
        return resourceKeyValue.toString();
    }

    public Object[] getArguments() {
        return this.mArgumentList;
    }

    public EventCode getEventCode() {
        return this.mEventCode;
    }

    public String getParameterMsg() {
        return ParameterCoder.decodeParameters(this.mArgumentList);
    }

    public String getDecodedMsg() {
        StringBuilder result = null;
        Object[] processedArguments = new Object[100];
        if (this.mArgumentList != null) {
            for (int i = 0; i < this.mArgumentList.length; ++i) {
                if (this.mArgumentList[i] instanceof ResourceKey) {
                    String key = ((ResourceKey)this.mArgumentList[i]).getValue();
                    processedArguments[i] = this.getResourceKeyValue(key);
                    continue;
                }
                if (this.mArgumentList[i] instanceof Date) {
                    String o = new SimpleDateFormat("@yyyy-MM-dd/HH:mm:ss.SSS").format((Date)this.mArgumentList[i]);
                    if (o == null) continue;
                    processedArguments[i] = o;
                    continue;
                }
                if (this.mArgumentList[i] instanceof Number) {
                    if (this.mArgumentList[i].toString().contains(".")) {
                        DecimalFormat df = new DecimalFormat();
                        df.setGroupingUsed(false);
                        df.applyPattern("#.###E0");
                        processedArguments[i] = Double.valueOf(df.format(this.mArgumentList[i]));
                        continue;
                    }
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setGroupingUsed(false);
                    processedArguments[i] = Long.valueOf(nf.format(this.mArgumentList[i]));
                    continue;
                }
                if (!(this.mArgumentList[i] instanceof String)) continue;
                processedArguments[i] = this.mArgumentList[i];
            }
        } else {
            processedArguments = null;
        }
        try {
            result = new StringBuilder(MessageFormat.format(this.mEventCode.getEventMsgString(), processedArguments));
        }
        catch (Exception e) {
            StatusLogger.getLogger().error("Error in decoding message. So get parameter message instead.");
            result = new StringBuilder(this.getParameterMsg());
        }
        return result.toString();
    }

    public String toString() {
        return this.getDecodedMsg();
    }
}

