/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.commons.lang;

import com.avaya.commons.lang.ArgAssert;
import com.avaya.commons.lang.FailedToDetermineException;
import com.avaya.commons.lang.ReaderTextDeterminer;
import com.avaya.commons.lang.TextDeterminer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;

public final class FileTextDeterminer
implements TextDeterminer {
    private final File file;

    public FileTextDeterminer(File file) {
        ArgAssert.assertNotNull(file, "file");
        this.file = file;
    }

    public boolean isContentText() {
        if (this.file.exists() && this.file.isFile()) {
            boolean bl;
            FileReader reader = null;
            try {
                reader = new FileReader(this.file);
                bl = new ReaderTextDeterminer(reader).isContentText();
            }
            catch (FileNotFoundException e) {
                try {
                    throw new FailedToDetermineException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)reader);
            return bl;
        }
        return false;
    }
}

