/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.commons.lang;

import com.avaya.commons.lang.CharsetMetadata;
import com.avaya.commons.lang.SpecifiedCharsetMetadata;
import com.avaya.commons.lang.UnicodeByteOrderMark;
import com.avaya.commons.lang.UnspecifiedCharsetMetadata;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PushbackInputStreamCharsetMetadata
implements CharsetMetadata {
    private final Set<Charset> charsets;
    private final CharsetMetadata delegate;

    PushbackInputStreamCharsetMetadata(Set<Charset> charsets, PushbackInputStream pushbackInputStream) throws IOException {
        this.charsets = Sets.newHashSet(charsets);
        this.delegate = this.get(pushbackInputStream);
    }

    private CharsetMetadata get(PushbackInputStream pushbackInputStream) throws IOException {
        byte[] firstBytes = this.peek(pushbackInputStream, UnicodeByteOrderMark.getMaxNumBytes(this.charsets));
        for (Charset charset : this.charsets) {
            if (!this.startsWithByteOrderMark(firstBytes, charset)) continue;
            int numBytesToSkip = this.getNumBytesInByteOrderMark(charset);
            long numBytesSkipped = pushbackInputStream.skip(numBytesToSkip);
            if (numBytesSkipped != (long)numBytesToSkip) {
                throw new IllegalStateException("Failed to skip bytes:" + numBytesToSkip + ":" + numBytesToSkip + ":" + charset);
            }
            return new SpecifiedCharsetMetadata(charset);
        }
        return new UnspecifiedCharsetMetadata();
    }

    private byte[] peek(PushbackInputStream pushbackInputStream, int numBytesToRead) throws IOException {
        byte[] bytesAtStart = new byte[numBytesToRead];
        int numBytesRead = pushbackInputStream.read(bytesAtStart);
        if (numBytesRead > 0) {
            pushbackInputStream.unread(bytesAtStart, 0, numBytesRead);
        }
        return ArrayUtils.subarray((byte[])bytesAtStart, (int)0, (int)numBytesRead);
    }

    private boolean startsWithByteOrderMark(byte[] bytes, Charset charset) {
        return this.startsWith(bytes, UnicodeByteOrderMark.getBytes(charset));
    }

    private boolean startsWith(byte[] source, byte[] prefix) {
        if (source.length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (source[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    private int getNumBytesInByteOrderMark(Charset charset) {
        return UnicodeByteOrderMark.getBytes(charset).length;
    }

    @Override
    public boolean isCharsetSpecified() {
        return this.delegate.isCharsetSpecified();
    }

    @Override
    public Charset getCharset() {
        return this.delegate.getCharset();
    }
}

