/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.commons.lang;

import com.avaya.commons.lang.ArgAssert;
import com.avaya.commons.lang.FailedToDetermineException;
import com.avaya.commons.lang.TextDeterminer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReaderTextDeterminer
implements TextDeterminer {
    static final int MAX_NUM_CHARACTERS_TO_READ = 1024;
    static final int MAX_NUM_NON_TEXT_CHARACTERS = 50;
    private final Reader reader;

    public ReaderTextDeterminer(Reader reader) {
        ArgAssert.assertNotNull(reader, "reader");
        this.reader = reader;
    }

    @Override
    public boolean isContentText() {
        try {
            List<Integer> initialCharacters = this.readInitialCharacters();
            return this.doesNotHaveAsciiNullCharacter(initialCharacters) && this.hasFewEnoughNonTextCharacters(initialCharacters);
        }
        catch (IOException e) {
            throw new FailedToDetermineException(e);
        }
    }

    private List<Integer> readInitialCharacters() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(this.reader);
        ArrayList<Integer> initialCharacters = new ArrayList<Integer>(1024);
        int endOfInput = -1;
        int charInReader = ((Reader)bufferedReader).read();
        while (charInReader != -1 && initialCharacters.size() < 1024) {
            initialCharacters.add(charInReader);
            charInReader = ((Reader)bufferedReader).read();
        }
        return initialCharacters;
    }

    private boolean doesNotHaveAsciiNullCharacter(List<Integer> characters) {
        boolean asciiNullCharacter = false;
        return !characters.contains(0);
    }

    private boolean hasFewEnoughNonTextCharacters(List<Integer> characters) {
        return this.getNumNonTextCharacters(characters) <= 50;
    }

    private int getNumNonTextCharacters(List<Integer> characters) {
        int numNonTextCharacters = 0;
        for (int c : characters) {
            if (!this.isNonTextChar(c)) continue;
            ++numNonTextCharacters;
        }
        return numNonTextCharacters;
    }

    private boolean isNonTextChar(int c) {
        int minAsciiTextChar = 9;
        int maxAsciiWhitespaceChar = 13;
        int minAsciiPrintableChar = 32;
        int maxAsciiPrintableChar = 127;
        return c < 9 || c > 13 && c < 32 || c > 127;
    }
}

