/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.util;

import com.avaya.common.logging.client.Logger;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public final class SystemStatus {
    private static final Logger LOG = Logger.getLogger(SystemStatus.class);
    private String SOL_PIPE = "/var/avaya/sol_pipe";
    private static String INSTALLPROPS = "/opt/Avaya/install.properties";
    private static final String DEFAULTPLATFORMVERSION = "3.0.0.0.0";
    private static final String DEFAULTSDKAPIVERSION = "3.0";
    private static final int RETRY_WAIT = 5000;
    private boolean isOverloaded = false;
    private boolean isInDenyNewService = false;
    private String platformVersion;
    private String sdkApiVersion;
    private int cpuOccupancy = 0;
    private int memoryUtilization = 0;
    private int maxDiskUtilization = 0;
    private final int[] diskUtilization = new int[DiskVolume.getSize()];
    private String statusMessage;
    private static final SystemStatus onlyMe = new SystemStatus();

    private SystemStatus() {
    }

    protected static String getDEFAULTPLATFORMVERSION() {
        return DEFAULTPLATFORMVERSION;
    }

    protected static String getDEFAULTSDKAPIVERSION() {
        return DEFAULTSDKAPIVERSION;
    }

    public static boolean isOverloaded() {
        return SystemStatus.onlyMe.isOverloaded;
    }

    public static boolean isInDenyNewService() {
        return SystemStatus.onlyMe.isInDenyNewService;
    }

    public static int getCpuOccupancy() {
        return SystemStatus.onlyMe.cpuOccupancy;
    }

    public static int getMemoryUtilization() {
        return SystemStatus.onlyMe.memoryUtilization;
    }

    public static int getMaxDiskUtilization() {
        return SystemStatus.onlyMe.maxDiskUtilization;
    }

    public static int getDiskUtilization(DiskVolume disk) {
        return SystemStatus.onlyMe.diskUtilization[disk.ordinal()];
    }

    public static String getStatusMessage() {
        return SystemStatus.onlyMe.statusMessage;
    }

    public static String getPlatformVersion() {
        return SystemStatus.onlyMe.platformVersion;
    }

    public static String getSdkVersionOnPlatform() {
        return SystemStatus.onlyMe.sdkApiVersion;
    }

    protected static void setPipe(String solPipe) {
        SystemStatus.onlyMe.SOL_PIPE = solPipe;
    }

    protected static void setINSTALLPROPS(String installProps) {
        INSTALLPROPS = installProps;
    }

    private void startListener() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                SystemStatus.this.listener();
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    private void listener() {
        LOG.info((Object)"Now listening for System Status updates.");
        try {
            try (BufferedReader in = new BufferedReader(new FileReader(this.SOL_PIPE));){
                String line;
                while ((line = in.readLine()) != null) {
                    if (LOG.isFineEnabled()) {
                        LOG.fine((Object)("Got an update: " + line));
                    }
                    String[] parms = line.trim().split("[|]+");
                    int parm = 0;
                    this.cpuOccupancy = Integer.parseInt(parms[parm++]);
                    this.isOverloaded = Boolean.parseBoolean(parms[parm++]);
                    this.isInDenyNewService = Boolean.parseBoolean(parms[parm++]);
                    this.memoryUtilization = Integer.parseInt(parms[parm++]);
                    this.maxDiskUtilization = Integer.parseInt(parms[parm++]);
                    this.statusMessage = parms[parm++];
                    int nextParm = parm;
                    for (int i = 0; i < this.diskUtilization.length && nextParm < parms.length; ++i, ++nextParm) {
                        this.diskUtilization[i] = Integer.parseInt(parms[nextParm]);
                    }
                }
            }
            catch (NumberFormatException e) {
                LOG.error((Object)("Error reading " + this.SOL_PIPE + " " + e));
            }
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("Cannot open " + this.SOL_PIPE + " for reading: " + e));
        }
        catch (IOException e) {
            LOG.error((Object)("IO exception " + this.SOL_PIPE + " for reading: " + e));
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.startListener();
    }

    private void readInstallProperties() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(INSTALLPROPS);
            Properties installProps = new Properties();
            installProps.load(fis);
            this.platformVersion = installProps.getProperty("patchVersionInstall");
            if (this.platformVersion == null) {
                this.platformVersion = installProps.getProperty("Release");
                if (this.platformVersion == null) {
                    this.platformVersion = DEFAULTPLATFORMVERSION;
                }
            }
            this.sdkApiVersion = installProps.getProperty("SdkApiVersion");
            if (this.sdkApiVersion == null) {
                this.sdkApiVersion = DEFAULTSDKAPIVERSION;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to load release version from " + INSTALLPROPS + ":" + e.getLocalizedMessage()), (Throwable)e);
            if (this.platformVersion == null) {
                this.platformVersion = DEFAULTPLATFORMVERSION;
            }
            if (this.sdkApiVersion == null) {
                this.sdkApiVersion = DEFAULTSDKAPIVERSION;
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)("Failed to close " + INSTALLPROPS), (Throwable)ioe);
            }
        }
        LOG.finest((Object)("Platform Version = " + this.platformVersion + " and sdkapiversion = " + this.sdkApiVersion));
    }

    protected static void reReadInstallProperties() {
        onlyMe.readInstallProperties();
    }

    static {
        onlyMe.readInstallProperties();
        onlyMe.startListener();
    }

    public static enum DiskVolume {
        VAR("/var"),
        ROOT("/"),
        DATA("/data"),
        HOME("/home"),
        TEMP_STORE("/data/activemq/temp_store");

        private final String disk;
        private static final int SIZE;

        private DiskVolume(String disk) {
            this.disk = disk;
        }

        public String getValue() {
            return this.disk;
        }

        public static int getSize() {
            return SIZE;
        }

        static {
            SIZE = DiskVolume.values().length;
        }
    }
}

