/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.service.logger;

import com.avaya.collaboration.service.logger.Logger;
import com.avaya.collaboration.service.logger.LoggerFactoryInterface;
import com.avaya.collaboration.service.logger.Marker;
import java.lang.reflect.InvocationTargetException;
import java.security.ProviderException;

public final class LoggerFactory {
    private static final String LOGGER_FACTORY_IMPL_NAME = "com.avaya.collaboration.service.logger.internal.LoggerFactoryImpl";
    private static LoggerFactoryInterface loggerFactoryImpl = null;

    private LoggerFactory() {
    }

    static synchronized LoggerFactoryInterface getLoggerFactoryImpl() {
        if (loggerFactoryImpl == null) {
            try {
                loggerFactoryImpl = (LoggerFactoryInterface)Class.forName(LOGGER_FACTORY_IMPL_NAME).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new ProviderException("Error creating LoggerFactoryImpl instance", e);
            }
        }
        return loggerFactoryImpl;
    }

    static void setLoggerFactoryImpl(LoggerFactoryInterface loggerFactoryInterface) {
        loggerFactoryImpl = loggerFactoryInterface;
    }

    public static Logger getLogger() {
        return LoggerFactory.getLoggerFactoryImpl().getLogger();
    }

    public static Logger getLogger(Class<?> classInstance) {
        return LoggerFactory.getLoggerFactoryImpl().getLogger(classInstance);
    }

    public static Logger getLogger(String loggerName) {
        return LoggerFactory.getLoggerFactoryImpl().getLogger(loggerName);
    }

    public static Logger getServiceLogger(String serviceName) {
        return LoggerFactory.getLoggerFactoryImpl().getServiceLogger(serviceName);
    }

    public static Marker getMarker(String markerName, Object ... markerValues) {
        return LoggerFactory.getLoggerFactoryImpl().getMarker(markerName, markerValues);
    }
}

