/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.debug.WriteReftable;
import org.kohsuke.args4j.Argument;

@Command
class VerifyReftable
extends TextBuiltin {
    private static final long SEED1 = -6077401753911101332L;
    private static final long SEED2 = 2935040899052465333L;
    @Argument(index=0)
    private String lsRemotePath;
    @Argument(index=1)
    private String reftablePath;

    VerifyReftable() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void run() throws Exception {
        List<Ref> refs = WriteReftable.readRefs(this.lsRemotePath);
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream in = new FileInputStream(this.reftablePath);
            try {
                block18: {
                    BlockSource src = BlockSource.from((FileInputStream)in);
                    try {
                        try (ReftableReader reader = new ReftableReader(src);){
                            this.scan(refs, reader);
                            this.seek(refs, reader);
                            this.byId(refs, reader);
                        }
                        if (src == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (src == null) throw throwable;
                        src.close();
                        throw throwable;
                    }
                    src.close();
                }
                if (in == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    private void scan(List<Ref> refs, ReftableReader reader) throws IOException {
        this.errw.print((Object)String.format("%-20s", "sequential scan..."));
        this.errw.flush();
        Throwable throwable = null;
        Object var4_5 = null;
        try (RefCursor rc = reader.allRefs();){
            for (Ref exp : refs) {
                this.verify(exp, rc);
            }
            if (rc.next()) {
                throw VerifyReftable.die("expected end of table");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.errw.println(" OK");
    }

    private void seek(List<Ref> refs, ReftableReader reader) throws IOException {
        ArrayList<Ref> rnd = new ArrayList<Ref>(refs);
        Collections.shuffle(rnd, new Random(-6077401753911101332L));
        TextProgressMonitor pm = new TextProgressMonitor((Writer)this.errw);
        pm.beginTask("random seek", rnd.size());
        for (Ref exp : rnd) {
            Throwable throwable = null;
            Object var8_9 = null;
            try (RefCursor rc = reader.seekRef(exp.getName());){
                this.verify(exp, rc);
                if (rc.next()) {
                    throw VerifyReftable.die("should not have ref after " + exp.getName());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            pm.update(1);
        }
        pm.endTask();
    }

    private void byId(List<Ref> refs, ReftableReader reader) throws IOException {
        Map<ObjectId, List<Ref>> want = VerifyReftable.groupById(refs);
        ArrayList<List<Ref>> rnd = new ArrayList<List<Ref>>(want.values());
        Collections.shuffle(rnd, new Random(2935040899052465333L));
        TextProgressMonitor pm = new TextProgressMonitor((Writer)this.errw);
        pm.beginTask("byObjectId", rnd.size());
        for (List list : rnd) {
            Collections.sort(list, RefComparator.INSTANCE);
            ObjectId id = ((Ref)list.get(0)).getObjectId();
            Throwable throwable = null;
            Object var10_11 = null;
            try (RefCursor rc = reader.byObjectId((AnyObjectId)id);){
                for (Ref r : list) {
                    this.verify(r, rc);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            pm.update(1);
        }
        pm.endTask();
    }

    private static Map<ObjectId, List<Ref>> groupById(List<Ref> refs) {
        HashMap<ObjectId, List<Ref>> m = new HashMap<ObjectId, List<Ref>>();
        for (Ref r : refs) {
            ObjectId id = r.getObjectId();
            if (id == null) continue;
            ArrayList<Ref> c = (ArrayList<Ref>)m.get(id);
            if (c == null) {
                c = new ArrayList<Ref>(2);
                m.put(id, c);
            }
            c.add(r);
        }
        return m;
    }

    private void verify(Ref exp, RefCursor rc) throws IOException {
        if (!rc.next()) {
            throw VerifyReftable.die("ended before " + exp.getName());
        }
        Ref act = rc.getRef();
        if (!exp.getName().equals(act.getName())) {
            throw VerifyReftable.die(String.format("expected %s, found %s", exp.getName(), act.getName()));
        }
        if (exp.isSymbolic()) {
            if (!act.isSymbolic()) {
                throw VerifyReftable.die("expected " + act.getName() + " to be symbolic");
            }
            if (!exp.getTarget().getName().equals(act.getTarget().getName())) {
                throw VerifyReftable.die(String.format("expected %s to be %s, found %s", exp.getName(), exp.getLeaf().getName(), act.getLeaf().getName()));
            }
            return;
        }
        if (!AnyObjectId.equals((AnyObjectId)exp.getObjectId(), (AnyObjectId)act.getObjectId())) {
            throw VerifyReftable.die(String.format("expected %s to be %s, found %s", exp.getName(), VerifyReftable.id(exp.getObjectId()), VerifyReftable.id(act.getObjectId())));
        }
        if (exp.getPeeledObjectId() != null && !AnyObjectId.equals((AnyObjectId)exp.getPeeledObjectId(), (AnyObjectId)act.getPeeledObjectId())) {
            throw VerifyReftable.die(String.format("expected %s to be %s, found %s", exp.getName(), VerifyReftable.id(exp.getPeeledObjectId()), VerifyReftable.id(act.getPeeledObjectId())));
        }
    }

    private static String id(ObjectId id) {
        return id != null ? id.name() : "<null>";
    }
}

