/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.authorization.client;

import com.avaya.collaboration.authorization.AuthorizationHelperException;
import com.avaya.collaboration.authorization.client.AccessToken;
import com.avaya.collaboration.authorization.client.HttpResponseException;
import com.avaya.collaboration.authorization.client.TokenAggregate;
import com.avaya.collaboration.authorization.spi.AccessTokenProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.ProviderException;
import java.util.List;
import javax.servlet.ServletRequest;

public final class AuthorizationClientHelper {
    private static AccessTokenProvider tokenProvider;
    private static String accessTokenProviderImpl;
    private static Object lock;

    private AuthorizationClientHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AccessTokenProvider getAccessTokenProvider() throws AuthorizationHelperException {
        Object object = lock;
        synchronized (object) {
            if (tokenProvider == null) {
                Constructor<?> constructor;
                Class<?> clazz;
                try {
                    clazz = Class.forName(accessTokenProviderImpl);
                }
                catch (ClassNotFoundException e) {
                    throw new ProviderException("failed to find delegate class: " + accessTokenProviderImpl, e);
                }
                try {
                    constructor = clazz.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new ProviderException("failed to find the default constructor of the delegate class: " + accessTokenProviderImpl, e);
                }
                try {
                    tokenProvider = (AccessTokenProvider)constructor.newInstance(new Object[0]);
                }
                catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    throw new AuthorizationHelperException("Failed to instantiate AuthorizationClientHelper. Check if required service attributes related to Authorization are in place.", e);
                }
            }
        }
        return tokenProvider;
    }

    public static AccessToken getAccessToken() throws AuthorizationHelperException, HttpResponseException {
        return AuthorizationClientHelper.getAccessTokenProvider().getAccessToken();
    }

    public static TokenAggregate getTokenAggregate() throws AuthorizationHelperException, HttpResponseException {
        return AuthorizationClientHelper.getAccessTokenProvider().getTokenAggregate();
    }

    public static AccessToken getAccessToken(List<String> scopes) throws AuthorizationHelperException, HttpResponseException {
        return AuthorizationClientHelper.getAccessTokenProvider().getAccessToken(scopes);
    }

    public static TokenAggregate getTokenAggregate(List<String> scopes) throws AuthorizationHelperException, HttpResponseException {
        return AuthorizationClientHelper.getAccessTokenProvider().getTokenAggregate(scopes);
    }

    public static AccessToken getAccessTokenForUser(ServletRequest servletRequest) throws AuthorizationHelperException, HttpResponseException {
        return AuthorizationClientHelper.getAccessTokenProvider().getAccessTokenForUser(servletRequest);
    }

    public static TokenAggregate getTokenAggregateForUser(ServletRequest servletRequest) throws AuthorizationHelperException, HttpResponseException {
        return AuthorizationClientHelper.getAccessTokenProvider().getTokenAggregateForUser(servletRequest);
    }

    public static AccessToken getAccessTokenForUser(String userName, String userPassword) throws AuthorizationHelperException, HttpResponseException {
        return AuthorizationClientHelper.getAccessTokenProvider().getAccessTokenForUser(userName, userPassword);
    }

    public static TokenAggregate getTokenAggregateForUser(String userName, String userPassword) throws AuthorizationHelperException, HttpResponseException {
        return AuthorizationClientHelper.getAccessTokenProvider().getTokenAggregateForUser(userName, userPassword);
    }

    public static AccessToken getAccessTokenForUser(String userName, String userPassword, List<String> scopes) throws AuthorizationHelperException, HttpResponseException {
        return AuthorizationClientHelper.getAccessTokenProvider().getAccessTokenForUser(userName, userPassword, scopes);
    }

    public static TokenAggregate getTokenAggregateForUser(String userName, String userPassword, List<String> scopes) throws AuthorizationHelperException, HttpResponseException {
        return AuthorizationClientHelper.getAccessTokenProvider().getTokenAggregateForUser(userName, userPassword, scopes);
    }

    public static TokenAggregate getTokenAggregate(String refreshToken) throws AuthorizationHelperException, HttpResponseException {
        return AuthorizationClientHelper.getAccessTokenProvider().getTokenAggregate(refreshToken);
    }

    public static String getAuthorizationEndpoint(ServletRequest servletRequest) throws AuthorizationHelperException {
        return AuthorizationClientHelper.getAccessTokenProvider().getAuthorizationEndpoint(servletRequest);
    }

    public static String getAuthorizationEndpoint(ServletRequest servletRequest, List<String> scopes) throws AuthorizationHelperException {
        return AuthorizationClientHelper.getAccessTokenProvider().getAuthorizationEndpoint(servletRequest, scopes);
    }

    public static void shutdown() {
        if (tokenProvider != null) {
            tokenProvider.shutDown();
        }
    }

    static {
        accessTokenProviderImpl = "com.avaya.collaboration.authorization.client.AccessTokenProviderImpl";
        lock = new Object();
    }
}

