/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AusServiceLicense;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AusServiceLicenseDao
extends DataAccessObject {
    private static final Logger LOG = AsmLogger.getLogger(AusServiceLicenseDao.class);
    protected static final String licenseTable = "zr_service_license";
    protected static final String getAllLicenseData = "SELECT id, service_name, service_version, signature_token, license_mode from zr_service_license";
    public static final String getLicenseDataById = " WHERE id = ?";
    private Map<Long, AusServiceLicense> serviceLicenseMap;
    private Map<String, Map<String, String>> licenseModeMapByServiceName;
    private Map<String, Map<String, Boolean>> tokenMapByServiceName;
    private List<DMListener> listeners = new CopyOnWriteArrayList<DMListener>();

    public AusServiceLicenseDao() {
        super(true);
        this.serviceLicenseMap = new ConcurrentHashMap<Long, AusServiceLicense>();
        this.licenseModeMapByServiceName = new ConcurrentHashMap<String, Map<String, String>>();
        this.tokenMapByServiceName = new ConcurrentHashMap<String, Map<String, Boolean>>();
    }

    public Map<Long, AusServiceLicense> getServiceLicenseMap() {
        return this.serviceLicenseMap;
    }

    public Map<String, Map<String, String>> getLicenseModeMapByServiceName() {
        return this.licenseModeMapByServiceName;
    }

    public Map<String, Map<String, Boolean>> getTokenMapByServiceName() {
        return this.tokenMapByServiceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map tempServiceLicenseMap = null;
        ConcurrentHashMap<String, Map<String, String>> tempLicenseModeMapByServiceName = new ConcurrentHashMap<String, Map<String, String>>();
        ConcurrentHashMap<String, Map<String, Boolean>> tempTokenMapByServiceName = new ConcurrentHashMap<String, Map<String, Boolean>>();
        try {
            Object[] params = new Object[]{};
            tempServiceLicenseMap = (Map)this.dataSource.executeQuery(getAllLicenseData, params, (Object)this.getLicenseMapper());
            for (AusServiceLicense license : tempServiceLicenseMap.values()) {
                this.addLicenseToLicenseModeMapByServiceName(license, tempLicenseModeMapByServiceName);
                this.addLicenseToTokenMapByServiceName(license, tempTokenMapByServiceName);
            }
            if (LOG.isFinerEnabled()) {
                LOG.finer((Object)("init: query returns all the license states:" + tempServiceLicenseMap));
            }
            try {
                this.lock.acquireWriteLock();
                this.serviceLicenseMap = tempServiceLicenseMap;
                this.licenseModeMapByServiceName = tempLicenseModeMapByServiceName;
                this.tokenMapByServiceName = tempTokenMapByServiceName;
            }
            finally {
                this.lock.releaseWriteLock();
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            LOG.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent((GenericAlarmRecoveryIntf)this, (Exception)((Object)e));
            this.setStatus(DataMgr.Status.FAIL);
            return;
        }
    }

    private void addLicenseToTokenMapByServiceName(AusServiceLicense license, Map<String, Map<String, Boolean>> tempTokenMapByServiceName) {
        Map<String, Boolean> licenses = tempTokenMapByServiceName.get(license.getServiceName());
        if (licenses == null) {
            licenses = new ConcurrentHashMap<String, Boolean>();
            tempTokenMapByServiceName.put(license.getServiceName(), licenses);
        }
        if (license.getSignatureToken() != null) {
            licenses.put(license.getServiceVersion(), Boolean.TRUE);
        } else {
            licenses.put(license.getServiceVersion(), Boolean.FALSE);
        }
    }

    private void addLicenseToLicenseModeMapByServiceName(AusServiceLicense license, Map<String, Map<String, String>> tempLicenseMapByServiceName) {
        Map<String, String> licenses = tempLicenseMapByServiceName.get(license.getServiceName());
        if (licenses == null) {
            licenses = new ConcurrentHashMap<String, String>();
            tempLicenseMapByServiceName.put(license.getServiceName(), licenses);
        }
        licenses.put(license.getServiceVersion(), license.getLicenseMode().toString());
    }

    private void removeLicenseFromLicenseModeMapByServiceName(AusServiceLicense license) {
        Map<String, String> licenses = this.licenseModeMapByServiceName.get(license.getServiceName());
        if (licenses != null) {
            licenses.remove(license.getServiceVersion());
        }
        if ((licenses = this.licenseModeMapByServiceName.get(license.getServiceName())) != null && licenses.size() == 0) {
            this.licenseModeMapByServiceName.remove(license.getServiceName());
        }
    }

    private void removeLicenseFromTokenMapByServiceName(AusServiceLicense license) {
        Map<String, Boolean> licenses = this.tokenMapByServiceName.get(license.getServiceName());
        if (licenses != null) {
            licenses.remove(license.getServiceVersion());
        }
        if ((licenses = this.tokenMapByServiceName.get(license.getServiceName())) != null && licenses.size() == 0) {
            this.tokenMapByServiceName.remove(license.getServiceName());
        }
    }

    public List<String> getDependentTables() {
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add(licenseTable);
        return tableList;
    }

    protected Object getMainCollection() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDAO(DAOTableEvent tableEvent) {
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        AusServiceLicense oldObject = null;
        AusServiceLicense newObject = null;
        try {
            if (licenseTable.equals(tableEvent.getTableName())) {
                switch (operation) {
                    case DELETE: {
                        try {
                            this.lock.acquireWriteLock();
                            AusServiceLicense tempLic = this.serviceLicenseMap.get(id);
                            this.removeLicenseFromLicenseModeMapByServiceName(tempLic);
                            this.removeLicenseFromTokenMapByServiceName(tempLic);
                            oldObject = this.serviceLicenseMap.remove(id);
                            break;
                        }
                        finally {
                            this.lock.releaseWriteLock();
                        }
                    }
                    case INSERT: {
                        Map allLicenses = new HashMap();
                        Object[] params = new Object[]{id};
                        allLicenses = (Map)this.dataSource.executeQuery("SELECT id, service_name, service_version, signature_token, license_mode from zr_service_license WHERE id = ?", params, (Object)this.getLicenseMapper());
                        AusServiceLicense newlyInsertedLicense = (AusServiceLicense)allLicenses.get(id);
                        if (newlyInsertedLicense != null) {
                            try {
                                this.lock.acquireWriteLock();
                                this.serviceLicenseMap.put(newlyInsertedLicense.getId(), newlyInsertedLicense);
                                this.addLicenseToLicenseModeMapByServiceName(newlyInsertedLicense, this.licenseModeMapByServiceName);
                                this.addLicenseToTokenMapByServiceName(newlyInsertedLicense, this.tokenMapByServiceName);
                                newObject = this.serviceLicenseMap.get(newlyInsertedLicense.getId());
                                if (!LOG.isFinerEnabled()) break;
                                LOG.finer((Object)("adding license:" + newlyInsertedLicense));
                                break;
                            }
                            finally {
                                this.lock.releaseWriteLock();
                            }
                        }
                        LOG.warn((Object)("updateLicenseDAO: Entry in the database not found: " + tableEvent));
                        break;
                    }
                    case UPDATE: {
                        oldObject = this.serviceLicenseMap.get(id);
                        Object[] paramets = new Object[]{id};
                        Map allLicenses = (Map)this.dataSource.executeQuery("SELECT id, service_name, service_version, signature_token, license_mode from zr_service_license WHERE id = ?", paramets, (Object)this.getLicenseMapper());
                        AusServiceLicense updatedLicense = (AusServiceLicense)allLicenses.get(id);
                        try {
                            this.lock.acquireWriteLock();
                            this.serviceLicenseMap.put(updatedLicense.getId(), updatedLicense);
                            this.addLicenseToLicenseModeMapByServiceName(updatedLicense, this.licenseModeMapByServiceName);
                            this.addLicenseToTokenMapByServiceName(updatedLicense, this.tokenMapByServiceName);
                            newObject = this.serviceLicenseMap.get(updatedLicense.getId());
                            break;
                        }
                        finally {
                            this.lock.releaseWriteLock();
                        }
                    }
                    default: {
                        LOG.fine((Object)"This is not a DB supported operation.");
                    }
                }
                if (oldObject != null || newObject != null) {
                    this.updateListeners(oldObject, newObject);
                }
            }
        }
        catch (DMException e) {
            LOG.error((Object)"Error encountered.", (Throwable)e);
            this.reinit();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateListeners(Object oldObject, Object newObject) {
        LOG.info((Object)"Update invoked on LicenseDAO");
        ClassLoader platClassLoader = Thread.currentThread().getContextClassLoader();
        for (DMListener l : this.listeners) {
            try {
                Thread.currentThread().setContextClassLoader(l.getClass().getClassLoader());
                l.objectChanged(oldObject, newObject);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception on invoking objectChanged on " + l + " from " + ((Object)((Object)this)).getClass().getName()));
                LOG.error((Object)"Exception is: ", (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                LOG.error((Object)("NoClassDefFoundError on invoking objectChanged on " + l + " from " + ((Object)((Object)this)).getClass().getName()));
                LOG.error((Object)"Error is: ", (Throwable)e);
                LOG.error((Object)("Unregistering the listener " + l + " from " + ((Object)((Object)this)).getClass().getName()));
                this.removeListener(l);
            }
            finally {
                Thread.currentThread().setContextClassLoader(platClassLoader);
            }
        }
    }

    public void registerListener(DMListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DMListener listener) {
        this.listeners.remove(listener);
    }

    protected ResultSetMapper getLicenseMapper() {
        return new ResultSetMapper(){

            public Object mapResults(ResultSet rs) throws SQLException {
                ConcurrentHashMap<Long, AusServiceLicense> map = new ConcurrentHashMap<Long, AusServiceLicense>();
                while (rs.next()) {
                    Long id = (Long)rs.getObject("id");
                    map.put(id, new AusServiceLicense(id, rs.getString("service_name"), rs.getString("service_version"), rs.getString("signature_token"), rs.getString("license_mode")));
                }
                return map;
            }
        };
    }

    public Map<Long, AusServiceLicense> getAllAusLicenses() {
        return Collections.unmodifiableMap(this.serviceLicenseMap);
    }

    public Map<String, Map<String, String>> getLicenseMap() {
        return Collections.unmodifiableMap(this.licenseModeMapByServiceName);
    }

    public Map<String, Map<String, Boolean>> getTokenMap() {
        return Collections.unmodifiableMap(this.tokenMapByServiceName);
    }

    @SMConsole(description="Get token status for all versions of the given service name.")
    public Map<String, Boolean> getTokenStatusForAllVersions(String serviceName) throws ServiceNotFoundException {
        if (this.tokenMapByServiceName.get(serviceName) != null) {
            return Collections.unmodifiableMap(this.tokenMapByServiceName.get(serviceName));
        }
        throw new ServiceNotFoundException("Service " + serviceName + " not found.");
    }

    @SMConsole(description="Get all license modes for the given service name.")
    public Map<String, String> getLicenseModeForAllVersions(String serviceName) throws ServiceNotFoundException {
        if (this.licenseModeMapByServiceName.get(serviceName) != null) {
            return Collections.unmodifiableMap(this.licenseModeMapByServiceName.get(serviceName));
        }
        throw new ServiceNotFoundException("Service " + serviceName + " not found.");
    }

    @SMConsole(description="Checks token status for the given service name.")
    public Boolean hasValidToken(String serviceName, String serviceVersion) throws ServiceNotFoundException {
        if (this.tokenMapByServiceName.get(serviceName) != null) {
            if (this.tokenMapByServiceName.get(serviceName).get(serviceVersion) != null) {
                return this.tokenMapByServiceName.get(serviceName).get(serviceVersion);
            }
            throw new ServiceNotFoundException("Service version " + serviceVersion + " for " + serviceName + " not found.");
        }
        throw new ServiceNotFoundException("Service " + serviceName + " not found.");
    }

    @SMConsole(description="Get license mode for the given service name.")
    public String getLicenseMode(String serviceName, String serviceVersion) throws ServiceNotFoundException {
        if (this.licenseModeMapByServiceName.get(serviceName) != null) {
            if (this.licenseModeMapByServiceName.get(serviceName).get(serviceVersion) != null) {
                return this.licenseModeMapByServiceName.get(serviceName).get(serviceVersion);
            }
            throw new ServiceNotFoundException("Service version " + serviceVersion + " for " + serviceName + " not found.");
        }
        throw new ServiceNotFoundException("Service " + serviceName + " not found.");
    }
}

