/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AusServiceSdk;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.MapUtils;

public class AusServiceSdkDao
extends DataAccessObject {
    private static final Logger LOG = AsmLogger.getLogger(AusServiceSdkDao.class);
    protected static final String SERVICE_VERSION = "zr_service_version";
    protected static final String GET_ALL_SERVICES = "SELECT service_version_table.service_id,service_version_table.application_name,service_version_table.sdk_version,service_version_table.sdk_build FROM zr_service_version service_version_table";
    protected static final String GET_SDK_VERSION = "SELECT service_version_table.service_id,service_version_table.application_name,service_version_table.sdk_version,service_version_table.sdk_build FROM zr_service_version service_version_table WHERE service_version_table.application_name = ?";
    private Map<String, AusServiceSdk> appNameToServiceSdkVersionMap;

    public AusServiceSdkDao() {
        super(true);
    }

    protected ResultSetMapper getappNameToServiceSdkVersionMapper() {
        return new ResultSetMapper(){

            public Map<String, AusServiceSdk> mapResults(ResultSet results) throws SQLException, DMException {
                ConcurrentHashMap<String, AusServiceSdk> tmpMap = new ConcurrentHashMap<String, AusServiceSdk>();
                while (results.next()) {
                    String appName = (String)results.getObject("application_name");
                    AusServiceSdk serviceSdk = new AusServiceSdk(appName, results.getString("sdk_version"), results.getString("sdk_build"));
                    tmpMap.put(appName, serviceSdk);
                }
                return tmpMap;
            }
        };
    }

    public List<String> getDependentTables() {
        return Arrays.asList(SERVICE_VERSION);
    }

    protected Object getMainCollection() {
        return this.getAppNameToServiceSdkVersionMap();
    }

    public void updateDAO(DAOTableEvent arg0) {
    }

    public void init() {
        Map tmpappNameToServiceSdkVersionMap = null;
        try {
            Object[] params = new Object[]{};
            tmpappNameToServiceSdkVersionMap = (Map)this.dataSource.executeQuery(GET_ALL_SERVICES, params, (Object)this.getappNameToServiceSdkVersionMapper());
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            LOG.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent((GenericAlarmRecoveryIntf)this, (Exception)((Object)e));
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            this.setAppNameToServiceSdkVersionMap(tmpappNameToServiceSdkVersionMap);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @SMConsole(description="Given the application name, find the sdk version which has this application name.", parameterNames={"applicationName"})
    public String getSdkVersionByApplicationName(String applicationName) {
        String sdkVersion = null;
        Object[] params = new Object[]{applicationName};
        Map tmpMap = null;
        try {
            tmpMap = (Map)this.dataSource.executeQuery(GET_SDK_VERSION, params, (Object)this.getappNameToServiceSdkVersionMapper());
            if (MapUtils.isNotEmpty((Map)tmpMap)) {
                for (AusServiceSdk serviceSdk : tmpMap.values()) {
                    sdkVersion = serviceSdk.getsdkVersion();
                }
            }
        }
        catch (DMException e) {
            LOG.error((Object)("Unable to find sdk version for given application name : " + applicationName), (Throwable)e);
        }
        return sdkVersion;
    }

    public Map<String, AusServiceSdk> getAppNameToServiceSdkVersionMap() {
        return this.appNameToServiceSdkVersionMap;
    }

    public void setAppNameToServiceSdkVersionMap(Map<String, AusServiceSdk> appNameToServiceSdkVersionMap) {
        this.appNameToServiceSdkVersionMap = appNameToServiceSdkVersionMap;
    }
}

