/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao.common.alarm;

import com.avaya.asm.alarming.PollingAlarm;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.GUIPages;
import com.avaya.common.logging.helper.EventCode;
import com.avaya.zephyr.platform.dao.common.exception.AUSIdentityException;

public class DAOAusIdentityAlarm
extends PollingAlarm {
    private static final int scaleVal = 3;
    private static final long PRE_ALARM_RETRY_INTERVAL = 60000L;
    private static final long POST_ALARM_RETRY_INTERVAL = 3600000L;
    private static int retryCount = 10;

    protected long getPreAlarmRetryInterval() {
        AUSIdentityException ausIdEx = (AUSIdentityException)this.exception;
        if (ausIdEx.getInstanceEverResolved()) {
            return 60000L;
        }
        return 180000L;
    }

    public Object[] getAlarmEventArgs() {
        AUSIdentityException ausIdEx = (AUSIdentityException)this.exception;
        return new Object[]{GUIPages.get((Object)this.getFailedObj()), ausIdEx.getAUSName()};
    }

    public EventCode getAlarmEventCode() {
        AUSIdentityException ausIdEx = (AUSIdentityException)this.exception;
        if (ausIdEx.getAUSName() == null) {
            return AsmLogger.OP_CDAO50028;
        }
        return AsmLogger.OP_CDAO50029;
    }

    public Object[] getClearEventArgs() {
        return null;
    }

    public EventCode getClearEventCode() {
        DAOAusIdentityAlarm.clearRetryCount();
        return AsmLogger.OP_CDAO50030;
    }

    private static void clearRetryCount() {
        retryCount = 0;
    }

    public long getPostAlarm_RetryInterval() {
        return 3600000L;
    }

    public int getPreAlarm_MaxRetryCount() {
        return retryCount;
    }

    public long getPreAlarm_RetryInterval() {
        return 60000L;
    }

    public Object[] getWarnEventArgs() {
        return null;
    }

    public EventCode getWarnEventCode() {
        return null;
    }

    public boolean isSingularFailure() {
        return true;
    }
}

