/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.helper;

import com.avaya.common.logging.client.LogLevel;
import com.avaya.common.logging.helper.PluginResource;
import com.avaya.common.logging.helper.ResourceBundleLoader;
import java.io.FileInputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.logging.log4j.status.StatusLogger;

public class EventCode {
    protected static final String rbName = "EventCodes";
    protected StringBuilder mCode = null;
    protected StringBuilder mNameSpace = null;
    protected LogLevel mLogLevel = LogLevel.FINEST;

    public EventCode(String aCode, String aNameSpace) {
        if (aCode == null) {
            throw new NullPointerException("A null Message Code argument is invalid.");
        }
        if (aNameSpace == null) {
            throw new NullPointerException("A null NameSpace argument is invalid.");
        }
        if (aCode.length() > 32) {
            throw new IllegalArgumentException("The maximum Message Code size is 32 characters.");
        }
        this.mLogLevel = LogLevel.FINEST;
        this.mCode = new StringBuilder(aCode);
        this.mNameSpace = new StringBuilder(aNameSpace);
    }

    public EventCode(String aCode, String aNameSpace, LogLevel aLogLevel) {
        if (aCode == null) {
            throw new NullPointerException("A null Message Code argument is invalid.");
        }
        if (aNameSpace == null) {
            throw new NullPointerException("A null NameSpace argument is invalid.");
        }
        if (aCode.length() > 32) {
            throw new IllegalArgumentException("The maximum Message Code size is 32 characters.");
        }
        this.mLogLevel = aLogLevel == null ? LogLevel.FINEST : aLogLevel;
        this.mCode = new StringBuilder(aCode);
        this.mNameSpace = new StringBuilder(aNameSpace);
    }

    public LogLevel getLogLevel() {
        return this.mLogLevel;
    }

    public void setLogLevel(LogLevel aLogLevel) {
        this.mLogLevel = aLogLevel;
    }

    public String getCode() {
        return this.mCode.toString();
    }

    public String getNameSpace() {
        return this.mNameSpace.toString();
    }

    public boolean equals(Object aCode) {
        if (aCode == null || !(aCode instanceof EventCode)) {
            return false;
        }
        EventCode code = (EventCode)aCode;
        return code.mCode.equals(this.mCode) && code.mLogLevel.equals(this.mLogLevel) && code.mNameSpace.equals(this.mNameSpace);
    }

    protected String getEventMsgString() throws Exception {
        StringBuilder baseName = new StringBuilder(this.mNameSpace).append(".").append(rbName);
        StringBuilder message = new StringBuilder("");
        ResourceBundle rBundle = null;
        try {
            FileInputStream resourceBundleInputStream;
            block5: {
                resourceBundleInputStream = null;
                try {
                    ResourceBundleLoader rbloader = new ResourceBundleLoader();
                    rBundle = rbloader.load(baseName.toString());
                }
                catch (MissingResourceException e) {
                    PluginResource pluginResource = new PluginResource();
                    resourceBundleInputStream = pluginResource.getPropertiesFile(Locale.getDefault().toString(), this.mNameSpace.toString());
                    if (resourceBundleInputStream == null) break block5;
                    rBundle = new PropertyResourceBundle(resourceBundleInputStream);
                }
            }
            message = new StringBuilder(rBundle.getString(this.mCode.toString()));
            if (resourceBundleInputStream != null) {
                resourceBundleInputStream.close();
            }
        }
        catch (Exception e) {
            StatusLogger.getLogger().error("Cannot find message for EventCode=" + this.mCode);
            throw new Exception("Cannot find message for EventCode=" + this.mCode);
        }
        return message.toString();
    }

    public String toString() {
        return this.mCode.toString();
    }
}

