/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class DeleteRepositoryConfirmDialog
extends TitleAreaDialog {
    private final Repository repository;
    private boolean shouldDeleteGitDir = false;
    private boolean shouldDeleteWorkingDir = false;
    private boolean shouldRemoveProjects = false;
    private final Collection<IProject> projectsToDelete;
    private Button deleteGitDir;
    private Button deleteWorkDir;
    private Button removeProjects;
    private Text deleteWorkDirLabel;

    public DeleteRepositoryConfirmDialog(Shell parentShell, Repository repository, Collection<IProject> projectsToDelete) {
        super(parentShell);
        this.setHelpAvailable(false);
        if (repository.isBare()) {
            throw new IllegalArgumentException("DeleteRepositoryConfirmDialog can only be used for non-bare repository.");
        }
        this.repository = repository;
        this.projectsToDelete = projectsToDelete;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        main.setLayout((Layout)new GridLayout(1, false));
        this.deleteGitDir = new Button(main, 32);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.deleteGitDir);
        this.deleteGitDir.setText(UIText.DeleteRepositoryConfirmDialog_DeleteGitDirCheckbox);
        DeleteRepositoryConfirmDialog.createIndentedLabel(main, this.repository.getDirectory().getPath());
        this.deleteWorkDir = new Button(main, 32);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.deleteWorkDir);
        this.deleteWorkDir.setText(UIText.DeleteRepositoryConfirmDialog_DeleteWorkingDirectoryCheckbox);
        this.deleteWorkDirLabel = DeleteRepositoryConfirmDialog.createIndentedLabel(main, this.repository.getWorkTree().getPath());
        this.removeProjects = new Button(main, 32);
        this.deleteGitDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeleteRepositoryConfirmDialog.this.shouldDeleteGitDir = DeleteRepositoryConfirmDialog.this.deleteGitDir.getSelection();
                DeleteRepositoryConfirmDialog.this.updateUI();
            }
        });
        this.deleteWorkDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeleteRepositoryConfirmDialog.this.shouldDeleteWorkingDir = DeleteRepositoryConfirmDialog.this.deleteWorkDir.getSelection();
                DeleteRepositoryConfirmDialog.this.updateUI();
            }
        });
        if (!this.projectsToDelete.isEmpty()) {
            this.removeProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeleteRepositoryConfirmDialog.this.shouldRemoveProjects = DeleteRepositoryConfirmDialog.this.removeProjects.getSelection();
                    DeleteRepositoryConfirmDialog.this.updateUI();
                }
            });
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.removeProjects);
            this.removeProjects.setText(MessageFormat.format(UIText.DeleteRepositoryConfirmDialog_DeleteProjectsCheckbox, this.projectsToDelete.size()));
            TableViewer projectsViewer = new TableViewer(main, 2560);
            GridDataFactory.fillDefaults().grab(true, true).indent(20, 0).hint(-1, 100).applyTo(projectsViewer.getControl());
            projectsViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
            projectsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            projectsViewer.setInput(this.projectsToDelete);
        } else {
            this.removeProjects.setVisible(false);
        }
        this.deleteGitDir.setFocus();
        main.setTabList(new Control[]{this.deleteGitDir, this.deleteWorkDir, this.removeProjects});
        return main;
    }

    public void create() {
        super.create();
        this.setTitle(NLS.bind((String)UIText.DeleteRepositoryConfirmDialog_DeleteRepositoryTitle, (Object)Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repository)));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.DeleteRepositoryConfirmDialog_DeleteRepositoryWindowTitle);
    }

    protected Control createButtonBar(Composite parent) {
        Control result = super.createButtonBar(parent);
        this.updateUI();
        return result;
    }

    public boolean shouldDeleteWorkingDir() {
        return this.shouldDeleteWorkingDir;
    }

    public boolean shouldRemoveProjects() {
        return this.shouldRemoveProjects;
    }

    private static Text createIndentedLabel(Composite main, String text) {
        Text widget = UIUtils.createSelectableLabel(main, 0);
        widget.setText(text);
        int indent = 20;
        GridDataFactory.fillDefaults().grab(true, false).indent(indent, 0).applyTo((Control)widget);
        return widget;
    }

    private void updateUI() {
        this.getButton(0).setEnabled(this.shouldDeleteGitDir);
        this.deleteWorkDir.setEnabled(this.shouldDeleteGitDir);
        this.deleteWorkDirLabel.setEnabled(this.shouldDeleteGitDir);
        this.removeProjects.setEnabled(this.shouldDeleteGitDir && !this.shouldDeleteWorkingDir);
        if (this.shouldDeleteWorkingDir && !this.projectsToDelete.isEmpty()) {
            this.removeProjects.setSelection(true);
            this.shouldRemoveProjects = true;
        }
        if (this.shouldDeleteGitDir) {
            this.setMessage(UIText.DeleteRepositoryConfirmDialog_DeleteRepositoryNoUndoWarning, 2);
        } else {
            this.setMessage(UIText.DeleteRepositoryConfirmDialog_DeleteRepositoryConfirmMessage);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, UIText.DeleteRepositoryConfirmDialog_DeleteRepositoryConfirmButton, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

