/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;

public class DeletePathsOperation
implements IEGitOperation {
    private final Collection<IPath> paths;
    private final ISchedulingRule schedulingRule;

    public DeletePathsOperation(Collection<IPath> paths) {
        this.paths = paths;
        this.schedulingRule = this.calculateSchedulingRule();
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                DeletePathsOperation.this.deletePaths(actMonitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, m);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    private void deletePaths(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)CoreText.DeleteResourcesOperation_deletingResources, (int)(this.paths.size() + 1));
        boolean errorOccurred = false;
        boolean refreshAll = false;
        ArrayList<IPath> refreshCachePaths = new ArrayList<IPath>();
        for (IPath path : this.paths) {
            IResource resource = ResourceUtil.getResourceForLocation(path, false);
            if (resource != null && resource.exists()) {
                resource.delete(false, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            File file = path.toFile();
            if (file.exists()) {
                try {
                    FileUtils.delete((File)file, (int)1);
                }
                catch (IOException e) {
                    errorOccurred = true;
                    String message = MessageFormat.format(CoreText.DeleteResourcesOperation_deleteFailed, file.getPath());
                    Activator.logError(message, e);
                }
                refreshCachePaths.add(path);
                if (file.isDirectory()) {
                    refreshAll = true;
                }
            }
            progress.worked(1);
        }
        if (!refreshCachePaths.isEmpty()) {
            this.refreshIndexDiffCache(refreshCachePaths, refreshAll);
        }
        progress.worked(1);
        if (errorOccurred) {
            IStatus status = Activator.error(CoreText.DeleteResourcesOperation_deleteFailedSeeLog, null);
            throw new CoreException(status);
        }
    }

    private ISchedulingRule calculateSchedulingRule() {
        return RuleUtil.getRuleForContainers(this.paths);
    }

    private void refreshIndexDiffCache(List<IPath> refreshCachePaths, boolean refreshAll) {
        Map<Repository, Collection<String>> resourcesByRepository = ResourceUtil.splitPathsByRepository(refreshCachePaths);
        for (Map.Entry<Repository, Collection<String>> entry : resourcesByRepository.entrySet()) {
            Repository repository = entry.getKey();
            Collection<String> files = entry.getValue();
            IndexDiffCache cache = Activator.getDefault().getIndexDiffCache();
            IndexDiffCacheEntry cacheEntry = cache.getIndexDiffCacheEntry(repository);
            if (cacheEntry == null) continue;
            if (refreshAll) {
                cacheEntry.refresh();
                continue;
            }
            cacheEntry.refreshFiles(files);
        }
    }
}

