/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.conference.scheduled;

import com.avaya.collaboration.conference.scheduled.SchedConfFactory;
import com.avaya.collaboration.conference.scheduled.SchedConfOperationsDelegate;
import com.avaya.common.logging.client.Logger;
import java.security.ProviderException;
import javax.xml.datatype.Duration;

public final class SchedConfOperations {
    private static volatile SchedConfOperationsDelegate confOperationsDelegate;
    private static String confOperationsImplName;
    private static final Logger LOGGER;

    private SchedConfOperations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SchedConfOperationsDelegate getConfOperationsDelegate() {
        if (confOperationsDelegate == null) {
            try {
                Class<SchedConfFactory> clazz = SchedConfFactory.class;
                synchronized (SchedConfFactory.class) {
                    Class<?> clazz2 = Class.forName(confOperationsImplName);
                    confOperationsDelegate = (SchedConfOperationsDelegate)clazz2.getDeclaredField("INSTANCE").get(null);
                    // ** MonitorExit[var0] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"getConfOperationsDelegate Could not find delegate class for SchedConfOperations");
                throw new ProviderException("Failed to find delegate class for SchedConfOperations", e);
            }
        }
        {
            return confOperationsDelegate;
        }
    }

    public static void cancelConf(int confId) {
        SchedConfOperations.getConfOperationsDelegate().cancelConf(confId);
    }

    public static void cancelConfOutsideTransaction(int confId) {
        SchedConfOperations.getConfOperationsDelegate().cancelConfOutsideTransaction(confId);
    }

    public static Duration getMaxDuration() {
        return SchedConfOperations.getConfOperationsDelegate().getMaxDuration();
    }

    public static Duration getMinDuration() {
        return SchedConfOperations.getConfOperationsDelegate().getMinDuration();
    }

    public static String getCharsAllowedInDescription() {
        return SchedConfOperations.getConfOperationsDelegate().getCharsAllowedInDescription();
    }

    public static boolean isValidCharsInDescription(String description) {
        return SchedConfOperations.getConfOperationsDelegate().isValidCharsInDescription(description);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Can't clone it");
    }

    static {
        confOperationsImplName = "com.avaya.collaboration.conference.scheduled.SchedConfOperationsImpl";
        LOGGER = Logger.getLogger(SchedConfOperations.class);
    }
}

