/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.call.speech.search.sample;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.CallListenerAbstract;
import com.avaya.collaboration.call.TheCallListener;
import com.avaya.collaboration.call.speech.search.SearchOptions;
import com.avaya.collaboration.call.speech.search.SpeechFactory;
import com.avaya.collaboration.call.speech.search.SpeechSearchListener;
import com.avaya.collaboration.call.speech.search.match.SpeechSearchMatch;
import com.avaya.collaboration.call.speech.search.query.Concept;
import com.avaya.collaboration.call.speech.search.query.SearchQuery;
import com.avaya.collaboration.util.logger.Logger;
import java.util.List;
import java.util.UUID;

@TheCallListener
public class SampleSpeechSearchCall
extends CallListenerAbstract {
    private final Logger logger = Logger.getLogger(SampleSpeechSearchCall.class);
    private static final float SAMPLE_THRESHHOLD = 45.0f;

    @Override
    public void callIntercepted(Call call) {
        SearchQuery searchQuery = this.createSearchQuery();
        SearchOptions options = SpeechFactory.createSearchOptions().setLanguage("en_US").setSearchQuery(searchQuery);
        UUID searchID = SpeechFactory.createSpeechService().startSearch(call, options, (SpeechSearchListener)new MySpeechSearchListener());
        this.logger.info("Search started with UUID " + searchID.toString());
    }

    private SearchQuery createSearchQuery() {
        Concept greeting = SpeechFactory.createConcept().setName("Greeting").setOperator(SpeechFactory.createAnyOperator()).setThreshold(45.0f).addPhrase("Good Morning", 45.0f).addPhrase("Hello", 45.0f);
        Concept introduction = SpeechFactory.createConcept().setName("Introduction of Agent and Department").setOperator(SpeechFactory.createAnyOperator()).setThreshold(45.0f).addPhrase("Welcome to", 45.0f).addPhrase("My name is", 45.0f);
        Concept opening = SpeechFactory.createConcept().setName("Opening").setOperator(SpeechFactory.createAllOperator()).setThreshold(45.0f).setSubConcepts(greeting, introduction);
        Concept selling = SpeechFactory.createConcept().setName("Selling").setOperator(SpeechFactory.createAllOperator()).setThreshold(45.0f).addPhrase("Would you like to buy", 45.0f).addPhrase("Could I offer you", 45.0f);
        Concept closing = SpeechFactory.createConcept().setName("Closing").setOperator(SpeechFactory.createAllOperator()).setThreshold(45.0f).addPhrase("Thank you for calling", 45.0f).addPhrase("We appreciate your call", 45.0f);
        return SpeechFactory.createSearchQuery().setName("Sales Insurance Query").setLangauge("en_US").setConcepts(opening, selling, closing).addPhrase("This call is being monitored", 45.0f);
    }

    private class MySpeechSearchListener
    implements SpeechSearchListener {
        private MySpeechSearchListener() {
        }

        @Override
        public void matchFound(UUID searchId, Call call, List<SpeechSearchMatch> matches) {
            for (SpeechSearchMatch match : matches) {
                SampleSpeechSearchCall.this.logger.info("A match has been found for " + match.getName() + " at " + match.getStartTime() + " seconds");
            }
        }

        @Override
        public void startSearchFailed(UUID searchId, Exception execption) {
            SampleSpeechSearchCall.this.logger.info("The search failed due to errors[" + execption.getMessage() + "]");
        }

        @Override
        public void terminated(UUID searchId, String reason) {
            SampleSpeechSearchCall.this.logger.info("The search was terminated due to " + reason);
        }
    }
}

