/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jgit.blame.BlameGenerator;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=false, usage="usage_Blame")
class Blame
extends TextBuiltin {
    private RawTextComparator comparator = RawTextComparator.DEFAULT;
    @Option(name="--abbrev", metaVar="metaVar_n", usage="usage_abbrevCommits")
    private int abbrev;
    @Option(name="-l", usage="usage_blameLongRevision")
    private boolean showLongRevision;
    @Option(name="-t", usage="usage_blameRawTimestamp")
    private boolean showRawTimestamp;
    @Option(name="-b", usage="usage_blameShowBlankBoundary")
    private boolean showBlankBoundary;
    @Option(name="-s", usage="usage_blameSuppressAuthor")
    private boolean noAuthor;
    @Option(name="--show-email", aliases={"-e"}, usage="usage_blameShowEmail")
    private boolean showAuthorEmail;
    @Option(name="--show-name", aliases={"-f"}, usage="usage_blameShowSourcePath")
    private boolean showSourcePath;
    @Option(name="--show-number", aliases={"-n"}, usage="usage_blameShowSourceLine")
    private boolean showSourceLine;
    @Option(name="--root", usage="usage_blameShowRoot")
    private boolean root;
    @Option(name="-L", metaVar="metaVar_blameL", usage="usage_blameRange")
    private String rangeString;
    @Option(name="--reverse", metaVar="metaVar_blameReverse", usage="usage_blameReverse")
    private List<RevCommit> reverseRange = new ArrayList<RevCommit>(2);
    @Argument(index=0, required=false, metaVar="metaVar_revision")
    private String revision;
    @Argument(index=1, required=false, metaVar="metaVar_file")
    private String file;
    private ObjectReader reader;
    private final Map<RevCommit, String> abbreviatedCommits = new HashMap<RevCommit, String>();
    private SimpleDateFormat dateFmt;
    private int begin;
    private int end;
    private BlameResult blame;

    Blame() {
    }

    @Option(name="-w", usage="usage_ignoreWhitespace")
    void ignoreAllSpace(boolean on) {
        this.comparator = RawTextComparator.WS_IGNORE_ALL;
    }

    @Override
    protected void run() throws Exception {
        boolean autoAbbrev;
        if (this.file == null) {
            if (this.revision == null) {
                throw Blame.die(CLIText.get().fileIsRequired);
            }
            this.file = this.revision;
            this.revision = null;
        }
        boolean bl = autoAbbrev = this.abbrev == 0;
        if (this.abbrev == 0) {
            this.abbrev = this.db.getConfig().getInt("core", "abbrev", 7);
        }
        if (!this.showBlankBoundary) {
            this.root = this.db.getConfig().getBoolean("blame", "blankboundary", false);
        }
        if (!this.root) {
            this.root = this.db.getConfig().getBoolean("blame", "showroot", false);
        }
        this.dateFmt = this.showRawTimestamp ? new SimpleDateFormat("ZZZZ") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZZZ");
        this.reader = this.db.newObjectReader();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BlameGenerator generator = new BlameGenerator(this.db, this.file);){
                RevFlag scanned = generator.newFlag("SCANNED");
                generator.setTextComparator(this.comparator);
                if (!this.reverseRange.isEmpty()) {
                    RevCommit rangeStart = null;
                    ArrayList<RevCommit> rangeEnd = new ArrayList<RevCommit>(2);
                    for (RevCommit c : this.reverseRange) {
                        if (c.has(RevFlag.UNINTERESTING)) {
                            rangeStart = c;
                            continue;
                        }
                        rangeEnd.add(c);
                    }
                    generator.reverse(rangeStart, rangeEnd);
                } else if (this.revision != null) {
                    generator.push(null, (AnyObjectId)this.db.resolve(String.valueOf(this.revision) + "^{commit}"));
                } else {
                    generator.push(null, (AnyObjectId)this.db.resolve("HEAD"));
                    if (!this.db.isBare()) {
                        DirCache dc = this.db.readDirCache();
                        int entry = dc.findEntry(this.file);
                        if (entry >= 0) {
                            generator.push(null, (AnyObjectId)dc.getEntry(entry).getObjectId());
                        }
                        File inTree = new File(this.db.getWorkTree(), this.file);
                        if (this.db.getFS().isFile(inTree)) {
                            generator.push(null, new RawText(inTree));
                        }
                    }
                }
                this.blame = BlameResult.create((BlameGenerator)generator);
                this.begin = 0;
                this.end = this.blame.getResultContents().size();
                if (this.rangeString != null) {
                    this.parseLineRangeOption();
                }
                this.blame.computeRange(this.begin, this.end);
                int authorWidth = 8;
                int dateWidth = 8;
                int pathWidth = 1;
                int maxSourceLine = 1;
                int line = this.begin;
                while (line < this.end) {
                    RevCommit c = this.blame.getSourceCommit(line);
                    if (c != null && !c.has(scanned)) {
                        c.add(scanned);
                        if (autoAbbrev) {
                            this.abbrev = Math.max(this.abbrev, this.uniqueAbbrevLen(c));
                        }
                        authorWidth = Math.max(authorWidth, this.author(line).length());
                        dateWidth = Math.max(dateWidth, this.date(line).length());
                        pathWidth = Math.max(pathWidth, this.path(line).length());
                    }
                    while (line + 1 < this.end && this.blame.getSourceCommit(line + 1) == c) {
                        ++line;
                    }
                    maxSourceLine = Math.max(maxSourceLine, this.blame.getSourceLine(line));
                    ++line;
                }
                String pathFmt = MessageFormat.format(" %{0}s", pathWidth);
                String numFmt = MessageFormat.format(" %{0}d", 1 + (int)Math.log10(maxSourceLine + 1));
                String lineFmt = MessageFormat.format(" %{0}d) ", 1 + (int)Math.log10(this.end + 1));
                String authorFmt = MessageFormat.format(" (%-{0}s %{1}s", authorWidth, dateWidth);
                int line2 = this.begin;
                while (line2 < this.end) {
                    RevCommit c = this.blame.getSourceCommit(line2);
                    String commit = this.abbreviate(c);
                    String author = null;
                    String date = null;
                    if (!this.noAuthor) {
                        author = this.author(line2);
                        date = this.date(line2);
                    }
                    do {
                        this.outw.print((Object)commit);
                        if (this.showSourcePath) {
                            this.outw.format(pathFmt, new Object[]{this.path(line2)});
                        }
                        if (this.showSourceLine) {
                            this.outw.format(numFmt, new Object[]{this.blame.getSourceLine(line2) + 1});
                        }
                        if (!this.noAuthor) {
                            this.outw.format(authorFmt, new Object[]{author, date});
                        }
                        this.outw.format(lineFmt, new Object[]{line2 + 1});
                        this.outw.flush();
                        this.blame.getResultContents().writeLine(this.outs, line2);
                        this.outs.flush();
                        this.outw.print('\n');
                    } while (++line2 < this.end && this.blame.getSourceCommit(line2) == c);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.reader.close();
        }
    }

    private int uniqueAbbrevLen(RevCommit commit) throws IOException {
        return this.reader.abbreviate((AnyObjectId)commit, this.abbrev).length();
    }

    private void parseLineRangeOption() {
        String endStr;
        String beginStr;
        if (this.rangeString.startsWith("/")) {
            int c = this.rangeString.indexOf("/,", 1);
            if (c < 0) {
                beginStr = this.rangeString;
                endStr = String.valueOf(this.end);
            } else {
                beginStr = this.rangeString.substring(0, c);
                endStr = this.rangeString.substring(c + 2);
            }
        } else {
            int c = this.rangeString.indexOf(44);
            if (c < 0) {
                beginStr = this.rangeString;
                endStr = String.valueOf(this.end);
            } else if (c == 0) {
                beginStr = "0";
                endStr = this.rangeString.substring(1);
            } else {
                beginStr = this.rangeString.substring(0, c);
                endStr = this.rangeString.substring(c + 1);
            }
        }
        this.begin = beginStr.equals("") ? 0 : (beginStr.startsWith("/") ? this.findLine(0, beginStr) : Math.max(0, Integer.parseInt(beginStr) - 1));
        this.end = endStr.equals("") ? this.blame.getResultContents().size() : (endStr.startsWith("/") ? this.findLine(this.begin, endStr) : (endStr.startsWith("-") ? this.begin + Integer.parseInt(endStr) : (endStr.startsWith("+") ? this.begin + Integer.parseInt(endStr.substring(1)) : Math.max(0, Integer.parseInt(endStr) - 1))));
    }

    private int findLine(int b, String regex) {
        String re = regex.substring(1, regex.length() - 1);
        if (!re.startsWith("^")) {
            re = ".*" + re;
        }
        if (!re.endsWith("$")) {
            re = String.valueOf(re) + ".*";
        }
        Pattern p = Pattern.compile(re);
        RawText text = this.blame.getResultContents();
        int line = b;
        while (line < text.size()) {
            if (p.matcher(text.getString(line)).matches()) {
                return line;
            }
            ++line;
        }
        return b;
    }

    private String path(int line) {
        String p = this.blame.getSourcePath(line);
        return p != null ? p : "";
    }

    private String author(int line) {
        PersonIdent author = this.blame.getSourceAuthor(line);
        if (author == null) {
            return "";
        }
        String name = this.showAuthorEmail ? author.getEmailAddress() : author.getName();
        return name != null ? name : "";
    }

    private String date(int line) {
        if (this.blame.getSourceCommit(line) == null) {
            return "";
        }
        PersonIdent author = this.blame.getSourceAuthor(line);
        if (author == null) {
            return "";
        }
        this.dateFmt.setTimeZone(author.getTimeZone());
        if (!this.showRawTimestamp) {
            return this.dateFmt.format(author.getWhen());
        }
        return String.format("%d %s", author.getWhen().getTime() / 1000L, this.dateFmt.format(author.getWhen()));
    }

    private String abbreviate(RevCommit commit) throws IOException {
        String r = this.abbreviatedCommits.get(commit);
        if (r != null) {
            return r;
        }
        if (this.showBlankBoundary && commit.getParentCount() == 0) {
            commit = null;
        }
        if (commit == null) {
            int len = this.showLongRevision ? 40 : this.abbrev + 1;
            StringBuilder b = new StringBuilder(len);
            int i = 0;
            while (i < len) {
                b.append(' ');
                ++i;
            }
            r = b.toString();
        } else {
            r = !this.root && commit.getParentCount() == 0 ? (this.showLongRevision ? "^" + commit.name().substring(0, 39) : "^" + this.reader.abbreviate((AnyObjectId)commit, this.abbrev).name()) : (this.showLongRevision ? commit.name() : this.reader.abbreviate((AnyObjectId)commit, this.abbrev + 1).name());
        }
        this.abbreviatedCommits.put(commit, r);
        return r;
    }
}

