/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.zip.InflaterInputStream;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.internal.storage.pack.BinaryDelta;
import org.eclipse.jgit.internal.storage.pack.ObjectReuseAsIs;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.internal.storage.pack.StoredObjectRepresentation;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.kohsuke.args4j.Argument;

@Command(usage="usage_ShowPackDelta")
class ShowPackDelta
extends TextBuiltin {
    @Argument(index=0)
    private ObjectId objectId;

    ShowPackDelta() {
    }

    @Override
    protected void run() throws Exception {
        RevObject obj;
        ObjectReader reader = this.db.newObjectReader();
        Throwable throwable = null;
        Object var4_4 = null;
        try (RevWalk rw = new RevWalk(reader);){
            obj = rw.parseAny((AnyObjectId)this.objectId);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        byte[] delta = ShowPackDelta.getDelta(reader, obj);
        long size = reader.getObjectSize((AnyObjectId)obj, obj.getType());
        try {
            if (BinaryDelta.getResultSize((byte[])delta) != size) {
                throw ShowPackDelta.die("Object " + obj.name() + " is not a delta");
            }
        }
        catch (ArrayIndexOutOfBoundsException bad) {
            throw ShowPackDelta.die("Object " + obj.name() + " is not a delta");
        }
        this.outw.println(BinaryDelta.format((byte[])delta));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getDelta(ObjectReader reader, RevObject obj) throws IOException, MissingObjectException, StoredObjectRepresentationNotAvailableException {
        ObjectReuseAsIs asis = (ObjectReuseAsIs)reader;
        ObjectToPack target = asis.newObjectToPack((AnyObjectId)obj, obj.getType());
        PackWriter pw = new PackWriter(reader){

            public void select(ObjectToPack otp, StoredObjectRepresentation next) {
                otp.select(next);
            }
        };
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        asis.selectObjectRepresentation(pw, (ProgressMonitor)NullProgressMonitor.INSTANCE, Collections.singleton(target));
        asis.copyObjectAsIs(new PackOutputStream((ProgressMonitor)NullProgressMonitor.INSTANCE, (OutputStream)buf, pw), target, true);
        byte[] bufArray = buf.toByteArray();
        int ptr = 0;
        while ((bufArray[ptr] & 0x80) != 0) {
            ++ptr;
        }
        ++ptr;
        Throwable throwable = null;
        Object var9_10 = null;
        try {
            TemporaryBuffer.Heap raw = new TemporaryBuffer.Heap(bufArray.length);
            try {
                byte[] byArray;
                block15: {
                    InflaterInputStream inf = new InflaterInputStream(new ByteArrayInputStream(bufArray, ptr, bufArray.length));
                    try {
                        raw.copy((InputStream)inf);
                        byArray = raw.toByteArray();
                        return byArray;
                    }
                    finally {
                        if (inf == null) break block15;
                        inf.close();
                    }
                }
                if (raw != null) {
                    raw.close();
                }
                return byArray;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (raw == null) throw throwable;
                raw.close();
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }
}

