/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.sms;

import com.avaya.collaboration.sms.SmsFactoryDelegate;
import com.avaya.collaboration.sms.SmsRequest;
import com.avaya.zephyr.platform.dal.api.ServiceDescriptor;
import com.avaya.zephyr.platform.dal.api.ServiceUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.ProviderException;
import java.util.List;

public final class SmsFactory {
    private static volatile SmsFactoryDelegate smsFactoryDelegate;
    private static String smsFactoryImplName;
    private static String serviceName;
    private static String serviceVersion;
    private static boolean junitTestInProgress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SmsFactoryDelegate getSmsFactoryDelegate() {
        if (smsFactoryDelegate != null) return smsFactoryDelegate;
        Class<SmsFactory> clazz = SmsFactory.class;
        synchronized (SmsFactory.class) {
            Constructor<?> clazzConstructor;
            Class<?> clazz2;
            if (!junitTestInProgress) {
                ServiceDescriptor serviceDescriptor = ServiceUtil.getServiceDescriptor();
                serviceName = serviceDescriptor.getName();
                serviceVersion = serviceDescriptor.getVersion();
            }
            try {
                clazz2 = Class.forName(smsFactoryImplName);
            }
            catch (Exception exception) {
                throw new ProviderException("forName: Failed to find delegate class for SmsFactory (" + smsFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion, exception);
            }
            try {
                clazzConstructor = clazz2.getConstructor(String.class, String.class);
            }
            catch (Exception exception) {
                throw new ProviderException("getConstructor: Failed to find delegate class for SmsFactory (" + smsFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion, exception);
            }
            try {
                smsFactoryDelegate = (SmsFactoryDelegate)clazzConstructor.newInstance(serviceName, serviceVersion);
            }
            catch (InstantiationException instantiationException) {
                throw new ProviderException("newInstance(InstantiationException): Failed to find delegate class for SmsFactory (" + smsFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion + "\n" + instantiationException, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ProviderException("newInstance(IllegalAccessException): Failed to find delegate class for SmsFactory (" + smsFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion + "\n" + illegalAccessException, illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ProviderException("newInstance(IllegalArgumentException): Failed to find delegate class for SmsFactory (" + smsFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion + "\n" + illegalArgumentException, illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ProviderException("newInstance(InvocationTargetException): Failed to find delegate class for SmsFactory (" + smsFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion + "\n" + invocationTargetException + " target exception=" + invocationTargetException.getMessage() + " target cause=" + invocationTargetException.getCause() + " target localized message=" + invocationTargetException.getLocalizedMessage(), invocationTargetException);
            }
            return smsFactoryDelegate;
        }
    }

    public static SmsRequest createSmsRequest(String recipient, String message) {
        return SmsFactory.getSmsFactoryDelegate().getSmsRequest(recipient, message);
    }

    public static SmsRequest createSmsRequest(List<String> recipients, String message) {
        if (recipients.size() > 100) {
            throw new IllegalArgumentException("Exceeded maximum number of SMS recipients (100)");
        }
        return SmsFactory.getSmsFactoryDelegate().getSmsRequest(recipients, message);
    }

    static {
        smsFactoryImplName = "com.avaya.collaboration.sms.SmsFactoryImpl";
        serviceName = null;
        serviceVersion = null;
        junitTestInProgress = false;
    }
}

