/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.platformlistener;

import com.avaya.collaboration.platformlistener.ClusterDbState;
import com.avaya.collaboration.platformlistener.DatagridState;
import com.avaya.collaboration.platformlistener.PlatformFactoryDelegate;
import com.avaya.collaboration.platformlistener.ReliableEventingState;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.ProviderException;

public final class PlatformFactory {
    private static String platformFactoryImplName = "com.avaya.collaboration.platformlistener.PlatformFactoryImpl";
    private static PlatformFactoryDelegate delegate = null;
    private static Object lock = new Object();

    private PlatformFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PlatformFactoryDelegate getPlatformFactoryDelegate() {
        Object object = lock;
        synchronized (object) {
            if (delegate == null) {
                Constructor<?> constructor;
                Class<?> clazz;
                try {
                    clazz = Class.forName(platformFactoryImplName);
                }
                catch (ClassNotFoundException e) {
                    throw new ProviderException("failed to find delegate class: " + platformFactoryImplName, e);
                }
                try {
                    constructor = clazz.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new ProviderException("failed to find the default constructor of the delegate class: " + platformFactoryImplName, e);
                }
                try {
                    delegate = (PlatformFactoryDelegate)constructor.newInstance(new Object[0]);
                }
                catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    throw new ProviderException("failed to instanstiate the delegate class: " + platformFactoryImplName, e);
                }
            }
        }
        return delegate;
    }

    public static ReliableEventingState getReliableEventingState() {
        return PlatformFactory.getPlatformFactoryDelegate().getReliableEventingState();
    }

    public static DatagridState getDatagridState() {
        return PlatformFactory.getPlatformFactoryDelegate().getDatagridState();
    }

    public static ClusterDbState getClusterDbState() {
        return PlatformFactory.getPlatformFactoryDelegate().getClusterDbState();
    }
}

