/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.transport.URIish;

public class SelectUriWizard
extends Wizard {
    private URIish uri;
    private RepositorySelectionPage page;

    public SelectUriWizard(boolean sourceSelection) {
        this(sourceSelection, null);
    }

    public SelectUriWizard(boolean sourceSelection, String presetUri) {
        this.page = new RepositorySelectionPage(sourceSelection, presetUri);
        this.addPage((IWizardPage)this.page);
        this.setWindowTitle(UIText.SelectUriWizard_Title);
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_IMPORT_REPO);
    }

    public URIish getUri() {
        return this.uri;
    }

    public boolean performFinish() {
        this.uri = this.page.getSelection().getURI();
        if (this.page.getStoreInSecureStore() && !SecureStoreUtils.storeCredentials(this.page.getCredentials(), this.uri)) {
            return false;
        }
        return this.uri != null;
    }

    public UserPasswordCredentials getCredentials() {
        return this.page.getCredentials();
    }
}

