/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.alarming;

import com.avaya.asm.alarming.GenericAlarm;

public class GenericAlarmFailurePair {
    public static final int INFINITE_MAX_LIMIT = -1;
    private int failureCount;
    private GenericAlarm alarm;
    private Object lock;
    private boolean canReplaceAlarm;

    public GenericAlarmFailurePair(GenericAlarm a) {
        this.alarm = a;
        this.failureCount = 1;
        this.lock = new Object();
        this.canReplaceAlarm = false;
    }

    public GenericAlarm getAlarm() {
        return this.alarm;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public void setAlarm(GenericAlarm alarm) {
        this.alarm = alarm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incFailures(int i) {
        Object object = this.lock;
        synchronized (object) {
            int max = this.alarm.getMaxFailuresAllowed();
            if (max == -1 || this.failureCount + i <= max) {
                this.failureCount += i;
            }
        }
    }

    public boolean canReplaceAlarm() {
        return this.canReplaceAlarm;
    }

    public void setCanReplaceAlarm() {
        this.canReplaceAlarm = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decFailures(int i) {
        Object object = this.lock;
        synchronized (object) {
            this.failureCount = this.failureCount >= i ? (this.failureCount -= i) : 0;
        }
    }

    public String toString() {
        return this.alarm.toString() + " - Failures: " + this.failureCount + " time(s).";
    }
}

