/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.core;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESEncrypter {
    private final int CBC_IV_LENGTH = 16;
    private final SecureRandom rng = new SecureRandom();

    public String getEncryptionSchemeWithKeyLength(EncryptionScheme encryptionScheme) {
        return encryptionScheme.getNameWithKeyLength();
    }

    public String generateKey(EncryptionScheme encryptionScheme) throws GeneralSecurityException {
        KeyGenerator key = KeyGenerator.getInstance("AES");
        key.init(encryptionScheme.getKeyLength());
        SecretKey encryptionKey = key.generateKey();
        return Base64.getEncoder().encodeToString(encryptionKey.getEncoded());
    }

    public String encrypt(String strToEncrypt, String textEncodedKey, EncryptionScheme encryptionScheme) throws IllegalArgumentException, GeneralSecurityException, UnsupportedEncodingException {
        if (encryptionScheme == EncryptionScheme.CBC_128 || encryptionScheme == EncryptionScheme.CBC_256) {
            return this.encryptUsingCBC(strToEncrypt, textEncodedKey, encryptionScheme.getName());
        }
        if (encryptionScheme == EncryptionScheme.ECB_128) {
            return this.encryptUsingECB(strToEncrypt, textEncodedKey, encryptionScheme.getName());
        }
        throw new IllegalArgumentException("Invalid encryption scheme " + (Object)((Object)encryptionScheme));
    }

    public String decrypt(String strToDecrypt, String textEncodedKey, EncryptionScheme encryptionScheme) throws IllegalArgumentException, GeneralSecurityException {
        if (encryptionScheme == EncryptionScheme.CBC_128 || encryptionScheme == EncryptionScheme.CBC_256) {
            return this.decryptUsingCBC(strToDecrypt, textEncodedKey, encryptionScheme.getName());
        }
        if (encryptionScheme == EncryptionScheme.ECB_128) {
            return this.decryptUsingECB(strToDecrypt, textEncodedKey, encryptionScheme.getName());
        }
        throw new IllegalArgumentException("Invalid encryption scheme " + (Object)((Object)encryptionScheme));
    }

    private String encryptUsingECB(String strToEncrypt, String textEncodedKey, String encryptionName) throws IllegalArgumentException, GeneralSecurityException, UnsupportedEncodingException {
        if (strToEncrypt == null) {
            throw new IllegalArgumentException("String to encrypt is empty");
        }
        byte[] decodedKey = Base64.getDecoder().decode(textEncodedKey);
        SecretKeySpec encryptionKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
        Cipher cipher = Cipher.getInstance(encryptionName);
        cipher.init(1, encryptionKey);
        return Base64.getEncoder().encodeToString(cipher.doFinal(strToEncrypt.getBytes("UTF-8")));
    }

    private String encryptUsingCBC(String strToEncrypt, String textEncodedKey, String encryptionName) throws IllegalArgumentException, GeneralSecurityException, UnsupportedEncodingException {
        if (strToEncrypt == null) {
            throw new IllegalArgumentException("String to encrypt is empty");
        }
        byte[] decodedKey = Base64.getDecoder().decode(textEncodedKey);
        SecretKeySpec encryptionKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
        byte[] iv = new byte[16];
        this.rng.nextBytes(iv);
        Cipher cipher = Cipher.getInstance(encryptionName);
        cipher.init(1, (Key)encryptionKey, new IvParameterSpec(iv));
        byte[] cipherTxt = cipher.doFinal(strToEncrypt.getBytes("UTF-8"));
        byte[] msg = new byte[cipherTxt.length + 16];
        System.arraycopy(iv, 0, msg, 0, 16);
        System.arraycopy(cipherTxt, 0, msg, 16, cipherTxt.length);
        return Base64.getEncoder().encodeToString(msg);
    }

    private String decryptUsingECB(String strToDecrypt, String textEncodedKey, String encryptionName) throws IllegalArgumentException, GeneralSecurityException {
        if (strToDecrypt == null || textEncodedKey == null) {
            throw new IllegalArgumentException("String to decrypt or the decryption key is empty");
        }
        byte[] decodedKey = Base64.getDecoder().decode(textEncodedKey);
        SecretKeySpec encryptionKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
        Cipher cipher = Cipher.getInstance(encryptionName);
        cipher.init(2, encryptionKey);
        return new String(cipher.doFinal(Base64.getDecoder().decode(strToDecrypt)));
    }

    private String decryptUsingCBC(String strToDecrypt, String textEncodedKey, String encryptionName) throws IllegalArgumentException, GeneralSecurityException {
        if (strToDecrypt == null || textEncodedKey == null) {
            throw new IllegalArgumentException("String to decrypt or the decryption key is empty");
        }
        byte[] decodedKey = Base64.getDecoder().decode(textEncodedKey);
        SecretKeySpec encryptionKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
        byte[] cipherTxt = Base64.getDecoder().decode(strToDecrypt);
        Cipher cipher = Cipher.getInstance(encryptionName);
        cipher.init(2, (Key)encryptionKey, new IvParameterSpec(cipherTxt, 0, 16));
        return new String(cipher.doFinal(cipherTxt, 16, cipherTxt.length - 16));
    }

    public static enum EncryptionScheme {
        ECB_128("AES/ECB/PKCS5Padding", "AES-128/ECB/PKCS5Padding", 128),
        CBC_128("AES/CBC/PKCS5Padding", "AES-128/CBC/PKCS5Padding", 128),
        CBC_256("AES/CBC/PKCS5Padding", "AES-256/CBC/PKCS5Padding", 256);

        private final String nameWithKeyLength;
        private final String name;
        private final int keyLength;

        private EncryptionScheme(String name, String nameWithKeyLength, int keyLength) {
            this.name = name;
            this.nameWithKeyLength = nameWithKeyLength;
            this.keyLength = keyLength;
        }

        public String getNameWithKeyLength() {
            return this.nameWithKeyLength;
        }

        public String getName() {
            return this.name;
        }

        public int getKeyLength() {
            return this.keyLength;
        }

        public static EncryptionScheme create(String encryptionScheme) throws IllegalArgumentException {
            return Arrays.stream(EncryptionScheme.values()).filter(es -> es.nameWithKeyLength.equals(encryptionScheme)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid encryption scheme " + encryptionScheme));
        }

        public static String getEncryptionWithNameAndKeyLength(String encryptionScheme) throws IllegalArgumentException {
            return EncryptionScheme.create(encryptionScheme).getNameWithKeyLength();
        }
    }
}

