/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.CallHistoryAPI_FP4;
import com.avaya.asm.datamgr.dao.CallHistoryDAO_FP4;
import com.avaya.asm.datamgr.objectapi.CallLog;
import com.avaya.common.logging.client.Logger;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class CallHistoryDM_FP4
implements CallHistoryAPI_FP4 {
    private final Logger log = AsmLogger.getLogger(CallHistoryDM_FP4.class);
    Integer cassandraPort = null;

    public static void setConnInfo(String host, int port, String dbUsername, String dbPassword) {
        CallHistoryDAO_FP4.setConnInfo(host, port, dbUsername, dbPassword);
    }

    public CallHistoryDM_FP4() {
    }

    public CallHistoryDM_FP4(int cassandraPort) {
        this.cassandraPort = cassandraPort;
    }

    @Override
    public void addCallHistory(long csuserId, long cscommprofilesetId, Integer maxLogs, List<CallLog> callLogs) throws DMException {
        long endTime;
        String fcn_name = "addCallHistory";
        long startTime = 0L;
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("addCallHistory: enter, csuserId=" + csuserId + ", cscommprofilesetId=" + cscommprofilesetId + ", maxLogs=" + maxLogs + ", callLogs=" + callLogs));
        }
        List<UUID> deleteUuids = null;
        int numToDelete = 0;
        CallHistoryDAO_FP4 dao = CallHistoryDAO_FP4.getInstance(this.cassandraPort);
        if (maxLogs != null) {
            if (maxLogs <= 0) {
                throw new IllegalArgumentException("maxLogs is <= 0: " + maxLogs);
            }
            if (isFinest) {
                startTime = System.currentTimeMillis();
            }
            List<UUID> allUuids = dao.getCallLogIds(csuserId, cscommprofilesetId);
            if (isFinest) {
                endTime = System.currentTimeMillis();
                this.log.finest((Object)("addCallHistory: dao.getLogIds took " + (endTime - startTime) + "ms, allUuids.size=" + allUuids.size()));
            }
            if ((numToDelete = allUuids.size() + callLogs.size() - maxLogs) > 0) {
                deleteUuids = allUuids.subList(0, numToDelete);
            }
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        dao.updateCallLogs(csuserId, cscommprofilesetId, deleteUuids, callLogs);
        if (isFinest) {
            endTime = System.currentTimeMillis();
            this.log.finest((Object)("addCallHistory: dao.updateCallLogs took " + (endTime - startTime) + "ms, deleteUuids.size=" + (deleteUuids != null ? deleteUuids.size() : -1)));
        }
        if (isFiner) {
            this.log.finer((Object)"addCallHistory: leave");
        }
    }

    @Override
    public void deleteCallHistoryById(long csuserId, long cscommprofilesetId, List<UUID> callLogUuids) throws DMException {
        CallHistoryDAO_FP4 dao = CallHistoryDAO_FP4.getInstance();
        dao.deleteCallLogs(csuserId, cscommprofilesetId, callLogUuids);
    }

    @Override
    public void deleteCallHistoryByLimit(long csuserId, long cscommprofilesetId, int maxLogs) throws DMException {
        CallHistoryDAO_FP4 dao = CallHistoryDAO_FP4.getInstance();
        if (maxLogs == 0) {
            dao.deleteAllCallLogs(csuserId, cscommprofilesetId);
        } else {
            List<UUID> deleteUuids = null;
            List<UUID> allUuids = dao.getCallLogIds(csuserId, cscommprofilesetId);
            int numToDelete = allUuids.size() - maxLogs;
            if (numToDelete > 0) {
                deleteUuids = allUuids.subList(0, numToDelete);
                dao.deleteCallLogs(csuserId, cscommprofilesetId, deleteUuids);
            }
        }
    }

    @Override
    public void deleteAllCallHistory(long csuserId) throws DMException {
        CallHistoryDAO_FP4 dao = CallHistoryDAO_FP4.getInstance();
        dao.deleteAllCallLogs(csuserId);
    }

    @Override
    public List<CallLog> getCallHistory(long csuserId, long cscommprofilesetId, Integer maxLogs) throws DMException {
        CallHistoryDAO_FP4 dao = CallHistoryDAO_FP4.getInstance();
        List<CallLog> allCallLogs = dao.getCallHistory(csuserId, cscommprofilesetId, maxLogs);
        return allCallLogs;
    }

    @Override
    public Map<Long, List<CallLog>> getCallHistory(long csuserId) throws DMException {
        CallHistoryDAO_FP4 dao = CallHistoryDAO_FP4.getInstance(this.cassandraPort);
        Map<Long, List<CallLog>> callLogsPerCommProfSetId = dao.getCallHistory(csuserId);
        return callLogsPerCommProfSetId;
    }
}

