/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.GUIPages;
import com.avaya.asm.datamgr.dao.AppSetDAO;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.DigitMapRouterDAO;
import com.avaya.asm.datamgr.dao.EntityLinkTableDAO;
import com.avaya.asm.datamgr.dao.EventDAO;
import com.avaya.asm.datamgr.dao.HostNameDAO;
import com.avaya.asm.datamgr.dao.LocationDAO;
import com.avaya.asm.datamgr.dao.RoutePolicyDAO;
import com.avaya.asm.datamgr.dao.SIPDomainDAO;
import com.avaya.asm.datamgr.dao.SIPEntityDAO;
import com.avaya.asm.datamgr.dao.TimeDAO;
import com.avaya.asm.datamgr.dao.UserCommunityDAO;

public enum DAOClassToGUIPageEnum {
    APP_SET(AppSetDAO.class, GUIPages.USER_MGMT, GUIPages.APPLICATION_SET),
    ASM_INSTANCE(AsmInstanceDAO.class, GUIPages.ASM_INSTANCES, GUIPages.SIP_ENTITIES),
    DIGITMAP_ROUTER(DigitMapRouterDAO.class, GUIPages.DIAL_PATTERNS),
    ENTITY_LINK(EntityLinkTableDAO.class, GUIPages.ENTITY_LINKS),
    EVENT(EventDAO.class, GUIPages.EVENTING),
    HOST_NAME(HostNameDAO.class, GUIPages.HOST_NAMES),
    LOCATION(LocationDAO.class, GUIPages.LOCATIONS),
    ROUTE_POLICY(RoutePolicyDAO.class, GUIPages.ROUTING_POLICIES),
    SIP_DOMAIN(SIPDomainDAO.class, GUIPages.SIP_DOMAINS),
    SIP_ENTITY(SIPEntityDAO.class, GUIPages.SIP_ENTITIES),
    TIME(TimeDAO.class, GUIPages.TIME_RANGES),
    USER_COMM(UserCommunityDAO.class, GUIPages.USER_MGMT, GUIPages.USER_COMMUNITY),
    UNKNOWN(null, new GUIPages[0]);

    private Class<?> daoClass;
    private GUIPages[] guiPages;

    private DAOClassToGUIPageEnum(Class<? extends DataAccessObject> daoClass, GUIPages ... guiPages) {
        this.daoClass = daoClass;
        this.guiPages = guiPages;
        if (this.guiPages == null) {
            this.guiPages = new GUIPages[]{GUIPages.UNKNOWN_PAGE};
        }
    }

    public String getGuiPages() {
        StringBuilder retStr = new StringBuilder();
        int count = 0;
        for (GUIPages gp : this.guiPages) {
            if (count++ != 0) {
                retStr.append(", ");
            }
            retStr.append(gp.toString());
        }
        return retStr.toString();
    }

    public static DAOClassToGUIPageEnum get(Object obj) {
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            for (DAOClassToGUIPageEnum classToGUI : DAOClassToGUIPageEnum.values()) {
                if (!clazz.equals(classToGUI.daoClass)) continue;
                return classToGUI;
            }
        }
        return UNKNOWN;
    }
}

