/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.ReadWriteLockHandler;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dynamic.DynamicDataMgr;
import com.avaya.asm.datamgr.loadrules.LoadRule;
import com.avaya.asm.datamgr.objectapi.WeakHashSet;
import com.avaya.common.logging.client.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class DataMgr
implements DMListener {
    private static int instanceId = 0;
    private final int id;
    private static Logger log = AsmLogger.getLogger(DataMgr.class);
    private Status status = Status.UNINITIALIZED;
    private final WeakHashSet<DMListener> listeners = new WeakHashSet();
    protected DMFactory dmFactory;
    protected final ReadWriteLockHandler lock = new ReadWriteLockHandler(this.getClass().getSimpleName());
    private AtomicBoolean shouldInit = new AtomicBoolean(true);
    protected Map<String, Set<String>> loadRules = new HashMap<String, Set<String>>();
    protected final boolean supportsListeners;

    public DataMgr() {
        this(false);
    }

    public DataMgr(boolean supportsListeners) {
        this.supportsListeners = supportsListeners;
        this.id = ++instanceId;
    }

    public abstract void init();

    public boolean uninitialized() {
        return this.status == Status.UNINITIALIZED;
    }

    public boolean okay() {
        return this.status == Status.OKAY;
    }

    public boolean failed() {
        return this.status == Status.FAIL;
    }

    public boolean partial() {
        return this.status == Status.PARTIAL;
    }

    public void setStatus(Status status) {
        this.status = status;
        if (status == Status.UNINITIALIZED) {
            this.shouldInit.set(true);
        }
    }

    @SMConsole
    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", status=" + this.status.name() + "]";
    }

    protected DMFactory getDMFactoryInstance() {
        if (this.dmFactory == null) {
            this.dmFactory = DMFactory.getInstance();
        }
        return this.dmFactory;
    }

    protected DataMgr getDataMgr(Class<? extends DataMgr> clazz) {
        DataMgr dataMgr = this.getDMFactoryInstance().getDataMgr(clazz);
        if (this instanceof DynamicDataMgr || this instanceof DataAccessObject) {
            dataMgr.registerListener(this);
        }
        return dataMgr;
    }

    protected void setLoadRules(Collection<LoadRule> appLoadRules) {
        this.loadRules.clear();
        if (appLoadRules == null) {
            return;
        }
        for (LoadRule rule : appLoadRules) {
            for (Map.Entry<String, String> entry : rule.getParameters().entrySet()) {
                if (!this.loadRules.containsKey(entry.getKey())) {
                    this.loadRules.put(entry.getKey(), new HashSet());
                }
                this.loadRules.get(entry.getKey()).add(entry.getValue());
            }
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)("Load Rules for " + this.getClass().getSimpleName() + " are now: " + this.loadRules));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(DMListener listener) {
        if (!this.supportsListeners) {
            throw new IllegalArgumentException("Attempt to register DMListener(" + listener.getClass().getSimpleName() + ") to DataMgr which does not support Listeners (" + this.getClass().getSimpleName() + ")");
        }
        WeakHashSet<DMListener> weakHashSet = this.listeners;
        synchronized (weakHashSet) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            } else if (listener instanceof DataMgr) {
                for (DMListener l : this.getListeners()) {
                    if (!l.equals(listener) || l == listener) continue;
                    log.finer((Object)("registerListener: We are replacing this listener with a new version: " + listener.getClass().getSimpleName() + " for " + this.getClass().getSimpleName()));
                    this.listeners.remove(l);
                    this.listeners.add(listener);
                }
            }
            this.getDMFactoryInstance().registerListener(listener, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DMListener listener) {
        WeakHashSet<DMListener> weakHashSet = this.listeners;
        synchronized (weakHashSet) {
            this.listeners.remove(listener);
            this.getDMFactoryInstance().removeListener(listener, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DMListener> getListeners() {
        WeakHashSet<DMListener> weakHashSet = this.listeners;
        synchronized (weakHashSet) {
            ArrayList<DMListener> list = new ArrayList<DMListener>();
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                DMListener listener = (DMListener)it.next();
                if (listener != null) {
                    list.add(listener);
                    continue;
                }
                it.remove();
            }
            return list;
        }
    }

    protected void updateListeners(Object oldObject, Object newObject) {
        for (DMListener listener : this.getListeners()) {
            try {
                listener.objectChanged(oldObject, newObject);
            }
            catch (Exception e) {
                log.error((Object)("Encountered an error while invoking objectChanged on DMListener " + listener.getClass().getSimpleName()), (Throwable)e);
                if (!(listener instanceof DataMgr)) continue;
                ((DataMgr)listener).reinit();
            }
        }
    }

    protected void updateListeners(List<Object> oldObjects, List<Object> newObjects) {
        boolean reinit = false;
        if (oldObjects == null || newObjects == null || oldObjects.size() != newObjects.size()) {
            log.warn((Object)("updateListeners called with parameters of different sizes: " + oldObjects + " " + newObjects));
            reinit = true;
        }
        int size = oldObjects == null ? Integer.MAX_VALUE : oldObjects.size();
        for (DMListener listener : this.getListeners()) {
            try {
                if (listener instanceof DataMgr) {
                    DataMgr dm = (DataMgr)listener;
                    if (reinit || size >= dm.numChangesBeforeReinit()) {
                        dm.reinit();
                        continue;
                    }
                    for (int i = 0; i < size; ++i) {
                        dm.objectChanged(oldObjects.get(i), newObjects.get(i));
                    }
                    continue;
                }
                if (reinit) continue;
                for (int i = 0; i < size; ++i) {
                    listener.objectChanged(oldObjects.get(i), newObjects.get(i));
                }
            }
            catch (Exception e) {
                log.error((Object)("Encountered an error while invoking objectChanged on DMListener " + listener.getClass().getSimpleName()), (Throwable)e);
                if (!(listener instanceof DataMgr)) continue;
                ((DataMgr)listener).reinit();
            }
        }
    }

    public int numChangesBeforeReinit() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        log.warn((Object)("objectChanged: Default behavior executing, this could have ill effects: " + this.getClass().getSimpleName()));
        this.init();
    }

    public Status reinit() {
        this.init();
        return this.status;
    }

    public boolean shouldInit() {
        return this.shouldInit.getAndSet(false);
    }

    public void destroy() {
    }

    public boolean equals(Object o) {
        return o == null ? false : o.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static enum Status {
        OKAY,
        UNINITIALIZED,
        PARTIAL,
        FAIL;


        public String toString() {
            return this.name();
        }
    }
}

