/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DeviceDataAPI;
import com.avaya.asm.datamgr.dao.cassandra.CassandraDAOFactory;
import com.avaya.asm.datamgr.dao.cassandra.TokenRangeIterator;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.ustore.DeviceDataDAO;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.asm.datamgr.helpers.UriUtils;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.objectapi.DeviceDataKey;
import com.avaya.ustore.objectapi.DeviceDataRecord;
import com.datastax.driver.core.TokenRange;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DeviceDataDM
implements DeviceDataAPI {
    private final Logger log = AsmLogger.getLogger(DeviceDataDM.class);
    private CassandraDAOFactory<DeviceDataDAO> deviceDataDAOFactory = new CassandraDAOFactory();
    protected final SortByTimestampComparator sorter = new SortByTimestampComparator();
    private UserStoreKeyspace globalUserDCKeyspace = new UserStoreKeyspace("global_user_dc");
    private DeviceDataDAO dDAO = null;

    private synchronized DeviceDataDAO getDeviceDataDAO() throws DMException {
        String fcn_name = "getDeviceDataDAO";
        if (this.dDAO == null) {
            this.dDAO = this.deviceDataDAOFactory.getDAOInstance(null, DeviceDataDAO.class);
            if (this.dDAO == null) {
                String msg = "getDeviceDataDAO: DeviceDataDAO Instance failed.";
                this.log.error((Object)msg);
                throw new DMException(msg);
            }
        }
        return this.dDAO;
    }

    public boolean getBatchStatementsArePreferred(CassandraConnectionInfo cConnInfo) throws DMException {
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        return dDAO.getBatchStatementsArePreferred();
    }

    public void setBatchStatementsArePreferred(boolean batchStatementsArePreferred, CassandraConnectionInfo cConnInfo) throws DMException {
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        dDAO.setBatchStatementsArePreferred(batchStatementsArePreferred);
    }

    public static boolean isConfigXML(DeviceDataKey ddk) {
        return ddk != null && DeviceDataDM.isConfigXML(ddk.getDataCategory(), ddk.getDataName());
    }

    public static boolean isConfigXML(String category, String name) {
        return "XML".equals(name) && "Config".equals(category);
    }

    public TokenRangeIterator getNewTokenRangeIterator(List<InetAddress> downNodes) {
        String fcn_name = "getNewTokenRangeIterator";
        TokenRangeIterator tokenRangeIterator = null;
        try {
            DeviceDataDAO dDAO = this.getDeviceDataDAO();
            tokenRangeIterator = dDAO.newTokenRangeIterator(downNodes);
        }
        catch (DMException | UnknownHostException e) {
            this.log.error((Object)("getNewTokenRangeIterator Error while creating TokenRangeIterator, downNodes = " + downNodes), (Throwable)e);
        }
        return tokenRangeIterator;
    }

    @Override
    public List<DeviceDataRecord> getDeviceDataUsingFamiliesParameter(UserStoreKeyspace keyspace, long acpId, String dataCategory, String deviceHandle, String dataName, String family) throws DMException {
        return this.getDeviceDataDAO().getDeviceDataByFamily(keyspace, acpId, dataCategory, deviceHandle, dataName, family);
    }

    @Override
    public List<DeviceDataRecord> getDeviceData(UserStoreKeyspace keyspace, long acpId, String dataCategory, String deviceHandle, String dataName) throws DMException {
        String fcn_name = "getDeviceData";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDeviceData: enter with keyspace = " + keyspace + ", acpId = " + acpId + ", dataCategory = " + dataCategory + ", deviceHandle = " + deviceHandle + ", dataName = " + dataName));
        }
        if (keyspace == null) {
            String message = "getDeviceData: We got bad data: keyspace = " + keyspace + ", acpId = " + acpId + ", dataCategory = " + dataCategory + ", deviceHandle = " + deviceHandle + ", dataName = " + dataName;
            this.log.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        List<DeviceDataRecord> ddrList = dDAO.getDeviceData(keyspace, acpId, dataCategory, deviceHandle, dataName);
        if (isFiner) {
            this.log.finer((Object)("getDeviceData: leave with ddrList.size() = " + (ddrList != null ? Integer.valueOf(ddrList.size()) : null)));
        }
        return ddrList;
    }

    @Override
    public List<DeviceDataRecord> getDeviceModelData(UserStoreKeyspace keyspace, List<Long> acpIdList, String dataCategory, String dataName) throws DMException, IllegalArgumentException {
        String fcn_name = "getDeviceModelData";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDeviceModelData: enter with keyspace = " + keyspace + ", acpIdList = " + acpIdList + ", dataCategory = " + dataCategory + ", dataName = " + dataName));
        }
        if (keyspace == null) {
            String message = "getDeviceModelData: We got bad data, keyspace = " + keyspace + ", acpIdList = " + acpIdList + ", dataCategory = " + dataCategory + ", dataName = " + dataName;
            this.log.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        List<DeviceDataRecord> ddrList = dDAO.getDeviceModelData(keyspace, acpIdList, dataCategory, dataName);
        if (isFiner) {
            this.log.finer((Object)("getDeviceModelData: leave with ddrList.size() = " + (ddrList != null ? Integer.valueOf(ddrList.size()) : null)));
        }
        return ddrList;
    }

    @Override
    public List<DeviceDataRecord> getDeviceDataRecordsForSmEm(UserStoreKeyspace keyspace, Long acpId, TokenRange tokenRange, String dataCategory, Integer limit) throws DMException {
        String fcn_name = "getDeviceDataRecordsForSmEm";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataRecordsForSmEm: enter with keyspace = " + keyspace + ", acpId = " + acpId + ", tokenRange = " + tokenRange + ", dataCategory = " + dataCategory + ", limit = " + limit));
        }
        if (keyspace == null) {
            String message = "getDeviceDataRecordsForSmEm: We got bad data: keyspace = " + keyspace + ". Also, acpId = " + acpId + ", tokenRange = " + tokenRange + ", dataCategory = " + dataCategory + ", limit = " + limit;
            this.log.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        List<DeviceDataRecord> ddrList = dDAO.getDeviceDataRecordsForSmEm(keyspace, acpId, tokenRange, dataCategory, limit);
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataRecordsForSmEm: leave with ddrList.size() = " + (ddrList != null ? Integer.valueOf(ddrList.size()) : null)));
        }
        return ddrList;
    }

    @Override
    public List<DeviceDataRecord> getDeviceDataRecordsForSMGR(UserStoreKeyspace keyspace, long acpId, String dataCategory, String deviceHandle) throws DMException {
        String fcn_name = "getDeviceDataRecordsForSMGR";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataRecordsForSMGR: enter with keyspace = " + keyspace + ", acpId = " + acpId + ", dataCategory = " + dataCategory + ", deviceHandle = " + deviceHandle));
        }
        if (keyspace == null) {
            String message = "getDeviceDataRecordsForSMGR: We got bad data: keyspace = " + keyspace + ", acpId = " + acpId + ", dataCategory = " + dataCategory + ", deviceHandle = " + deviceHandle;
            this.log.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        List<DeviceDataRecord> ddrList = dDAO.getDeviceDataForSpecificEndpointFamily(keyspace, acpId, dataCategory, deviceHandle);
        Collections.sort(ddrList, this.sorter);
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataRecordsForSMGR: leave with ddrList.size() = " + (ddrList != null ? Integer.valueOf(ddrList.size()) : null)));
        }
        return ddrList;
    }

    @Override
    public List<DeviceDataRecord> getDeviceDataWithNoValues(UserStoreKeyspace keyspace, long acpId) throws DMException {
        String fcn_name = "getDeviceDataWithNoValues";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataWithNoValues: enter with keyspace = " + keyspace + ", acpId = " + acpId));
        }
        if (keyspace == null) {
            String message = "getDeviceDataWithNoValues: We got bad data: keyspace = " + keyspace + ", acpId = " + acpId;
            this.log.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        List<DeviceDataRecord> ddrList = dDAO.getDeviceDataWithNoValues(keyspace, acpId);
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataWithNoValues: leave with ddrList.size() = " + (ddrList != null ? Integer.valueOf(ddrList.size()) : null)));
        }
        return ddrList;
    }

    @Override
    public void deleteDeviceData(UserStoreKeyspace keyspace, Collection<DeviceDataKey> ddrCollection, boolean isAtomic) throws DMException {
        String fcn_name = "deleteDeviceData";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteDeviceData: enter with keyspace = " + keyspace + ", ddrCollection = " + ddrCollection + ", isAtomic = " + isAtomic));
        }
        if (keyspace == null) {
            String message = "deleteDeviceData: We got bad data: keyspace = " + keyspace + ", ddrCollection = " + ddrCollection;
            this.log.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        dDAO.deleteDeviceData(keyspace, ddrCollection, isAtomic);
        if (isFiner) {
            this.log.finer((Object)"deleteDeviceData: Leave");
        }
    }

    @Override
    public void setDeviceDataTimestamp(DeviceDataKey deviceDataKey, long timestamp) throws DMException {
        String fcn_name = "setDeviceDataTimestamp";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("setDeviceDataTimestamp: enter with deviceDataKey = " + deviceDataKey + ", timestamp = " + timestamp));
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        dDAO.setDeviceDataTimestamp(deviceDataKey, timestamp);
        if (isFiner) {
            this.log.finer((Object)("setDeviceDataTimestamp: leave with deviceDataKey = " + deviceDataKey + ", timestamp = " + timestamp));
        }
    }

    @Override
    public void setDeviceDataTimestamp(Collection<DeviceDataRecord> ddrCollection, long timestamp, boolean isAtomic) throws DMException {
        String fcn_name = "setDeviceDataTimestamp";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("setDeviceDataTimestamp: enter with ddrCollection with size = " + (ddrCollection != null ? Integer.valueOf(ddrCollection.size()) : null) + ", timestamp = " + timestamp + ", isAtomic = " + isAtomic));
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        dDAO.setDeviceDataTimestamp(ddrCollection, timestamp, isAtomic);
        if (isFiner) {
            this.log.finer((Object)"setDeviceDataTimestamp: leave ");
        }
    }

    @Override
    public void setCommunityPublicDeviceDataTimestamp(Collection<DeviceDataRecord> ddrCollection, long timestamp, boolean isAtomic) throws DMException {
        String fcn_name = "setCommunityPublicDeviceDataTimestamp";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("setCommunityPublicDeviceDataTimestamp: enter with ddrCollection with size = " + (ddrCollection != null ? Integer.valueOf(ddrCollection.size()) : null) + ", timestamp = " + timestamp + ", isAtomic = " + isAtomic));
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        if (ddrCollection == null || ddrCollection.isEmpty()) {
            if (isFiner) {
                this.log.warn((Object)"setCommunityPublicDeviceDataTimestamp: leave, ddrCollection is either empty or null");
            }
            return;
        }
        DeviceDataKey ddk = ddrCollection.iterator().next().getKey();
        long acpid = ddk.getAsmCommProfileId();
        List<DeviceDataRecord> dbDDRList = dDAO.getDeviceData(ddk.getKeyspace(), acpid, "public", ddk.getDeviceHandle(), null);
        boolean invalidCommunityPublicDeviceData = false;
        for (DeviceDataRecord dbDDR : dbDDRList) {
            if (UriUtils.isValidData(dbDDR.getDataValue())) continue;
            invalidCommunityPublicDeviceData = true;
            break;
        }
        if (invalidCommunityPublicDeviceData) {
            dDAO.setDeviceData(ddrCollection, isAtomic);
        } else {
            dDAO.setDeviceDataTimestamp(ddrCollection, timestamp, isAtomic);
        }
        if (isFiner) {
            this.log.finer((Object)("setCommunityPublicDeviceDataTimestamp: leave, acpid=" + acpid + ",invalidCommunityPublicDeviceData=" + invalidCommunityPublicDeviceData));
        }
    }

    @Override
    public void getDistinctAcpIdsFromKeyspace(UserStoreKeyspace keyspace, Collection<Long> distinctAcpIdList) throws DMException {
        String fcn_name = "getDistinctAcpIdsFromKeyspace";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDistinctAcpIdsFromKeyspace: enter with keyspace = " + keyspace));
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        dDAO.getDistinctAcpIdsFromKeyspace(keyspace, distinctAcpIdList);
        if (isFiner) {
            this.log.finer((Object)("getDistinctAcpIdsFromKeyspace: leave with distinctAcpIdList size = " + distinctAcpIdList.size()));
        }
    }

    @Override
    public void deleteDeviceDataForAcpId(UserStoreKeyspace keyspace, long acpId) throws DMException {
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        boolean isFiner = this.log.isFinerEnabled();
        String fcn_name = "deleteDeviceDataForAcpId";
        if (isFiner) {
            this.log.finer((Object)("deleteDeviceDataForAcpId: ENTER. keyspace " + keyspace.getName() + ", acpId = " + acpId));
        }
        dDAO.deleteDeviceDataForAcpId(keyspace, acpId, true);
        if (isFiner) {
            this.log.finer((Object)"deleteDeviceDataForAcpId: LEAVE");
        }
    }

    @Override
    public void setDeviceData(Collection<DeviceDataRecord> ddrCollection, boolean isAtomic) throws DMException {
        String fcn_name = "setDeviceData";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("setDeviceData: enter with ddrCollection.size() = " + (ddrCollection != null ? Integer.valueOf(ddrCollection.size()) : null) + ", isAtomic = " + isAtomic));
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        dDAO.setDeviceData(ddrCollection, isAtomic);
        if (isFiner) {
            this.log.finer((Object)("setDeviceData: leave with ddrCollection.size() = " + (ddrCollection != null ? Integer.valueOf(ddrCollection.size()) : null) + ", isAtomic = " + isAtomic));
        }
    }

    @Override
    public void setAndDeleteDeviceData(Collection<DeviceDataRecord> ddrCollection, Collection<DeviceDataKey> deletedDdrs, boolean isAtomic) throws DMException {
        String fcn_name = "setAndDeleteDeviceData";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("setAndDeleteDeviceData: enter with ddrCollection = " + ddrCollection + ", deletedDdrs = " + deletedDdrs + ", isAtomic = " + isAtomic));
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        dDAO.setDeviceData(ddrCollection, isAtomic);
        dDAO.deleteDeviceData(this.globalUserDCKeyspace, deletedDdrs, isAtomic);
        if (isFiner) {
            this.log.finer((Object)"setAndDeleteDeviceData: leave ");
        }
    }

    @Override
    public void moveDeviceData(long acpId, UserStoreKeyspace oldKS, UserStoreKeyspace newKS) throws DMException {
        String fcn_name = "moveDeviceData";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        DeviceDataDAO deviceDataDAO = this.getDeviceDataDAO();
        if (isFiner) {
            this.log.finer((Object)("moveDeviceData: enter, acpId=" + acpId + ", oldKeyspace=" + oldKS + ", newKeyspace=" + newKS));
        }
        if (oldKS.equals(newKS)) {
            if (isFiner) {
                this.log.finer((Object)("moveDeviceData: leave, oldKeyspace == newKeyspace: " + oldKS));
            }
            return;
        }
        List<DeviceDataRecord> devices = null;
        devices = deviceDataDAO.getDeviceData(oldKS, acpId, null, null, null);
        if (devices == null) {
            if (isFiner) {
                this.log.finer((Object)("moveDeviceData: LEAVE - devices is null so no devices for acpId " + acpId + ", oldKeyspace " + oldKS));
            }
            return;
        }
        if (isFinest) {
            this.log.finest((Object)("moveDeviceData: num devices read is " + devices.size()));
        }
        if (devices != null && !devices.isEmpty()) {
            ArrayList<DeviceDataRecord> ddrlist = new ArrayList<DeviceDataRecord>();
            ArrayList<DeviceDataKey> ddkList = new ArrayList<DeviceDataKey>();
            for (DeviceDataRecord oldDdr : devices) {
                DeviceDataKey oldDdk = oldDdr.getKey();
                DeviceDataKey ddk = new DeviceDataKey(oldDdk.getAsmCommProfileId(), oldDdk.getDataCategory(), oldDdk.getDeviceHandle(), oldDdk.getDataName(), newKS);
                DeviceDataRecord newDdr = new DeviceDataRecord(ddk, oldDdr.getOwnerCsUserId(), oldDdr.getCreatedDateTime(), oldDdr.getUpdateDateTime(), oldDdr.getDataValue());
                ddrlist.add(newDdr);
                ddkList.add(oldDdk);
            }
            if (isFiner) {
                this.log.finer((Object)("moveDeviceData: DeviceDataRecord list=> ddrlist" + ddrlist));
                this.log.finer((Object)("moveDeviceData: DeviceDatakey list=> ddkList" + ddkList));
            }
            try {
                this.setDeviceData(ddrlist, true);
            }
            catch (DMException e) {
                this.log.error((Object)("moveDeviceData: DMException thrown by deviceDataDM.setDeviceData for acpId=" + acpId + ", ddrlist.size=" + ddrlist.size()), (Throwable)e);
                throw e;
            }
            deviceDataDAO.deleteDeviceData(oldKS, ddkList, true);
        }
        if (isFiner) {
            this.log.finer((Object)("moveDeviceData, leave, device data moved for acpId " + acpId + " to newKeyspace " + newKS));
        }
    }

    @Override
    public void updateConfigDeviceDataTimestamp(DeviceDataKey reqDdk, long updateTimeStamp) throws DMException {
        String fcn_name = "updateDeviceDataTimestamp";
        boolean isFiner = this.log.isFinerEnabled();
        DeviceDataDAO deviceDataDAO = this.getDeviceDataDAO();
        if (isFiner) {
            this.log.finer((Object)("updateDeviceDataTimestamp: enter with DeviceDataKey = " + reqDdk + ", updateTimeStamp = " + updateTimeStamp));
        }
        DeviceDataKey ddk = new DeviceDataKey(reqDdk.getAsmCommProfileId(), "DeviceSettings", reqDdk.getDeviceHandle(), "version", this.globalUserDCKeyspace);
        deviceDataDAO.setDeviceDataTimestamp(ddk, updateTimeStamp);
        if (isFiner) {
            this.log.finer((Object)"updateDeviceDataTimestamp: leave ");
        }
    }

    @Override
    public boolean deviceDataMigratedToGlobalUserDC(long acpId) throws DMException {
        String fcn_name = "deviceDataMigratedToGlobalUserDC";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deviceDataMigratedToGlobalUserDC: enter with acpId = " + acpId));
        }
        DeviceDataDAO dao = this.getDeviceDataDAO();
        boolean fcnRC = dao.deviceDataMigratedToGlobalUserDC(acpId);
        if (isFiner) {
            this.log.finer((Object)("deviceDataMigratedToGlobalUserDC: leave with isDeviceDataMigratedToGlobalUserDC : " + fcnRC));
        }
        return fcnRC;
    }

    public List<DeviceDataRecord> getAllDeviceDataWithMigrationRecord(long acpId) throws DMException {
        String fcn_name = "getAllDeviceDataWithMigrationRecord";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getAllDeviceDataWithMigrationRecord: enter with acpId = " + acpId));
        }
        DeviceDataDAO dao = this.getDeviceDataDAO();
        List<DeviceDataRecord> ddrList = dao.getAllDeviceDataWithMigrationRecord(acpId);
        if (isFiner) {
            this.log.finer((Object)("getAllDeviceDataWithMigrationRecord: leave, ddrList's size for acpId =" + acpId + " : " + ddrList.size()));
        }
        return ddrList;
    }

    @Override
    public void setMigrationDeviceData(long acpId) throws DMException {
        String fcn_name = "setMigrationDeviceData";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("setMigrationDeviceData: enter with acpId = " + acpId));
        }
        DeviceDataDAO dao = this.getDeviceDataDAO();
        dao.setMigrationDeviceData(acpId);
        if (isFiner) {
            this.log.finer((Object)"setMigrationDeviceData: leave");
        }
    }

    class SortByTimestampComparator
    implements Comparator<DeviceDataRecord> {
        SortByTimestampComparator() {
        }

        @Override
        public int compare(DeviceDataRecord ddRecord1, DeviceDataRecord ddRecord2) {
            Long ddrTimestamp1 = ddRecord1.getUpdateDateTime();
            Long ddrTimestamp2 = ddRecord2.getUpdateDateTime();
            return Long.compare(ddrTimestamp1, ddrTimestamp2);
        }
    }
}

